/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.util.LifecycleUtil;
import com.ibm.faces.util.StringUtil;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.http.Cookie;

public class JavaScriptUtil {
    public static final String JS_NEWLINE = "\n";
    private static final String VAR_NAME_PREFIX = "hx_";
    private static String[] javascriptReservedWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "imports", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "while", "with"};
    private static String IMG_SUB_DIR = "img/";
    private static String CSS_SUB_DIR = "css/";
    private static String DLG_SUB_DIR = "dlg/";
    private static String ODC_PRJ_DIR = "odc/";
    private static String ODC_RTE_DIR = "rte/";
    private static String ODC_RTE_IMG_DIR = "images/";
    private static Map _keyTable = null;

    public static boolean isJavaScriptReservedWord(String sString) {
        boolean jsrw = false;
        int x = 0;
        int y = javascriptReservedWords.length;
        int z = 0;
        while (x <= y) {
            z = (x + y) / 2;
            int i = sString.compareTo(javascriptReservedWords[z]);
            if (i == 0) {
                jsrw = true;
                break;
            }
            if (i > 0) {
                x = z + 1;
                continue;
            }
            y = z - 1;
        }
        return jsrw;
    }

    public static String makeVariableName(String sString) {
        StringBuffer sBuffer = new StringBuffer(sString);
        int i = 0;
        int j = 0;
        j = sBuffer.length();
        for (i = 0; i < j; ++i) {
            char ch = sBuffer.charAt(i);
            if (Character.isLetterOrDigit(ch)) continue;
            sBuffer.replace(i, i + 1, "_");
        }
        return VAR_NAME_PREFIX + sBuffer.toString();
    }

    public static String getStartTag(String src) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<script type=\"text/javascript\"");
        if (src != null) {
            buffer.append(" src=\"");
            buffer.append(src);
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static String getStartTag() {
        return JavaScriptUtil.getStartTag(null);
    }

    public static String getEndTag() {
        return "</script>";
    }

    public static boolean isValidWidth(String sWidth) {
        boolean vw = true;
        if (sWidth == null || sWidth == "") {
            vw = false;
        } else {
            int j = sWidth.length();
            if (sWidth.endsWith("%")) {
                --j;
            }
            for (int i = 0; i < j; ++i) {
                char ch = sWidth.charAt(i);
                if (Character.isDigit(ch)) continue;
                vw = false;
                break;
            }
        }
        return vw;
    }

    public static boolean isValidHeight(String sHeight) {
        return JavaScriptUtil.isValidWidth(sHeight);
    }

    public static String getResourcePath(FacesContext context, String sSubDir) {
        if (context == null) {
            throw new FacesException("Cannot resolve context path as faces context is null.");
        }
        StringBuffer str = new StringBuffer(context.getExternalContext().getRequestContextPath());
        str.append("/").append(LifecycleUtil.getJSResourceURLPattern(FacesContext.getCurrentInstance())).append("/").append(sSubDir);
        return str.toString();
    }

    public static String getResourcePrefix(FacesContext context, String sSubDir) {
        if (context == null) {
            throw new FacesException("Cannot resolve context path as faces context is null.");
        }
        StringBuffer str = new StringBuffer(LifecycleUtil.getJSResourceURLPattern(FacesContext.getCurrentInstance())).append("/").append(sSubDir);
        return str.toString();
    }

    public static String getImagePath(FacesContext context) {
        return JavaScriptUtil.getResourcePath(context, IMG_SUB_DIR);
    }

    public static String getImagePath(FacesContext context, String src) {
        StringBuffer sb = new StringBuffer(JavaScriptUtil.getResourcePath(context, IMG_SUB_DIR));
        sb.append(src);
        return sb.toString();
    }

    public static String getImageURL(FacesContext context, String src) {
        StringBuffer sb = new StringBuffer(LifecycleUtil.getResourceServletContextPath(context));
        sb.append('/').append(IMG_SUB_DIR).append(src);
        return sb.toString();
    }

    public static String getCSSPath(FacesContext context) {
        return JavaScriptUtil.getResourcePath(context, CSS_SUB_DIR);
    }

    public static String getDlgPath(FacesContext context) {
        return JavaScriptUtil.getResourcePath(context, DLG_SUB_DIR);
    }

    public static String getJavaScriptPath(FacesContext context) {
        return LifecycleUtil.getJSResourceURLPattern(FacesContext.getCurrentInstance()) + "/";
    }

    public static String getOdysseyPath(FacesContext context) {
        return JavaScriptUtil.getResourcePath(context, ODC_PRJ_DIR);
    }

    public static String getOdysseyEditorPath(FacesContext context) {
        return JavaScriptUtil.getResourcePath(context, ODC_PRJ_DIR + ODC_RTE_DIR);
    }

    public static String getOdysseyEditorImagesPath(FacesContext context) {
        return JavaScriptUtil.getResourcePath(context, ODC_PRJ_DIR + ODC_RTE_DIR + ODC_RTE_IMG_DIR);
    }

    public static String getKeyCode(String keyname) {
        String code;
        keyname = keyname.trim();
        if (_keyTable == null) {
            JavaScriptUtil._createKeyTable();
        }
        if ((code = (String)_keyTable.get(keyname.toLowerCase())) == null) {
            return keyname;
        }
        return code;
    }

    private static synchronized void _createKeyTable() {
        _keyTable = new HashMap();
        _keyTable.put("tab", "9");
        _keyTable.put("enter", "13");
        _keyTable.put("space", "32");
        _keyTable.put("f1", "112");
        _keyTable.put("f2", "113");
        _keyTable.put("f3", "114");
        _keyTable.put("f4", "115");
        _keyTable.put("f5", "116");
        _keyTable.put("f6", "117");
        _keyTable.put("f7", "118");
        _keyTable.put("f8", "119");
        _keyTable.put("f9", "120");
        _keyTable.put("f10", "121");
        _keyTable.put("f11", "122");
        _keyTable.put("f12", "123");
        _keyTable.put("a", "65");
        _keyTable.put("b", "66");
        _keyTable.put("c", "67");
        _keyTable.put("d", "68");
        _keyTable.put("e", "69");
        _keyTable.put("f", "70");
        _keyTable.put("g", "71");
        _keyTable.put("h", "72");
        _keyTable.put("i", "73");
        _keyTable.put("j", "74");
        _keyTable.put("k", "75");
        _keyTable.put("l", "76");
        _keyTable.put("m", "77");
        _keyTable.put("n", "78");
        _keyTable.put("o", "79");
        _keyTable.put("p", "80");
        _keyTable.put("q", "81");
        _keyTable.put("r", "82");
        _keyTable.put("s", "83");
        _keyTable.put("t", "84");
        _keyTable.put("u", "85");
        _keyTable.put("v", "86");
        _keyTable.put("w", "87");
        _keyTable.put("x", "88");
        _keyTable.put("y", "89");
        _keyTable.put("z", "90");
        _keyTable.put("arrow_up", "38");
        _keyTable.put("arrow_down", "40");
        _keyTable.put("arrow_left", "37");
        _keyTable.put("arrow_right", "39");
        _keyTable.put("page_up", "33");
        _keyTable.put("page_down", "34");
        _keyTable.put("home", "36");
        _keyTable.put("end", "35");
    }

    public static String convertEL2JavaScript(String elExpression) {
        StringBuffer jsExpression = new StringBuffer();
        if (elExpression.startsWith("#{")) {
            elExpression = elExpression.substring(2);
        }
        if (elExpression.endsWith("}")) {
            elExpression = elExpression.substring(0, elExpression.length() - 1);
        }
        elExpression = elExpression.replaceAll(" eq ", " == ");
        elExpression = elExpression.replaceAll(" ne ", " != ");
        elExpression = elExpression.replaceAll(" lt ", " < ");
        elExpression = elExpression.replaceAll(" gt ", " > ");
        elExpression = elExpression.replaceAll(" le ", " <= ");
        elExpression = elExpression.replaceAll(" ge ", " >= ");
        elExpression = elExpression.replaceAll(" and ", " && ");
        elExpression = elExpression.replaceAll(" or ", " || ");
        elExpression = elExpression.replaceAll(" not ", " ! ");
        elExpression = elExpression.replaceAll(" mod ", " % ");
        boolean bInDoubleQuotes = false;
        boolean bInSingleQuotes = false;
        boolean bInIdentifier = false;
        StringBuffer identifier = null;
        for (int i = 0; i < elExpression.length(); ++i) {
            char ch = elExpression.charAt(i);
            if (bInDoubleQuotes && ch != '\"') {
                jsExpression.append(ch);
                continue;
            }
            if (bInSingleQuotes && ch != '\'') {
                jsExpression.append(ch);
                continue;
            }
            if (bInIdentifier) {
                if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '[' || ch == ']') {
                    identifier.append(ch);
                    continue;
                }
                bInIdentifier = false;
                jsExpression.append(JavaScriptUtil.evaluateIdentifier(identifier.toString()));
            }
            if (ch == '\"') {
                bInDoubleQuotes = !bInDoubleQuotes;
                jsExpression.append(ch);
                continue;
            }
            if (ch == '\'') {
                bInSingleQuotes = !bInSingleQuotes;
                jsExpression.append(ch);
                continue;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                bInIdentifier = true;
                identifier = new StringBuffer();
                identifier.append(ch);
                continue;
            }
            jsExpression.append(ch);
            if (ch != '\\' || i == elExpression.length() - 1) continue;
            jsExpression.append(elExpression.charAt(++i));
        }
        if (bInIdentifier) {
            jsExpression.append(JavaScriptUtil.evaluateIdentifier(identifier.toString()));
        }
        String result = jsExpression.toString();
        result = result.replaceAll("\\\"", "'");
        return result;
    }

    private static String evaluateIdentifier(String identifier) {
        if (identifier.equals("value") || identifier.startsWith("value.")) {
            String result = identifier.replaceFirst("value", "@testValue");
            return result;
        }
        String vbExp = "#{" + identifier + "}";
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ValueBinding vb = context.getApplication().createValueBinding(vbExp);
            Object vbResult = vb.getValue(context);
            if (vbResult instanceof String) {
                return "'" + vbResult + "'";
            }
            return vbResult.toString();
        }
        catch (Exception e) {
            return identifier;
        }
    }

    public static TimeZone addTimeZoneCookieScript(String TimeZoneCookieName) {
        TimeZone tz = JavaScriptUtil.getClientTimeZone(TimeZoneCookieName);
        if (null == tz) {
            UIScriptCollector scriptCollector = UIScriptCollector.find((UIComponent)FacesContext.getCurrentInstance().getViewRoot().getChildren().get(0));
            scriptCollector.addSimpleLibraryReference("hxclient_tz");
            String varName = FacesContext.getCurrentInstance().getExternalContext().encodeNamespace("__" + TimeZoneCookieName + "__");
            StringBuffer sb = new StringBuffer();
            sb.append("var ").append(varName).append(" = new ").append("hX_6").append(".DSTCookie(\"").append(TimeZoneCookieName).append("\");").append(varName).append(".CreateCookie();");
            scriptCollector.addScriptOnce(sb.toString());
        }
        return tz;
    }

    public static TimeZone getClientTimeZone(String TimeZoneCookieName) {
        Map requestCookieMap = FacesContext.getCurrentInstance().getExternalContext().getRequestCookieMap();
        if (requestCookieMap.containsKey(TimeZoneCookieName)) {
            Cookie cookie = (Cookie)requestCookieMap.get(TimeZoneCookieName);
            return JavaScriptUtil.computeClientTimeZone(cookie);
        }
        return null;
    }

    private static TimeZone computeClientTimeZone(Cookie cook) {
        SimpleTimeZone stz = null;
        try {
            boolean problem = false;
            String valueCookie = cook.getValue();
            String[] tab = StringUtil.splitToArray(valueCookie, ' ');
            if (!(tab.length != 10 || StringUtil.isEmpty(tab[0]) || StringUtil.isEmpty(tab[1]) || StringUtil.isEmpty(tab[2]) || StringUtil.isEmpty(tab[3]) || StringUtil.isEmpty(tab[4]) || StringUtil.isEmpty(tab[5]) || StringUtil.isEmpty(tab[6]) || StringUtil.isEmpty(tab[7]) || StringUtil.isEmpty(tab[8]) || StringUtil.isEmpty(tab[9]))) {
                GregorianCalendar cal;
                int janOffset = Integer.parseInt(tab[0]);
                int julOffset = Integer.parseInt(tab[1]);
                int withoutDSTOffset = 0;
                withoutDSTOffset = janOffset > julOffset ? janOffset : (janOffset < julOffset ? julOffset : janOffset);
                int rawOffset = -withoutDSTOffset * 60000;
                int dstOffset = 0;
                if (janOffset != julOffset) {
                    dstOffset = Math.abs(janOffset - julOffset) * 60000;
                }
                int mMar = 0;
                int dMar = 0;
                int tMar = 0;
                int mOct = 0;
                int dOct = 0;
                int tOct = 0;
                int mBegin = 0;
                int dBegin = 0;
                int tBegin = 0;
                int mEnd = 0;
                int dEnd = 0;
                int tEnd = 0;
                mMar = Integer.parseInt(tab[2]);
                Integer.parseInt(tab[3]);
                Integer.parseInt(tab[4]);
                tMar = Integer.parseInt(tab[5]);
                mOct = Integer.parseInt(tab[6]);
                dOct = Integer.parseInt(tab[7]);
                Integer.parseInt(tab[8]);
                tOct = Integer.parseInt(tab[9]);
                if (janOffset > julOffset) {
                    mBegin = mMar;
                    dBegin = dMar;
                    tBegin = tMar;
                    mEnd = mOct;
                    dEnd = dOct;
                    tEnd = tOct;
                } else if (janOffset < julOffset) {
                    mBegin = mOct;
                    dBegin = dOct;
                    tBegin = tOct;
                    mEnd = mMar;
                    dEnd = dMar;
                    tEnd = tMar;
                }
                tEnd += dstOffset;
                int millisPerDay = 86400000;
                if ((tBegin -= dstOffset) < 0 || tBegin >= millisPerDay) {
                    cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.set(2, mBegin);
                    cal.set(5, dBegin);
                    cal.set(14, tBegin);
                    mBegin = cal.get(2);
                    dBegin = cal.get(5);
                    tBegin = cal.get(14);
                }
                if (tEnd < 0 || tEnd >= millisPerDay) {
                    cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.set(2, mEnd);
                    cal.set(5, dEnd);
                    cal.set(14, tEnd);
                    mEnd = cal.get(2);
                    dEnd = cal.get(5);
                    tEnd = cal.get(14);
                }
                if (!problem) {
                    if (dstOffset == 0) {
                        stz = new SimpleTimeZone(rawOffset, "");
                    } else {
                        try {
                            stz = new SimpleTimeZone(rawOffset, "", mBegin, dBegin, 0, tBegin, mEnd, dEnd, 0, tEnd, dstOffset);
                        }
                        catch (IllegalArgumentException e) {
                            stz = new SimpleTimeZone(rawOffset, "", mBegin, dBegin, 0, 0, mEnd, dEnd, 0, 0, dstOffset);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stz;
    }

    public static String encodeScriptResourceString(String res, boolean encodeAll) {
        if (res != null) {
            StringBuffer buf = new StringBuffer();
            String hexVal = null;
            for (int x = 0; x < res.length(); ++x) {
                if (encodeAll || res.charAt(x) > '\u007f') {
                    buf.append("\\u");
                    hexVal = Integer.toHexString(res.charAt(x));
                    int z = 4 - hexVal.length();
                    if (z > 0) {
                        for (int i = 0; i < z; ++i) {
                            buf.append("0");
                        }
                    }
                    buf.append(hexVal);
                    continue;
                }
                buf.append(res.charAt(x));
            }
            return buf.toString();
        }
        return res;
    }
}

