/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import com.ibm.faces.ResourceHandler;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;

public class FacesMessageUtil {
    private static String _validatorMessage = "validatorMessage";
    private static String _converterMessage = "converterMessage";
    private static String _label = "label";

    public static FacesMessage getValidatorFacesMessage(ResourceBundle rb, FacesMessage.Severity severity, String summaryKey, String detailKey, UIComponent component, Object value) {
        String validatorMessage = null;
        if (component != null) {
            validatorMessage = (String)component.getAttributes().get(_validatorMessage);
        }
        return FacesMessageUtil.getFM(rb, severity, summaryKey, detailKey, component, value, validatorMessage);
    }

    public static FacesMessage getConverterFacesMessage(ResourceBundle rb, FacesMessage.Severity severity, String summaryKey, String detailKey, UIComponent component, Object value) {
        String converterMessage = null;
        if (component != null) {
            converterMessage = (String)component.getAttributes().get(_converterMessage);
        }
        return FacesMessageUtil.getFM(rb, severity, summaryKey, detailKey, component, value, converterMessage);
    }

    public static FacesMessage getFM(ResourceBundle rb, FacesMessage.Severity severity, String summaryKey, String detailKey, UIComponent component, Object value, String overRideMessage) {
        Class<?> type;
        String label = null;
        if (component != null) {
            label = (String)component.getAttributes().get(_label);
        }
        String summaryMessage = null;
        String detailMessage = null;
        if (overRideMessage != null) {
            summaryMessage = detailMessage = overRideMessage;
        } else {
            summaryMessage = ResourceHandler.getFacesMessageString(rb, summaryKey);
            detailMessage = detailKey != null ? ResourceHandler.getFacesMessageString(rb, detailKey) : summaryMessage;
        }
        Object[] values = null;
        if (label != null && value != null) {
            type = value.getClass();
            if (type.isArray()) {
                int length = Array.getLength(value);
                values = new Object[length + 1];
                for (int i = 0; i < length; ++i) {
                    values[i] = Array.get(value, i);
                }
                values[length] = label;
            } else {
                values = new Object[]{value, label};
            }
        } else if (label != null && value == null) {
            values = new Object[]{label};
        } else if (label == null && value != null) {
            type = value.getClass();
            values = type.isArray() ? (Object[])value : new Object[]{value};
        }
        if (values != null) {
            MessageFormat message = new MessageFormat(summaryMessage);
            summaryMessage = message.format(values);
            message = new MessageFormat(detailMessage);
            detailMessage = message.format(values);
        }
        FacesMessage mess = new FacesMessage(summaryMessage);
        if (detailMessage != null) {
            mess.setDetail(detailMessage);
        }
        if (severity != null) {
            mess.setSeverity(severity);
        }
        return mess;
    }
}

