/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheHashMap
extends HashMap {
    private LinkedValueNode mruNode = null;
    private int maxSize = 16;

    public CacheHashMap() {
    }

    public CacheHashMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public CacheHashMap(int maxSize, int initialCapacity) {
        super(initialCapacity);
        this.maxSize = maxSize;
    }

    public CacheHashMap(int maxSize, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.maxSize = maxSize;
    }

    public Object get(Object key) {
        LinkedValueNode node = (LinkedValueNode)super.get(key);
        if (null != node) {
            this.removeNode(node);
            this.addNode(node);
            return node.value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        LinkedValueNode prev;
        this.remove(key);
        if (this.size() == this.maxSize) {
            this.remove(this.mruNode.previous.key);
        }
        return null != (prev = super.put(key, this.addNode(new LinkedValueNode(key, value)))) ? prev.value : null;
    }

    public void putAll(Map t) {
        if (null == t) {
            return;
        }
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mapEntry = i.next();
            this.put(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    public Object remove(Object key) {
        LinkedValueNode node = (LinkedValueNode)super.get(key);
        if (null != node) {
            this.removeNode(node);
            if (node.next == null) {
                this.mruNode.previous = node.previous;
            }
            if (this.mruNode == node) {
                this.mruNode = node.next;
            }
            super.remove(key);
            return node.value;
        }
        return null;
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Collection values() {
        return new CacheCollection(this);
    }

    public void clear() {
        this.mruNode = null;
        super.clear();
    }

    private LinkedValueNode removeNode(LinkedValueNode node) {
        LinkedValueNode tempNode = node.next;
        if (null != tempNode) {
            tempNode.previous = node.previous;
        }
        if (null != (tempNode = node.previous)) {
            tempNode.next = node.next;
        }
        return node;
    }

    private LinkedValueNode addNode(LinkedValueNode node) {
        node.next = this.mruNode;
        if (null != this.mruNode) {
            node.previous = this.mruNode.previous;
            this.mruNode.previous = node;
        } else {
            node.previous = node;
        }
        this.mruNode = node;
        return this.mruNode;
    }

    public static void main(String[] args) {
    }

    class CacheCollection
    implements Collection {
        private CacheHashMap cache;

        public CacheCollection(CacheHashMap cache) {
            this.cache = cache;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add is unsupported");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("addAll is unsupported");
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean contains(Object o) {
            return this.cache.containsValue(o);
        }

        public boolean containsAll(Collection c) {
            if (null == c) {
                return true;
            }
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (this.cache.containsValue(i.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public boolean remove(Object o) {
            if (null == this.cache.mruNode) {
                return false;
            }
            LinkedValueNode node = CacheHashMap.this.mruNode;
            do {
                if (node.equals(o)) {
                    this.cache.remove(node.key);
                    return true;
                }
                node = node.next;
            } while (node.next != CacheHashMap.this.mruNode && null != node);
            return false;
        }

        public boolean removeAll(Collection c) {
            if (null == c) {
                return false;
            }
            boolean collectionChanged = false;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                collectionChanged = true;
            }
            return false;
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("retainAll is not supported");
        }

        public int size() {
            return this.cache.size();
        }

        public Object[] toArray() {
            Object[] a = new Object[this.cache.size()];
            int i = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                a[i++] = iter.next();
            }
            return a;
        }

        public Object[] toArray(Object[] a) {
            int i = 0;
            Class<?> matchClass = a.getClass();
            if (a.length < this.cache.size()) {
                a = (Object[])Array.newInstance(matchClass, this.cache.size());
            }
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (null != o && !a.getClass().equals(o.getClass())) continue;
                a[i++] = iter.next();
            }
            if (i < a.length) {
                a[i] = null;
            }
            return a;
        }

        public Iterator iterator() {
            return new CacheIterator(this.cache);
        }
    }

    class CacheIterator
    implements Iterator {
        private CacheHashMap cache;
        private LinkedValueNode nextNode;
        private boolean hasNext;

        public CacheIterator(CacheHashMap cache) {
            this.cache = cache;
            this.nextNode = (LinkedValueNode)cache.mruNode.clone();
            this.hasNext = this.nextNode != null;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            Object o = this.nextNode.value;
            this.nextNode = this.nextNode.next;
            this.hasNext = this.nextNode != null && this.nextNode != CacheHashMap.this.mruNode;
            return o;
        }

        public void remove() {
            if (null != this.nextNode.previous) {
                this.cache.remove(this.nextNode.previous.key);
            }
            throw new UnsupportedOperationException("remove is unsupported");
        }
    }

    private class LinkedValueNode {
        LinkedValueNode next;
        LinkedValueNode previous;
        Object key;
        Object value;

        LinkedValueNode(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj == null ? this.value == null : this.value.equals(obj);
        }

        public Object clone() {
            LinkedValueNode newNode = new LinkedValueNode(this.key, this.value);
            newNode.next = this.next;
            newNode.previous = this.previous;
            return newNode;
        }
    }
}

