/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

public class Base64 {
    private static final char[] base64Alphabet;
    private static final char base64Pad = '=';
    private static final byte[] decodeTable;

    public static byte[] decode(String base64Text) {
        char[] inbutBuffer = new char[4];
        byte[] outputBuffer = new byte[base64Text.length() / 4 * 3 + 3];
        int inputBufferCnt = 0;
        int outputBufferCnt = 0;
        for (int i = 0; i < base64Text.length(); ++i) {
            char ch = base64Text.charAt(i);
            if (ch != '=' && (ch >= decodeTable.length || decodeTable[ch] == 127)) continue;
            inbutBuffer[inputBufferCnt++] = ch;
            if (inputBufferCnt != inbutBuffer.length) continue;
            inputBufferCnt = 0;
            outputBufferCnt += Base64.decode(inbutBuffer, outputBuffer, outputBufferCnt);
        }
        if (outputBufferCnt == outputBuffer.length) {
            return outputBuffer;
        }
        byte[] returnBuffer = new byte[outputBufferCnt];
        System.arraycopy(outputBuffer, 0, returnBuffer, 0, outputBufferCnt);
        return returnBuffer;
    }

    public static String encode(byte[] clearText) {
        return Base64.encode(clearText, 0, clearText.length);
    }

    private static String encode(byte[] clearText, int offset, int len) {
        int i;
        int rest;
        if (len <= 0) {
            return "";
        }
        char[] out = new char[len / 3 * 4 + 4];
        int rNdx = offset;
        int wNdx = 0;
        for (rest = len; rest >= 3; rest -= 3) {
            i = ((clearText[rNdx] & 0xFF) << 16) + ((clearText[rNdx + 1] & 0xFF) << 8) + (clearText[rNdx + 2] & 0xFF);
            out[wNdx++] = base64Alphabet[i >> 18];
            out[wNdx++] = base64Alphabet[i >> 12 & 0x3F];
            out[wNdx++] = base64Alphabet[i >> 6 & 0x3F];
            out[wNdx++] = base64Alphabet[i & 0x3F];
            rNdx += 3;
        }
        if (rest == 1) {
            i = clearText[rNdx] & 0xFF;
            out[wNdx++] = base64Alphabet[i >> 2];
            out[wNdx++] = base64Alphabet[i << 4 & 0x3F];
            out[wNdx++] = 61;
            out[wNdx++] = 61;
        } else if (rest == 2) {
            i = ((clearText[rNdx] & 0xFF) << 8) + (clearText[rNdx + 1] & 0xFF);
            out[wNdx++] = base64Alphabet[i >> 10];
            out[wNdx++] = base64Alphabet[i >> 4 & 0x3F];
            out[wNdx++] = base64Alphabet[i << 2 & 0x3F];
            out[wNdx++] = 61;
        }
        return new String(out, 0, wNdx);
    }

    private static int decode(char[] base64Text, byte[] outputBuffer, int ptr) {
        int outlen = 3;
        if (base64Text[3] == '=') {
            outlen = 2;
        }
        if (base64Text[2] == '=') {
            outlen = 1;
        }
        byte b0 = decodeTable[base64Text[0]];
        byte b1 = decodeTable[base64Text[1]];
        byte b2 = decodeTable[base64Text[2]];
        byte b3 = decodeTable[base64Text[3]];
        switch (outlen) {
            case 1: {
                outputBuffer[ptr] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                return 1;
            }
            case 2: {
                outputBuffer[ptr++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                outputBuffer[ptr] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                outputBuffer[ptr++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                outputBuffer[ptr++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                outputBuffer[ptr] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                return 3;
            }
        }
        throw new RuntimeException("Unable to Base64-decode");
    }

    static {
        int i;
        base64Alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        decodeTable = new byte[128];
        for (i = 0; i < decodeTable.length; ++i) {
            Base64.decodeTable[i] = 127;
        }
        for (i = 0; i < base64Alphabet.length; ++i) {
            Base64.decodeTable[Base64.base64Alphabet[i]] = (byte)i;
        }
    }
}

