/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class AjaxUtil {
    public static final String AJAX_VIEWID = "$$viewid";
    public static final String AJAX_MODE = "$$ajaxmode";
    public static final String AJAX_COMPID = "$$ajaxid";
    public static final String VIEW_PREFIX = "view";
    public static final String MODE_NORMAL = "axnone";
    public static final String MODE_AJAX_FULL = "axfull";
    public static final String MODE_AJAX_PARTIAL = "axpartial";
    public static final int AJAX_NONE = 0;
    public static final int AJAX_FULL = 1;
    public static final int AJAX_PARTIAL = 2;
    public static final int AJAX_OTHER = 3;
    private static final String com_ibm_faces_AJAXISRENDERING = "com.ibm.faces.AJAXISRENDERING";

    public static boolean isAjaxRequest(FacesContext context) {
        return AjaxUtil.getAjaxMode(context) != 0;
    }

    public static int getAjaxMode(FacesContext context) {
        String modeStr = AjaxUtil.getAjaxModeValue(context);
        if (modeStr == null || modeStr.equals(MODE_NORMAL)) {
            return 0;
        }
        if (modeStr.equals(MODE_AJAX_PARTIAL)) {
            return 2;
        }
        if (modeStr.equals(MODE_AJAX_FULL)) {
            return 1;
        }
        if (modeStr.length() > 0) {
            return 3;
        }
        return 0;
    }

    public static String getAjaxModeValue(FacesContext context) {
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        String modeStr = (String)parameterMap.get(AJAX_MODE);
        return modeStr;
    }

    public static String getAjaxComponentId(FacesContext facesContext) {
        Object obj = facesContext.getExternalContext().getRequestMap().get(AJAX_COMPID);
        if (obj == null) {
            obj = facesContext.getExternalContext().getRequestParameterMap().get(AJAX_COMPID);
            if (obj == null) {
                return null;
            }
            facesContext.getExternalContext().getRequestMap().put(AJAX_COMPID, obj);
        }
        return obj.toString();
    }

    public static String computeComponentId(FacesContext context, UIComponent component) {
        return component.getClientId(context);
    }

    public static boolean isRendering(FacesContext context) {
        Object o = context.getExternalContext().getRequestMap().get(com_ibm_faces_AJAXISRENDERING);
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    public static boolean isRendered(FacesContext context, UIComponent component) {
        String ajaxComponentId;
        String _componentId = AjaxUtil.getAjaxComponentId(context);
        return _componentId != null && _componentId.equals(ajaxComponentId = AjaxUtil.computeComponentId(context, component));
    }

    public static void setRendering(FacesContext context, boolean rendering) {
        context.getExternalContext().getRequestMap().put(com_ibm_faces_AJAXISRENDERING, rendering);
    }
}

