/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.sdo;

import com.ibm.websphere.sdo.DataObjectAccessBean;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

public class SdoPropertyResolver
extends PropertyResolver {
    private PropertyResolver oldPropResolver = null;
    private boolean sdoAvailable = true;

    public SdoPropertyResolver(PropertyResolver propResolver) throws Exception {
        try {
            boolean test = this instanceof DataObjectAccessBean;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.sdoAvailable = false;
        }
        this.oldPropResolver = propResolver;
    }

    public Object getValue(Object base, Object property) throws PropertyNotFoundException {
        if (this.sdoAvailable && base instanceof DataObjectAccessBean) {
            return ((DataObjectAccessBean)base).get(property);
        }
        if (this.oldPropResolver != null) {
            return this.oldPropResolver.getValue(base, property);
        }
        throw new PropertyNotFoundException();
    }

    public Object getValue(Object base, int index) throws PropertyNotFoundException {
        if (this.oldPropResolver != null) {
            return this.oldPropResolver.getValue(base, index);
        }
        throw new PropertyNotFoundException();
    }

    public void setValue(Object base, Object property, Object value) throws PropertyNotFoundException {
        if (this.sdoAvailable && base instanceof DataObjectAccessBean) {
            if (property == null) {
                String className = base.getClass().getName();
                throw new PropertyNotFoundException("Error setting property '" + property + "' in bean of type " + className);
            }
            ((DataObjectAccessBean)base).put(property, value);
            return;
        }
        if (this.oldPropResolver != null) {
            this.oldPropResolver.setValue(base, property, value);
            return;
        }
        throw new PropertyNotFoundException();
    }

    public void setValue(Object base, int index, Object value) throws PropertyNotFoundException {
        if (this.oldPropResolver != null) {
            this.oldPropResolver.setValue(base, index, value);
            return;
        }
        throw new PropertyNotFoundException();
    }

    public boolean isReadOnly(Object base, Object property) throws PropertyNotFoundException {
        if (this.sdoAvailable && base instanceof DataObjectAccessBean) {
            try {
                if (property instanceof String) {
                    return ((DataObjectAccessBean)base).isReadOnly((String)property);
                }
                String className = base.getClass().getName();
                throw new PropertyNotFoundException("Property '" + property + "' is not a String in bean of type " + className);
            }
            catch (Exception e) {
                throw new PropertyNotFoundException((Throwable)e);
            }
        }
        if (this.oldPropResolver != null) {
            return this.oldPropResolver.isReadOnly(base, property);
        }
        throw new PropertyNotFoundException();
    }

    public boolean isReadOnly(Object base, int index) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (this.sdoAvailable && base instanceof DataObjectAccessBean) {
            throw new PropertyNotFoundException("Property index not supported");
        }
        if (this.oldPropResolver != null) {
            return this.oldPropResolver.isReadOnly(base, index);
        }
        throw new PropertyNotFoundException();
    }

    public Class getType(Object base, Object property) throws PropertyNotFoundException {
        if (this.sdoAvailable && base instanceof DataObjectAccessBean) {
            try {
                if (property instanceof String) {
                    return ((DataObjectAccessBean)base).getType((String)property);
                }
                String className = base.getClass().getName();
                throw new PropertyNotFoundException("Error testing property '" + property + "' in bean of type " + className);
            }
            catch (Exception e) {
                throw new PropertyNotFoundException((Throwable)e);
            }
        }
        if (this.oldPropResolver != null) {
            return this.oldPropResolver.getType(base, property);
        }
        throw new PropertyNotFoundException();
    }

    public Class getType(Object base, int index) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (this.sdoAvailable && base instanceof DataObjectAccessBean) {
            throw new PropertyNotFoundException("Property index not supported");
        }
        if (this.oldPropResolver != null) {
            return this.oldPropResolver.getType(base, index);
        }
        throw new PropertyNotFoundException();
    }
}

