/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIPager;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlPagerWeb;
import com.ibm.faces.renderkit.html_extended.AbstractPagerRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class WebPagerRenderer
extends AbstractPagerRenderer
implements IScriptContributor {
    private static final String PAGER_SIMPLE_NUMBERLIST = "__pagerWeb";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_be.js", component);
        HxClientRenderUtil.addScriptLibrary("hxclient_table.js", component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String tabindex;
        String title;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlPagerWeb webComponent = null;
        if (component instanceof HtmlPagerWeb) {
            webComponent = (HtmlPagerWeb)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        String idHidden = id + PAGER_SIMPLE_NUMBERLIST;
        String formId = this.getFormId(context, component);
        if (webComponent != null) {
            style = webComponent.getStyle();
            styleClass = webComponent.getStyleClass();
            title = webComponent.getTitle();
            tabindex = webComponent.getTabindex();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            title = (String)component.getAttributes().get("title");
            tabindex = (String)component.getAttributes().get("tabindex");
        }
        boolean isBinaryNavigation = this.isAttributeTrue(component, "binaryNavigation");
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        StringBuffer buffer = new StringBuffer();
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        int currentPage = ((UIPager)component).getCurrentPage(pdw);
        HtmlUtil.writeInputHidden((Writer)writer, idHidden, "" + currentPage);
        int[] pageList = null;
        if (isBinaryNavigation) {
            pageList = this.getBinaryTraversalPageList(component);
        } else {
            pageList = this.getSimplePageList(component);
            if (pageList.length > 0 && pageList[0] > 0) {
                ResourceBundle bundle = ResourceHandler.getBundle(context);
                String localizedNext = ResourceHandler.getString(bundle, "PagerRenderer.previous");
                this.writePagerWebElement((Writer)writer, localizedNext, currentPage - 1, idHidden, formId, buffer, "_prev", title, tabindex);
            }
        }
        int len = pageList.length;
        for (int i = 0; i < len; ++i) {
            if (pageList[i] < 0) continue;
            if (pageList[i] == currentPage) {
                HtmlUtil.writeTagStartOpen((Writer)writer, "strong", false, false);
                HtmlUtil.writeTagStartClose((Writer)writer, false);
                writer.write(this.getLocalizedIndexText(context, currentPage + 1));
                HtmlUtil.writeTagEndLn((Writer)writer, "strong");
                continue;
            }
            String indexDisplay = this.getLocalizedIndexText(context, pageList[i] + 1);
            this.writePagerWebElement((Writer)writer, indexDisplay, pageList[i], idHidden, formId, buffer, null, title, tabindex);
        }
        if (!isBinaryNavigation) {
            int lastPage = ((UIPager)component).getLastPage(pdw);
            if (pageList.length > 0 && pageList[pageList.length - 1] < lastPage) {
                ResourceBundle bundle = ResourceHandler.getBundle(context);
                String localizedPrevious = ResourceHandler.getString(bundle, "PagerRenderer.next");
                this.writePagerWebElement((Writer)writer, localizedPrevious, currentPage + 1, idHidden, formId, buffer, "_next", title, tabindex);
            }
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
        if (UIScriptCollector.find(component) == null) {
            writer.write(JavaScriptUtil.getStartTag(JavaScriptUtil.getJavaScriptPath(context) + Utils.versionizeFilename("hxclient_table.js")));
            writer.write(JavaScriptUtil.getEndTag());
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        if (pdw == null) {
            return;
        }
        if (!((UIPager)component).isPaged(pdw)) {
            return;
        }
        String key = component.getClientId(context) + PAGER_SIMPLE_NUMBERLIST;
        String value = (String)context.getExternalContext().getRequestParameterMap().get(key);
        if (value != null) {
            int currentPage = ((UIPager)component).getCurrentPage(pdw);
            int lastPage = ((UIPager)component).getLastPage(pdw);
            int newPage = -1;
            try {
                Integer intObj = new Integer(value);
                newPage = intObj;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.queueEvent(component, currentPage, newPage, lastPage);
        }
    }

    private void writePagerWebElement(Writer writer, String text, int index, String id, String formId, StringBuffer buffer, String idSuffix, String title, String tabindex) throws IOException {
        if (formId == null) {
            formId = "notNestedInUIForm_csdfvfbdbfdfbdwbwrbrbgwrgtrwgwvwvfvfw";
        }
        String linkId = id + "__" + index;
        if (idSuffix != null) {
            linkId = linkId + idSuffix;
        }
        buffer.setLength(0);
        buffer.append("hX_6").append(".JSFWebPagerSubmit('").append(id).append("', ").append(index).append(", '").append(formId).append("'); return false;");
        HtmlUtil.writeTagStartOpen(writer, "a", false, false);
        HtmlUtil.writeTagAttribute(writer, "id", linkId);
        HtmlUtil.writeTagAttribute(writer, "href", "#");
        if (title != null) {
            HtmlUtil.writeTagAttribute(writer, "title", title);
        }
        if (tabindex != null) {
            HtmlUtil.writeTagAttribute(writer, "tabindex", tabindex);
        }
        HtmlUtil.writeTagAttribute(writer, "onclick", buffer.toString());
        HtmlUtil.writeTagStartClose(writer, false);
        writer.write(text);
        HtmlUtil.writeTagEndLn(writer, "a");
    }

    private int[] getBinaryTraversalPageList(UIComponent pager) {
        int next;
        int lenMinusTwo;
        int lenMinusOne;
        int prev;
        boolean ok;
        int numberOfPages = this.getAttributeInteger(pager, "numberOfPages", 10);
        if (numberOfPages < 7) {
            numberOfPages = 7;
        }
        int[] numberList = new int[numberOfPages];
        int len = numberList.length;
        Arrays.fill(numberList, -1);
        int firstPage = 0;
        UIPager.PagerDataWrapper pdw = ((UIPager)pager).getPagerDataWrapper();
        int lastPage = ((UIPager)pager).getLastPage(pdw);
        int page = ((UIPager)pager).getCurrentPage(pdw);
        if (lastPage < 0) {
            lastPage = page + 1;
        }
        int idx = 0;
        numberList[idx++] = firstPage;
        if (page > firstPage) {
            numberList[idx++] = page;
        }
        if (lastPage > page) {
            numberList[idx++] = lastPage;
        }
        int pre = page - 1;
        int post = page + 1;
        do {
            ok = false;
            if (pre > firstPage) {
                numberList[idx++] = pre--;
                if (idx >= len) break;
                ok = true;
            }
            if (post >= lastPage) continue;
            numberList[idx++] = post++;
            if (idx >= len) break;
            ok = true;
        } while (ok);
        Arrays.sort(numberList);
        if (numberList[1] - numberList[0] > 1 && (prev = (numberList[1] - numberList[0]) / 2 + numberList[0]) != numberList[0]) {
            numberList[1] = prev;
        }
        if (numberList[lenMinusOne = len - 1] - numberList[lenMinusTwo = len - 2] > 1 && (next = numberList[lenMinusOne] - (numberList[lenMinusOne] - numberList[lenMinusTwo]) / 2) != numberList[lenMinusTwo]) {
            numberList[lenMinusTwo] = next;
        }
        return numberList;
    }

    private int[] getSimplePageList(UIComponent pager) {
        int delta;
        int numberOfPages;
        UIPager.PagerDataWrapper pdw = ((UIPager)pager).getPagerDataWrapper();
        int currentPage = ((UIPager)pager).getCurrentPage(pdw);
        int firstPage = 0;
        int lastPage = ((UIPager)pager).getLastPage(pdw);
        if (lastPage < 0) {
            lastPage = Integer.MAX_VALUE;
        }
        if ((numberOfPages = this.getAttributeInteger(pager, "numberOfPages", 5)) < 2) {
            numberOfPages = 2;
        }
        int midPos = numberOfPages / 2;
        if (numberOfPages % 2 > 0) {
            ++midPos;
        }
        int first = currentPage - (midPos - 1);
        int last = currentPage + (numberOfPages - midPos);
        if (last > lastPage) {
            delta = last - lastPage;
            first -= delta;
            last -= delta;
        }
        if (first < firstPage) {
            delta = firstPage - first;
            first += delta;
            last += delta;
        }
        if (last > lastPage) {
            last = lastPage;
        }
        int[] range = new int[last - first + 1];
        int len = range.length;
        for (int i = 0; i < len; ++i) {
            range[i] = first++;
        }
        return range;
    }

    private boolean isAttributeTrue(UIComponent component, String key) {
        Object value = component.getAttributes().get(key);
        if (value == null) {
            return false;
        }
        if (Boolean.FALSE.equals(value)) {
            return false;
        }
        return Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString());
    }

    private int getAttributeInteger(UIComponent component, String key, int defaultValue) {
        Object value = component.getAttributes().get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            String str = value.toString();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getFormId(FacesContext context, UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIForm) {
            return component.getClientId(context);
        }
        return this.getFormId(context, component.getParent());
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
    }
}

