/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.UIDataIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class Utils {
    public static final String DATESTYLE_SHORT = "short";
    public static final String DATESTYLE_MEDIUM = "medium";
    public static final String DATESTYLE_LONG = "long";
    public static final String DATESTYLE_FULL = "full";
    public static final String NUMBERSTYLE_NUMBER = "number";
    public static final String NUMBERSTYLE_CURRENCY = "currency";
    public static final String NUMBERSTYLE_PERCENT = "percent";
    private String _modKey = "";
    private String _key = "";
    private Map _keyTable = null;

    public Utils(String attr) {
        this.parseKeyExpression(attr);
    }

    private void parseKeyExpression(String attr) {
        this._modKey = "";
        this._key = "";
        if (attr == null) {
            return;
        }
        int x = attr.indexOf(43);
        if (x == -1) {
            this._key = attr;
        } else {
            this._modKey = attr.substring(0, x);
            this._key = attr.substring(x + 1);
        }
    }

    public String getModKey() {
        return this._modKey;
    }

    public String getKey() {
        return this._key;
    }

    public String getKeyCode() {
        if (this._key.length() > 0 && Character.isDigit(this._key.charAt(0))) {
            return this._key;
        }
        return this.getKeyCode(this._key);
    }

    private void _createKeyTable() {
        this._keyTable = new HashMap();
        this._keyTable.put("tab", "9");
        this._keyTable.put("enter", "13");
        this._keyTable.put("space", "32");
        this._keyTable.put("f1", "112");
        this._keyTable.put("f2", "113");
        this._keyTable.put("f3", "114");
        this._keyTable.put("f4", "115");
        this._keyTable.put("f5", "116");
        this._keyTable.put("f6", "117");
        this._keyTable.put("f7", "118");
        this._keyTable.put("f8", "119");
        this._keyTable.put("f9", "120");
        this._keyTable.put("f10", "121");
        this._keyTable.put("f11", "122");
        this._keyTable.put("f12", "123");
        this._keyTable.put("a", "65");
        this._keyTable.put("b", "66");
        this._keyTable.put("c", "67");
        this._keyTable.put("d", "68");
        this._keyTable.put("e", "69");
        this._keyTable.put("f", "70");
        this._keyTable.put("g", "71");
        this._keyTable.put("h", "72");
        this._keyTable.put("i", "73");
        this._keyTable.put("j", "74");
        this._keyTable.put("k", "75");
        this._keyTable.put("l", "76");
        this._keyTable.put("m", "77");
        this._keyTable.put("n", "78");
        this._keyTable.put("o", "79");
        this._keyTable.put("p", "80");
        this._keyTable.put("q", "81");
        this._keyTable.put("r", "82");
        this._keyTable.put("s", "83");
        this._keyTable.put("t", "84");
        this._keyTable.put("u", "85");
        this._keyTable.put("v", "86");
        this._keyTable.put("w", "87");
        this._keyTable.put("x", "88");
        this._keyTable.put("y", "89");
        this._keyTable.put("z", "90");
        this._keyTable.put("arrow_up", "38");
        this._keyTable.put("arrow_down", "40");
        this._keyTable.put("arrow_left", "37");
        this._keyTable.put("arrow_right", "39");
    }

    public String getKeyCode(String keyname) {
        if (this._keyTable == null) {
            this._createKeyTable();
        }
        return (String)this._keyTable.get(keyname.toLowerCase());
    }

    public static String qq(String s) {
        if (s != null) {
            char[] ca = s.toCharArray();
            StringBuffer sb = new StringBuffer();
            sb.append("\"");
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == '\\' || ca[i] == '\"') {
                    sb.append('\\');
                }
                sb.append(ca[i]);
            }
            sb.append("\"");
            s = sb.toString();
        }
        return s;
    }

    public static String escapeBackslash(String s) {
        if (s != null) {
            char[] ca = s.toCharArray();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == '\\') {
                    sb.append('\\');
                }
                sb.append(ca[i]);
            }
            s = sb.toString();
        }
        return s;
    }

    public static void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            Utils.encodeComponent(context, child);
        }
    }

    public static void encodeComponent(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator children = component.getChildren().iterator();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                Utils.encodeComponent(context, child);
            }
        }
        component.encodeEnd(context);
    }

    public static UIComponent findComponent(UIComponent component, String target) {
        UIComponent found = null;
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent c = (UIComponent)children.next();
            if (c.getId() != null && c.getId().equals(target)) {
                return c;
            }
            if (c instanceof NamingContainer) {
                found = c.findComponent(target);
            }
            if (found == null && c.getChildCount() > 0) {
                found = Utils.findComponent(c, target);
            }
            if (found == null) continue;
            break;
        }
        return found;
    }

    public static UIComponent findNearestComponent(UIComponent component, String target) {
        UIComponent found = null;
        UIComponent parentNamingContainer = Utils.getParentNamingContainer(component);
        while (parentNamingContainer != null && (found = Utils.findComponent(parentNamingContainer, target)) == null) {
            parentNamingContainer = Utils.getParentNamingContainer(parentNamingContainer);
        }
        if (found == null) {
            found = Utils.findComponent((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), target);
        }
        return found;
    }

    public static UIComponent getParentNamingContainer(UIComponent component) {
        if (component == null) {
            return null;
        }
        UIComponent parent = component.getParent();
        if (parent instanceof NamingContainer) {
            return parent;
        }
        return Utils.getParentNamingContainer(parent);
    }

    public static String versionizeFilename(String filename) {
        if (filename == null) {
            return filename;
        }
        if (filename.lastIndexOf(".") == -1) {
            return filename + "_" + "v3_1_3";
        }
        StringBuffer newname = new StringBuffer(filename.substring(0, filename.lastIndexOf("."))).append("_").append("v3_1_3").append(filename.substring(filename.lastIndexOf(".")));
        return newname.toString();
    }

    public static UIData findParentUIData(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIData) {
            return (UIData)component;
        }
        return Utils.findParentUIData(component.getParent());
    }

    public static UIDataIterator findParentUIDataIterator(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIDataIterator) {
            return (UIDataIterator)component;
        }
        return Utils.findParentUIDataIterator(component.getParent());
    }

    public static String getViewIdFromRequest(FacesContext context) {
        String viewId = null;
        Map reqMap = context.getExternalContext().getRequestMap();
        viewId = (String)reqMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)reqMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null && context.getExternalContext().getRequest() instanceof HttpServletRequest) {
            viewId = ((HttpServletRequest)context.getExternalContext().getRequest()).getServletPath();
        }
        return viewId;
    }

    public static String appendStrings(String[] values) {
        StringBuffer buf = new StringBuffer();
        Boolean first = Boolean.TRUE;
        for (int i = 0; i < values.length; ++i) {
            if (first.booleanValue()) {
                buf.append("\"");
                first = Boolean.FALSE;
            } else {
                buf.append(",\"");
            }
            buf.append(values[i]).append("\"");
        }
        return buf.toString();
    }

    public static int getDateStyle(String s) {
        int dateCode = 2;
        if (s != null && s != "") {
            if (DATESTYLE_SHORT.equalsIgnoreCase(s)) {
                dateCode = 3;
            } else if (DATESTYLE_MEDIUM.equalsIgnoreCase(s)) {
                dateCode = 2;
            } else if (DATESTYLE_LONG.equalsIgnoreCase(s)) {
                dateCode = 1;
            } else if (DATESTYLE_FULL.equalsIgnoreCase(s)) {
                dateCode = 0;
            }
        }
        return dateCode;
    }

    public static String getEncodedResourceURL(FacesContext context, String src) {
        src = context.getApplication().getViewHandler().getResourceURL(context, src);
        return context.getExternalContext().encodeResourceURL(src);
    }

    public static String getFirstCSSClassName(String classes) {
        if (classes == null) {
            return null;
        }
        int firstSpace = classes.indexOf(32);
        if (firstSpace != -1) {
            return classes.substring(0, firstSpace);
        }
        return classes;
    }

    public static String checkMeasurementMetric(String measurement) {
        String retMeasurement = measurement;
        if (retMeasurement != null) {
            retMeasurement = retMeasurement.trim();
            if (Character.isDigit(measurement.charAt(measurement.length() - 1))) {
                retMeasurement = retMeasurement + "px";
            }
        }
        return retMeasurement;
    }
}

