/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlOutputStatistics;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.RowSelectRenderer;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class StatisticsRenderer
extends Renderer
implements IScriptContributor {
    private static final String PAD_STATISTICS = "__stats";
    private static final String JS_STATISTICS = "__jsStatistics";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        HxClientRenderUtil.initJSLibraries(component, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_be.js", component);
        HxClientRenderUtil.addScriptLibrary("hxclient_table.js", component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String title;
        String statusTextOn;
        String filteredOn;
        String shownOn;
        String totalOn;
        String selectedOn;
        String pagingOn;
        String styleClass;
        String style;
        UIData data;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlOutputStatistics statComponent = null;
        if (component instanceof HtmlOutputStatistics) {
            statComponent = (HtmlOutputStatistics)component;
        }
        if ((data = this.findUIData(component)) == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String id = component.getClientId(context);
        if (statComponent != null) {
            style = statComponent.getStyle();
            styleClass = statComponent.getStyleClass();
            pagingOn = statComponent.getPaging();
            selectedOn = statComponent.getSelected();
            totalOn = statComponent.getTotal();
            shownOn = statComponent.getShown();
            filteredOn = statComponent.getFiltered();
            statusTextOn = statComponent.getStatusText();
            title = statComponent.getTitle();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            pagingOn = (String)component.getAttributes().get("paging");
            selectedOn = (String)component.getAttributes().get("selected");
            totalOn = (String)component.getAttributes().get("total");
            shownOn = (String)component.getAttributes().get("shown");
            filteredOn = (String)component.getAttributes().get("filtered");
            statusTextOn = (String)component.getAttributes().get("statusText");
            title = (String)component.getAttributes().get("title");
        }
        if (pagingOn == null && selectedOn == null && totalOn == null && shownOn == null && filteredOn == null && statusTextOn == null) {
            pagingOn = "true";
            selectedOn = "true";
        }
        int currentPage = this.getCurrentPage(data);
        int lastPage = this.getLastPage(data);
        String jsStatistics = id + JS_STATISTICS;
        jsStatistics = JavaScriptUtil.makeVariableName(jsStatistics);
        int numSelected = -99;
        Job job = new Job(jsStatistics);
        boolean supportsSelection = this.getSelectedRows(data, (UIComponent)data, job);
        if (supportsSelection) {
            numSelected = job.getSelected();
        }
        int totalRows = this.getTotalRows(data);
        int shownRows = this.getShownRows(data);
        String filteredRows = "-99";
        if (filteredOn != null && filteredOn.trim().length() > 0) {
            filteredRows = statComponent.getFiltered();
        }
        if (statusTextOn == null || statusTextOn.trim().equals("")) {
            HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
            if (id != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
            }
            if (title != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "title", title);
            }
            if (style != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
            }
            if (styleClass != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
            }
            HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
            if (pagingOn != null && pagingOn.trim().equalsIgnoreCase("true") && lastPage >= 0) {
                HtmlUtil.writeTagStartOpen((Writer)writer, "span", true, false);
                Object[] args = new Object[]{new Integer(currentPage + 1), new Integer(lastPage + 1)};
                String localizedPageOf = ResourceHandler.getString(bundle, "PagerRenderer.pageof", args);
                HtmlUtil.writeText((Writer)writer, localizedPageOf);
                HtmlUtil.writeTagEndLn((Writer)writer, "span");
            }
            if (selectedOn != null && selectedOn.equalsIgnoreCase("true")) {
                String localizedSelected = ResourceHandler.getString(bundle, "DatagridStatisticsRenderer.Selected");
                if (supportsSelection) {
                    writer.write(" ");
                    HtmlUtil.writeTagStartOpen((Writer)writer, "span", true, false);
                    HtmlUtil.writeText((Writer)writer, localizedSelected);
                    HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
                    HtmlUtil.writeTagAttribute((Writer)writer, "id", id + PAD_STATISTICS);
                    HtmlUtil.writeTagStartClose((Writer)writer, false);
                    writer.write("" + numSelected);
                    HtmlUtil.writeTagEndLn((Writer)writer, "span");
                    HtmlUtil.writeTagEndLn((Writer)writer, "span");
                }
                if (supportsSelection) {
                    StringBuffer script = new StringBuffer();
                    String tableClientId = data.getClientId(context);
                    script.append("if(");
                    script.append("hX_6");
                    script.append(".getComponentById(\"");
                    script.append(tableClientId);
                    script.append("\") === null)");
                    script.append("hX_6");
                    script.append(".addComponent(\"");
                    script.append(tableClientId);
                    script.append("\", new ");
                    script.append("hX_6");
                    script.append(".JSFDataTable());\n");
                    script.append("hX_6");
                    script.append(".getComponentById(\"");
                    script.append(tableClientId);
                    script.append("\").setAttribute(\"pager-select-div:");
                    script.append(id + PAD_STATISTICS);
                    script.append("\");\n");
                    this.writeJavaScript(context, component, script.toString());
                }
            }
            if (totalOn != null && totalOn.trim().equalsIgnoreCase("true")) {
                HtmlUtil.writeTagStartOpen((Writer)writer, "span", true, false);
                Object[] args1 = new Object[]{new Integer(totalRows)};
                String localizedTotal = ResourceHandler.getString(bundle, "DatagridStatisticsRenderer.Total", args1);
                HtmlUtil.writeText((Writer)writer, localizedTotal);
                HtmlUtil.writeTagEndLn((Writer)writer, "span");
            }
            if (shownOn != null && shownOn.trim().equalsIgnoreCase("true")) {
                HtmlUtil.writeTagStartOpen((Writer)writer, "span", true, false);
                Object[] args2 = new Object[]{new Integer(shownRows)};
                String localizedShown = ResourceHandler.getString(bundle, "DatagridStatisticsRenderer.Shown", args2);
                HtmlUtil.writeText((Writer)writer, localizedShown);
                HtmlUtil.writeTagEndLn((Writer)writer, "span");
            }
            if (filteredOn != null && filteredOn.trim().length() > 0) {
                HtmlUtil.writeTagStartOpen((Writer)writer, "span", true, false);
                Object[] args3 = new Object[]{new Integer(filteredRows)};
                String localizedFiltered = ResourceHandler.getString(bundle, "DatagridStatisticsRenderer.Filtered", args3);
                HtmlUtil.writeText((Writer)writer, localizedFiltered);
                HtmlUtil.writeTagEndLn((Writer)writer, "span");
            }
            HtmlUtil.writeTagEndLn((Writer)writer, "span");
        } else {
            HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
            if (id != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
            }
            if (title != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "title", title);
            }
            if (style != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
            }
            if (styleClass != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
            }
            HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
            String statusText = statusTextOn;
            Integer filter = new Integer(filteredRows);
            int[] args = new int[]{currentPage + 1, lastPage + 1, numSelected, totalRows, shownRows, filter};
            for (int i = 0; i < 6; ++i) {
                if (i == 2) continue;
                while (statusText.indexOf("{" + i + "}") >= 0) {
                    statusText = statusText.substring(0, statusText.indexOf("{" + i + "}")) + args[i] + statusText.substring(statusText.indexOf("{" + i + "}") + 3, statusText.length());
                }
            }
            int x = 0;
            while (statusText.indexOf("{2}") >= 0 && supportsSelection) {
                HtmlUtil.writeText((Writer)writer, statusText.substring(0, statusText.indexOf("{2}")));
                HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
                HtmlUtil.writeTagAttribute((Writer)writer, "id", id + PAD_STATISTICS + x);
                HtmlUtil.writeTagStartClose((Writer)writer, false);
                writer.write("" + numSelected);
                HtmlUtil.writeTagEndLn((Writer)writer, "span");
                StringBuffer script = new StringBuffer();
                String tableClientId = data.getClientId(context);
                script.append("if(");
                script.append("hX_6");
                script.append(".getComponentById(\"");
                script.append(tableClientId);
                script.append("\") === null)");
                script.append("hX_6");
                script.append(".addComponent(\"");
                script.append(tableClientId);
                script.append("\", new ");
                script.append("hX_6");
                script.append(".JSFDataTable());");
                script.append("\n");
                script.append("hX_6");
                script.append(".getComponentById(\"");
                script.append(tableClientId);
                script.append("\").setAttribute(\"pager-select-div:");
                script.append(id + PAD_STATISTICS + x);
                script.append("\");");
                this.writeJavaScript(context, component, script.toString());
                statusText = statusText.substring(statusText.indexOf("{2}") + 3, statusText.length());
                ++x;
            }
            HtmlUtil.writeText((Writer)writer, statusText);
            HtmlUtil.writeTagEndLn((Writer)writer, "span");
        }
    }

    private UIData findUIData(UIComponent component) {
        String _for;
        HtmlOutputStatistics statComponent = null;
        if (component instanceof HtmlOutputStatistics) {
            statComponent = (HtmlOutputStatistics)component;
        }
        if ((_for = statComponent != null ? statComponent.getFor() : (String)component.getAttributes().get("for")) == null) {
            return this.getUIDataParent(component);
        }
        UIComponent c = component.findComponent(_for);
        if (c == null || !(c instanceof UIData)) {
            return null;
        }
        return (UIData)c;
    }

    private UIData getUIDataParent(UIComponent component) {
        if ((component = component.getParent()) == null) {
            return null;
        }
        if (component instanceof UIData) {
            return (UIData)component;
        }
        return this.getUIDataParent(component);
    }

    private boolean getSelectedRows(UIData data, UIComponent component, Job job) {
        if (data == null) {
            return false;
        }
        if ("com.ibm.faces.RowSelect".equals(component.getRendererType())) {
            int start = data.getFirst();
            int rows = data.getRows();
            int len = rows > 0 ? start + rows : data.getRowCount();
            for (int i = start; i < len; ++i) {
                data.setRowIndex(i);
                if (!data.isRowAvailable()) break;
                job.processRow(component);
            }
            data.setRowIndex(-1);
            return true;
        }
        List children = component.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (!this.getSelectedRows(data, child, job)) continue;
            return true;
        }
        return false;
    }

    private void writeJavaScript(FacesContext context, UIComponent component, String script) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        if (scriptCollector != null) {
            HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
            scriptCollector.addScript(script);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.write(JavaScriptUtil.getStartTag());
            writer.write(script);
            writer.write(JavaScriptUtil.getEndTag());
        }
    }

    private int getCurrentPage(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        if (rows <= 0) {
            return 0;
        }
        return data.getFirst() / rows;
    }

    private int getShownRows(UIData dataComponent) {
        if (dataComponent == null) {
            return 0;
        }
        int processedRowCount = 0;
        Boolean processRow = Boolean.TRUE;
        int rowIndex = dataComponent.getFirst();
        int rowsToDisplay = dataComponent.getRows();
        while (processRow.booleanValue()) {
            if (rowsToDisplay > 0 && ++processedRowCount >= rowsToDisplay) {
                processRow = Boolean.FALSE;
                continue;
            }
            dataComponent.setRowIndex(++rowIndex);
            if (dataComponent.isRowAvailable()) continue;
            processRow = Boolean.FALSE;
        }
        dataComponent.setRowIndex(-1);
        return processedRowCount;
    }

    private int getTotalRows(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        int max = data.getRowCount();
        if (rows <= 0 && max <= 0) {
            if (max < 0) {
                return -1;
            }
            return 0;
        }
        return max;
    }

    private int getLastPage(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        if (rows <= 0) {
            return 0;
        }
        int max = data.getRowCount();
        if (max < 0) {
            return -1;
        }
        if (max > 0) {
            int lastPage = max / rows;
            if (max % rows == 0) {
                --lastPage;
            }
            return lastPage;
        }
        return 0;
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
    }

    private class Job {
        private int selected = 0;
        private int total = 0;
        private int shown = 0;
        private String jsStatistics;
        private StringBuffer script = new StringBuffer();

        Job(String jsStatistics) {
            this.jsStatistics = jsStatistics;
        }

        void processRow(UIComponent component) {
            boolean bSelected = false;
            if (RowSelectRenderer.isRowSelected(component)) {
                ++this.selected;
                bSelected = true;
            }
            String selectionVar = RowSelectRenderer.getJsSelectionVariable(component.getClientId(FacesContext.getCurrentInstance()));
            this.script.append("if(!").append(selectionVar).append(") var ").append(selectionVar).append(" = new ").append("HxG_6").append(".prototype.HxSelection(").append(bSelected).append("); \r\n");
            this.script.append(selectionVar).append(".addSelectionListener(").append(this.jsStatistics).append(");\r\n");
        }

        StringBuffer getScript() {
            return this.script;
        }

        int getSelected() {
            return this.selected;
        }
    }
}

