/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIPager;
import com.ibm.faces.component.html.HtmlPagerSimple;
import com.ibm.faces.renderkit.html_extended.AbstractPagerRenderer;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.HtmlUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class SimplePagerRenderer
extends AbstractPagerRenderer {
    private static final String PAGER_SIMPLE_CHOOSE = "___pagerSimple";
    private static final String PAGER_SIMPLE_GO = "___pagerSimpleGo";
    private static final String PAGER_PREVIOUS = "__pagerPrevious";
    private static final String PAGER_NEXT = "__pagerNext";
    private static final String PAGER_FIRST = "__pagerFirst";
    private static final String PAGER_LAST = "__pagerLast";
    private static final String PAGER_LAST_SELECTED = "__lastSelected";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String imageSrc;
        String tabindex;
        String title;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlPagerSimple simpleComponent = null;
        if (component instanceof HtmlPagerSimple) {
            simpleComponent = (HtmlPagerSimple)component;
        }
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        int lastPage = ((UIPager)component).getLastPage(pdw);
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String localizedNext = ResourceHandler.getString(bundle, "PagerRenderer.nextPage");
        String localizedPrevious = ResourceHandler.getString(bundle, "PagerRenderer.previousPage");
        String localizedFirst = ResourceHandler.getString(bundle, "PagerRenderer.firstPage");
        String localizedLast = ResourceHandler.getString(bundle, "PagerRenderer.lastPage");
        String localizedGo = ResourceHandler.getString(bundle, "PagerRenderer.go");
        String id = component.getClientId(context);
        String selectId = id + PAGER_SIMPLE_CHOOSE;
        String inputId = id + PAGER_SIMPLE_GO;
        if (simpleComponent != null) {
            style = simpleComponent.getStyle();
            styleClass = simpleComponent.getStyleClass();
            title = simpleComponent.getTitle();
            tabindex = simpleComponent.getTabindex();
            imageSrc = simpleComponent.getButtonImageSrc();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            title = (String)component.getAttributes().get("title");
            tabindex = (String)component.getAttributes().get("tabindex");
            imageSrc = (String)component.getAttributes().get("buttonImageSrc");
        }
        if (imageSrc != null) {
            imageSrc = Utils.getEncodedResourceURL(context, imageSrc);
        }
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        HtmlUtil.writeTagStartOpen((Writer)writer, "select", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", selectId);
        HtmlUtil.writeTagAttribute((Writer)writer, "name", selectId);
        HtmlUtil.writeTagAttribute((Writer)writer, "size", "1");
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        String lastSelected = (String)component.getAttributes().get(PAGER_LAST_SELECTED);
        if (PAGER_PREVIOUS.equals(lastSelected)) {
            HtmlUtil.writeOption((Writer)writer, localizedPrevious, PAGER_PREVIOUS);
            HtmlUtil.writeOption((Writer)writer, localizedNext, PAGER_NEXT);
        } else {
            HtmlUtil.writeOption((Writer)writer, localizedNext, PAGER_NEXT);
            HtmlUtil.writeOption((Writer)writer, localizedPrevious, PAGER_PREVIOUS);
        }
        HtmlUtil.writeOption((Writer)writer, localizedFirst, PAGER_FIRST);
        if (lastPage >= 0) {
            HtmlUtil.writeOption((Writer)writer, localizedLast, PAGER_LAST);
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "select");
        writer.write("\n");
        writer.startElement("input", component);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", null);
            writer.writeAttribute("src", (Object)imageSrc, null);
        } else {
            writer.writeAttribute("type", (Object)"submit", null);
        }
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("value", (Object)localizedGo, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
            writer.writeAttribute("alt", (Object)title, null);
        }
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        writer.endElement("input");
        writer.write("\n");
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        if (pdw == null) {
            return;
        }
        if (!((UIPager)component).isPaged(pdw)) {
            return;
        }
        int newPage = -1;
        int currentPage = ((UIPager)component).getCurrentPage(pdw);
        int lastPage = ((UIPager)component).getLastPage(pdw);
        String keyGo = component.getClientId(context) + PAGER_SIMPLE_GO;
        if (context.getExternalContext().getRequestParameterMap().get(keyGo) != null || context.getExternalContext().getRequestParameterMap().get(keyGo + ".x") != null) {
            String keyChoice = component.getClientId(context) + PAGER_SIMPLE_CHOOSE;
            String valueChoice = (String)context.getExternalContext().getRequestParameterMap().get(keyChoice);
            if (valueChoice.equals(PAGER_NEXT)) {
                component.getAttributes().put(PAGER_LAST_SELECTED, PAGER_NEXT);
                newPage = currentPage + 1;
            } else if (valueChoice.equals(PAGER_PREVIOUS)) {
                component.getAttributes().put(PAGER_LAST_SELECTED, PAGER_PREVIOUS);
                newPage = currentPage - 1;
            } else if (valueChoice.equals(PAGER_FIRST)) {
                component.getAttributes().put(PAGER_LAST_SELECTED, PAGER_NEXT);
                newPage = 0;
            } else if (valueChoice.equals(PAGER_LAST) && lastPage >= 0) {
                component.getAttributes().put(PAGER_LAST_SELECTED, PAGER_PREVIOUS);
                newPage = lastPage >= 0 ? lastPage : currentPage + 1;
            }
            this.queueEvent(component, currentPage, newPage, lastPage);
        }
    }
}

