/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.html.HtmlOutputSelecticons;
import com.ibm.faces.renderkit.html_extended.AbstractSelectRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class SelecticonsRenderer
extends AbstractSelectRenderer
implements IScriptContributor {
    private static final String SELCTL_ICONS_ALL = "__selectCtrlIconsAll";
    private static final String SELCTL_ICONS_NONE = "__selectCtrlIconsNone";
    private static final String SELCTL_ICONS_INVERSE = "__selectCtrlIconsInverse";
    private static final String SELECT_ALL_IMG = Utils.versionizeFilename("datagrid_select_all.gif");
    private static final String SELECT_NONE_IMG = Utils.versionizeFilename("datagrid_select_none.gif");
    private static final String SELECT_INVERSE_IMG = Utils.versionizeFilename("datagrid_select_inverse.gif");

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String useButtonsVal;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HxClientRenderUtil.initJSLibraries(component, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_be.js", component);
        HxClientRenderUtil.addScriptLibrary("hxclient_table.js", component);
        HtmlOutputSelecticons selectComponent = null;
        if (component instanceof HtmlOutputSelecticons) {
            selectComponent = (HtmlOutputSelecticons)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String localizedSelectAll = ResourceHandler.getString(bundle, "DatagridSelectionRenderer.Select_All");
        String localizedSelectNone = ResourceHandler.getString(bundle, "DatagridSelectionRenderer.Select_None");
        String localizedSelectInverse = ResourceHandler.getString(bundle, "DatagridSelectionRenderer.Select_Inverse");
        String id = component.getClientId(context);
        String tableid = this.getParentTableID(context, component);
        StringBuffer buffer = new StringBuffer();
        String onclickSelectAll = this.makeOnclickCode(buffer, tableid, "selectAll");
        String onclickSelectNone = this.makeOnclickCode(buffer, tableid, "selectNone");
        String onclickSelectInverse = this.makeOnclickCode(buffer, tableid, "selectInverse");
        if (selectComponent != null) {
            style = selectComponent.getStyle();
            styleClass = selectComponent.getStyleClass();
            useButtonsVal = selectComponent.getUseButtons();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            useButtonsVal = component.getAttributes().get("useButtons");
        }
        boolean useButtons = "true".equals(useButtonsVal) || Boolean.TRUE.equals(useButtonsVal);
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        if (useButtons) {
            this.writeInputSubmit((Writer)writer, id + SELCTL_ICONS_ALL, localizedSelectAll, onclickSelectAll, styleClass);
            this.writeInputSubmit((Writer)writer, id + SELCTL_ICONS_NONE, localizedSelectNone, onclickSelectNone, styleClass);
            this.writeInputSubmit((Writer)writer, id + SELCTL_ICONS_INVERSE, localizedSelectInverse, onclickSelectInverse, styleClass);
        } else {
            String srcInverse;
            String srcNone;
            String srcAll;
            if (selectComponent != null) {
                srcAll = selectComponent.getSrcAll();
                srcNone = selectComponent.getSrcNone();
                srcInverse = selectComponent.getSrcInverse();
            } else {
                srcAll = (String)component.getAttributes().get("srcAll");
                srcNone = (String)component.getAttributes().get("srcNone");
                srcInverse = (String)component.getAttributes().get("srcInverse");
            }
            String imgAll = this.encodeResource(context, srcAll, SELECT_ALL_IMG);
            String imgNone = this.encodeResource(context, srcNone, SELECT_NONE_IMG);
            String imgInverse = this.encodeResource(context, srcInverse, SELECT_INVERSE_IMG);
            this.writeInputImage((Writer)writer, id + SELCTL_ICONS_ALL, localizedSelectAll, imgAll, onclickSelectAll, styleClass);
            this.writeInputImage((Writer)writer, id + SELCTL_ICONS_NONE, localizedSelectNone, imgNone, onclickSelectNone, styleClass);
            this.writeInputImage((Writer)writer, id + SELCTL_ICONS_INVERSE, localizedSelectInverse, imgInverse, onclickSelectInverse, styleClass);
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
    }

    private String makeOnclickCode(StringBuffer buffer, String tableClientId, String method) {
        buffer.setLength(0);
        buffer.append("return ");
        buffer.append("hX_6");
        buffer.append(".getComponentById('");
        buffer.append(tableClientId);
        buffer.append("').selection.");
        buffer.append(method);
        buffer.append("();");
        return buffer.toString();
    }

    private void writeInputImage(Writer writer, String id, String alt, String src, String onclick, String css) throws IOException {
        HtmlUtil.writeTagStartOpen(writer, "input", false, false);
        HtmlUtil.writeTagAttribute(writer, "type", "image");
        HtmlUtil.writeTagAttribute(writer, "id", id);
        HtmlUtil.writeTagAttribute(writer, "name", id);
        HtmlUtil.writeTagAttribute(writer, "alt", alt);
        HtmlUtil.writeTagAttribute(writer, "title", alt);
        HtmlUtil.writeTagAttribute(writer, "src", src);
        HtmlUtil.writeTagAttribute(writer, "onclick", onclick);
        HtmlUtil.writeTagAttribute(writer, "class", css);
        HtmlUtil.writeTagStartCloseLn(writer, true);
    }

    private String encodeResource(FacesContext context, String customImage, String defaultImage) {
        String imageURL = null;
        imageURL = customImage != null ? Utils.getEncodedResourceURL(context, customImage) : context.getExternalContext().encodeResourceURL(JavaScriptUtil.getImageURL(context, defaultImage));
        return imageURL;
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
    }
}

