/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputRowSelect;
import com.ibm.faces.renderkit.html_extended.AbstractRowRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import com.ibm.faces.util.LifecycleUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;

public class RowSelectRenderer
extends AbstractRowRenderer
implements IScriptContributor {
    private static final String PAD_INPUT_SEL = "__input_sel";
    private static final String PAD_HIDDEN_SEL = "__hidden_sel";
    private static final String IMAGE_SELECTED = Utils.versionizeFilename("datagrid_selected.gif");
    private static final String IMAGE_UNSELECTED = Utils.versionizeFilename("datagrid_unselected.gif");
    private static final String SELECTONE_IMAGE_SELECTED = Utils.versionizeFilename("datagrid_radio_selected.gif");
    private static final String SELECTONE_IMAGE_UNSELECTED = Utils.versionizeFilename("datagrid_radio_unselected.gif");
    private static final String JS_SELECTION = "__jsSelection";
    private static final String JS_OBJGROUP = "__jsObjGroup";
    private static final String VALUE_STORE = "com.ibm.faces.ROW_SEL_TEMP_";
    private static final String ORIGINAL_VALUE_STORE = "com.ibm.faces.ROW_SEL_ORIGINAL_";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String titleSelected;
        String title;
        String onmouseup;
        String onclick;
        String selectOneStr;
        String styleClass;
        String style;
        String noscriptString;
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        this.initializeValues(context, component);
        boolean selected = RowSelectRenderer.isRowSelected(component);
        if (selectComponent != null) {
            noscriptString = selectComponent.getNoscript();
            style = selectComponent.getStyle();
            styleClass = selectComponent.getStyleClass();
            selectOneStr = selectComponent.getSelectOne();
            onclick = selectComponent.getOnclick();
            onmouseup = selectComponent.getOnmouseup();
            title = selectComponent.getTitle();
            titleSelected = selectComponent.getTitleSelected();
        } else {
            noscriptString = (String)component.getAttributes().get("noscript");
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            selectOneStr = (String)component.getAttributes().get("selectOne");
            onclick = (String)component.getAttributes().get("onclick");
            onmouseup = (String)component.getAttributes().get("onmouseup");
            title = (String)component.getAttributes().get("title");
            titleSelected = (String)component.getAttributes().get("titleSelected");
        }
        boolean noscript = "true".equalsIgnoreCase(noscriptString);
        boolean selectOne = "true".equalsIgnoreCase(selectOneStr);
        if (noscript) {
            String paddedId = id + PAD_INPUT_SEL;
            HtmlUtil.writeTagStartOpen((Writer)writer, "input", false, false);
            if (onclick != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "onclick", onclick);
            }
            if (onmouseup != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "onmouseup", onmouseup);
            }
            if (selectOne) {
                HtmlUtil.writeTagAttribute((Writer)writer, "type", "radio");
                HtmlUtil.writeTagAttribute((Writer)writer, "id", component.getId());
                HtmlUtil.writeTagAttribute((Writer)writer, "name", component.getId());
                HtmlUtil.writeTagAttribute((Writer)writer, "value", component.getClientId(context));
            } else {
                HtmlUtil.writeTagAttribute((Writer)writer, "type", "checkbox");
                HtmlUtil.writeTagAttribute((Writer)writer, "id", paddedId);
                HtmlUtil.writeTagAttribute((Writer)writer, "name", paddedId);
            }
            HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
            HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
            HtmlUtil.writeTagAttribute((Writer)writer, "title", title);
            if (selected) {
                HtmlUtil.writeTagAttribute((Writer)writer, "checked", "checked");
            }
            HtmlUtil.writeTagStartCloseLn((Writer)writer, true);
        } else {
            ResourceBundle bundle = ResourceHandler.getBundle(context);
            String paddedId = id + PAD_INPUT_SEL;
            String localizedUnselected = ResourceHandler.getString(bundle, "DataRendererSelect.unselected");
            String localizedSelected = ResourceHandler.getString(bundle, "DataRendererSelect.selected");
            if (titleSelected != null && titleSelected.length() > 0) {
                localizedSelected = titleSelected;
            }
            if (title != null && title.length() > 0) {
                localizedUnselected = title;
            }
            String src = this.getImage(context, component, selectOne, selected);
            String alt = selected ? localizedSelected : localizedUnselected;
            HtmlUtil.writeTagStartOpen((Writer)writer, "input", false, false);
            if (onclick != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "onclick", onclick);
            }
            if (onmouseup != null) {
                HtmlUtil.writeTagAttribute((Writer)writer, "onmouseup", onmouseup);
            }
            HtmlUtil.writeTagAttribute((Writer)writer, "type", "image");
            HtmlUtil.writeTagAttribute((Writer)writer, "id", paddedId);
            HtmlUtil.writeTagAttribute((Writer)writer, "name", paddedId);
            HtmlUtil.writeTagAttribute((Writer)writer, "src", src);
            HtmlUtil.writeTagAttribute((Writer)writer, "alt", alt);
            HtmlUtil.writeTagAttribute((Writer)writer, "title", alt);
            HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
            HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
            HtmlUtil.writeTagStartCloseLn((Writer)writer, true);
            HtmlUtil.writeInputHidden((Writer)writer, id + PAD_HIDDEN_SEL, selected ? "true" : "false");
            this.encodeJavaScript(context, component, selectOne, selected);
        }
        this.encodeParameters(context, component);
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
    }

    private void encodeJavaScript(FacesContext context, UIComponent component, boolean selectOne, boolean selected) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        String dataId = this.findUIDataId(context, component);
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        if (dataId != null) {
            String title;
            String titleSelected;
            ResourceBundle bundle = ResourceHandler.getBundle(context);
            String id = component.getClientId(context);
            String localizedUnselected = ResourceHandler.getString(bundle, "DataRendererSelect.unselected");
            String localizedSelected = ResourceHandler.getString(bundle, "DataRendererSelect.selected");
            if (selectComponent != null) {
                titleSelected = selectComponent.getTitleSelected();
                title = selectComponent.getTitle();
            } else {
                titleSelected = (String)component.getAttributes().get("titleSelected");
                title = (String)component.getAttributes().get("title");
            }
            if (titleSelected != null && titleSelected.length() > 0) {
                localizedSelected = titleSelected;
            }
            if (title != null && title.length() > 0) {
                localizedUnselected = title;
            }
            String src_sel = this.getImage(context, component, selectOne, true);
            String src_usel = this.getImage(context, component, selectOne, false);
            StringBuffer buffer = new StringBuffer();
            buffer.append("if(");
            buffer.append("hX_6");
            buffer.append(".getComponentById(\"");
            buffer.append(dataId);
            buffer.append("\") === null)");
            buffer.append("hX_6");
            buffer.append(".addComponent(\"");
            buffer.append(dataId);
            buffer.append("\", new ");
            buffer.append("hX_6");
            buffer.append(".JSFDataTable());\n");
            buffer.append("hX_6");
            buffer.append(".getComponentById(\"");
            buffer.append(dataId);
            buffer.append("\").setAttribute([\"selection:true\", \"single-select:");
            buffer.append(selectOne ? "true" : "false");
            buffer.append("\"]); \n");
            String varCellGroup = RowSelectRenderer.getJsSelectionGroupVariable(dataId);
            buffer.append("var ");
            buffer.append(varCellGroup);
            buffer.append(" = ");
            buffer.append("hX_6");
            buffer.append(".getComponentById(\"");
            buffer.append(dataId);
            buffer.append("\").selection;\n");
            this.writeJavaScriptOnce(context, component, scriptCollector, buffer.toString());
            buffer.setLength(0);
            String columnClasses = selectComponent != null ? selectComponent.getColumnClasses() : (String)component.getAttributes().get("columnClasses");
            buffer.append("hX_6");
            buffer.append(".addBehavior(\"");
            buffer.append(id);
            buffer.append("\", \"onclick\", new ");
            buffer.append("hX_6");
            buffer.append(".JSFBehaviorRowSelect(\"");
            buffer.append(dataId);
            buffer.append("\"");
            buffer.append(", \"selected-img:");
            buffer.append(src_sel);
            buffer.append("\"");
            buffer.append(", \"unselected-img:");
            buffer.append(src_usel);
            buffer.append("\"");
            buffer.append(", \"selected-alt:");
            buffer.append(localizedSelected);
            buffer.append("\"");
            buffer.append(", \"unselected-alt:");
            buffer.append(localizedUnselected);
            buffer.append("\"");
            if (columnClasses != null) {
                buffer.append(", \"selection-class:");
                buffer.append(columnClasses);
                buffer.append("\"");
            }
            buffer.append(", \"selected:");
            buffer.append(selected ? "true" : "false");
            buffer.append("\"));\n");
            this.writeJavaScript(context, scriptCollector, buffer.toString());
        }
    }

    private void writeJavaScriptOnce(FacesContext context, UIComponent component, UIScriptCollector scriptCollector, String script) throws IOException {
        if (scriptCollector != null) {
            HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
            HxClientRenderUtil.addScriptLibrary("hxclient_be.js", component);
            HxClientRenderUtil.addScriptLibrary("hxclient_table.js", component);
            scriptCollector.addScript(script);
        } else {
            this.writeJavaScript(context, null, script);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        String selectOneStr;
        String noscriptString;
        String id = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        if (selectComponent != null) {
            noscriptString = selectComponent.getNoscript();
            selectOneStr = selectComponent.getSelectOne();
        } else {
            noscriptString = (String)component.getAttributes().get("noscript");
            selectOneStr = (String)component.getAttributes().get("selectOne");
        }
        boolean noscript = "true".equalsIgnoreCase(noscriptString);
        boolean selectOne = "true".equalsIgnoreCase(selectOneStr);
        boolean selected = false;
        if (noscript) {
            if (selectOne) {
                String selectOneValue = (String)requestMap.get(component.getId());
                if (selectOneValue != null && selectOneValue.equals(id)) {
                    selected = true;
                }
            } else {
                selected = requestMap.get(id + PAD_INPUT_SEL) != null;
            }
        } else {
            selected = "true".equals(requestMap.get(id + PAD_HIDDEN_SEL));
        }
        this.initializeValues(context, component);
        this.setRowSelected(context, component, selected);
    }

    static boolean isRowSelected(UIComponent component) throws IndexOutOfBoundsException {
        if (!(component instanceof UIInput)) {
            return false;
        }
        UIInput input = (UIInput)component;
        Object value = input.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Boolean[]) {
            return RowSelectRenderer.isRowSelected(component, (Boolean[])value);
        }
        if (value instanceof boolean[]) {
            return RowSelectRenderer.isRowSelected(component, (boolean[])value);
        }
        if (value instanceof Integer[]) {
            return RowSelectRenderer.isRowSelected(component, (Integer[])value);
        }
        if (value instanceof int[]) {
            return RowSelectRenderer.isRowSelected(component, (int[])value);
        }
        if (value instanceof Collection) {
            return RowSelectRenderer.isRowSelected(component, (Collection)value);
        }
        return false;
    }

    private static boolean isRowSelected(UIComponent component, Boolean[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        if (arr[idx] == null) {
            return false;
        }
        return arr[idx];
    }

    private static boolean isRowSelected(UIComponent component, boolean[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        return arr[idx];
    }

    private static boolean isRowSelected(UIComponent component, Integer[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i] == null || arr[i] != idx) continue;
            return true;
        }
        return false;
    }

    private static boolean isRowSelected(UIComponent component, int[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i] != idx) continue;
            return true;
        }
        return false;
    }

    private static boolean isRowSelected(UIComponent component, Collection arr) {
        UIParameter[] params = LifecycleUtil.getParameters(component);
        if (params == null || params.length == 0) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            map.put(params[i].getName(), params[i].getValue());
        }
        return arr.contains(map);
    }

    private static int getCurrentRowIndex(UIComponent component) {
        UIData data = RowSelectRenderer.findUIData(component);
        if (data == null) {
            return -1;
        }
        return data.getRowIndex();
    }

    private void setRowSelected(FacesContext context, UIComponent component, boolean selected) {
        if (!(component instanceof UIInput)) {
            return;
        }
        UIInput input = (UIInput)component;
        Object value = input.getValue();
        UIData data = RowSelectRenderer.findUIData(component);
        Map reqMap = context.getExternalContext().getRequestMap();
        String valueParam = VALUE_STORE + component.getId();
        if (value instanceof Boolean) {
            if ((Boolean)value != selected && reqMap.get(valueParam) == null) {
                reqMap.put(valueParam, new Boolean[]{(Boolean)value, selected ? Boolean.TRUE : Boolean.FALSE});
            }
            input.setValue((Object)(selected ? Boolean.TRUE : Boolean.FALSE));
            if (this.isLastRow(data)) {
                Boolean[] b = (Boolean[])reqMap.get(valueParam);
                if (b != null) {
                    input.queueEvent((FacesEvent)new ValueChangeEvent(component, (Object)b[0], (Object)b[1]));
                }
                reqMap.remove(valueParam);
            }
        } else {
            Object v;
            Object newValue = reqMap.get(valueParam);
            boolean copy = false;
            if (newValue == null) {
                copy = true;
            } else {
                value = newValue;
            }
            if (value instanceof Collection) {
                v = value;
                if (copy) {
                    v = this.getCopy((Collection)v);
                    value = v;
                }
                this.setRowSelected(input, (Collection)v, selected);
            }
            if (value instanceof Boolean[]) {
                v = value;
                if (copy) {
                    v = this.getCopy((Boolean[])v);
                    value = v;
                }
                this.setRowSelected(input, (Boolean[])v, selected);
            } else if (value instanceof boolean[]) {
                v = value;
                if (copy) {
                    boolean[] blArray = this.getCopy((boolean[])v);
                    v = blArray;
                    value = blArray;
                }
                this.setRowSelected(input, (boolean[])v, selected);
            } else if (value instanceof Integer[]) {
                v = (Integer[])value;
                if (copy) {
                    v = this.getCopy((Integer[])v);
                    value = v;
                }
                value = this.setRowSelected(input, (Integer[])v, selected);
            } else if (value instanceof int[]) {
                v = (int[])value;
                if (copy) {
                    int[] nArray = this.getCopy((int[])v);
                    v = nArray;
                    value = nArray;
                }
                value = this.setRowSelected(input, (int[])v, selected);
            }
            boolean last = this.isLastRow(data);
            if (!last) {
                reqMap.put(valueParam, value);
            } else {
                String key = ORIGINAL_VALUE_STORE + component.getId();
                Object originalValue = reqMap.get(key);
                if (this.hasValueChanged(originalValue, value)) {
                    input.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)input, originalValue, value));
                }
                reqMap.remove(key);
                reqMap.remove(valueParam);
            }
            input.setValue(value);
        }
    }

    private boolean hasValueChanged(Object oldValue, Object newValue) {
        Boolean changed = Boolean.FALSE;
        if (oldValue == null) {
            if (newValue != null) {
                changed = Boolean.TRUE;
            }
        } else if (newValue == null) {
            changed = Boolean.TRUE;
        } else if (newValue instanceof boolean[]) {
            if (!Arrays.equals((boolean[])oldValue, (boolean[])newValue)) {
                changed = Boolean.TRUE;
            }
        } else if (newValue instanceof Boolean[]) {
            if (!Arrays.equals((Object[])((Boolean[])oldValue), (Object[])((Boolean[])newValue))) {
                changed = Boolean.TRUE;
            }
        } else if (newValue instanceof int[]) {
            if (!Arrays.equals((int[])oldValue, (int[])newValue)) {
                changed = Boolean.TRUE;
            }
        } else if (newValue instanceof Integer[]) {
            if (!Arrays.equals((Object[])((Integer[])oldValue), (Object[])((Integer[])newValue))) {
                changed = Boolean.TRUE;
            }
        } else if (newValue instanceof Collection && !Arrays.equals(((Collection)oldValue).toArray(), ((Collection)newValue).toArray())) {
            changed = Boolean.TRUE;
        }
        return changed;
    }

    private boolean isLastRow(UIData data) {
        int lastRow;
        boolean last = false;
        int currentRow = data.getRowIndex();
        if (data.getRows() >= 1 && (lastRow = data.getFirst() + data.getRows() - 1) == currentRow) {
            last = true;
        }
        if (last) {
            return last;
        }
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            if (currentRow + 1 == rowCount) {
                last = true;
            }
        } else {
            int nextRow = currentRow + 1;
            data.setRowIndex(nextRow);
            if (!data.isRowAvailable()) {
                last = true;
            }
            data.setRowIndex(currentRow);
        }
        return last;
    }

    private int[] getCopy(int[] array) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Integer[] getCopy(Integer[] array) {
        Integer[] copy = new Integer[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private boolean[] getCopy(boolean[] array) {
        boolean[] copy = new boolean[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Boolean[] getCopy(Boolean[] array) {
        Boolean[] copy = new Boolean[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Collection getCopy(Collection collection) {
        if (collection instanceof Cloneable) {
            try {
                Class[] params = new Class[]{};
                Method clone = collection.getClass().getMethod("clone", params);
                Object[] args = new Object[]{};
                Collection ret = (Collection)clone.invoke((Object)collection, args);
                return ret;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return collection;
    }

    private void setRowSelected(UIInput component, Boolean[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return;
        }
        if (arr[idx] != null && arr[idx] == selected) {
            return;
        }
        arr[idx] = selected ? Boolean.TRUE : Boolean.FALSE;
    }

    private void setRowSelected(UIInput component, boolean[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return;
        }
        if (arr[idx] == selected) {
            return;
        }
        arr[idx] = selected;
    }

    private Object setRowSelected(UIInput component, Integer[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return arr;
        }
        if (selected) {
            int len = arr.length;
            for (int i = 0; i < len; ++i) {
                if (arr[i] == null || arr[i] != idx) continue;
                return arr;
            }
            Integer[] copy = new Integer[arr.length + 1];
            System.arraycopy(arr, 0, copy, 0, arr.length);
            copy[arr.length] = new Integer(idx);
            return copy;
        }
        int found = -1;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i] == null || arr[i] != idx) continue;
            found = i;
            break;
        }
        if (found < 0) {
            return arr;
        }
        Integer[] copy = new Integer[arr.length - 1];
        System.arraycopy(arr, 0, copy, 0, found);
        System.arraycopy(arr, found + 1, copy, found, arr.length - found - 1);
        return copy;
    }

    private Object setRowSelected(UIInput component, int[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return arr;
        }
        if (selected) {
            int len = arr.length;
            for (int i = 0; i < len; ++i) {
                if (arr[i] != idx) continue;
                return arr;
            }
            int[] copy = new int[arr.length + 1];
            System.arraycopy(arr, 0, copy, 0, arr.length);
            copy[arr.length] = idx;
            return copy;
        }
        int found = -1;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i] != idx) continue;
            found = i;
            break;
        }
        if (found < 0) {
            return arr;
        }
        int[] copy = new int[arr.length - 1];
        System.arraycopy(arr, 0, copy, 0, found);
        System.arraycopy(arr, found + 1, copy, found, arr.length - found - 1);
        return copy;
    }

    private void setRowSelected(UIInput component, Collection arr, boolean selected) {
        Map map = this.decodeParameters(FacesContext.getCurrentInstance(), (UIComponent)component);
        if (map == null) {
            return;
        }
        try {
            if (selected && !arr.contains(map)) {
                arr.add(map);
            } else if (!selected && arr.contains(map)) {
                arr.remove(map);
            }
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    static String getJsSelectionVariable(String id) {
        return JavaScriptUtil.makeVariableName(id + JS_SELECTION);
    }

    static String getJsSelectionGroupVariable(String id) {
        return JavaScriptUtil.makeVariableName(id + JS_OBJGROUP);
    }

    private String getImage(FacesContext context, UIComponent component, boolean selectOne, boolean selected) {
        String ret;
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        if (selected) {
            String img = selectComponent != null ? selectComponent.getSrcSelected() : (String)component.getAttributes().get("srcSelected");
            if (img != null) {
                ret = Utils.getEncodedResourceURL(context, img);
            } else {
                ret = selectOne ? JavaScriptUtil.getImageURL(context, SELECTONE_IMAGE_SELECTED) : JavaScriptUtil.getImageURL(context, IMAGE_SELECTED);
                ret = context.getExternalContext().encodeResourceURL(ret);
            }
        } else {
            String img = selectComponent != null ? selectComponent.getSrcUnselected() : (String)component.getAttributes().get("srcUnselected");
            if (img != null) {
                ret = Utils.getEncodedResourceURL(context, img);
            } else {
                ret = selectOne ? JavaScriptUtil.getImageURL(context, SELECTONE_IMAGE_UNSELECTED) : JavaScriptUtil.getImageURL(context, IMAGE_UNSELECTED);
                ret = context.getExternalContext().encodeResourceURL(ret);
            }
        }
        return ret;
    }

    private void initializeValues(FacesContext context, UIComponent component) {
        String key = component.getId() + "_boolcheck";
        Boolean done = (Boolean)context.getExternalContext().getRequestMap().get(key);
        if (done != null) {
            return;
        }
        context.getExternalContext().getRequestMap().put(key, Boolean.TRUE);
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return;
        }
        String name = vb.getType(context).getName();
        Object val = ((UIInput)component).getValue();
        if (name.equals("[Ljava.lang.Boolean;") || name.equals("[Z") || name.equals("[Ljava.lang.Integer;") || name.equals("[I")) {
            int tableRows = Utils.findParentUIData(component).getRowCount();
            if (val == null || val instanceof Boolean[] && (((Boolean[])val).length == 0 || ((Boolean[])val).length < tableRows) || val instanceof boolean[] && (((boolean[])val).length == 0 || ((boolean[])val).length < tableRows)) {
                if (name.equals("[Ljava.lang.Boolean;")) {
                    vb.setValue(context, (Object)new Boolean[tableRows]);
                } else if (name.equals("[Z")) {
                    vb.setValue(context, (Object)new boolean[tableRows]);
                } else if (name.equals("[Ljava.lang.Integer;")) {
                    vb.setValue(context, (Object)new Integer[0]);
                } else if (name.equals("[I")) {
                    vb.setValue(context, (Object)new int[0]);
                }
            }
        }
        context.getExternalContext().getRequestMap().put(ORIGINAL_VALUE_STORE + component.getId(), val);
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
    }
}

