/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IClientValueHolder;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputMiniCalendar;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.ScriptObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public class MiniCalendarRenderer
extends Renderer
implements IClientValueHolder {
    protected static final String _INPUT = "_INPUT";

    public Object getConvertedValue(FacesContext context, UIComponent component, Object convertee) throws ConverterException {
        Object converted = null;
        if (convertee != null) {
            Converter con;
            String convertee_str = null;
            if (convertee instanceof String) {
                convertee_str = (String)convertee;
            }
            if ((con = ((UIInput)component).getConverter()) != null) {
                converted = con.getAsObject(context, component, convertee_str);
            }
        }
        return converted;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (component == null) {
            throw new NullPointerException();
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        String sub_Value = (String)paramMap.get(clientId + _INPUT);
        ((UIInput)component).setSubmittedValue((Object)sub_Value);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        HtmlInputMiniCalendar calendar_comp = null;
        if (component instanceof HtmlInputMiniCalendar) {
            calendar_comp = (HtmlInputMiniCalendar)component;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_dp.js", component);
        HxClientRenderUtil.addScriptLibrary("hxclient_cal.js", component);
        DateTimeConverter dtConverter = (DateTimeConverter)((UIInput)component).getConverter();
        if (dtConverter != null) {
            Locale locale = dtConverter.getLocale();
            HxClientRenderUtil.addLocalizedStringLibraryIfNeeded(locale.toString(), component);
        }
        String id = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String lang = null;
        String dir = null;
        boolean disabled = false;
        String user_method_change = null;
        String user_method_focus = null;
        String user_method_blur = null;
        String tabindex = null;
        String ackey = null;
        String title = null;
        String style = null;
        String styleClass = null;
        if (calendar_comp != null) {
            lang = calendar_comp.getLang();
            dir = calendar_comp.getDir();
            disabled = calendar_comp.isDisabled();
            user_method_change = calendar_comp.getOnchange();
            user_method_focus = calendar_comp.getOnfocus();
            user_method_blur = calendar_comp.getOnblur();
            tabindex = calendar_comp.getTabindex();
            ackey = calendar_comp.getAccesskey();
            title = calendar_comp.getTitle();
            style = calendar_comp.getStyle();
            styleClass = calendar_comp.getStyleClass();
        } else {
            lang = (String)component.getAttributes().get("lang");
            dir = (String)component.getAttributes().get("dir");
            Object bDisabled = component.getAttributes().get("disabled");
            if (bDisabled instanceof String && "true".equalsIgnoreCase(bDisabled.toString())) {
                disabled = true;
            }
            if (bDisabled instanceof Boolean) {
                disabled = (Boolean)bDisabled;
            }
            user_method_change = (String)component.getAttributes().get("onchange");
            user_method_focus = (String)component.getAttributes().get("onfocus");
            user_method_blur = (String)component.getAttributes().get("onblur");
            tabindex = (String)component.getAttributes().get("tabindex");
            ackey = (String)component.getAttributes().get("accesskey");
            title = (String)component.getAttributes().get("title");
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)(id + _INPUT), null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("name", (Object)(id + _INPUT), null);
        writer.writeAttribute("style", (Object)"display:none;", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (dir != null && dir.length() > 0) {
            writer.writeAttribute("dir", (Object)dir, null);
        }
        if (lang != null && lang.length() > 0) {
            writer.writeAttribute("lang", (Object)lang, null);
        }
        if (user_method_change != null && user_method_change.length() > 0) {
            writer.writeAttribute("onchange", (Object)user_method_change, null);
        }
        if (user_method_focus != null && user_method_focus.length() > 0) {
            writer.writeAttribute("onfocus", (Object)user_method_focus, null);
        }
        if (user_method_blur != null && user_method_blur.length() > 0) {
            writer.writeAttribute("onblur", (Object)user_method_blur, null);
        }
        if (tabindex != null && tabindex.length() > 0) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        if (ackey != null && ackey.length() > 0) {
            writer.writeAttribute("accesskey", (Object)ackey, null);
        }
        String value = null;
        ValueBinding vb = component.getValueBinding("value");
        Object obj = null;
        obj = vb != null ? vb.getValue(context) : (calendar_comp != null ? calendar_comp.getValue() : component.getAttributes().get("value"));
        if (obj instanceof String) {
            value = (String)obj;
        }
        if (obj instanceof Date && dtConverter != null) {
            value = dtConverter.getAsString(context, component, obj);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)id, "id");
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (dir != null && dir.length() > 0) {
            writer.writeAttribute("dir", (Object)dir, null);
        }
        if (lang != null && lang.length() > 0) {
            writer.writeAttribute("lang", (Object)lang, null);
        }
        if (title != null && title.length() > 0) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.endElement("div");
        this.doscript(context, component);
    }

    private void doscript(FacesContext context, UIComponent component) {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        DateTimeConverter dtConverter = (DateTimeConverter)((UIInput)component).getConverter();
        if (dtConverter == null) {
            ResourceBundle rb = ResourceHandler.getBundle(context);
            throw new FacesException(ResourceHandler.getString(rb, "MiniCalendarNoConveterFoundError"));
        }
        ScriptObject converterScript = HxClientRenderUtil.buildJsDateConverter(context, dtConverter);
        ScriptObject validatorScript = null;
        if (null != converterScript) {
            validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, (Converter)dtConverter, HxClientRenderUtil.getRangeValidator((UIInput)component), ((UIInput)component).isRequired(), HxClientRenderUtil.getExpressionValidator((UIInput)component), null);
        }
        String calendarScript = null;
        calendarScript = this.getCalendarScript(context, component, dtConverter.getLocale(), converterScript != null ? converterScript.getId() : null, validatorScript != null ? validatorScript.getId() : null);
        if (null != converterScript) {
            scriptCollector.addScriptOnce(converterScript.getScript());
        }
        if (null != validatorScript) {
            scriptCollector.addScriptOnce(validatorScript.getScript());
        }
        if (null != calendarScript) {
            scriptCollector.addScript(calendarScript);
        }
    }

    private String getCalendarScript(FacesContext context, UIComponent component, Locale converterLocale, String converterId, String validatorId) {
        HtmlInputMiniCalendar calendarComponent = null;
        if (component instanceof HtmlInputMiniCalendar) {
            calendarComponent = (HtmlInputMiniCalendar)component;
        }
        String sRequired = null;
        boolean disabled = false;
        boolean multiLine = true;
        String sCSSPrefix = null;
        if (calendarComponent != null) {
            sCSSPrefix = calendarComponent.getStyleClass();
            multiLine = calendarComponent.isMultiLine();
            disabled = calendarComponent.isDisabled();
            boolean bRequired = calendarComponent.isRequired();
            if (bRequired) {
                sRequired = "true";
            }
        } else {
            Boolean bRequired;
            Object ml;
            Map attrs = component.getAttributes();
            sCSSPrefix = (String)attrs.get("styleClass");
            Object bDisabled = attrs.get("disabled");
            if (bDisabled instanceof String && "true".equalsIgnoreCase(bDisabled.toString())) {
                disabled = true;
            }
            if (bDisabled instanceof Boolean) {
                disabled = (Boolean)bDisabled;
            }
            if ((ml = attrs.get("multiLine")) != null && ml instanceof String && "false".equalsIgnoreCase(ml.toString())) {
                multiLine = false;
            }
            if (ml != null && ml instanceof Boolean) {
                multiLine = (Boolean)ml;
            }
            if ((bRequired = (Boolean)attrs.get("required")).booleanValue()) {
                sRequired = "true";
            }
        }
        Locale locale = converterLocale == null ? context.getViewRoot().getLocale() : converterLocale;
        Calendar cal = Calendar.getInstance(locale);
        int DefaultFirstDay = cal.getFirstDayOfWeek();
        String firstDay = null;
        String sFirstDay = this.getNumericAttribute(firstDay, "first-day-of-week:", new Integer(--DefaultFirstDay).toString(), new Integer(0), new Integer(6));
        StringBuffer script = new StringBuffer("hX_6").append(".addComponent(\"").append(component.getClientId(context)).append("\", new ").append("hX_6").append(".JSFCalendar(");
        if (disabled) {
            script.append("\"disabled:true\", ");
        }
        if (null != converterId) {
            script.append("\"converter:");
            script.append(converterId);
            script.append('\"');
        }
        if (null != validatorId) {
            script.append(", \"");
            script.append("validator:");
            script.append(validatorId);
            script.append('\"');
        }
        if (sCSSPrefix != null && sCSSPrefix != "") {
            script.append(", \"css-prefix:");
            script.append(sCSSPrefix);
            script.append('\"');
        }
        if (sRequired != null && sRequired != "") {
            script.append(", \"required:");
            script.append(sRequired);
            script.append('\"');
        }
        if (multiLine) {
            script.append(", \"multi-line:");
            script.append("true");
            script.append('\"');
        } else {
            script.append(", \"multi-line:");
            script.append("false");
            script.append('\"');
        }
        script.append(", \"");
        script.append(sFirstDay);
        script.append('\"');
        script.append("));");
        return script.toString();
    }

    private String getNumericAttribute(String sValue, String sAttOutName, String DefaultValue, Integer MinValue, Integer MaxValue) {
        if (sValue == null || sValue == "") {
            sValue = DefaultValue;
        } else {
            try {
                int iValue = Integer.parseInt(sValue);
                if (MinValue != null && iValue < MinValue) {
                    sValue = DefaultValue;
                } else if (MaxValue != null && iValue > MaxValue) {
                    sValue = DefaultValue;
                }
            }
            catch (NumberFormatException e) {
                sValue = DefaultValue;
            }
        }
        sValue = sAttOutName + sValue;
        return sValue;
    }

    public String getValueHolderClientId(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + _INPUT;
    }
}

