/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.converter.DateTimeConverterEx;
import com.ibm.faces.converter.MaskConverter;
import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.CacheHashMap;
import com.ibm.faces.util.LifecycleUtil;
import com.ibm.faces.util.ScriptObject;
import com.ibm.faces.validator.DateTimeRangeValidator;
import com.ibm.faces.validator.DoubleRangeValidatorEx;
import com.ibm.faces.validator.LongRangeValidatorEx;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.validator.Validator;

public class HxClientUtil {
    private static final ClassLoader hxClientClassLoader = new HxClientUtil().getClass().getClassLoader();
    private static final String DATESTYLE_SHORT = "short";
    private static final String DATESTYLE_MEDIUM = "medium";
    private static final String DATESTYLE_LONG = "long";
    private static final String DATESTYLE_FULL = "full";
    private static final String NUMBERSTYLE_NUMBER = "number";
    private static final String NUMBERSTYLE_CURRENCY = "currency";
    private static final String NUMBERSTYLE_PERCENT = "percent";
    private static int idSeed = 0;
    private static CacheHashMap maskConverterJs = new CacheHashMap(25);
    private static CacheHashMap dateConverterJs = new CacheHashMap(25);
    private static CacheHashMap numberConverterJs = new CacheHashMap(25);
    private static CacheHashMap rangeValidatorJs = new CacheHashMap(25);
    private static CacheHashMap libraryInclude = new CacheHashMap(12);
    private static DateTimeConverter defaultDateTimeConverter = new DateTimeConverter();
    private static Boolean curClassAvailable = null;
    private static Class curClass = null;
    private static Class[] stringArg = new Class[]{String.class};

    private static synchronized String genScriptId(FacesContext context) {
        return context.getExternalContext().encodeNamespace(Integer.toHexString(idSeed++));
    }

    public static final String buildSetResourcePathCall(FacesContext context) {
        StringBuffer script = new StringBuffer();
        script.append("if (hX_1)  hX_1.setResourceServer(\"");
        script.append(LifecycleUtil.getResourceServletContextPath(context));
        script.append("\");");
        return script.toString();
    }

    public static final String buildJsConverter(StringBuffer javascript, FacesContext context, UIOutput component) {
        Converter converter = component.getConverter();
        if (null == converter) {
            return null;
        }
        if (converter instanceof DateTimeConverter) {
            ScriptObject js = HxClientUtil.buildJsDateConverter(context, (DateTimeConverterEx)converter);
            javascript.append(js.getScript());
            return js.getId();
        }
        if (converter instanceof NumberConverterEx) {
            ScriptObject js = HxClientUtil.buildJsNumberConverter(context, (NumberConverterEx)converter);
            javascript.append(js.getScript());
            return js.getId();
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsMaskConverter(FacesContext context, MaskConverter maskConverter) {
        if (null == maskConverter) {
            return null;
        }
        String pattern = maskConverter.getMask();
        ScriptObject cachedScript = (ScriptObject)maskConverterJs.get(pattern);
        if (null != cachedScript) {
            return cachedScript;
        }
        String converterId = HxClientUtil.genScriptId(context);
        if (pattern != null && !pattern.equals("")) {
            StringBuffer javascript = new StringBuffer("hX_1.addConverter(\"");
            javascript.append(converterId);
            javascript.append("\", ");
            javascript.append("new hX_1.MaskConverter(\"mask:");
            javascript.append(pattern);
            javascript.append("\")");
            javascript.append(");");
            ScriptObject so = new ScriptObject(converterId, javascript.toString());
            maskConverterJs.put(pattern, so);
            return so;
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsDateConverter(FacesContext context, DateTimeConverter datetimeConverter) {
        if (null == datetimeConverter) {
            datetimeConverter = defaultDateTimeConverter;
        }
        Locale locale = datetimeConverter.getLocale();
        String converterKey = HxClientUtil.createDateConverterKey(datetimeConverter);
        ScriptObject cachedScript = (ScriptObject)dateConverterJs.get(converterKey);
        if (null != cachedScript) {
            return cachedScript;
        }
        String converterId = HxClientUtil.genScriptId(context);
        String pattern = datetimeConverter.getPattern();
        String type = datetimeConverter.getType();
        String dateStyle = datetimeConverter.getDateStyle();
        String timeStyle = datetimeConverter.getTimeStyle();
        String format = null;
        if (pattern != null && !pattern.equals("")) {
            format = pattern;
        } else {
            DateFormat df = null;
            df = type.equals("both") ? DateFormat.getDateTimeInstance(HxClientUtil.getStyleCode(dateStyle), HxClientUtil.getStyleCode(timeStyle), locale) : (type.equals("date") ? DateFormat.getDateInstance(HxClientUtil.getStyleCode(dateStyle), locale) : (type.equals("time") ? DateFormat.getTimeInstance(HxClientUtil.getStyleCode(timeStyle), locale) : DateFormat.getDateInstance(HxClientUtil.getStyleCode(dateStyle), locale)));
            format = ((SimpleDateFormat)df).toPattern();
        }
        if (null != format) {
            StringBuffer javascript = new StringBuffer("hX_1.addConverter(\"");
            javascript.append(converterId);
            javascript.append("\", ");
            javascript.append("new hX_1.DateTimeConverter(\"strict:1\", \"format:");
            javascript.append(format);
            javascript.append("\")");
            javascript.append(");");
            ScriptObject so = new ScriptObject(converterId, javascript.toString());
            dateConverterJs.put(converterKey, so);
            return so;
        }
        return null;
    }

    private static String createDateConverterKey(DateTimeConverter converter) {
        StringBuffer key = new StringBuffer(converter.getLocale().toString());
        key.append(converter.getType());
        key.append(converter.getPattern());
        key.append(converter.getDateStyle());
        key.append(converter.getTimeStyle());
        return key.toString();
    }

    public static final synchronized ScriptObject buildJsNumberConverter(FacesContext context, NumberConverterEx numConverter) {
        Locale locale = numConverter.getLocale();
        String pattern = numConverter.getPattern();
        String type = numConverter.getType();
        String numConverterKey = HxClientUtil.createNumberConverterKey(numConverter);
        ScriptObject cachedScript = (ScriptObject)numberConverterJs.get(numConverterKey);
        if (null != cachedScript) {
            return cachedScript;
        }
        String converterId = HxClientUtil.genScriptId(context);
        StringBuffer javascript = new StringBuffer();
        String converterPattern = null;
        try {
            NumberFormat formatter = HxClientUtil.getNumberFormat(numConverter, locale);
            if (pattern != null && !pattern.equals("") || NUMBERSTYLE_CURRENCY.equals(type)) {
                HxClientUtil.configureCurrency(numConverter, formatter);
            }
            HxClientUtil.configureFormatter(numConverter, formatter);
            if (formatter instanceof DecimalFormat) {
                converterPattern = ((DecimalFormat)formatter).toPattern();
            } else {
                String formattedResult = formatter.format(new Double(1.111111111111111E17));
                converterPattern = formattedResult.replace('1', '#');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (null != converterPattern && converterPattern.length() > 0) {
            javascript.append("hX_1.addConverter(\"");
            javascript.append(converterId);
            javascript.append("\", ");
            javascript.append("new hX_1.NumberConverter(\"strict:1\", \"pattern:");
            javascript.append(converterPattern);
            javascript.append("\", \"locale:");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            javascript.append(symbols.getGroupingSeparator());
            javascript.append(symbols.getDecimalSeparator());
            javascript.append(symbols.getPercent());
            javascript.append(symbols.getPerMill());
            javascript.append(symbols.getMinusSign());
            javascript.append(Utils.escapeBackslash(symbols.getCurrencySymbol()));
            javascript.append("\")");
            javascript.append(");");
            ScriptObject so = new ScriptObject(converterId, javascript.toString());
            numberConverterJs.put(numConverterKey, so);
            return so;
        }
        return null;
    }

    private static String createNumberConverterKey(NumberConverterEx numConverter) {
        StringBuffer key = new StringBuffer(numConverter.getLocale().toString());
        key.append(numConverter.getPattern());
        key.append(numConverter.getType());
        key.append(numConverter.isCurrencySymbolSet() ? numConverter.getCurrencySymbol() : null);
        key.append(numConverter.isCurrencyCodeSet() ? numConverter.getCurrencyCode() : null);
        key.append(numConverter.isGroupingUsed());
        key.append(numConverter.isIntegerOnly());
        key.append(numConverter.isMaxFractionDigitsSet() ? Integer.toString(numConverter.getMaxFractionDigits()) : null);
        key.append(numConverter.isMinFractionDigitsSet() ? Integer.toString(numConverter.getMinFractionDigits()) : null);
        key.append(numConverter.isMaxIntegerDigitsSet() ? Integer.toString(numConverter.getMaxIntegerDigits()) : null);
        key.append(numConverter.isMinIntegerDigitsSet() ? Integer.toString(numConverter.getMinIntegerDigits()) : null);
        return key.toString();
    }

    private static String createRangeValidatorKey(Object a, Object b, Object c, Object d) {
        StringBuffer key = new StringBuffer();
        key.append(a);
        key.append(b);
        key.append(c);
        key.append(d);
        return key.toString();
    }

    private static String createRangeValidatorKey(double a, double b, Object c, Object d) {
        StringBuffer key = new StringBuffer();
        key.append(a);
        key.append(b);
        key.append(c);
        key.append(d);
        return key.toString();
    }

    private static String createRangeValidatorKey(long a, long b, Object c, Object d) {
        StringBuffer key = new StringBuffer();
        key.append(a);
        key.append(b);
        key.append(c);
        key.append(d);
        return key.toString();
    }

    public static final String buildJsNumberConverter(NumberConverterEx numConverter, Locale locale) {
        String converterPattern = null;
        if (null != numConverter.getLocale()) {
            locale = numConverter.getLocale();
        }
        try {
            NumberFormat formatter = HxClientUtil.getNumberFormat(numConverter, locale);
            String pattern = numConverter.getPattern();
            String type = numConverter.getType();
            if (pattern != null && !pattern.equals("") || NUMBERSTYLE_CURRENCY.equals(type)) {
                HxClientUtil.configureCurrency(numConverter, formatter);
            }
            HxClientUtil.configureFormatter(numConverter, formatter);
            if (formatter instanceof DecimalFormat) {
                converterPattern = ((DecimalFormat)formatter).toPattern();
            } else {
                String formattedResult = formatter.format(new Double(1.111111111111111E17));
                converterPattern = formattedResult.replace('1', '#');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (null != converterPattern && converterPattern.length() > 0) {
            StringBuffer javascript = new StringBuffer();
            javascript.append("new hX_1.NumberConverter(\"strict:1\", \"pattern:");
            javascript.append(converterPattern);
            javascript.append("\", \"locale:");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            javascript.append(symbols.getGroupingSeparator());
            javascript.append(symbols.getDecimalSeparator());
            javascript.append(symbols.getPercent());
            javascript.append(symbols.getPerMill());
            javascript.append(symbols.getMinusSign());
            javascript.append(Utils.escapeBackslash(symbols.getCurrencySymbol()));
            javascript.append("\")");
            return javascript.toString();
        }
        return null;
    }

    public static final String buildJsDateConverter(DateTimeConverter datetimeConverter, Locale locale) {
        String pattern;
        String format = null;
        if (null != datetimeConverter.getLocale()) {
            locale = datetimeConverter.getLocale();
        }
        if ((pattern = datetimeConverter.getPattern()) != null && !pattern.equals("")) {
            format = pattern;
        } else {
            String type = datetimeConverter.getType();
            DateFormat df = null;
            df = type.equals("both") ? DateFormat.getDateTimeInstance(HxClientUtil.getStyleCode(datetimeConverter.getDateStyle()), HxClientUtil.getStyleCode(datetimeConverter.getTimeStyle()), locale) : (type.equals("date") ? DateFormat.getDateInstance(HxClientUtil.getStyleCode(datetimeConverter.getDateStyle()), locale) : (type.equals("time") ? DateFormat.getTimeInstance(HxClientUtil.getStyleCode(datetimeConverter.getTimeStyle()), locale) : DateFormat.getDateInstance(HxClientUtil.getStyleCode(datetimeConverter.getDateStyle()), locale)));
            format = ((SimpleDateFormat)df).toPattern();
        }
        if (null != format) {
            StringBuffer javascript = new StringBuffer();
            javascript.append("new hX_1.DateTimeConverter(\"strict:1\", \"format:");
            javascript.append(format);
            javascript.append("\")");
            return javascript.toString();
        }
        return null;
    }

    private static int getStyleCode(String s) {
        int dateCode = 2;
        if (s != null && s != "") {
            if (DATESTYLE_SHORT.equalsIgnoreCase(s)) {
                dateCode = 3;
            } else if (DATESTYLE_MEDIUM.equalsIgnoreCase(s)) {
                dateCode = 2;
            } else if (DATESTYLE_LONG.equalsIgnoreCase(s)) {
                dateCode = 1;
            } else if (DATESTYLE_FULL.equalsIgnoreCase(s)) {
                dateCode = 0;
            }
        }
        return dateCode;
    }

    public static final String buildJsRangeValidator(StringBuffer javascript, FacesContext context, UIInput input) {
        ScriptObject js = HxClientUtil.buildJsRangeValidator(context, HxClientUtil.getRangeValidator(input));
        javascript.append(js.getScript());
        return js.getId();
    }

    public static final synchronized ScriptObject buildJsRangeValidator(FacesContext context, Validator validator) {
        ScriptObject cachedScript;
        Object minBound = null;
        Object maxBound = null;
        String validatorKey = null;
        String validatorId = null;
        String newValidator = null;
        if (validator instanceof DateTimeRangeValidator) {
            validatorKey = HxClientUtil.createRangeValidatorKey(((DateTimeRangeValidator)validator).getMinimum(), ((DateTimeRangeValidator)validator).getMaximum(), minBound, maxBound);
            cachedScript = (ScriptObject)rangeValidatorJs.get(validatorKey);
            if (null != cachedScript) {
                return cachedScript;
            }
            newValidator = HxClientUtil.buildJsDateRangeValidator((DateTimeRangeValidator)validator, minBound, maxBound);
        } else if (validator instanceof LongRangeValidatorEx || validator instanceof DoubleRangeValidatorEx) {
            validatorKey = validator instanceof LongRangeValidatorEx ? HxClientUtil.createRangeValidatorKey(((LongRangeValidatorEx)validator).getMinimum(), ((LongRangeValidatorEx)validator).getMaximum(), minBound, maxBound) : HxClientUtil.createRangeValidatorKey(((DoubleRangeValidatorEx)validator).getMinimum(), ((DoubleRangeValidatorEx)validator).getMaximum(), minBound, maxBound);
            cachedScript = (ScriptObject)rangeValidatorJs.get(validatorKey);
            if (null != cachedScript) {
                return cachedScript;
            }
            newValidator = HxClientUtil.buildJsNumberRangeValidator(validator, minBound, maxBound);
        }
        validatorId = HxClientUtil.genScriptId(context);
        if (null != newValidator) {
            StringBuffer javascript = new StringBuffer("hX_1.addValidator(\"");
            javascript.append(validatorId);
            javascript.append("\", ");
            javascript.append(newValidator);
            javascript.append(");");
            ScriptObject so = new ScriptObject(validatorId, javascript.toString());
            rangeValidatorJs.put(validatorKey, so);
            return so;
        }
        return null;
    }

    public static final Validator getRangeValidator(UIInput input) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            if (!(validator instanceof DateTimeRangeValidator) && !(validator instanceof LongRangeValidatorEx) && !(validator instanceof DoubleRangeValidatorEx)) continue;
            return validator;
        }
        return null;
    }

    public static final String buildJsNumberRangeValidator(Validator validator) {
        return HxClientUtil.buildJsNumberRangeValidator(validator, null, null);
    }

    public static final String buildJsNumberRangeValidator(Validator validator, Number minBound, Number maxBound) {
        StringBuffer javascript = new StringBuffer();
        if (validator instanceof LongRangeValidatorEx) {
            LongRangeValidatorEx longValidator = (LongRangeValidatorEx)validator;
            if (null == minBound && longValidator.isMinimumSet()) {
                minBound = new Long(longValidator.getMinimum());
            }
            if (null == maxBound && longValidator.isMaximumSet()) {
                maxBound = new Long(longValidator.getMaximum());
            }
        }
        if (validator instanceof DoubleRangeValidatorEx) {
            DoubleRangeValidatorEx doubleValidator = (DoubleRangeValidatorEx)validator;
            if (null == minBound && doubleValidator.isMinimumSet()) {
                minBound = new Double(doubleValidator.getMinimum());
            }
            if (null == maxBound && doubleValidator.isMaximumSet()) {
                maxBound = new Double(doubleValidator.getMaximum());
            }
        }
        javascript.append("new hX_1.NumberValidator(");
        if (minBound != null) {
            javascript.append(" \"min-bound:");
            javascript.append(minBound);
            javascript.append('\"');
        }
        if (maxBound != null) {
            if (minBound != null) {
                javascript.append(", ");
            }
            javascript.append(" \"max-bound:");
            javascript.append(maxBound);
            javascript.append('\"');
        }
        javascript.append(")");
        return javascript.toString();
    }

    public static final String buildJsDateRangeValidator(DateTimeRangeValidator validator) {
        return HxClientUtil.buildJsDateRangeValidator(validator, null, null);
    }

    public static final String buildJsDateRangeValidator(DateTimeRangeValidator validator, Date minBound, Date maxBound) {
        StringBuffer javascript = new StringBuffer();
        if (null == minBound) {
            minBound = validator.getMinimum();
        }
        if (null == maxBound) {
            maxBound = validator.getMaximum();
        }
        javascript.append("new hX_1.DateTimeValidator(");
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddhhmmss");
        if (minBound != null) {
            javascript.append(" \"min-bound:");
            javascript.append(sd.format(minBound));
            javascript.append('\"');
        }
        if (maxBound != null) {
            if (minBound != null) {
                javascript.append(", ");
            }
            javascript.append(" \"max-bound:");
            javascript.append(sd.format(maxBound));
            javascript.append('\"');
        }
        javascript.append(")");
        return javascript.toString();
    }

    private static NumberFormat getNumberFormat(NumberConverterEx numConverter, Locale locale) {
        NumberFormat formatter = null;
        String pattern = numConverter.getPattern();
        String type = numConverter.getType();
        if (pattern == null && type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            formatter = new DecimalFormat(pattern, symbols);
        } else if (type.equals(NUMBERSTYLE_CURRENCY)) {
            formatter = NumberFormat.getCurrencyInstance(locale);
        } else if (type.equals(NUMBERSTYLE_NUMBER)) {
            formatter = NumberFormat.getNumberInstance(locale);
        } else if (type.equals(NUMBERSTYLE_PERCENT)) {
            formatter = NumberFormat.getPercentInstance(locale);
        } else {
            throw new ConverterException((Throwable)new IllegalArgumentException(type));
        }
        if (numConverter.isIntegerOnly()) {
            formatter.setMaximumFractionDigits(0);
        }
        return formatter;
    }

    private static void configureCurrency(NumberConverterEx numConverter, NumberFormat formatter) throws Exception {
        if (numConverter.getCurrencyCode() == null && numConverter.getCurrencySymbol() == null) {
            return;
        }
        if (curClassAvailable == null) {
            try {
                curClass = Class.forName("java.util.Currency");
                curClassAvailable = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                curClassAvailable = Boolean.FALSE;
            }
        }
        if (numConverter.getCurrencyCode() != null && curClassAvailable.booleanValue()) {
            Method method = curClass.getMethod("getInstance", stringArg);
            Object cur = method.invoke(null, numConverter.getCurrencyCode());
            Class<?> numFormatClass = Class.forName("java.text.NumberFormat");
            method = numFormatClass.getMethod("setCurrency", curClass);
            method.invoke((Object)formatter, cur);
            return;
        }
        String curSymbol = null;
        if (numConverter.getCurrencySymbol() != null) {
            curSymbol = numConverter.getCurrencySymbol();
        } else if (numConverter.getCurrencyCode() != null) {
            curSymbol = numConverter.getCurrencyCode();
        }
        if (curSymbol != null) {
            DecimalFormat df = (DecimalFormat)formatter;
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setCurrencySymbol(curSymbol);
            df.setDecimalFormatSymbols(dfs);
        }
    }

    private static void configureFormatter(NumberConverterEx numConverter, NumberFormat formatter) {
        formatter.setGroupingUsed(numConverter.isGroupingUsed());
        if (numConverter.isMaxIntegerDigitsSet()) {
            formatter.setMaximumIntegerDigits(numConverter.getMaxIntegerDigits());
        }
        if (numConverter.isMinIntegerDigitsSet()) {
            formatter.setMinimumIntegerDigits(numConverter.getMinIntegerDigits());
        }
        if (numConverter.isMaxFractionDigitsSet()) {
            formatter.setMaximumFractionDigits(numConverter.getMaxFractionDigits());
        }
        if (numConverter.isMinFractionDigitsSet()) {
            formatter.setMinimumFractionDigits(numConverter.getMinFractionDigits());
        }
    }

    public static void initJSLibraries(UIComponent component, FacesContext context) {
        UIScriptCollector scriptCollector = null;
        scriptCollector = component instanceof UIScriptCollector ? (UIScriptCollector)component : UIScriptCollector.find(component);
        ScriptObject script = HxClientUtil.buildLibraryIncludeBlock(context);
        scriptCollector.writeLibraryReference(context, script.getId(), script.getScript());
    }

    public static void initJSLibraries(UIComponent component, FacesContext context, boolean bWriteNow) {
        UIScriptCollector scriptCollector = null;
        scriptCollector = component instanceof UIScriptCollector ? (UIScriptCollector)component : UIScriptCollector.find(component);
        ScriptObject script = HxClientUtil.buildLibraryIncludeBlock(context);
        if (bWriteNow) {
            scriptCollector.writeLibraryReference(context, script.getId(), script.getScript());
        } else {
            scriptCollector.addLibrary(script.getId(), script.getScript());
            scriptCollector.addScriptOnce("hX_1.onPageLoad();");
        }
    }

    public static synchronized ScriptObject buildLibraryIncludeBlock(FacesContext context) {
        Object buffer;
        String libKey = context.getViewRoot().getLocale().toString();
        ScriptObject script = (ScriptObject)libraryInclude.get(libKey);
        if (null != script) {
            return script;
        }
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String libStrings = ResourceHandler.buildLocalizedLibName(bundle, "ibmjsfres/hxclient_S_1.js");
        String strings = null;
        InputStream stream = hxClientClassLoader.getResourceAsStream(libStrings);
        if (stream != null) {
            buffer = new byte[10000];
            byte[] bytes = new byte[]{};
            int read = 0;
            try {
                while ((read = stream.read((byte[])buffer)) > 0) {
                    int newSize = bytes.length + read;
                    byte[] newBytes = new byte[newSize];
                    System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                    System.arraycopy(buffer, 0, newBytes, bytes.length, read);
                    bytes = newBytes;
                }
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                String encoding = bundle.getString("Locale.encoding");
                if (encoding == null || encoding.trim().length() == 0 || encoding.equals("!Locale.encoding!")) {
                    encoding = "ISO-8859-1";
                }
                strings = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                strings = new String(bytes);
            }
        }
        buffer = new StringBuffer();
        ((StringBuffer)buffer).append("<script type=\"text/JavaScript\" language=\"JavaScript\"");
        ((StringBuffer)buffer).append(" src=\"");
        ((StringBuffer)buffer).append(LifecycleUtil.getContextPath(context)).append('/');
        ((StringBuffer)buffer).append(".ibmjsfres/hxclient_v1.js\"></script>\n");
        ((StringBuffer)buffer).append("<script type=\"text/JavaScript\" language=\"JavaScript\">\n");
        if (null != strings) {
            ((StringBuffer)buffer).append(strings);
        }
        ((StringBuffer)buffer).append(HxClientUtil.buildSetResourcePathCall(context));
        ((StringBuffer)buffer).append("\n</script>");
        script = new ScriptObject(libKey, ((StringBuffer)buffer).toString());
        libraryInclude.put(libKey, script);
        return script;
    }

    public static boolean isContainedInPanel(UIComponent component) {
        while (component != null) {
            if (component.getRendersChildren()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }
}

