/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIDataIterator;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.converter.DateTimeConverterExICU;
import com.ibm.faces.converter.MaskConverter;
import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.faces.converter.NumberConverterExICU;
import com.ibm.faces.renderkit.html_extended.HxClientICU;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.AjaxUtil;
import com.ibm.faces.util.CacheHashMap;
import com.ibm.faces.util.JavaScriptUtil;
import com.ibm.faces.util.LifecycleUtil;
import com.ibm.faces.util.ScriptObject;
import com.ibm.faces.util.StringUtil;
import com.ibm.faces.validator.DateTimeRangeValidator;
import com.ibm.faces.validator.DoubleRangeValidatorEx;
import com.ibm.faces.validator.ExpressionValidator;
import com.ibm.faces.validator.LongRangeValidatorEx;
import com.ibm.faces.validator.ModulusSelfCheckValidator;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.validator.Validator;

public class HxClientRenderUtil {
    public static final String HX_VERSION = "v3_1_3";
    public static final String HX_LIB_FILENAME = "hxclient_v3_1_3.js";
    public static final String HX_VAR_NAME = "hX_6";
    public static final String HXG_FUNCTION_NAME = "HxG_6";
    public static final String HX_STRING_RESOURCES = "com.ibm.faces.HX_STRING_RESOURCES";
    public static final String HX_VIEW_LOCALE = "viewLocale";
    public static final String HX_CAL_MAGICNAME_RESOURCES = "_JWLCALSTRING";
    public static final String HX_PORTAL_ENCODING = "com.ibm.faces.JWL.HX_PORTAL_ENCODING";
    public static final String DELIM_END = "com.ibm.faces.JWLAJAX.DELIMITER_END";
    public static final String DELIM_START = "com.ibm.faces.JWLAJAX.DELIMITER_START";
    private static final ClassLoader hxClientClassLoader = new HxClientRenderUtil().getClass().getClassLoader();
    private static int idSeed = 0;
    private static CacheHashMap dateConverterJs = new CacheHashMap(25);
    private static CacheHashMap numberConverterJs = new CacheHashMap(25);
    private static CacheHashMap rangeValidatorJs = new CacheHashMap(25);
    private static CacheHashMap constraintValidatorJs = new CacheHashMap(25);
    private static String numberStrictnessLevel = null;
    private static String dateStrictnessLevel = null;
    public static final String BODY_SCOPE = "#body";
    private static DateTimeConverter defaultDateTimeConverter = new DateTimeConverter();
    private static NumberConverterEx defaultNumberConverter = new NumberConverterEx();
    private static Boolean curClassAvailable = null;
    private static Class curClass = null;
    private static Class[] stringArg = new Class[]{String.class};
    private static final Class PORTLET_REQ = HxClientRenderUtil.getPortletRequestClass();
    private static final Class LEG_PORTLET_REQ = HxClientRenderUtil.getLegacyPortletRequestClass();

    private static synchronized String genScriptId(FacesContext context) {
        return context.getExternalContext().encodeNamespace(Integer.toHexString(idSeed++));
    }

    public static final String buildSetResourcePathCall(FacesContext context) {
        StringBuffer script = new StringBuffer();
        script.append("if (").append(HX_VAR_NAME).append(") ").append(HX_VAR_NAME).append(".setResourceServer(\"");
        script.append(LifecycleUtil.getResourceServletContextPath(context));
        script.append("\");\n");
        return script.toString();
    }

    public static final String buildLocaleCall(FacesContext context) {
        StringBuffer script = new StringBuffer();
        script.append("if(").append(HX_VAR_NAME).append(" && ").append(HX_VAR_NAME).append(".setLocale) ").append(HX_VAR_NAME).append(".setLocale(\"").append(context.getViewRoot().getLocale()).append("\");\n");
        return script.toString();
    }

    public static final String buildPortalFlag(FacesContext context) {
        boolean inportal = false;
        String stored = (String)context.getExternalContext().getSessionMap().get(HX_PORTAL_ENCODING);
        if (stored != null && "true".equalsIgnoreCase(stored)) {
            inportal = true;
        } else if (stored != null && "false".equalsIgnoreCase(stored)) {
            inportal = false;
        } else if (stored == null) {
            Object req = context.getExternalContext().getRequest();
            inportal = HxClientRenderUtil.isPortal(req);
            if (inportal) {
                context.getExternalContext().getSessionMap().put(HX_PORTAL_ENCODING, "true");
            } else {
                context.getExternalContext().getSessionMap().put(HX_PORTAL_ENCODING, "false");
            }
        }
        if (inportal) {
            StringBuffer script = new StringBuffer("\n");
            script.append("if (").append(HX_VAR_NAME).append(" && ").append(HX_VAR_NAME).append(".setPortalEncoding) ").append(HX_VAR_NAME).append(".setPortalEncoding(); // turns on Portal code paths for HxClient.\n");
            return script.toString();
        }
        return "";
    }

    public static final synchronized ScriptObject buildJsMaskConverter(FacesContext context, MaskConverter maskConverter) {
        if (null == maskConverter) {
            return null;
        }
        String pattern = maskConverter.getMask();
        String converterId = HxClientRenderUtil.genScriptId(context);
        if (pattern != null && !pattern.equals("")) {
            StringBuffer javascript = new StringBuffer(HX_VAR_NAME);
            javascript.append(".addConverter(\"");
            javascript.append(converterId);
            javascript.append("\", ");
            javascript.append(HxClientRenderUtil.buildJsMaskConverter(maskConverter));
            javascript.append(");");
            ScriptObject so = new ScriptObject(converterId, javascript.toString());
            return so;
        }
        return null;
    }

    public static final String buildJsMaskConverter(MaskConverter maskConverter) {
        if (null == maskConverter) {
            return null;
        }
        String pattern = maskConverter.getMask();
        if (pattern != null && !pattern.equals("")) {
            StringBuffer javascript = new StringBuffer("new ");
            javascript.append(HX_VAR_NAME);
            javascript.append(".MaskConverter(\"mask:");
            javascript.append(pattern).append("\"");
            if (maskConverter.getProtectMask() != null) {
                javascript.append(",\"protect-mask:").append(maskConverter.getProtectMask()).append("\"");
            }
            if (maskConverter.getChar1RegEx() != null) {
                javascript.append(",\"char1-regexpression:").append(maskConverter.getChar1RegEx()).append("\"");
            }
            if (maskConverter.getChar2RegEx() != null) {
                javascript.append(",\"char2-regexpression:").append(maskConverter.getChar2RegEx()).append("\"");
            }
            if (maskConverter.getChar3RegEx() != null) {
                javascript.append(",\"char3-regexpression:").append(maskConverter.getChar3RegEx()).append("\"");
            }
            if (maskConverter.getChar4RegEx() != null) {
                javascript.append(",\"char4-regexpression:").append(maskConverter.getChar4RegEx()).append("\"");
            }
            javascript.append(")");
            return javascript.toString();
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsDateConverter(FacesContext context, DateTimeConverter datetimeConverter) {
        String converterKey;
        ScriptObject cachedScript;
        if (null == datetimeConverter) {
            datetimeConverter = defaultDateTimeConverter;
        }
        if (null != (cachedScript = (ScriptObject)dateConverterJs.get(converterKey = HxClientRenderUtil.createDateConverterKey(datetimeConverter)))) {
            return cachedScript;
        }
        HxClientRenderUtil.setupStrictnessLevel(context);
        String converterId = HxClientRenderUtil.genScriptId(context);
        String newConverter = HxClientRenderUtil.buildJsDateTimeConverter(datetimeConverter);
        if (null != newConverter) {
            StringBuffer javascript = new StringBuffer(HX_VAR_NAME);
            javascript.append(".addConverter(\"");
            javascript.append(converterId);
            javascript.append("\", ");
            javascript.append(newConverter);
            javascript.append(");");
            ScriptObject so = new ScriptObject(converterId, javascript.toString());
            dateConverterJs.put(converterKey, so);
            return so;
        }
        return null;
    }

    private static String createDateConverterKey(DateTimeConverter converter) {
        StringBuffer key = new StringBuffer(converter.getLocale().toString());
        if (converter instanceof DateTimeConverterExICU && ((DateTimeConverterExICU)converter).getCalendar() != null) {
            key.append(((DateTimeConverterExICU)converter).getCalendar().getType());
        }
        key.append(converter.getType());
        key.append(converter.getPattern());
        key.append(converter.getDateStyle());
        key.append(converter.getTimeStyle());
        key.append(converter.getLocale());
        return key.toString();
    }

    public static final String buildJsDateTimeConverter(DateTimeConverter datetimeConverter) {
        if (datetimeConverter instanceof DateTimeConverterExICU) {
            return HxClientICU.buildJsDateTimeConverterICU((DateTimeConverterExICU)datetimeConverter);
        }
        String pattern = datetimeConverter.getPattern();
        String type = datetimeConverter.getType();
        String dateStyle = datetimeConverter.getDateStyle();
        String timeStyle = datetimeConverter.getTimeStyle();
        Locale locale = datetimeConverter.getLocale();
        String format = null;
        if (pattern != null && !pattern.equals("")) {
            format = pattern;
        } else {
            DateFormat df = null;
            df = type.equalsIgnoreCase("both") ? DateFormat.getDateTimeInstance(Utils.getDateStyle(dateStyle), Utils.getDateStyle(timeStyle), locale) : (type.equalsIgnoreCase("date") ? DateFormat.getDateInstance(Utils.getDateStyle(dateStyle), locale) : (type.equalsIgnoreCase("time") ? DateFormat.getTimeInstance(Utils.getDateStyle(timeStyle), locale) : DateFormat.getDateInstance(Utils.getDateStyle(dateStyle), locale)));
            format = ((SimpleDateFormat)df).toPattern();
        }
        if (null != format) {
            StringBuffer javascript = new StringBuffer("new hX_6.DateTimeConverter(\"strict:" + dateStrictnessLevel + "\", \"format:");
            javascript.append(format);
            if (!locale.toString().equals(FacesContext.getCurrentInstance().getViewRoot().getLocale().toString())) {
                javascript.append("\", \"locale:").append(locale);
            }
            javascript.append("\")");
            return javascript.toString();
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsNumberConverter(FacesContext context, NumberConverterEx numConverter) {
        String numConverterKey = HxClientRenderUtil.createNumberConverterKey(numConverter);
        ScriptObject cachedScript = (ScriptObject)numberConverterJs.get(numConverterKey);
        if (null != cachedScript) {
            return cachedScript;
        }
        HxClientRenderUtil.setupStrictnessLevel(context);
        String converterId = HxClientRenderUtil.genScriptId(context);
        StringBuffer javascript = new StringBuffer();
        String newConverter = null;
        newConverter = numConverter instanceof NumberConverterExICU ? HxClientICU.buildJsNumberConverterICU((NumberConverterExICU)numConverter) : HxClientRenderUtil.buildJsNumberConverter(numConverter);
        if (null != newConverter && newConverter.length() > 0) {
            javascript.append(HX_VAR_NAME);
            javascript.append(".addConverter(\"");
            javascript.append(converterId);
            javascript.append("\", ");
            javascript.append(newConverter);
            javascript.append(");");
            ScriptObject so = new ScriptObject(converterId, javascript.toString());
            numberConverterJs.put(numConverterKey, so);
            return so;
        }
        return null;
    }

    public static NumberConverterEx getDefaultNumberConverter() {
        return defaultNumberConverter;
    }

    private static String createNumberConverterKey(NumberConverterEx numConverter) {
        StringBuffer key = new StringBuffer(numConverter.getLocale().toString());
        key.append(numConverter.getPattern());
        if (numConverter.isPatternExtensionSet()) {
            key.append(numConverter.getPatternExtension());
        }
        key.append(numConverter.getType());
        key.append(numConverter.isCurrencySymbolSet() ? numConverter.getCurrencySymbol() : null);
        key.append(numConverter.isCurrencyCodeSet() ? numConverter.getCurrencyCode() : null);
        key.append(numConverter.isGroupingUsed());
        key.append(numConverter.isIntegerOnly());
        key.append(numConverter.isMaxFractionDigitsSet() ? Integer.toString(numConverter.getMaxFractionDigits()) : null);
        key.append(numConverter.isMinFractionDigitsSet() ? Integer.toString(numConverter.getMinFractionDigits()) : null);
        key.append(numConverter.isMaxIntegerDigitsSet() ? Integer.toString(numConverter.getMaxIntegerDigits()) : null);
        key.append(numConverter.isMinIntegerDigitsSet() ? Integer.toString(numConverter.getMinIntegerDigits()) : null);
        return key.toString();
    }

    private static String createNumberValidatorKey(Object a, Object b, Object c, Object d, boolean required, String expression, String modulus) {
        StringBuffer key = new StringBuffer("n");
        key.append(a);
        key.append(b);
        key.append(c);
        key.append(d);
        key.append(required);
        key.append(expression);
        key.append(modulus);
        return key.toString();
    }

    private static String createDateTimeValidatorKey(Object a, Object b, Object c, Object d, boolean required, String expression) {
        StringBuffer key = new StringBuffer("d");
        key.append(a);
        key.append(b);
        key.append(c);
        key.append(d);
        key.append(required);
        key.append(expression);
        return key.toString();
    }

    private static String createStringValidatorKey(String constraint, String minLength, String maxLength, boolean required, String expression) {
        StringBuffer key = new StringBuffer();
        key.append(constraint);
        key.append(minLength);
        key.append(maxLength);
        key.append(required);
        key.append(expression);
        return key.toString();
    }

    public static final String buildJsNumberConverter(NumberConverterEx numConverter, Locale locale) {
        return HxClientRenderUtil.buildJsNumberConverter(numConverter);
    }

    public static final String buildJsNumberConverter(NumberConverterEx numConverter) {
        String converterPattern = null;
        Locale locale = numConverter.getLocale();
        NumberFormat formatter = HxClientRenderUtil.getNumberFormat(numConverter, locale);
        try {
            String pattern = numConverter.getPattern();
            String type = numConverter.getType();
            if (pattern != null && !pattern.equals("") || "currency".equalsIgnoreCase(type)) {
                HxClientRenderUtil.configureCurrency(numConverter, formatter);
            }
            HxClientRenderUtil.configureFormatter(numConverter, formatter);
            if (formatter instanceof DecimalFormat) {
                if (pattern != null && !pattern.equals("")) {
                    ((DecimalFormat)formatter).applyPattern(pattern);
                    converterPattern = pattern;
                } else {
                    converterPattern = ((DecimalFormat)formatter).toPattern();
                }
                while (converterPattern.indexOf("\u00a4") > -1) {
                    int pos = converterPattern.indexOf("\u00a4");
                    StringBuffer b = new StringBuffer();
                    b.append(converterPattern.substring(0, pos));
                    b.append("\\u00A4");
                    b.append(converterPattern.substring(pos + 1, converterPattern.length()));
                    converterPattern = b.toString();
                }
            } else {
                String formattedResult = formatter.format(new Double(1.111111111111111E17));
                converterPattern = formattedResult.replace('1', '#');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (null != converterPattern && converterPattern.length() > 0) {
            StringBuffer javascript = new StringBuffer("new hX_6.NumberConverter(\"strict:" + numberStrictnessLevel + "\", \"pattern:");
            javascript.append(converterPattern);
            if (numConverter.isPatternExtensionSet()) {
                javascript.append(numConverter.getPatternExtension());
            }
            javascript.append("\", \"locale:");
            DecimalFormatSymbols symbols = null;
            symbols = formatter instanceof DecimalFormat ? ((DecimalFormat)formatter).getDecimalFormatSymbols() : new DecimalFormatSymbols(locale);
            StringBuffer localeBuf = new StringBuffer();
            localeBuf.append(HxClientRenderUtil.convertNbspToSpace(symbols.getGroupingSeparator()));
            localeBuf.append(HxClientRenderUtil.convertNbspToSpace(symbols.getDecimalSeparator()));
            localeBuf.append(symbols.getPercent());
            localeBuf.append(symbols.getPerMill());
            localeBuf.append(symbols.getMinusSign());
            localeBuf.append(Utils.escapeBackslash(symbols.getCurrencySymbol()));
            Locale loc = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            if (loc.getLanguage().equalsIgnoreCase("he") || loc.getLanguage().equalsIgnoreCase("iw")) {
                javascript.append(JavaScriptUtil.encodeScriptResourceString(localeBuf.toString(), true));
            } else {
                javascript.append(JavaScriptUtil.encodeScriptResourceString(localeBuf.toString(), false));
            }
            javascript.append("\")");
            return javascript.toString();
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsRangeValidator(FacesContext context, Converter converter, Validator validator, boolean required, ExpressionValidator expressionValidator, ModulusSelfCheckValidator modulusValidator) {
        if (converter instanceof DateTimeConverter || validator instanceof DateTimeRangeValidator) {
            return HxClientRenderUtil.buildJsAddDateTimeValidator(context, (DateTimeRangeValidator)validator, required, expressionValidator);
        }
        if (converter instanceof NumberConverterEx || validator instanceof LongRangeValidatorEx || validator instanceof DoubleRangeValidatorEx) {
            return HxClientRenderUtil.buildJsAddNumberValidator(context, validator, required, expressionValidator, modulusValidator);
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsAddDateTimeValidator(FacesContext context, DateTimeRangeValidator validator, boolean required, ExpressionValidator expressionValidator) {
        ScriptObject cachedScript;
        if (validator == null && !required && expressionValidator == null) {
            return null;
        }
        Object minBound = null;
        Object maxBound = null;
        String validatorKey = null;
        String validatorId = null;
        String newValidator = null;
        String expression = null;
        if (expressionValidator != null) {
            expression = JavaScriptUtil.convertEL2JavaScript(expressionValidator.getExpression());
        }
        if (null != (cachedScript = (ScriptObject)rangeValidatorJs.get(validatorKey = HxClientRenderUtil.createDateTimeValidatorKey(null == validator ? null : validator.getMinimum(), null == validator ? null : validator.getMaximum(), minBound, maxBound, required, expression)))) {
            return cachedScript;
        }
        newValidator = HxClientRenderUtil.buildJsDateRangeValidator(validator, minBound, maxBound, required, expression);
        validatorId = HxClientRenderUtil.genScriptId(context);
        if (null != newValidator) {
            StringBuffer javascript = new StringBuffer(HX_VAR_NAME);
            javascript.append(".addValidator(\"");
            javascript.append(validatorId);
            javascript.append("\", ");
            javascript.append(newValidator);
            javascript.append(");");
            ScriptObject so = new ScriptObject(validatorId, javascript.toString());
            rangeValidatorJs.put(validatorKey, so);
            return so;
        }
        return null;
    }

    public static final synchronized ScriptObject buildJsAddNumberValidator(FacesContext context, Validator validator, boolean required, ExpressionValidator expressionValidator, ModulusSelfCheckValidator modulusValidator) {
        if (validator == null && !required && expressionValidator == null && modulusValidator == null) {
            return null;
        }
        Object minBound = null;
        Object maxBound = null;
        String validatorKey = null;
        String validatorId = null;
        String newValidator = null;
        String expression = null;
        String modulus = null;
        if (expressionValidator != null) {
            expression = JavaScriptUtil.convertEL2JavaScript(expressionValidator.getExpression());
        }
        if (modulusValidator != null) {
            modulus = modulusValidator.getModulus();
        }
        validatorKey = validator instanceof LongRangeValidatorEx || validator instanceof DoubleRangeValidatorEx ? (validator instanceof LongRangeValidatorEx ? HxClientRenderUtil.createNumberValidatorKey(null == validator ? null : new Long(((LongRangeValidatorEx)validator).getMinimum()), null == validator ? null : new Long(((LongRangeValidatorEx)validator).getMaximum()), minBound, maxBound, required, expression, modulus) : HxClientRenderUtil.createNumberValidatorKey(null == validator ? null : new Double(((DoubleRangeValidatorEx)validator).getMinimum()), null == validator ? null : new Double(((DoubleRangeValidatorEx)validator).getMaximum()), minBound, maxBound, required, expression, modulus)) : HxClientRenderUtil.createNumberValidatorKey(null, null, null, null, required, expression, modulus);
        ScriptObject cachedScript = (ScriptObject)rangeValidatorJs.get(validatorKey);
        if (null != cachedScript) {
            return cachedScript;
        }
        newValidator = HxClientRenderUtil.buildJsNumberRangeValidator(validator, minBound, maxBound, required, expression, modulus);
        validatorId = HxClientRenderUtil.genScriptId(context);
        if (null != newValidator) {
            StringBuffer javascript = new StringBuffer(HX_VAR_NAME);
            javascript.append(".addValidator(\"");
            javascript.append(validatorId);
            javascript.append("\", ");
            javascript.append(newValidator);
            javascript.append(");");
            ScriptObject so = new ScriptObject(validatorId, javascript.toString());
            rangeValidatorJs.put(validatorKey, so);
            return so;
        }
        return null;
    }

    public static final Validator getRangeValidator(UIInput input) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            if (!(validator instanceof DateTimeRangeValidator) && !(validator instanceof LongRangeValidatorEx) && !(validator instanceof DoubleRangeValidatorEx)) continue;
            return validator;
        }
        return null;
    }

    public static final Validator getNumberRangeValidator(UIInput input) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            if (!(validator instanceof LongRangeValidatorEx) && !(validator instanceof DoubleRangeValidatorEx)) continue;
            return validator;
        }
        return null;
    }

    public static final DateTimeRangeValidator getDateRangeValidator(UIInput input) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            if (!(validator instanceof DateTimeRangeValidator)) continue;
            return (DateTimeRangeValidator)validator;
        }
        return null;
    }

    public static final ExpressionValidator getExpressionValidator(UIInput input) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            if (!(validator instanceof ExpressionValidator)) continue;
            return (ExpressionValidator)validator;
        }
        return null;
    }

    public static final ModulusSelfCheckValidator getModulusValidator(UIInput input) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            if (!(validator instanceof ModulusSelfCheckValidator)) continue;
            return (ModulusSelfCheckValidator)validator;
        }
        return null;
    }

    public static final String buildJsNumberRangeValidator(Validator validator) {
        return HxClientRenderUtil.buildJsNumberRangeValidator(validator, null, null, false, null, null);
    }

    public static final String buildJsNumberRangeValidator(Validator validator, Number minBound, Number maxBound, boolean required, String expression, String modulus) {
        StringBuffer javascript = new StringBuffer();
        if (validator instanceof LongRangeValidatorEx) {
            LongRangeValidatorEx longValidator = (LongRangeValidatorEx)validator;
            if (null == minBound && longValidator.isMinimumSet()) {
                minBound = new Long(longValidator.getMinimum());
            }
            if (null == maxBound && longValidator.isMaximumSet()) {
                maxBound = new Long(longValidator.getMaximum());
            }
        }
        if (validator instanceof DoubleRangeValidatorEx) {
            DoubleRangeValidatorEx doubleValidator = (DoubleRangeValidatorEx)validator;
            if (null == minBound && doubleValidator.isMinimumSet()) {
                minBound = new Double(doubleValidator.getMinimum());
            }
            if (null == maxBound && doubleValidator.isMaximumSet()) {
                maxBound = new Double(doubleValidator.getMaximum());
            }
        }
        javascript.append("new ");
        javascript.append(HX_VAR_NAME);
        javascript.append(".NumberValidator(");
        int nArgs = 0;
        if (minBound != null) {
            javascript.append(" \"min-bound:");
            javascript.append(minBound);
            javascript.append('\"');
            ++nArgs;
        }
        if (maxBound != null) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"max-bound:");
            javascript.append(maxBound);
            javascript.append('\"');
        }
        if (required) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"required:true\"");
        }
        if (expression != null) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"constraint-expression:");
            javascript.append(expression);
            javascript.append('\"');
        }
        if (modulus != null) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"modulus:");
            javascript.append(modulus);
            javascript.append('\"');
        }
        javascript.append(")");
        return javascript.toString();
    }

    public static final String buildJsDateRangeValidator(DateTimeRangeValidator validator) {
        return HxClientRenderUtil.buildJsDateRangeValidator(validator, null, null, false, null);
    }

    public static final String buildJsDateRangeValidator(DateTimeRangeValidator validator, Date minBound, Date maxBound, boolean required, String expression) {
        StringBuffer javascript = new StringBuffer();
        if (null != validator) {
            if (null == minBound) {
                minBound = validator.getMinimum();
            }
            if (null == maxBound) {
                maxBound = validator.getMaximum();
            }
        }
        javascript.append("new ");
        javascript.append(HX_VAR_NAME);
        javascript.append(".DateTimeValidator(");
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmss");
        int nArgs = 0;
        if (minBound != null) {
            javascript.append(" \"min-bound:");
            javascript.append(sd.format(minBound));
            javascript.append('\"');
            ++nArgs;
        }
        if (maxBound != null) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"max-bound:");
            javascript.append(sd.format(maxBound));
            javascript.append('\"');
        }
        if (required) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"required:true\"");
        }
        if (expression != null) {
            if (nArgs++ > 0) {
                javascript.append(", ");
            }
            javascript.append(" \"constraint-expression:");
            javascript.append(expression);
            javascript.append('\"');
        }
        javascript.append(")");
        return javascript.toString();
    }

    private static NumberFormat getNumberFormat(NumberConverterEx numConverter, Locale locale) {
        NumberFormat formatter = null;
        String pattern = numConverter.getPattern();
        String type = numConverter.getType();
        if (pattern == null && type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            formatter = new DecimalFormat(pattern, symbols);
        } else if (type.equalsIgnoreCase("currency")) {
            formatter = NumberFormat.getCurrencyInstance(locale);
        } else if (type.equalsIgnoreCase("number")) {
            formatter = NumberFormat.getNumberInstance(locale);
        } else if (type.equalsIgnoreCase("percent")) {
            formatter = NumberFormat.getPercentInstance(locale);
        } else {
            throw new ConverterException((Throwable)new IllegalArgumentException(type));
        }
        if (numConverter.isIntegerOnly()) {
            formatter.setMaximumFractionDigits(0);
        }
        return formatter;
    }

    private static char convertNbspToSpace(char c) {
        return c == '\u00a0' ? (char)' ' : (char)c;
    }

    private static void configureCurrency(NumberConverterEx numConverter, NumberFormat formatter) throws Exception {
        if (numConverter.getCurrencyCode() == null && numConverter.getCurrencySymbol() == null) {
            return;
        }
        if (curClassAvailable == null) {
            try {
                curClass = Class.forName("java.util.Currency");
                curClassAvailable = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                curClassAvailable = Boolean.FALSE;
            }
        }
        if (numConverter.getCurrencyCode() != null && curClassAvailable.booleanValue()) {
            Method method = curClass.getMethod("getInstance", stringArg);
            Object cur = method.invoke(null, numConverter.getCurrencyCode());
            Class<?> numFormatClass = Class.forName("java.text.NumberFormat");
            method = numFormatClass.getMethod("setCurrency", curClass);
            method.invoke((Object)formatter, cur);
            return;
        }
        String curSymbol = null;
        if (numConverter.getCurrencySymbol() != null) {
            curSymbol = numConverter.getCurrencySymbol();
        } else if (numConverter.getCurrencyCode() != null) {
            curSymbol = numConverter.getCurrencyCode();
        }
        if (curSymbol != null) {
            DecimalFormat df = (DecimalFormat)formatter;
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setCurrencySymbol(curSymbol);
            df.setDecimalFormatSymbols(dfs);
        }
    }

    private static void configureFormatter(NumberConverterEx numConverter, NumberFormat formatter) {
        formatter.setGroupingUsed(numConverter.isGroupingUsed());
        if (numConverter.isMaxIntegerDigitsSet()) {
            formatter.setMaximumIntegerDigits(numConverter.getMaxIntegerDigits());
        }
        if (numConverter.isMinIntegerDigitsSet()) {
            formatter.setMinimumIntegerDigits(numConverter.getMinIntegerDigits());
        }
        if (numConverter.isMaxFractionDigitsSet()) {
            formatter.setMaximumFractionDigits(numConverter.getMaxFractionDigits());
        }
        if (numConverter.isMinFractionDigitsSet()) {
            formatter.setMinimumFractionDigits(numConverter.getMinFractionDigits());
        }
    }

    public static void initJSLibraries(UIComponent component, FacesContext context) {
        HxClientRenderUtil.initJSLibraries(component, context, true);
    }

    public static void initJSLibraries(UIComponent component, FacesContext context, boolean bWriteNow) {
        boolean inPortal;
        if (StringUtil.checkEncoding() && (inPortal = HxClientRenderUtil.isPortal(context.getExternalContext().getRequest()))) {
            context.getExternalContext().getSessionMap().put("PortalEncoding", context.getExternalContext().encodeNamespace(""));
        }
        if (!AjaxUtil.isAjaxRequest(context)) {
            bWriteNow = true;
            UIScriptCollector scriptCollector = null;
            scriptCollector = component instanceof UIScriptCollector ? (UIScriptCollector)component : UIScriptCollector.find(component);
            if (scriptCollector != null) {
                Object req;
                Locale locale = context.getViewRoot().getLocale();
                Map resMap = context.getExternalContext().getApplicationMap();
                HxClientRenderUtil.generateStringResources(locale, resMap);
                ScriptObject script = HxClientRenderUtil.buildLibraryIncludeBlock(context);
                if (bWriteNow) {
                    scriptCollector.writeLibraryReference(context, script.getId(), script.getScript());
                } else {
                    scriptCollector.addLibrary(script.getId(), script.getScript());
                }
                String useFullHxVersion = context.getExternalContext().getInitParameter("com.ibm.faces.USE_HXCLIENT_FULL");
                if ((useFullHxVersion == null || useFullHxVersion.equalsIgnoreCase("false")) && HxClientRenderUtil.isPortal(req = context.getExternalContext().getRequest())) {
                    scriptCollector.addScriptOnce("if (hX_6) hX_6.AJAX_prototypeloader();", 1);
                }
                scriptCollector.addScriptOnce("hX_6.onPageLoad();", 3);
            } else {
                ResourceBundle rb = ResourceHandler.getBundle(context);
                throw new FacesException(ResourceHandler.getString(rb, "NoScriptCollectorFoundError"));
            }
        }
    }

    public static void resetHxClientStringResources(FacesContext context, Locale l) {
        Map resMap = (Map)context.getExternalContext().getApplicationMap().get(HX_STRING_RESOURCES);
        if (resMap != null) {
            if (l != null) {
                resMap.put(l.toString(), null);
            } else {
                resMap.clear();
            }
        }
    }

    protected static String[] removeEmptyStringArrayItems(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || array[i].equals("")) continue;
            list.add(array[i]);
        }
        String[] newarray = new String[list.size()];
        list.toArray(newarray);
        return newarray;
    }

    public static String generateStringResources(Locale locale, Map applicationMap) {
        HashMap<String, String> resMap = null;
        if (applicationMap != null) {
            resMap = (HashMap<String, String>)applicationMap.get(HX_STRING_RESOURCES);
        }
        String localeRes = null;
        if (resMap != null) {
            localeRes = (String)resMap.get(locale.toString());
        }
        if (localeRes == null) {
            Boolean useICU = Boolean.FALSE;
            try {
                Class<?> d = Class.forName("com.ibm.icu.text.DateFormatSymbols");
                Class[] dp = new Class[]{Integer.TYPE, Integer.TYPE};
                Method f = d.getMethod("getWeekdays", dp);
                if (f != null) {
                    useICU = Boolean.TRUE;
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            localeRes = useICU != false ? HxClientICU.compileHxICUResources(locale) : HxClientRenderUtil.compileHxResources(locale);
            String localeArrayIndex = ".L[\"" + locale + "\"]";
            String library = "ibmjsfres/hxclient_S_v3_1_3.js";
            library = ResourceHandler.buildLocalizedLibName(library, locale);
            String strings = "";
            InputStream stream = hxClientClassLoader.getResourceAsStream(library);
            if (stream != null) {
                byte[] buffer = new byte[10000];
                byte[] bytes = new byte[]{};
                int read = 0;
                try {
                    while ((read = stream.read(buffer)) > 0) {
                        int newSize = bytes.length + read;
                        byte[] newBytes = new byte[newSize];
                        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                        System.arraycopy(buffer, 0, newBytes, bytes.length, read);
                        bytes = newBytes;
                    }
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                strings = new String(bytes);
            }
            strings = strings.replaceAll(HX_VAR_NAME, HX_VAR_NAME + localeArrayIndex);
            StringBuffer buf = new StringBuffer();
            buf.append("if(").append(HX_VAR_NAME).append(localeArrayIndex).append("==null)").append(HX_VAR_NAME).append(localeArrayIndex).append("=new Object();\n");
            buf.append(strings);
            buf.append(localeRes);
            localeRes = buf.toString();
            if (resMap == null) {
                resMap = new HashMap<String, String>();
                if (applicationMap != null) {
                    applicationMap.put(HX_STRING_RESOURCES, resMap);
                }
            }
            resMap.put(locale.toString(), localeRes);
        }
        return localeRes;
    }

    private static String compileHxResources(Locale locale) {
        int i;
        StringBuffer buf = new StringBuffer();
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        String err = "ERR";
        String[] errWeek = new String[]{err, err, err, err, err, err, err};
        String[] errMonth = new String[]{err, err, err, err, err, err, err, err, err, err, err, err};
        String[] errHebrewMonth = new String[]{err, err, err, err, err, err, err, err, err, err, err, err, err};
        String[] tempArray = null;
        buf.append("\n//Note : Non-Gregorian calendar strings cannot be retrieved as ICU4J library is not available to this project.\n//Strings here retrieved from java.text.DateFormatSymbols in JRE\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_MONTHS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(dfs.getMonths()))).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(errMonth)).append("],\n");
        buf.append("//Hebrew...\n").append("[").append(Utils.appendStrings(errHebrewMonth)).append("]];\n");
        buf.append("\n//Note : Standalone wide months strings cannot be retrieved as ICU4J library is not available to this project.\n//Strings here retrieved from java.text.DateFormatSymbols in JRE\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SAMONTHS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(dfs.getMonths()))).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(errMonth)).append("],\n");
        buf.append("//Hebrew...\n").append("[").append(Utils.appendStrings(errHebrewMonth)).append("]];\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SHMONTHS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(dfs.getShortMonths()))).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(errMonth)).append("],\n");
        buf.append("//Hebrew...\n").append("[").append(Utils.appendStrings(errHebrewMonth)).append("]];\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_DAYS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(dfs.getWeekdays()))).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(errWeek)).append("],\n");
        buf.append("//Hebrew...\n").append("[").append(Utils.appendStrings(errWeek)).append("]];\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SHDAYS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(dfs.getShortWeekdays()))).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(errWeek)).append("],\n");
        buf.append("//Hebrew...\n").append("[").append(Utils.appendStrings(errWeek)).append("]];\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SHSHDAYS = \n").append("//Gregorian...\n");
        buf.append("[[");
        String[] days = HxClientRenderUtil.removeEmptyStringArrayItems(dfs.getShortWeekdays());
        for (int i2 = 0; i2 < days.length; ++i2) {
            days[i2] = days[i2].substring(0, 1);
        }
        buf.append(Utils.appendStrings(days)).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(errWeek)).append("],\n");
        buf.append("//Hebrew...\n").append("[").append(Utils.appendStrings(errWeek)).append("]];\n");
        buf.append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_EPOCHS = [\n").append("//Christian Gregorian Calendar, two epochs -- religious form\n");
        String[] eras = dfs.getEras();
        buf.append("[");
        tempArray = new String[2];
        for (i = 0; i < eras.length; ++i) {
            buf.append("[");
            tempArray[0] = "--";
            tempArray[1] = eras[i];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("//Hijiri (Islamic) Calendar, one epoch -- the date of the haj\n");
        eras = new String[]{err};
        buf.append("[");
        tempArray[1] = "--";
        buf.append("[").append(Utils.appendStrings(tempArray)).append("]");
        if (eras.length > 0) {
            buf.append(",");
        }
        for (i = 0; i < eras.length; ++i) {
            buf.append("[");
            tempArray[1] = eras[i];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("//Buddhist Gregorian Calendar, one epoch -- the birth of The Buddha\n");
        buf.append("[");
        tempArray[1] = "--";
        buf.append("[");
        buf.append(Utils.appendStrings(tempArray)).append("]");
        if (eras.length > 0) {
            buf.append(",");
        }
        for (i = 0; i < eras.length; ++i) {
            buf.append("[");
            tempArray[1] = eras[i];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("//Japanese Gregorian Calendar, reigns of the emperors -- Meiji period and later\n");
        buf.append("[");
        for (i = 0; i < eras.length; ++i) {
            buf.append("[");
            tempArray[1] = eras[i];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i + 1) continue;
            buf.append(",");
        }
        buf.append("]\n];\n");
        tempArray = dfs.getAmPmStrings();
        buf.append("//Default AM and PM suffixes\n").append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STR_AM_SUFFIX = \"").append(tempArray[0]).append("\";\n").append(HX_VAR_NAME).append(".L[\"").append(locale).append("\"]").append(".STR_PM_SUFFIX = \"").append(tempArray[1]).append("\";\n");
        return JavaScriptUtil.encodeScriptResourceString(buf.toString(), false);
    }

    public static synchronized ScriptObject buildLibraryIncludeBlock(FacesContext context) {
        String theEncodedURL;
        Locale locale = context.getViewRoot().getLocale();
        StringBuffer buffer = new StringBuffer();
        String useFullHxVersion = context.getExternalContext().getInitParameter("com.ibm.faces.USE_HXCLIENT_FULL");
        String theContextPath = LifecycleUtil.getResourceServletContextPath(context);
        String rebuild_proto_portal = "";
        if (useFullHxVersion != null && useFullHxVersion.equalsIgnoreCase("true")) {
            theEncodedURL = context.getExternalContext().encodeResourceURL(theContextPath + "/" + HX_LIB_FILENAME);
        } else {
            theEncodedURL = context.getExternalContext().encodeResourceURL(theContextPath + "/" + Utils.versionizeFilename("hxclient_core.js"));
            Object req = context.getExternalContext().getRequest();
            if (HxClientRenderUtil.isPortal(req)) {
                rebuild_proto_portal = "\nif (hX_6) hX_6.AJAX_prototypeloader();";
            }
        }
        StringBuffer resUrl = new StringBuffer(theContextPath);
        resUrl.append("/hxclient_S_").append(HX_VERSION).append(".js");
        resUrl = new StringBuffer(ResourceHandler.buildLocalizedLibName(ResourceHandler.getBundle(context), resUrl.toString()));
        resUrl.append("?").append(HX_VIEW_LOCALE).append("=").append(locale.toString());
        String theEncodedStringURL = context.getExternalContext().encodeResourceURL(resUrl.toString());
        buffer.append("\n<script type=\"text/JavaScript\" language=\"JavaScript\" src=\"").append(theEncodedURL + "\"" + "></script>\n").append("\n<script type=\"text/JavaScript\" language=\"JavaScript\" src=\"").append(theEncodedStringURL + "\"" + "></script>\n").append("<script type=\"text/JavaScript\" language=\"JavaScript\">\n").append(rebuild_proto_portal).append(HxClientRenderUtil.buildSetResourcePathCall(context)).append(HxClientRenderUtil.buildPortalFlag(context)).append(HxClientRenderUtil.buildLocaleCall(context)).append("\n</script>");
        ScriptObject script = new ScriptObject(locale.toString(), buffer.toString());
        return script;
    }

    public static boolean isContainedInPanel(UIComponent component) {
        while (component != null) {
            if (component instanceof UIData || component instanceof UIDataIterator) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static final synchronized ScriptObject buildJsStringValidator(FacesContext context, String constraint, String minLength, String maxLength, boolean required, ExpressionValidator expressionValidator) {
        return HxClientRenderUtil.buildJsAddStringValidator(context, constraint, minLength, maxLength, required, expressionValidator);
    }

    public static final synchronized ScriptObject buildJsAddStringValidator(FacesContext context, String regexp, String minLength, String maxLength, boolean required, ExpressionValidator expressionValidator) {
        ScriptObject cachedScript;
        String validatorKey = null;
        String validatorId = null;
        String expression = null;
        if (expressionValidator != null) {
            expression = JavaScriptUtil.convertEL2JavaScript(expressionValidator.getExpression());
        }
        if (null != (cachedScript = (ScriptObject)constraintValidatorJs.get(validatorKey = HxClientRenderUtil.createStringValidatorKey(regexp, minLength, maxLength, required, expression)))) {
            return cachedScript;
        }
        String[] args = new String[5];
        int iArg = 0;
        if (null != minLength) {
            args[iArg++] = "min-length:" + minLength;
        }
        if (null != maxLength) {
            args[iArg++] = "max-length:" + maxLength;
        }
        if (required) {
            args[iArg++] = "required:true";
        }
        if (null != expression) {
            args[iArg++] = "constraint-expression:" + expression;
        }
        if (null != regexp) {
            if (regexp.equalsIgnoreCase("AlphabetOnly") || regexp.equalsIgnoreCase("DigitOnly") || regexp.equalsIgnoreCase("AlnumOnly") || regexp.equalsIgnoreCase("AlphabetExOnly") || regexp.equalsIgnoreCase("AlnumExOnly")) {
                args[iArg++] = "constraint:" + regexp;
            } else {
                regexp = regexp.replaceAll("\\\\", "\\\\u005c");
                args[iArg++] = "constraint-regexpression:" + regexp;
            }
        }
        if (iArg > 0) {
            validatorId = HxClientRenderUtil.genScriptId(context);
            StringBuffer javascript = new StringBuffer(HX_VAR_NAME);
            javascript.append(".addValidator(\"");
            javascript.append(validatorId);
            javascript.append("\", ");
            javascript.append("new ").append(HX_VAR_NAME).append(".StringValidator(\"").append(args[--iArg]).append('\"');
            while (iArg > 0) {
                javascript.append(", \"").append(args[--iArg]).append('\"');
            }
            javascript.append("));");
            ScriptObject so = new ScriptObject(validatorId, javascript.toString());
            constraintValidatorJs.put(validatorKey, so);
            return so;
        }
        return null;
    }

    public static void setupStrictnessLevel(FacesContext context) {
        if (dateStrictnessLevel == null && ((dateStrictnessLevel = context.getExternalContext().getInitParameter("com.ibm.faces.DATETIME_ASSIST_STRICTNESS")) == null || !dateStrictnessLevel.equals("1") && !dateStrictnessLevel.equals("2"))) {
            dateStrictnessLevel = "1";
        }
        if (numberStrictnessLevel == null && ((numberStrictnessLevel = context.getExternalContext().getInitParameter("com.ibm.faces.NUMBER_ASSIST_STRICTNESS")) == null || !numberStrictnessLevel.equals("1") && !numberStrictnessLevel.equals("2"))) {
            numberStrictnessLevel = "1";
        }
    }

    public static String getDateStrictnessLevel() {
        if (dateStrictnessLevel == null) {
            HxClientRenderUtil.setupStrictnessLevel(FacesContext.getCurrentInstance());
        }
        return dateStrictnessLevel;
    }

    public static String getNumberStrictnessLevel() {
        if (numberStrictnessLevel == null) {
            HxClientRenderUtil.setupStrictnessLevel(FacesContext.getCurrentInstance());
        }
        return numberStrictnessLevel;
    }

    public static final void addScriptLibrary(String library, UIComponent component) {
        UIScriptCollector scriptCollector;
        String useFullHxVersion;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && ((useFullHxVersion = context.getExternalContext().getInitParameter("com.ibm.faces.USE_HXCLIENT_FULL")) == null || useFullHxVersion != null && !useFullHxVersion.equals("true")) && library != null && (scriptCollector = component == null ? HxClientRenderUtil.getScriptCollector(FacesContext.getCurrentInstance().getViewRoot().getFacetsAndChildren()) : (component instanceof UIScriptCollector ? (UIScriptCollector)component : UIScriptCollector.find(component))).isRendering()) {
            scriptCollector.addLibraryReference(Utils.versionizeFilename(library), context);
        }
    }

    private static UIScriptCollector getScriptCollector(Iterator components) {
        while (components.hasNext()) {
            UIComponent comp = (UIComponent)components.next();
            if (comp.getFacetsAndChildren().hasNext()) {
                HxClientRenderUtil.getScriptCollector(comp.getFacetsAndChildren());
            }
            if (!(comp instanceof UIScriptCollector)) continue;
            return (UIScriptCollector)comp;
        }
        return null;
    }

    public static final void addLocalizedStringLibraryIfNeeded(String locale, UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return;
        }
        if (locale.toString().equals(context.getViewRoot().getLocale().toString())) {
            return;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        if (scriptCollector == null || !scriptCollector.isRendering()) {
            return;
        }
        StringBuffer resUrl = new StringBuffer(LifecycleUtil.getResourceServletContextPath(context));
        resUrl.append("/hxclient_S_").append(HX_VERSION).append("_").append(locale).append(".js?").append(HX_VIEW_LOCALE).append("=").append(locale.toString());
        String theEncodedStringURL = context.getExternalContext().encodeResourceURL(resUrl.toString());
        scriptCollector.addLibrary(theEncodedStringURL);
    }

    private static Class getPortletRequestClass() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = HxClientRenderUtil.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            return cl.loadClass("javax.portlet.PortletRequest");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getLegacyPortletRequestClass() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = HxClientRenderUtil.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            return cl.loadClass("org.apache.jetspeed.portlet.PortletRequest");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isPortal(Object request) {
        if (PORTLET_REQ != null && PORTLET_REQ.isInstance(request)) {
            return true;
        }
        return LEG_PORTLET_REQ != null && LEG_PORTLET_REQ.isInstance(request);
    }

    public static String convertComponentIdToClientId(String id, UIComponent component) {
        String clientId = id;
        UIComponent targetComponent = Utils.findNearestComponent(component, id);
        if (targetComponent != null) {
            clientId = targetComponent.getClientId(FacesContext.getCurrentInstance());
        }
        return clientId;
    }

    public static String convertComponentIdsToClientIds(String ids, UIComponent component) {
        StringBuffer clientIds = new StringBuffer();
        StringTokenizer st = new StringTokenizer(ids, ";");
        while (st.hasMoreTokens()) {
            String currentId = st.nextToken();
            String clientId = HxClientRenderUtil.convertComponentIdToClientId(currentId, component);
            clientIds.append(clientId);
            if (!st.hasMoreTokens()) continue;
            clientIds.append(";");
        }
        return clientIds.toString();
    }
}

