/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.converter.DateTimeConverterExICU;
import com.ibm.faces.converter.NumberConverterExICU;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.ICU4JUtil;
import com.ibm.faces.util.JavaScriptUtil;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.HebrewCalendar;
import com.ibm.icu.util.IslamicCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.faces.context.FacesContext;

public class HxClientICU {
    private static int STANDALONE = 0;
    private static int NARROW = 0;
    private static int WIDE = 0;
    private static byte SHORT_MONTH = 0;
    private static byte DAY = 1;
    private static byte SHORT_DAY = (byte)2;
    private static byte ABBREVIATED_DAY = (byte)3;
    private static byte HEBREW = (byte)4;
    private static byte ISLAMIC = (byte)5;

    protected static final void initICU4JConstants() throws Exception {
        Class<?> clazz = Class.forName("com.ibm.icu.text.DateFormatSymbols");
        Field f = clazz.getField("STANDALONE");
        STANDALONE = f.getInt(null);
        f = clazz.getField("NARROW");
        NARROW = f.getInt(null);
        f = clazz.getField("WIDE");
        WIDE = f.getInt(null);
    }

    protected static final String buildJsDateTimeConverterICU(DateTimeConverterExICU datetimeConverter) {
        String pattern = datetimeConverter.getPattern();
        String type = datetimeConverter.getType();
        String dateStyle = datetimeConverter.getDateStyle();
        String timeStyle = datetimeConverter.getTimeStyle();
        String format = null;
        String epoch = new String("");
        int fdow = 0;
        Locale locale = datetimeConverter.getLocale();
        Calendar calendar = null;
        calendar = datetimeConverter.getCalendar();
        if (pattern != null && !pattern.equals("") && calendar == null) {
            format = pattern;
        } else if (calendar != null) {
            if (calendar instanceof BuddhistCalendar) {
                epoch = new String("b");
            }
            if (calendar instanceof HebrewCalendar) {
                epoch = new String("h");
            }
            if (calendar instanceof IslamicCalendar) {
                epoch = new String("i");
            }
            if (calendar instanceof JapaneseCalendar) {
                epoch = new String("j");
            }
            fdow = calendar.getFirstDayOfWeek();
            DateFormat df_icu = null;
            df_icu = calendar != null ? (type.equalsIgnoreCase("both") ? DateFormat.getDateTimeInstance((Calendar)calendar, (int)ICU4JUtil.getDateStyle(dateStyle), (int)ICU4JUtil.getDateStyle(timeStyle), (Locale)locale) : (type.equalsIgnoreCase("date") ? DateFormat.getDateInstance((Calendar)calendar, (int)ICU4JUtil.getDateStyle(dateStyle), (Locale)locale) : (type.equalsIgnoreCase("time") ? DateFormat.getTimeInstance((Calendar)calendar, (int)ICU4JUtil.getDateStyle(timeStyle), (Locale)locale) : DateFormat.getDateInstance((Calendar)calendar, (int)ICU4JUtil.getDateStyle(dateStyle), (Locale)locale)))) : (type.equalsIgnoreCase("both") ? DateFormat.getDateTimeInstance((int)ICU4JUtil.getDateStyle(dateStyle), (int)ICU4JUtil.getDateStyle(timeStyle), (Locale)locale) : (type.equalsIgnoreCase("date") ? DateFormat.getDateInstance((int)ICU4JUtil.getDateStyle(dateStyle), (Locale)locale) : (type.equalsIgnoreCase("time") ? DateFormat.getTimeInstance((int)ICU4JUtil.getDateStyle(timeStyle), (Locale)locale) : DateFormat.getDateInstance((int)ICU4JUtil.getDateStyle(dateStyle), (Locale)locale))));
            if (pattern != null && !pattern.equals("")) {
                ((SimpleDateFormat)df_icu).applyPattern(pattern);
                format = ((SimpleDateFormat)df_icu).toPattern();
            } else {
                format = ((SimpleDateFormat)df_icu).toPattern();
            }
        }
        if (null != format) {
            StringBuffer javascript = new StringBuffer("new hX_6.DateTimeConverter(");
            javascript.append("\"ICU4J\", \"epoch:" + epoch + "\", \"first-day-of-week:" + fdow + "\",");
            javascript.append(" \"strict:" + HxClientRenderUtil.getDateStrictnessLevel() + "\", \"format:");
            javascript.append(format);
            if (!locale.toString().equals(FacesContext.getCurrentInstance().getViewRoot().getLocale().toString())) {
                javascript.append("\", \"locale:").append(locale);
            }
            javascript.append("\")");
            return javascript.toString();
        }
        return null;
    }

    protected static final String buildJsNumberConverterICU(NumberConverterExICU numConverter) {
        String converterPattern = null;
        DecimalFormat formatter = numConverter.getNumberFormat(FacesContext.getCurrentInstance());
        try {
            HxClientICU.configureFormatterICU(numConverter, (NumberFormat)formatter);
            String pattern = numConverter.getPattern();
            if (formatter instanceof DecimalFormat) {
                if (pattern != null && !pattern.equals("")) {
                    formatter.applyPattern(pattern);
                    converterPattern = pattern;
                } else {
                    converterPattern = formatter.toPattern();
                }
                while (converterPattern.indexOf("\u00a4") > -1) {
                    int pos = converterPattern.indexOf("\u00a4");
                    StringBuffer b = new StringBuffer();
                    b.append(converterPattern.substring(0, pos));
                    b.append("\\u00A4");
                    b.append(converterPattern.substring(pos + 1, converterPattern.length()));
                    converterPattern = b.toString();
                }
            } else {
                String formattedResult = formatter.format((Object)new Double(1.111111111111111E17));
                converterPattern = formattedResult.replace('1', '#');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (null != converterPattern && converterPattern.length() > 0) {
            StringBuffer javascript = new StringBuffer("new ");
            javascript.append("hX_6").append(".NumberConverter(\"ICU4J\", ").append("\"strict:").append(HxClientRenderUtil.getNumberStrictnessLevel()).append("\", \"pattern:").append(converterPattern);
            if (numConverter.isPatternExtensionSet()) {
                javascript.append(numConverter.getPatternExtension());
            }
            DecimalFormatSymbols symbols = null;
            symbols = formatter instanceof DecimalFormat ? formatter.getDecimalFormatSymbols() : new DecimalFormatSymbols(numConverter.getLocale());
            char zero_digit = symbols.getZeroDigit();
            String w = Character.toString(zero_digit);
            if (!"0".equalsIgnoreCase(w)) {
                char i = zero_digit;
                javascript.append("\", \"digits:" + i);
            }
            javascript.append("\", \"locale:");
            StringBuffer localeBuf = new StringBuffer();
            localeBuf.append(HxClientICU.convertNbspToSpace(symbols.getGroupingSeparator()));
            localeBuf.append(HxClientICU.convertNbspToSpace(symbols.getDecimalSeparator()));
            localeBuf.append(symbols.getPercent());
            localeBuf.append(symbols.getPerMill());
            localeBuf.append(symbols.getMinusSign());
            localeBuf.append(Utils.escapeBackslash(symbols.getCurrencySymbol()));
            Locale loc = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            if (loc.getLanguage().equalsIgnoreCase("he") || loc.getLanguage().equalsIgnoreCase("iw")) {
                javascript.append(JavaScriptUtil.encodeScriptResourceString(localeBuf.toString(), true));
            } else {
                javascript.append(JavaScriptUtil.encodeScriptResourceString(localeBuf.toString(), false));
            }
            javascript.append("\")");
            return javascript.toString();
        }
        return null;
    }

    private static char convertNbspToSpace(char c) {
        return c == '\u00a0' ? (char)' ' : (char)c;
    }

    private static void configureFormatterICU(NumberConverterExICU numConverter, NumberFormat formatter) {
        formatter.setGroupingUsed(numConverter.isGroupingUsed());
        if (numConverter.isMaxIntegerDigitsSet()) {
            formatter.setMaximumIntegerDigits(numConverter.getMaxIntegerDigits());
        }
        if (numConverter.isMinIntegerDigitsSet()) {
            formatter.setMinimumIntegerDigits(numConverter.getMinIntegerDigits());
        }
        if (numConverter.isMaxFractionDigitsSet()) {
            formatter.setMaximumFractionDigits(numConverter.getMaxFractionDigits());
        }
        if (numConverter.isMinFractionDigitsSet()) {
            formatter.setMinimumFractionDigits(numConverter.getMinFractionDigits());
        }
        if (numConverter.isIntegerOnly()) {
            formatter.setMaximumFractionDigits(0);
        }
    }

    protected static String compileHxICUResources(Locale locale) {
        int i;
        int i2;
        int i3;
        try {
            HxClientICU.initICU4JConstants();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        DateFormatSymbols gregorianDFS = new DateFormatSymbols((Calendar)new GregorianCalendar(locale), locale);
        DateFormatSymbols islamicDFS = new DateFormatSymbols((Calendar)new IslamicCalendar(locale), locale);
        DateFormatSymbols hebrewDFS = new DateFormatSymbols((Calendar)new HebrewCalendar(locale), locale);
        DateFormatSymbols buddhistDFS = new DateFormatSymbols((Calendar)new BuddhistCalendar(locale), locale);
        DateFormatSymbols japaneseDFS = new DateFormatSymbols((Calendar)new JapaneseCalendar(locale), locale);
        String[] valueArray = null;
        String[] tempArray = null;
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_MONTHS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(gregorianDFS.getMonths())).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(islamicDFS.getMonths())).append("],\n");
        buf.append("//Hebrew...\n").append("[");
        tempArray = hebrewDFS.getMonths();
        valueArray = new String[13];
        for (i3 = 0; i3 < tempArray.length; ++i3) {
            if (i3 >= 7) {
                valueArray[i3 - 7] = tempArray[i3];
                continue;
            }
            valueArray[i3 + 6] = tempArray[i3];
        }
        buf.append(Utils.appendStrings(valueArray)).append("]];\n");
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SAMONTHS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(gregorianDFS.getMonths(STANDALONE, WIDE))).append("],\n");
        buf.append("//Islamic...\n").append("[").append(Utils.appendStrings(islamicDFS.getMonths(STANDALONE, WIDE))).append("],\n");
        buf.append("//Hebrew...\n").append("[");
        tempArray = hebrewDFS.getMonths(STANDALONE, WIDE);
        valueArray = new String[13];
        for (i3 = 0; i3 < tempArray.length; ++i3) {
            if (i3 >= 7) {
                valueArray[i3 - 7] = tempArray[i3];
                continue;
            }
            valueArray[i3 + 6] = tempArray[i3];
        }
        buf.append(Utils.appendStrings(valueArray)).append("]];\n");
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SHMONTHS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(gregorianDFS.getShortMonths())).append("],\n");
        buf.append("//Islamic...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, islamicDFS.getShortMonths(), SHORT_MONTH, ISLAMIC, gregorianDFS);
        buf.append("],\n");
        buf.append("//Hebrew...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, hebrewDFS.getShortMonths(), SHORT_MONTH, HEBREW, gregorianDFS);
        buf.append("]];\n");
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_DAYS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(gregorianDFS.getWeekdays()))).append("],\n");
        buf.append("//Islamic...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, HxClientRenderUtil.removeEmptyStringArrayItems(islamicDFS.getWeekdays()), DAY, ISLAMIC, gregorianDFS);
        buf.append("],\n");
        buf.append("//Hebrew...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, HxClientRenderUtil.removeEmptyStringArrayItems(hebrewDFS.getWeekdays()), DAY, HEBREW, gregorianDFS);
        buf.append("]];\n");
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SHDAYS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(gregorianDFS.getShortWeekdays()))).append("],\n");
        buf.append("//Islamic...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, HxClientRenderUtil.removeEmptyStringArrayItems(islamicDFS.getShortWeekdays()), SHORT_DAY, ISLAMIC, gregorianDFS);
        buf.append("],\n");
        buf.append("//Hebrew...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, HxClientRenderUtil.removeEmptyStringArrayItems(hebrewDFS.getShortWeekdays()), SHORT_DAY, HEBREW, gregorianDFS);
        buf.append("]];\n");
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_SHSHDAYS = \n").append("//Gregorian...\n");
        buf.append("[[").append(Utils.appendStrings(HxClientRenderUtil.removeEmptyStringArrayItems(gregorianDFS.getWeekdays(STANDALONE, NARROW)))).append("],\n");
        buf.append("//Islamic...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, HxClientRenderUtil.removeEmptyStringArrayItems(islamicDFS.getWeekdays(STANDALONE, NARROW)), ABBREVIATED_DAY, ISLAMIC, gregorianDFS);
        buf.append("],\n");
        buf.append("//Hebrew...\n").append("[");
        HxClientICU.checkBeforeAppendStrings(buf, HxClientRenderUtil.removeEmptyStringArrayItems(hebrewDFS.getWeekdays(STANDALONE, NARROW)), ABBREVIATED_DAY, HEBREW, gregorianDFS);
        buf.append("]];\n");
        buf.append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STRA_DATE_EPOCHS = [\n").append("//Christian Gregorian Calendar, two epochs -- religious form\n");
        String[] eras = gregorianDFS.getEras();
        buf.append("[");
        tempArray = new String[2];
        for (i2 = 0; i2 < eras.length; ++i2) {
            buf.append("[");
            tempArray[0] = "--";
            tempArray[1] = eras[i2];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i2 + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("//Hijiri (Islamic) Calendar, one epoch -- the date of the haj\n");
        eras = islamicDFS.getEras();
        buf.append("[");
        tempArray[1] = "--";
        buf.append("[").append(Utils.appendStrings(tempArray)).append("]");
        if (eras.length > 0) {
            buf.append(",");
        }
        for (i2 = 0; i2 < eras.length; ++i2) {
            buf.append("[");
            tempArray[1] = eras[i2];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i2 + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("// Hebrew Calendar, one epoch -- the date of the creation of the world\n");
        eras = hebrewDFS.getEras();
        buf.append("[");
        tempArray[1] = "--";
        buf.append("[").append(Utils.appendStrings(tempArray)).append("]");
        if (eras.length > 0) {
            buf.append(",");
        }
        String enc_str = null;
        for (i = 0; i < eras.length; ++i) {
            buf.append("[");
            enc_str = locale.getLanguage().equalsIgnoreCase("he") || locale.getLanguage().equalsIgnoreCase("iw") ? JavaScriptUtil.encodeScriptResourceString(eras[i], true) : JavaScriptUtil.encodeScriptResourceString(eras[i], false);
            tempArray[1] = enc_str;
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("//Buddhist Gregorian Calendar, one epoch -- the birth of The Buddha\n");
        eras = buddhistDFS.getEras();
        buf.append("[");
        tempArray[1] = "--";
        buf.append("[");
        buf.append(Utils.appendStrings(tempArray)).append("]");
        if (eras.length > 0) {
            buf.append(",");
        }
        for (i = 0; i < eras.length; ++i) {
            buf.append("[");
            tempArray[1] = eras[i];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (eras.length == i + 1) continue;
            buf.append(",");
        }
        buf.append("],\n").append("//Japanese Gregorian Calendar, reigns of the emperors -- Meiji period and later\n");
        eras = japaneseDFS.getEras();
        buf.append("[");
        for (i = 4; i > 0; --i) {
            buf.append("[");
            tempArray[1] = eras[eras.length - i];
            buf.append(Utils.appendStrings(tempArray)).append("]");
            if (i <= 1) continue;
            buf.append(",");
        }
        buf.append("]\n];\n");
        tempArray = gregorianDFS.getAmPmStrings();
        buf.append("//Default AM and PM suffixes\n").append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STR_AM_SUFFIX = \"").append(tempArray[0]).append("\";\n").append("hX_6").append(".L[\"").append(locale).append("\"]").append(".STR_PM_SUFFIX = \"").append(tempArray[1]).append("\";\n");
        return JavaScriptUtil.encodeScriptResourceString(buf.toString(), false);
    }

    private static void checkBeforeAppendStrings(StringBuffer buf, String[] values, byte type, byte calendar, DateFormatSymbols gregorianDFS) {
        if (type > -1) {
            String[] gsm;
            String ERR = "ERR";
            String[] week = new String[]{ERR, ERR, ERR, ERR, ERR, ERR, ERR};
            String[] month = new String[]{ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR};
            if (type == SHORT_MONTH) {
                String[] gsm2 = gregorianDFS.getShortMonths();
                if (gsm2[1].equals(values[1]) && gsm2[2].equals(values[2])) {
                    if (calendar == HEBREW) {
                        buf.append(Utils.appendStrings(new String[]{ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR, ERR}));
                    } else {
                        buf.append(Utils.appendStrings(month));
                    }
                } else {
                    buf.append(Utils.appendStrings(values));
                }
            } else if (type == DAY) {
                String[] gsm3 = HxClientRenderUtil.removeEmptyStringArrayItems(gregorianDFS.getWeekdays());
                if (gsm3[1].equals(values[1]) && gsm3[2].equals(values[2])) {
                    buf.append(Utils.appendStrings(week));
                }
            } else if (type == SHORT_DAY) {
                String[] gsm4 = HxClientRenderUtil.removeEmptyStringArrayItems(gregorianDFS.getShortWeekdays());
                if (gsm4[1].equals(values[1]) && gsm4[2].equals(values[2])) {
                    buf.append(Utils.appendStrings(week));
                }
            } else if (type == ABBREVIATED_DAY && (gsm = HxClientRenderUtil.removeEmptyStringArrayItems(gregorianDFS.getWeekdays(STANDALONE, NARROW)))[1].equals(values[1]) && gsm[2].equals(values[2])) {
                buf.append(Utils.appendStrings(week));
            }
        }
    }
}

