/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIPager;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlPagerGoto;
import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.faces.renderkit.html_extended.AbstractPagerRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.ScriptObject;
import com.ibm.faces.validator.LongRangeValidatorEx;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;

public class GotoPagerRenderer
extends AbstractPagerRenderer
implements IScriptContributor {
    protected static final String PAGER_GO = "__pagerGoButton";
    protected static final String PAGER_TEXT = "__pagerGoText";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String alt;
        String tabindex;
        String title;
        String imageSrc;
        String type;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlPagerGoto gotoComponent = null;
        if (component instanceof HtmlPagerGoto) {
            gotoComponent = (HtmlPagerGoto)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String localizedGo = ResourceHandler.getString(bundle, "PagerRenderer.go");
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        int currentPage = ((UIPager)component).getCurrentPage(pdw);
        String id = component.getClientId(context);
        if (gotoComponent != null) {
            style = gotoComponent.getStyle();
            styleClass = gotoComponent.getStyleClass();
            type = gotoComponent.getType();
            imageSrc = gotoComponent.getButtonImageSrc();
            title = gotoComponent.getTitle();
            tabindex = gotoComponent.getTabindex();
            alt = gotoComponent.getAlt();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            type = (String)component.getAttributes().get("type");
            imageSrc = (String)component.getAttributes().get("buttonImageSrc");
            title = (String)component.getAttributes().get("title");
            tabindex = (String)component.getAttributes().get("tabindex");
            alt = (String)component.getAttributes().get("alt");
        }
        if (imageSrc != null) {
            imageSrc = Utils.getEncodedResourceURL(context, imageSrc);
        }
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)id, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        if (type == null || type.equalsIgnoreCase("text") || !this.isTypeValid(type).booleanValue()) {
            this.writeTextInput(writer, id, currentPage, this.getFieldSize(component), styleClass, tabindex);
        } else if (type.equalsIgnoreCase("combobox")) {
            this.writeCombobox(writer, component, id, currentPage);
        } else if (type.equalsIgnoreCase("spinner") || type.equalsIgnoreCase("slider")) {
            int size = this.getFieldSize(component);
            writer.startElement("table", component);
            writer.startElement("tr", component);
            writer.startElement("td", component);
            writer.writeAttribute("width", (Object)String.valueOf(size * 8 + 20), null);
            this.writeSpinnerSlider(context, writer, component, id, currentPage, type, size, styleClass, tabindex);
            writer.endElement("td");
            writer.startElement("td", component);
        }
        this.writeSubmitControl(component, writer, localizedGo, id, styleClass, imageSrc, tabindex, alt);
        if (type != null && (type.equalsIgnoreCase("spinner") || type.equalsIgnoreCase("slider"))) {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        }
        writer.endElement("span");
    }

    protected void writeSubmitControl(UIComponent component, ResponseWriter writer, String localizedGo, String id, String styleClass, String imageSrc, String tabindex, String alt) throws IOException {
        writer.startElement("span", component);
        writer.write("\n");
        writer.startElement("input", component);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", null);
            writer.writeAttribute("src", (Object)imageSrc, null);
        } else {
            writer.writeAttribute("type", (Object)"submit", null);
        }
        writer.writeAttribute("id", (Object)(id + PAGER_GO), null);
        writer.writeAttribute("name", (Object)(id + PAGER_GO), null);
        writer.writeAttribute("value", (Object)localizedGo, null);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        if (alt != null) {
            writer.writeAttribute("alt", (Object)alt, "alt");
        }
        writer.endElement("input");
        writer.write("\n");
        writer.endElement("span");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        if (!((UIPager)component).isPaged(pdw)) {
            return;
        }
        String id = component.getClientId(context);
        String keyButton = id + PAGER_GO;
        if (this.wasInputClicked(context, component, keyButton)) {
            String keyText = id + PAGER_TEXT;
            String valueText = (String)context.getExternalContext().getRequestParameterMap().get(keyText);
            if (valueText != null) {
                try {
                    Number objI = this.getIndex(context, valueText);
                    int newPage = objI.intValue() - 1;
                    int currentPage = ((UIPager)component).getCurrentPage(pdw);
                    int lastPage = ((UIPager)component).getLastPage(pdw);
                    this.queueEvent(component, currentPage, newPage, lastPage);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private void writeTextInput(ResponseWriter writer, String id, int currentPage, int size, String styleClass, String tabindex) throws IOException {
        String textId = id + PAGER_TEXT;
        HtmlUtil.writeTagStartOpen((Writer)writer, "input", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "type", "text");
        HtmlUtil.writeTagAttribute((Writer)writer, "size", String.valueOf(size));
        HtmlUtil.writeTagAttribute((Writer)writer, "id", textId);
        HtmlUtil.writeTagAttribute((Writer)writer, "name", textId);
        HtmlUtil.writeTagAttribute((Writer)writer, "value", this.getLocalizedIndexText(FacesContext.getCurrentInstance(), currentPage + 1));
        if (tabindex != null) {
            HtmlUtil.writeTagAttribute((Writer)writer, "tabindex", tabindex);
        }
        if (styleClass != null) {
            HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass + "_inputText");
        }
        HtmlUtil.writeTagStartCloseLn((Writer)writer, true);
    }

    private void writeCombobox(ResponseWriter writer, UIComponent component, String id, int currentPage) throws IOException {
        String textId = id + PAGER_TEXT;
        writer.startElement("select", component);
        writer.writeAttribute("id", (Object)textId, null);
        writer.writeAttribute("name", (Object)textId, null);
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        int total = ((UIPager)component).getLastPage(pdw) + 1;
        if (total < 1) {
            total = 1;
        }
        for (int i = 1; i <= total; ++i) {
            writer.startElement("option", component);
            if (i == currentPage + 1) {
                writer.writeAttribute("selected", (Object)Boolean.TRUE, null);
            }
            writer.writeAttribute("value", (Object)this.getLocalizedIndexText(FacesContext.getCurrentInstance(), i), null);
            writer.writeText((Object)this.getLocalizedIndexText(FacesContext.getCurrentInstance(), i), null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    private void writeSpinnerSlider(FacesContext context, ResponseWriter writer, UIComponent component, String id, int currentPage, String type, int size, String styleClass, String tabindex) throws IOException {
        String textId = id + PAGER_TEXT;
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("size", (Object)String.valueOf(size), null);
        writer.writeAttribute("id", (Object)textId, null);
        writer.writeAttribute("name", (Object)textId, null);
        writer.writeAttribute("value", (Object)String.valueOf(currentPage + 1), null);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)(styleClass + "_inputText"), null);
        }
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        writer.endElement("input");
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        int total = ((UIPager)component).getLastPage(pdw) + 1;
        if (total < 1) {
            total = 1;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_sl.js", component);
        HxClientRenderUtil.addScriptLibrary("hxclient_sp.js", component);
        NumberConverterEx nc = new NumberConverterEx();
        nc.setIntegerOnly(true);
        LongRangeValidatorEx lrv = new LongRangeValidatorEx();
        lrv.setMinimum(1L);
        lrv.setMaximum(total);
        ScriptObject converterScript = HxClientRenderUtil.buildJsNumberConverter(context, nc);
        ScriptObject validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, (Converter)nc, (Validator)lrv, false, null, null);
        scriptCollector.addScriptOnce(converterScript.getScript());
        scriptCollector.addScriptOnce(validatorScript.getScript());
        StringBuffer script = new StringBuffer("hX_6");
        script.append(".addComponent(\"");
        script.append(textId);
        if (type.equalsIgnoreCase("slider")) {
            script.append("\", new ");
            script.append("hX_6");
            script.append(".JSFSlider(\"increment:1\"");
        } else {
            script.append("\", new ");
            script.append("hX_6");
            script.append(".JSFSpinner(\"increment:1\"");
        }
        script.append(",\"converter:");
        script.append(converterScript.getId());
        script.append('\"');
        script.append(",\"validator:");
        script.append(validatorScript.getId());
        script.append('\"');
        script.append("));");
        scriptCollector.addScript(script.toString());
    }

    protected boolean wasInputClicked(FacesContext context, UIComponent component, String name) {
        return context.getExternalContext().getRequestParameterMap().get(name) != null || context.getExternalContext().getRequestParameterMap().get(name + ".x") != null;
    }

    private Boolean isTypeValid(String type) {
        String[] types = new String[]{"text", "combobox", "spinner", "slider"};
        Boolean valid = Boolean.FALSE;
        for (int x = 0; x < types.length; ++x) {
            if (!type.equalsIgnoreCase(types[x])) continue;
            valid = Boolean.TRUE;
            break;
        }
        return valid;
    }

    private int getFieldSize(UIComponent component) {
        int size = 4;
        UIPager.PagerDataWrapper pdw = ((UIPager)component).getPagerDataWrapper();
        if (pdw == null) {
            return size;
        }
        size = pdw.getRows() > 0 ? String.valueOf(pdw.getRowCount() / pdw.getRows()).length() : 0;
        if (size == 0) {
            size = 1;
        }
        return ++size;
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
    }
}

