/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.html.HtmlFormItem;
import com.ibm.faces.component.html.HtmlFormMessagesArea;
import com.ibm.faces.component.html.HtmlPanelFormBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class FormMessagesAreaRenderer
extends Renderer {
    private static final String ERROR = "error";
    private static final String ALWAYS = "always";
    private static final String INFO = "info";
    private static final String BOTH = "both";
    private static final String ERRORS = "errors";
    private static final String CR = "\n";
    private static final String DIV = "div";
    private static final String TABLE = "table";
    private static final String TD = "td";
    private static final String TR = "tr";
    private static final String UL = "ul";
    private static final String LI = "li";
    private static final String SPAN = "span";
    private static final String _MESSAGESAREA_SUFFIX = "MessagesArea";
    private static final String _ERROR_SUFFIX = "Error";
    private static final String _INFO_SUFFIX = "Info";
    private static final String _WARN_SUFFIX = "Warn";
    private static final String _ERRORS_SUFFIX = "Errors";
    private static final String CONNECTOR_U = "_";
    private static final String CONNECTOR_H = "-";
    private static final String SPACER = " ";
    private static final String ERRORS_TABLE = "table";
    private static final String ERRORS_LIST = "list";
    private static final String CLASS = "class";
    private static final String STYLE = "style";
    private static final String TITLE = "title";
    private static final String ID = "id";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        List errors;
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        HtmlFormMessagesArea messages = (HtmlFormMessagesArea)component;
        String infoSpanId = component.getClientId(context) + CONNECTOR_U + _INFO_SUFFIX.toLowerCase();
        String errorSpanId = component.getClientId(context) + CONNECTOR_U + _ERROR_SUFFIX.toLowerCase();
        String messagesId = component.getClientId(context) + CONNECTOR_U + _ERRORS_SUFFIX.toLowerCase();
        String showHelp = messages.getShowHelp();
        boolean showErrorText = showHelp == null || showHelp.equals(ALWAYS) || showHelp.equals(ERROR) || showHelp.equals(BOTH) || showHelp.equals(ERRORS);
        boolean showInfoText = showHelp == null || showHelp.equals(ALWAYS) || showHelp.equals(INFO) || showHelp.equals(BOTH);
        boolean showChildErrors = showHelp == null || showHelp.equals(ALWAYS) || showHelp.equals(ERRORS);
        writer.startElement(DIV, null);
        writer.writeAttribute(ID, (Object)messages.getClientId(context), ID);
        String parentStyleClass = ((HtmlPanelFormBox)component.getParent()).getStyleClass();
        if (parentStyleClass != null && parentStyleClass.indexOf(SPACER) != -1) {
            parentStyleClass = parentStyleClass.substring(0, parentStyleClass.indexOf(SPACER)).trim();
        }
        String classSuffix = "";
        if (messages.getStyleClass() != null && messages.getStyleClass().trim().length() > 0) {
            classSuffix = SPACER + messages.getStyleClass();
        }
        if (parentStyleClass != null) {
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _MESSAGESAREA_SUFFIX + classSuffix), CLASS);
        }
        if (messages.getStyle() != null) {
            writer.writeAttribute(STYLE, (Object)messages.getStyle(), STYLE);
        }
        if (messages.getTitle() != null && messages.getTitle().length() > 0) {
            writer.writeAttribute(TITLE, (Object)messages.getTitle(), TITLE);
        }
        writer.writeText((Object)CR, null);
        writer.startElement("table", null);
        writer.writeText((Object)CR, null);
        if (showInfoText) {
            if (component.getFacet(INFO) != null) {
                writer.startElement(TR, null);
                writer.writeText((Object)CR, null);
                writer.startElement(TD, null);
                writer.writeText((Object)CR, null);
                this.encodeRecursive(context, component.getFacet(INFO));
                writer.writeText((Object)CR, null);
                writer.endElement(TD);
                writer.endElement(TR);
            } else if (messages.getInfoText() != null) {
                writer.writeText((Object)CR, null);
                writer.startElement(TR, null);
                writer.writeText((Object)CR, null);
                writer.startElement(TD, null);
                writer.writeText((Object)CR, null);
                writer.startElement(SPAN, null);
                writer.writeAttribute(ID, (Object)infoSpanId, ID);
                writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _MESSAGESAREA_SUFFIX + CONNECTOR_H + _INFO_SUFFIX), CLASS);
                if (messages.isEscape()) {
                    writer.writeText((Object)messages.getInfoText(), null);
                } else {
                    writer.write(messages.getInfoText());
                }
                writer.endElement(SPAN);
                writer.writeText((Object)CR, null);
                writer.endElement(TD);
                writer.endElement(TR);
                writer.writeText((Object)CR, null);
            }
        }
        if ((errors = this.getErrors(context, component.getParent())) != null) {
            if (showErrorText) {
                if (component.getFacet(ERROR) != null) {
                    writer.writeText((Object)CR, null);
                    writer.startElement(TR, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement(TD, null);
                    writer.writeText((Object)CR, null);
                    this.encodeRecursive(context, component.getFacet(ERROR));
                    writer.writeText((Object)CR, null);
                    writer.endElement(TD);
                    writer.endElement(TR);
                    writer.writeText((Object)CR, null);
                } else if (messages.getErrorText() != null) {
                    writer.writeText((Object)CR, null);
                    writer.startElement(TR, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement(TD, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement(SPAN, null);
                    writer.writeAttribute(ID, (Object)errorSpanId, ID);
                    writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _MESSAGESAREA_SUFFIX + CONNECTOR_H + _ERROR_SUFFIX), CLASS);
                    if (messages.isEscape()) {
                        writer.writeText((Object)messages.getErrorText(), null);
                    } else {
                        writer.write(messages.getErrorText());
                    }
                    writer.endElement(SPAN);
                    writer.writeText((Object)CR, null);
                    writer.endElement(TD);
                    writer.endElement(TR);
                    writer.writeText((Object)CR, null);
                }
            }
            if (showChildErrors && errors != null && errors.size() > 0) {
                if (messages.getShowErrors() == null || messages.getShowErrors().equals(ERRORS_LIST)) {
                    writer.writeText((Object)CR, null);
                    writer.startElement(TR, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement(TD, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement(UL, null);
                    writer.writeAttribute(ID, (Object)messagesId, ID);
                    int errorNum = errors.size();
                    for (int i = 0; i < errorNum; ++i) {
                        writer.writeText((Object)CR, null);
                        writer.startElement(LI, null);
                        String severity = (String)((Object[])errors.get(i))[2];
                        if (severity.equals(FacesMessage.SEVERITY_INFO.toString())) {
                            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _INFO_SUFFIX), CLASS);
                        } else if (severity.equals(FacesMessage.SEVERITY_WARN.toString())) {
                            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _WARN_SUFFIX), CLASS);
                        } else {
                            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _ERROR_SUFFIX), CLASS);
                        }
                        String errorText = (String)((Object[])errors.get(i))[0];
                        Boolean escape = (Boolean)((Object[])errors.get(i))[1];
                        if (escape.booleanValue()) {
                            writer.writeText((Object)errorText, null);
                        } else {
                            writer.write(errorText);
                        }
                        writer.endElement(LI);
                    }
                    writer.writeText((Object)CR, null);
                    writer.endElement(UL);
                    writer.writeText((Object)CR, null);
                    writer.endElement(TD);
                    writer.endElement(TR);
                    writer.writeText((Object)CR, null);
                } else if (messages.getShowErrors().equals("table")) {
                    writer.writeText((Object)CR, null);
                    writer.startElement(TR, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement(TD, null);
                    writer.writeText((Object)CR, null);
                    writer.startElement("table", null);
                    writer.writeAttribute(ID, (Object)messagesId, ID);
                    int errorNum = errors.size();
                    for (int i = 0; i < errorNum; ++i) {
                        writer.writeText((Object)CR, null);
                        writer.startElement(TR, null);
                        writer.writeText((Object)CR, null);
                        writer.startElement(TD, null);
                        String severity = (String)((Object[])errors.get(i))[2];
                        if (severity.equals(FacesMessage.SEVERITY_INFO.toString())) {
                            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _INFO_SUFFIX), CLASS);
                        } else if (severity.equals(FacesMessage.SEVERITY_WARN.toString())) {
                            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _WARN_SUFFIX), CLASS);
                        } else {
                            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _ERROR_SUFFIX), CLASS);
                        }
                        String errorText = (String)((Object[])errors.get(i))[0];
                        Boolean escape = (Boolean)((Object[])errors.get(i))[1];
                        if (escape.booleanValue()) {
                            writer.writeText((Object)errorText, null);
                        } else {
                            writer.write(errorText);
                        }
                        writer.endElement(TD);
                        writer.writeText((Object)CR, null);
                        writer.endElement(TR);
                    }
                    writer.writeText((Object)CR, null);
                    writer.endElement("table");
                    writer.writeText((Object)CR, null);
                    writer.endElement(TD);
                    writer.endElement(TR);
                    writer.writeText((Object)CR, null);
                }
            }
        }
        writer.writeText((Object)CR, null);
        writer.endElement("table");
        writer.writeText((Object)CR, null);
        writer.endElement(DIV);
        writer.writeText((Object)CR, null);
    }

    public void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator i = component.getChildren().iterator();
            while (i.hasNext()) {
                UIComponent child = (UIComponent)i.next();
                this.encodeRecursive(context, child);
            }
        }
        component.encodeEnd(context);
    }

    private List getErrors(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildren() == null || component.getChildren().size() < 1) {
            return null;
        }
        List children = component.getChildren();
        ArrayList<Object[]> errors = null;
        block0: for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof HtmlFormItem)) continue;
            HtmlFormItem child = (HtmlFormItem)((Object)children.get(i));
            List components = child.getChildren();
            for (int z = 0; z < components.size(); ++z) {
                String clientId;
                Iterator itr;
                if (!(components.get(z) instanceof UIInput) || (itr = context.getMessages(clientId = ((UIComponent)components.get(z)).getClientId(context))) == null || !itr.hasNext()) continue;
                if (errors == null) {
                    errors = new ArrayList<Object[]>();
                }
                if (child.getErrorText() != null && child.getErrorText().length() > 0) {
                    errors.add(new Object[]{child.getErrorText(), child.isEscape() ? Boolean.TRUE : Boolean.FALSE, FacesMessage.SEVERITY_ERROR.toString()});
                    continue block0;
                }
                if (child.getInfoText() != null && child.getInfoText().length() > 0) {
                    errors.add(new Object[]{child.getErrorText(), child.isEscape() ? Boolean.TRUE : Boolean.FALSE, FacesMessage.SEVERITY_INFO.toString()});
                    continue block0;
                }
                while (itr.hasNext()) {
                    FacesMessage msg = (FacesMessage)itr.next();
                    if (msg == null) continue;
                    String error = msg.getDetail();
                    if (error == null) {
                        error = msg.getSummary();
                    }
                    String severity = msg.getSeverity() != null ? msg.getSeverity().toString() : "";
                    errors.add(new Object[]{error, Boolean.TRUE, severity});
                }
                continue block0;
            }
        }
        return errors;
    }
}

