/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlFormItem;
import com.ibm.faces.component.html.HtmlInputHelperAssist;
import com.ibm.faces.component.html.HtmlPanelFormBox;
import com.ibm.faces.renderkit.html_extended.AssistRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.ScriptObject;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class FormItemRenderer
extends Renderer
implements IScriptContributor {
    private static final String ERROR = "error";
    private static final String ALWAYS = "always";
    private static final String INFO = "info";
    private static final String AS_NEEDED = "as-needed";
    private static final String OVER = "over";
    private static final String UNDER = "under";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String HELP = "help";
    private static final String BOTH = "both";
    private static final String CR = "\n";
    private static final String _ERROR_SUFFIX = "Error";
    private static final String _INFO_SUFFIX = "Info";
    private static final String _LABEL_SUFFIX = "Label";
    private static final String _REQUIRED_SUFFIX = "Required";
    private static final String _RELEASED_SUFFIX = "Released";
    private static final String _CONTENT_SUFFIX = "Content";
    private static final String _CELL_SUFFIX = "Cell";
    private static final String _HELP_SUFFIX = "Help";
    private static final String CONNECTOR_U = "_";
    private static final String CONNECTOR_H = "-";
    private static final String SPACER = " ";
    private static final String SPAN = "span";
    private static final String TABLE = "table";
    private static final String TD = "td";
    private static final String TR = "tr";
    private static final String LABEL = "label";
    private static final String CLASS = "class";
    private static final String STYLE = "style";
    private static final String FOR = "for";
    private static final String ID = "id";
    private static final String DIV = "div";
    private static final String VALUE = "value";
    private static final String COLSPAN = "colspan";
    private static final String ACCESSKEY = "accesskey";
    private static final String TITLE = "title";
    private static final String WIDTH = "width";
    private static final String DISPLAY_NONE = "display:none";
    private static int SINGLE_CELL = 0;
    private static int SINGLE_CELL_WITH_JOINED_CELL = 1;
    private static int LABEL_CELL = 2;
    private static int HELP_CELL = 3;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean required;
        FacesMessage msg;
        if (!component.isRendered()) {
            return;
        }
        if (component.getChildCount() == 0) {
            return;
        }
        UIComponent child = (UIComponent)component.getChildren().get(0);
        HtmlFormItem formItem = (HtmlFormItem)component;
        ResponseWriter writer = context.getResponseWriter();
        Iterator errorMsgIter = context.getMessages(child.getClientId(context));
        boolean errorOnPage = errorMsgIter.hasNext();
        FacesMessage facesMessage = msg = errorOnPage ? (FacesMessage)errorMsgIter.next() : null;
        String childErrorMessage = msg != null ? (msg.getDetail() != null ? msg.getDetail() : msg.getSummary()) : null;
        String showHelp = formItem.getShowHelp();
        String releaseMargin = formItem.getReleaseMargin();
        boolean releaseLabel = LABEL.equals(releaseMargin);
        boolean releaseHelp = HELP.equals(releaseMargin);
        boolean releaseBoth = BOTH.equals(releaseMargin);
        HtmlOutputLabel label = new HtmlOutputLabel();
        label.setValue((Object)formItem.getLabel());
        label.setTitle(formItem.getTitle());
        label.setStyle(formItem.getStyle());
        label.setFor(child.getClientId(context));
        label.setAccesskey(formItem.getAccesskey());
        HtmlPanelFormBox formBox = (HtmlPanelFormBox)component.getParent();
        String parentStyleClass = formBox.getStyleClass();
        if (parentStyleClass != null && parentStyleClass.indexOf(SPACER) != -1) {
            parentStyleClass = parentStyleClass.substring(0, parentStyleClass.indexOf(SPACER)).trim();
        }
        String widthContent = formBox.getWidthContent();
        boolean bl = required = child instanceof UIInput && ((UIInput)child).isRequired();
        if ((showHelp == null || showHelp.equals(ALWAYS) || showHelp.equals(INFO) || showHelp.equals(ERROR) || showHelp.equals(AS_NEEDED)) && !formItem.isNoClientValidation()) {
            UIScriptCollector scriptCollector = UIScriptCollector.find(component);
            HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
            scriptCollector.register(this, component);
        }
        String classSuffix = "";
        if (formItem.getStyleClass() != null && formItem.getStyleClass().trim().length() > 0) {
            classSuffix = SPACER + formItem.getStyleClass();
        }
        if (errorOnPage) {
            if (required) {
                label.setStyleClass(parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _REQUIRED_SUFFIX + CONNECTOR_H + _ERROR_SUFFIX + classSuffix);
            } else {
                label.setStyleClass(parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _ERROR_SUFFIX + classSuffix);
            }
        } else if (required) {
            label.setStyleClass(parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _REQUIRED_SUFFIX + classSuffix);
        } else {
            label.setStyleClass(parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + classSuffix);
        }
        String pos = ((HtmlPanelFormBox)component.getParent()).getLabelPosition();
        boolean labelIsOver = true;
        boolean labelIsLeft = false;
        boolean labelIsRight = false;
        boolean labelIsUnder = false;
        boolean helpIsOver = true;
        boolean helpIsLeft = false;
        boolean helpIsRight = false;
        boolean helpIsUnder = false;
        if (pos != null) {
            labelIsOver = pos.equals(OVER);
            labelIsLeft = pos.equals(LEFT);
            labelIsRight = pos.equals(RIGHT);
            labelIsUnder = pos.equals(UNDER);
        } else {
            labelIsOver = true;
        }
        pos = ((HtmlPanelFormBox)component.getParent()).getHelpPosition();
        if (pos != null) {
            helpIsOver = pos.equals(OVER);
            helpIsLeft = pos.equals(LEFT);
            helpIsRight = pos.equals(RIGHT);
            helpIsUnder = pos.equals(UNDER);
            pos = null;
        } else {
            helpIsOver = true;
        }
        if (releaseBoth && (labelIsLeft || labelIsRight || helpIsLeft || helpIsRight)) {
            int span = 1;
            if (labelIsLeft || labelIsRight) {
                ++span;
            }
            if (helpIsLeft || helpIsRight) {
                ++span;
            }
            this.startNestedTable(writer, parentStyleClass, span);
        }
        if (labelIsOver || helpIsOver) {
            if (labelIsLeft || helpIsLeft) {
                writer.startElement(TD, null);
                writer.endElement(TD);
            }
            this.writeLabelOrHelperCells(context, component, label, errorOnPage, childErrorMessage, labelIsOver, helpIsOver, labelIsRight || helpIsRight ? SINGLE_CELL_WITH_JOINED_CELL : SINGLE_CELL);
            writer.endElement(TR);
            writer.writeText((Object)CR, null);
            writer.startElement(TR, null);
        }
        if (releaseLabel && labelIsLeft) {
            this.startNestedTable(writer, parentStyleClass, labelIsLeft && helpIsLeft ? 3 : 2);
        }
        if (labelIsLeft || helpIsLeft) {
            this.writeLabelOrHelperCells(context, component, label, errorOnPage, childErrorMessage, labelIsLeft, helpIsLeft, LABEL_CELL);
            if (releaseHelp && helpIsLeft) {
                this.startNestedTable(writer, parentStyleClass, 2);
            }
            this.writeLabelOrHelperCells(context, component, label, errorOnPage, childErrorMessage, labelIsLeft, helpIsLeft, HELP_CELL);
        }
        if (releaseLabel && labelIsRight || releaseHelp && helpIsRight) {
            this.startNestedTable(writer, parentStyleClass, labelIsRight && helpIsRight && releaseHelp ? 3 : 2);
        }
        writer.startElement(TD, null);
        if (!(widthContent == null || releaseBoth || releaseLabel && (labelIsLeft || labelIsRight) || releaseHelp && (helpIsLeft || helpIsRight))) {
            writer.writeAttribute(WIDTH, (Object)widthContent, WIDTH);
        }
        if (releaseBoth || releaseLabel && (labelIsLeft || labelIsRight) || releaseHelp && (helpIsLeft || helpIsRight)) {
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _CONTENT_SUFFIX + CONNECTOR_H + _RELEASED_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
        } else {
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _CONTENT_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
        }
        if (component.getChildCount() > 0) {
            this.writeContent(context, component, errorOnPage, parentStyleClass);
        }
        writer.endElement(TD);
        writer.writeText((Object)CR, null);
        if (releaseLabel && labelIsLeft || releaseHelp && helpIsLeft) {
            this.endNestedTable(writer);
        }
        if (labelIsRight || helpIsRight) {
            this.writeLabelOrHelperCells(context, component, label, errorOnPage, childErrorMessage, labelIsRight, helpIsRight, LABEL_CELL);
            if (releaseLabel && labelIsRight) {
                this.endNestedTable(writer);
            }
            this.writeLabelOrHelperCells(context, component, label, errorOnPage, childErrorMessage, labelIsRight, helpIsRight, HELP_CELL);
        }
        if (releaseHelp && helpIsRight) {
            this.endNestedTable(writer);
        }
        if (labelIsUnder || helpIsUnder) {
            writer.endElement(TR);
            writer.writeText((Object)CR, null);
            writer.startElement(TR, null);
            if (labelIsLeft || helpIsLeft) {
                writer.startElement(TD, null);
                writer.endElement(TD);
            }
            this.writeLabelOrHelperCells(context, component, label, errorOnPage, childErrorMessage, labelIsUnder, helpIsUnder, labelIsRight || helpIsRight ? SINGLE_CELL_WITH_JOINED_CELL : SINGLE_CELL);
        }
        if (releaseBoth && (labelIsLeft || labelIsRight || helpIsLeft || helpIsRight)) {
            this.endNestedTable(writer);
        }
    }

    private void encodeCorrectMessage(FacesContext context, UIComponent component, boolean showInfoText, boolean showErrorText, boolean errorOnPage, Object childErrorMessage, String parentStyleClass) throws IOException {
        HtmlFormItem formItem = (HtmlFormItem)component;
        String spanInfoId = formItem.getInfoSpanId(context);
        String spanErrorId = formItem.getErrorSpanId(context);
        ResponseWriter writer = context.getResponseWriter();
        if (showInfoText) {
            writer.startElement(SPAN, null);
            writer.writeAttribute(ID, (Object)spanInfoId, ID);
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _INFO_SUFFIX), CLASS);
            if (errorOnPage || AS_NEEDED.equals(formItem.getShowHelp())) {
                writer.writeAttribute(STYLE, (Object)DISPLAY_NONE, STYLE);
            }
            if (formItem.getInfoText() != null) {
                if (formItem.isEscape()) {
                    writer.writeText((Object)formItem.getInfoText(), null);
                } else {
                    writer.write(formItem.getInfoText());
                }
            }
            writer.endElement(SPAN);
            writer.writeText((Object)CR, null);
        }
        if (showErrorText) {
            writer.startElement(SPAN, null);
            writer.writeAttribute(ID, (Object)spanErrorId, ID);
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _ERROR_SUFFIX), CLASS);
            if (!errorOnPage) {
                writer.writeAttribute(STYLE, (Object)DISPLAY_NONE, STYLE);
            }
            if (formItem.getErrorText() != null) {
                if (formItem.isEscape()) {
                    writer.writeText((Object)formItem.getErrorText(), null);
                } else {
                    writer.write(formItem.getErrorText());
                }
            } else if (childErrorMessage != null) {
                writer.writeText(childErrorMessage, null);
            }
            writer.endElement(SPAN);
            writer.writeText((Object)CR, null);
        }
    }

    private void addClientValidatorParameters(FacesContext context, UIComponent component, StringBuffer script, String styleClassFamily, ScriptObject converter, ScriptObject validator, boolean required) {
        String errorSpanAlways;
        String infoSpanAlways;
        String spanIsPopup;
        String errorSpanId;
        String infoSpanId;
        HtmlFormItem formItem = (HtmlFormItem)component;
        String classSuffix = "";
        if (formItem.getStyleClass() != null && formItem.getStyleClass().trim().length() > 0) {
            classSuffix = SPACER + formItem.getStyleClass();
        }
        if (required) {
            script.append("\"label-success-class:" + styleClassFamily + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _REQUIRED_SUFFIX + classSuffix + "\"");
        } else {
            script.append("\"label-success-class:" + styleClassFamily + CONNECTOR_U + _LABEL_SUFFIX + classSuffix + "\"");
        }
        if (required) {
            script.append(", \"label-error-class:" + styleClassFamily + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _REQUIRED_SUFFIX + CONNECTOR_H + _ERROR_SUFFIX + classSuffix + "\"");
        } else {
            script.append(", \"label-error-class:" + styleClassFamily + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _ERROR_SUFFIX + classSuffix + "\"");
        }
        String labelSpanId = formItem.getLabelId(context);
        if (labelSpanId != null) {
            script.append(", \"label-id:" + labelSpanId + "\"");
        }
        if ((infoSpanId = formItem.getInfoSpanId(context)) != null) {
            script.append(", \"info-span-id:" + infoSpanId + "\"");
        }
        if ((errorSpanId = formItem.getErrorSpanId(context)) != null) {
            script.append(", \"error-span-id:" + errorSpanId + "\"");
        }
        if ((spanIsPopup = formItem.getSpanIsPopup()) != null) {
            script.append(", \"span-is-popup:" + spanIsPopup + "\"");
        }
        if ((infoSpanAlways = formItem.getInfoSpanAlways()) != null) {
            script.append(", \"info-span-always:" + infoSpanAlways + "\"");
        }
        if ((errorSpanAlways = formItem.getErrorSpanAlways()) != null) {
            script.append(", \"error-span-always:" + errorSpanAlways + "\"");
        }
        if (converter != null) {
            script.append(", \"converter:" + converter.getId() + "\"");
        }
        if (validator != null) {
            script.append(", \"validator:" + validator.getId() + "\"");
        }
    }

    private void addClientEventCode(FacesContext context, UIComponent component, StringBuffer script, String editableValueHolderId, String eventName, String styleClassFamily, ScriptObject converter, ScriptObject validator, boolean required) {
        script.append("if (hX_6.getBehaviorById(\"" + editableValueHolderId + "\", \"validate\", \"" + eventName + "\")==null) ");
        script.append("\n\t");
        script.append("hX_6.addBehavior(\"" + editableValueHolderId + "\", \"" + eventName + "\", new " + "hX_6" + ".JSFBehaviorValidate(");
        this.addClientValidatorParameters(context, component, script, styleClassFamily, converter, validator, required);
        script.append("));");
        script.append(CR);
        script.append("else ");
        script.append("\t");
        script.append("hX_6.getBehaviorById(\"" + editableValueHolderId + "\", \"validate\", \"" + eventName + "\").setAttribute(");
        this.addClientValidatorParameters(context, component, script, styleClassFamily, converter, validator, required);
        script.append(");");
        script.append(CR);
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
        UIComponent child = (UIComponent)component.getChildren().get(0);
        boolean required = child instanceof UIInput && ((UIInput)child).isRequired();
        String editableValueHolderId = child.getClientId(context);
        String styleClassFamily = ((HtmlPanelFormBox)component.getParent()).getStyleClass();
        if (styleClassFamily != null && styleClassFamily.indexOf(SPACER) != -1) {
            styleClassFamily = styleClassFamily.substring(0, styleClassFamily.indexOf(SPACER)).trim();
        }
        StringBuffer javaScript = new StringBuffer();
        ScriptObject converter = null;
        ScriptObject validator = null;
        if (child instanceof UIInput && this.needValidator(context, (UIInput)child)) {
            converter = AssistRenderer.getConverterScript(context, (UIInput)child);
            validator = AssistRenderer.getValidatorScript(context, (UIInput)child, converter);
        }
        this.addClientEventCode(context, component, javaScript, editableValueHolderId, "onfocus", styleClassFamily, converter, validator, required);
        this.addClientEventCode(context, component, javaScript, editableValueHolderId, "onblur", styleClassFamily, converter, validator, required);
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        if (null != converter) {
            scriptCollector.writeScriptOnce(converter.getScript(), context, false);
        }
        if (null != validator) {
            scriptCollector.writeScriptOnce(validator.getScript(), context, false);
        }
        scriptCollector.addScript(javaScript.toString());
        javaScript = null;
    }

    private void writeLabel(FacesContext context, UIComponent component, HtmlOutputLabel label) throws IOException {
        HtmlFormItem formItem = (HtmlFormItem)component;
        ResponseWriter writer = context.getResponseWriter();
        boolean escape = formItem.isEscape();
        String labelId = formItem.getLabelId(context);
        writer.startElement(LABEL, (UIComponent)label);
        writer.writeAttribute(ID, (Object)labelId, ID);
        if (label.getFor() != null) {
            writer.writeAttribute(FOR, (Object)label.getFor(), FOR);
        }
        if (label.getStyleClass() != null) {
            writer.writeAttribute(CLASS, (Object)label.getStyleClass(), CLASS);
        }
        if (label.getAccesskey() != null) {
            writer.writeAttribute(ACCESSKEY, (Object)label.getAccesskey(), ACCESSKEY);
        }
        if (label.getStyle() != null) {
            writer.writeAttribute(STYLE, (Object)label.getStyle(), STYLE);
        }
        if (label.getTitle() != null) {
            writer.writeAttribute(TITLE, (Object)label.getTitle(), TITLE);
        }
        if (label.getValue() != null) {
            if (escape) {
                writer.writeText(label.getValue(), VALUE);
            } else {
                writer.write(label.getValue().toString());
            }
        }
        writer.endElement(LABEL);
        writer.writeText((Object)CR, null);
    }

    private void writeContent(FacesContext context, UIComponent component, boolean errorOnPage, String parentStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(DIV, null);
        writer.writeAttribute(ID, (Object)(component.getClientId(context) + _CONTENT_SUFFIX.toLowerCase()), ID);
        if (errorOnPage) {
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _CONTENT_SUFFIX + CONNECTOR_H + _ERROR_SUFFIX), CLASS);
        } else {
            writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _CONTENT_SUFFIX), CLASS);
        }
        writer.writeText((Object)CR, null);
        Utils.encodeChildren(context, component);
        writer.endElement(DIV);
        writer.writeText((Object)CR, null);
    }

    private void writeLabelOrHelperCells(FacesContext context, UIComponent component, HtmlOutputLabel label, boolean errorOnPage, String childErrorMessage, boolean hasLabel, boolean hasHelp, int type) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        HtmlFormItem formItem = (HtmlFormItem)component;
        String showHelp = formItem.getShowHelp();
        boolean showErrorText = showHelp == null || showHelp.equals(ALWAYS) || showHelp.equals(ERROR) || showHelp.equals(AS_NEEDED);
        boolean showInfoText = showHelp == null || showHelp.equals(ALWAYS) || showHelp.equals(INFO) || showHelp.equals(AS_NEEDED);
        HtmlPanelFormBox formBox = (HtmlPanelFormBox)component.getParent();
        String parentStyleClass = formBox.getStyleClass();
        if (parentStyleClass != null && parentStyleClass.indexOf(SPACER) != -1) {
            parentStyleClass = parentStyleClass.substring(0, parentStyleClass.indexOf(SPACER)).trim();
        }
        String widthHelp = formBox.getWidthHelp();
        String widthLabel = formBox.getWidthLabel();
        String releaseMargin = formItem.getReleaseMargin();
        if (type == SINGLE_CELL || type == SINGLE_CELL_WITH_JOINED_CELL) {
            writer.startElement(TD, null);
            boolean release = BOTH.equals(releaseMargin);
            if (hasLabel && widthLabel != null && !release) {
                writer.writeAttribute(WIDTH, (Object)widthLabel, WIDTH);
            } else if (hasHelp && widthHelp != null && !release) {
                writer.writeAttribute(WIDTH, (Object)widthHelp, WIDTH);
            }
            String labelClass = parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _CELL_SUFFIX;
            String helpClass = parentStyleClass + CONNECTOR_U + _HELP_SUFFIX + CONNECTOR_H + _CELL_SUFFIX;
            if (release) {
                labelClass = parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _RELEASED_SUFFIX + CONNECTOR_H + _CELL_SUFFIX;
                helpClass = parentStyleClass + CONNECTOR_U + _HELP_SUFFIX + CONNECTOR_H + _RELEASED_SUFFIX + CONNECTOR_H + _CELL_SUFFIX;
            }
            if (hasLabel && hasHelp) {
                writer.writeAttribute(CLASS, (Object)(labelClass + SPACER + helpClass), CLASS);
            } else if (hasLabel) {
                writer.writeAttribute(CLASS, (Object)labelClass, CLASS);
            } else {
                writer.writeAttribute(CLASS, (Object)helpClass, CLASS);
            }
            if (type == SINGLE_CELL_WITH_JOINED_CELL) {
                writer.writeAttribute(COLSPAN, (Object)new Integer(2).toString(), COLSPAN);
            }
            writer.writeText((Object)CR, null);
            if (hasLabel) {
                this.writeLabel(context, component, label);
            }
            if (hasHelp) {
                this.encodeCorrectMessage(context, component, showInfoText, showErrorText, errorOnPage, childErrorMessage, parentStyleClass);
            }
            writer.endElement(TD);
            writer.writeText((Object)CR, null);
        } else if (type == LABEL_CELL) {
            boolean releaseLabel;
            boolean bl = releaseLabel = LABEL.equals(releaseMargin) || BOTH.equals(releaseMargin);
            if (hasLabel) {
                writer.startElement(TD, null);
                if (widthLabel != null && !releaseLabel) {
                    writer.writeAttribute(WIDTH, (Object)widthLabel, WIDTH);
                }
                if (releaseLabel) {
                    writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _RELEASED_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
                } else {
                    writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _LABEL_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
                }
                writer.writeText((Object)CR, null);
                this.writeLabel(context, component, label);
                writer.endElement(TD);
                writer.writeText((Object)CR, null);
            }
        } else if (type == HELP_CELL) {
            boolean releaseHelp;
            boolean bl = releaseHelp = HELP.equals(releaseMargin) || BOTH.equals(releaseMargin);
            if (hasHelp) {
                writer.startElement(TD, null);
                if (widthHelp != null && !releaseHelp) {
                    writer.writeAttribute(WIDTH, (Object)widthHelp, WIDTH);
                }
                if (releaseHelp) {
                    writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _HELP_SUFFIX + CONNECTOR_H + _RELEASED_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
                } else {
                    writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _HELP_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
                }
                writer.writeText((Object)CR, null);
                this.encodeCorrectMessage(context, component, showInfoText, showErrorText, errorOnPage, childErrorMessage, parentStyleClass);
                writer.endElement(TD);
                writer.writeText((Object)CR, null);
            }
        }
    }

    private void startNestedTable(ResponseWriter writer, String parentStyleClass, int span) throws IOException {
        writer.startElement(TD, null);
        if (span > 1) {
            writer.writeAttribute(COLSPAN, (Object)new Integer(span).toString(), COLSPAN);
        }
        writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _RELEASED_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
        writer.writeText((Object)CR, null);
        writer.startElement(TABLE, null);
        writer.writeAttribute(CLASS, (Object)(parentStyleClass + CONNECTOR_U + _RELEASED_SUFFIX), CLASS);
        writer.startElement(TR, null);
    }

    private void endNestedTable(ResponseWriter writer) throws IOException {
        writer.endElement(TR);
        writer.endElement(TABLE);
        writer.endElement(TD);
        writer.writeText((Object)CR, null);
    }

    protected boolean needValidator(FacesContext context, UIInput input) {
        Iterator iter = input.getChildren().iterator();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            if (!(child instanceof HtmlInputHelperAssist)) continue;
            return false;
        }
        return true;
    }
}

