/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.UIFormItem;
import com.ibm.faces.component.html.HtmlPanelFormBox;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class FormBoxRenderer
extends Renderer {
    private static final String TR = "tr";
    private static final String TD = "td";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private static final String TABLE = "table";
    private static final String CELLSPACING = "cellspacing";
    private static final String CELLPADDING = "cellpadding";
    private static final String CLASS = "class";
    private static final String CRLF = "\n";
    private static final String ID = "id";
    private static final String COLSPAN = "colspan";
    private static final String ROWSPAN = "rowspan";
    private static final String STYLE = "style";
    private static final String LABEL = "label";
    private static final String _HEADER_SUFFIX = "Header";
    private static final String _OTHER_SUFFIX = "Other";
    private static final String _CELL_SUFFIX = "Cell";
    private static final String _TOP_SUFFIX = "Top";
    private static final String _BOTTOM_SUFFIX = "Bottom";
    private static final String _LEFT_SUFFIX = "Left";
    private static final String _RIGHT_SUFFIX = "Right";
    private static final String _SPACER_SUFFIX = "Spacer";
    private static final String CONNECTOR_U = "_";
    private static final String CONNECTOR_H = "-";
    private static final String BOTTOM = "bottom";
    private static final String TOP = "top";
    private static final String OVER = "over";
    private static final String VALUE = "value";
    private static final String FOR = "for";
    private static final String UNDER = "under";
    private static final String TITLE = "title";
    private static final String SPACER_STYLE = "font-family:sans-serif; font-size:";
    private static final String NBSP = Character.toString('\u00a0');

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HxClientRenderUtil.initJSLibraries(component, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_be.js", component);
        ResponseWriter writer = context.getResponseWriter();
        HtmlPanelFormBox formBox = (HtmlPanelFormBox)component;
        String styleClass = this.getStyleClass(component);
        String style = formBox.getStyle();
        String title = formBox.getTitle();
        String labelPosition = formBox.getLabelPosition();
        String helpPosition = formBox.getHelpPosition();
        int numCols = this.getColumnCount(component);
        writer.startElement(TABLE, null);
        if (formBox.getId() != null) {
            writer.writeAttribute(ID, (Object)formBox.getClientId(context), ID);
        }
        writer.writeAttribute(CELLSPACING, (Object)new Integer(0), CELLSPACING);
        writer.writeAttribute(CELLPADDING, (Object)new Integer(0), CELLPADDING);
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute(CLASS, (Object)formBox.getStyleClass(), CLASS);
        }
        if (style != null && style.length() > 0) {
            writer.writeAttribute(STYLE, (Object)style, STYLE);
        }
        if (title != null && title.length() > 0) {
            writer.writeAttribute(TITLE, (Object)title, TITLE);
        }
        writer.writeText((Object)CRLF, null);
        if (formBox.getLabel() != null) {
            HtmlOutputLabel label = new HtmlOutputLabel();
            label.setValue((Object)formBox.getLabel());
            label.setFor(formBox.getClientId(context));
            label.setStyleClass(styleClass + CONNECTOR_U + _HEADER_SUFFIX);
            writer.startElement(TR, null);
            writer.writeText((Object)CRLF, null);
            writer.startElement(TD, null);
            writer.writeAttribute(COLSPAN, (Object)new Integer(numCols).toString(), COLSPAN);
            writer.writeAttribute(CLASS, (Object)label.getStyleClass(), CLASS);
            writer.writeText((Object)CRLF, null);
            writer.startElement(LABEL, (UIComponent)label);
            writer.writeAttribute(FOR, (Object)label.getFor(), FOR);
            if (formBox.isEscape()) {
                writer.writeText(label.getValue(), VALUE);
            } else {
                writer.write(label.getValue().toString());
            }
            writer.endElement(LABEL);
            writer.writeText((Object)CRLF, null);
            writer.endElement(TD);
            writer.endElement(TR);
            writer.writeText((Object)CRLF, null);
        }
        if (component.getFacet(TOP) != null) {
            writer.startElement(TR, null);
            writer.writeText((Object)CRLF, null);
            writer.startElement(TD, null);
            writer.writeAttribute(COLSPAN, (Object)new Integer(numCols).toString(), COLSPAN);
            writer.writeAttribute(CLASS, (Object)(styleClass + CONNECTOR_U + _TOP_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
            writer.writeText((Object)CRLF, null);
            this.encodeRecursive(context, component.getFacet(TOP));
            writer.endElement(TD);
            writer.writeText((Object)CRLF, null);
            writer.endElement(TR);
            writer.writeText((Object)CRLF, null);
        }
        int numRows = 2;
        if (OVER.equals(labelPosition) || OVER.equals(helpPosition) || labelPosition == null || helpPosition == null) {
            ++numRows;
        }
        if (UNDER.equals(labelPosition) || UNDER.equals(helpPosition)) {
            ++numRows;
        }
        numRows *= component.getChildCount();
        if (component.getFacet(LEFT) != null) {
            writer.startElement(TR, null);
            writer.writeText((Object)CRLF, null);
            writer.startElement(TD, null);
            writer.writeAttribute(ROWSPAN, (Object)new Integer(numRows + 1).toString(), ROWSPAN);
            writer.writeAttribute(CLASS, (Object)(styleClass + CONNECTOR_U + _LEFT_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
            writer.writeText((Object)CRLF, null);
            this.encodeRecursive(context, component.getFacet(LEFT));
            writer.endElement(TD);
            writer.writeText((Object)CRLF, null);
        } else {
            writer.startElement(TR, null);
            writer.writeText((Object)CRLF, null);
        }
        writer.startElement(TD, null);
        writer.writeAttribute(COLSPAN, (Object)new Integer(this.getColumnSpacerCount(component)).toString(), COLSPAN);
        writer.writeAttribute(CLASS, (Object)(styleClass + CONNECTOR_U + _SPACER_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
        if (((HtmlPanelFormBox)component).getInterItemSpacing() != null) {
            writer.writeAttribute(STYLE, (Object)(SPACER_STYLE + ((HtmlPanelFormBox)component).getInterItemSpacing()), STYLE);
        }
        writer.writeText((Object)NBSP, null);
        writer.endElement(TD);
        if (component.getFacet(RIGHT) != null) {
            writer.writeText((Object)CRLF, null);
            writer.startElement(TD, null);
            writer.writeAttribute(ROWSPAN, (Object)new Integer(numRows + 1).toString(), ROWSPAN);
            writer.writeAttribute(CLASS, (Object)(styleClass + CONNECTOR_U + _RIGHT_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
            writer.writeText((Object)CRLF, null);
            this.encodeRecursive(context, component.getFacet(RIGHT));
            writer.endElement(TD);
            writer.writeText((Object)CRLF, null);
        }
        writer.endElement(TR);
        writer.writeText((Object)CRLF, null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        int numColSpacer = this.getColumnCount(component);
        if (component.getFacet(LEFT) != null) {
            --numColSpacer;
        }
        if (component.getFacet(RIGHT) != null) {
            --numColSpacer;
        }
        Iterator i = component.getChildren().iterator();
        String styleClass = this.getStyleClass(component);
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (!child.isRendered()) continue;
            writer.startElement(TR, null);
            writer.writeText((Object)CRLF, null);
            if (child instanceof UIFormItem) {
                this.encodeRecursive(context, child);
            } else {
                writer.startElement(TD, null);
                writer.writeAttribute(COLSPAN, (Object)new Integer(numColSpacer).toString(), COLSPAN);
                writer.writeAttribute(CLASS, (Object)(styleClass + CONNECTOR_U + _OTHER_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
                this.encodeRecursive(context, child);
                writer.endElement(TD);
                writer.writeText((Object)CRLF, null);
            }
            writer.endElement(TR);
            writer.writeText((Object)CRLF, null);
            writer.startElement(TR, null);
            writer.startElement(TD, null);
            writer.writeAttribute(COLSPAN, (Object)new Integer(numColSpacer).toString(), COLSPAN);
            writer.writeAttribute(CLASS, (Object)(styleClass + CONNECTOR_U + _SPACER_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
            if (((HtmlPanelFormBox)component).getInterItemSpacing() != null) {
                writer.writeAttribute(STYLE, (Object)(SPACER_STYLE + ((HtmlPanelFormBox)component).getInterItemSpacing()), STYLE);
            }
            writer.writeText((Object)NBSP, null);
            writer.endElement(TD);
            writer.endElement(TR);
            writer.writeText((Object)CRLF, null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        if (component.getFacet(BOTTOM) != null) {
            writer.startElement(TR, null);
            writer.writeText((Object)CRLF, null);
            writer.startElement(TD, null);
            writer.writeAttribute(COLSPAN, (Object)new Integer(this.getColumnCount(component)).toString(), COLSPAN);
            writer.writeAttribute(CLASS, (Object)(this.getStyleClass(component) + CONNECTOR_U + _BOTTOM_SUFFIX + CONNECTOR_H + _CELL_SUFFIX), CLASS);
            writer.writeText((Object)CRLF, null);
            this.encodeRecursive(context, component.getFacet(BOTTOM));
            writer.endElement(TD);
            writer.writeText((Object)CRLF, null);
            writer.endElement(TR);
            writer.writeText((Object)CRLF, null);
        }
        writer.endElement(TABLE);
        writer.writeText((Object)CRLF, null);
    }

    public void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator i = component.getChildren().iterator();
            while (i.hasNext()) {
                UIComponent child = (UIComponent)i.next();
                this.encodeRecursive(context, child);
            }
        }
        component.encodeEnd(context);
    }

    private String getStyleClass(UIComponent component) {
        HtmlPanelFormBox formBox = (HtmlPanelFormBox)component;
        String styleClass = formBox.getStyleClass();
        if (styleClass != null && styleClass.indexOf(" ") != -1) {
            styleClass = styleClass.substring(0, styleClass.indexOf(" "));
        }
        return styleClass;
    }

    private int getColumnCount(UIComponent component) {
        int numCols = this.getColumnSpacerCount(component);
        if (component.getFacet(LEFT) != null) {
            ++numCols;
        }
        if (component.getFacet(RIGHT) != null) {
            ++numCols;
        }
        return numCols;
    }

    private int getColumnSpacerCount(UIComponent component) {
        int numCols = 1;
        HtmlPanelFormBox formBox = (HtmlPanelFormBox)component;
        String labelPosition = formBox.getLabelPosition();
        String helpPosition = formBox.getHelpPosition();
        if (labelPosition != null && (labelPosition.equals(RIGHT) || labelPosition.equals(LEFT))) {
            ++numCols;
        }
        if (helpPosition != null && (helpPosition.equals(RIGHT) || helpPosition.equals(LEFT))) {
            ++numCols;
        }
        return numCols;
    }
}

