/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputHelperDatePicker;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import com.ibm.faces.util.ScriptObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.render.Renderer;

public class DatePickerRenderer
extends Renderer
implements IScriptContributor {
    private static final String DEFAULT_BUTTON_BORDER = "-1";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIComponent parent = component.getParent();
        if (parent == null || !(parent instanceof UIInput)) {
            return;
        }
        HxClientRenderUtil.addScriptLibrary("hxclient_dp.js", component);
        HxClientRenderUtil.addScriptLibrary("hxclient_sp.js", component);
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        UIInput input = (UIInput)component.getParent();
        DateTimeConverter dtConverter = (DateTimeConverter)input.getConverter();
        if (dtConverter != null) {
            Locale locale = dtConverter.getLocale();
            HxClientRenderUtil.addLocalizedStringLibraryIfNeeded(locale.toString(), component);
        }
        if (HxClientRenderUtil.isContainedInPanel(component.getParent())) {
            this.encode(context, component, false);
        } else {
            scriptCollector.register(this, component);
        }
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
        this.encode(context, component, true);
    }

    private void encode(FacesContext context, UIComponent component, boolean writeNow) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        UIInput input = (UIInput)component.getParent();
        DateTimeConverter dtConverter = (DateTimeConverter)input.getConverter();
        if (dtConverter == null) {
            ResourceBundle rb = ResourceHandler.getBundle(context);
            throw new FacesException(ResourceHandler.getString(rb, "DatePickerNoConveterFoundError"));
        }
        ScriptObject converterScript = HxClientRenderUtil.buildJsDateConverter(context, dtConverter);
        ScriptObject validatorScript = null;
        if (null != converterScript) {
            validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, (Converter)dtConverter, HxClientRenderUtil.getRangeValidator(input), input.isRequired(), HxClientRenderUtil.getExpressionValidator(input), null);
        }
        String assistScript = null;
        assistScript = dtConverter.getType().indexOf("date") != -1 ? this.getDatePickerScript(context, component, dtConverter.getLocale(), converterScript != null ? converterScript.getId() : null, validatorScript != null ? validatorScript.getId() : null) : this.getTimePickerScript(context, component, converterScript != null ? converterScript.getId() : null, validatorScript != null ? validatorScript.getId() : null);
        if (writeNow) {
            ResponseWriter writer = context.getResponseWriter();
            if (null != converterScript) {
                scriptCollector.writeScriptOnce(converterScript.getScript(), context, false);
            }
            if (null != validatorScript) {
                scriptCollector.writeScriptOnce(validatorScript.getScript(), context, false);
            }
            if (null != assistScript) {
                writer.write("\n");
                writer.write(assistScript);
            }
        } else {
            if (null != converterScript) {
                scriptCollector.addScriptOnce(converterScript.getScript());
            }
            if (null != validatorScript) {
                scriptCollector.addScriptOnce(validatorScript.getScript());
            }
            if (null != assistScript) {
                scriptCollector.addScript(assistScript);
            }
        }
    }

    private String getDatePickerScript(FacesContext context, UIComponent component, Locale converterLocale, String converterId, String validatorId) {
        String sBtnColor;
        String sCSSPrefix;
        String buttonBorder;
        String firstDay;
        String sRequired = null;
        UIInput input = null;
        HtmlInputHelperDatePicker dateComponent = null;
        if (component instanceof HtmlInputHelperDatePicker) {
            dateComponent = (HtmlInputHelperDatePicker)component;
        }
        Locale locale = converterLocale == null ? context.getViewRoot().getLocale() : converterLocale;
        Calendar cal = Calendar.getInstance(locale);
        int DefaultFirstDay = cal.getFirstDayOfWeek();
        --DefaultFirstDay;
        UIComponent parent = component.getParent();
        if (parent == null || !(parent instanceof UIInput)) {
            return "";
        }
        input = (UIInput)parent;
        Boolean bRequired = (Boolean)input.getAttributes().get("required");
        if (bRequired.booleanValue()) {
            sRequired = "true";
        }
        if (dateComponent != null) {
            firstDay = dateComponent.getFirstDay();
            buttonBorder = dateComponent.getButtonBorder();
        } else {
            firstDay = (String)component.getAttributes().get("firstDay");
            buttonBorder = (String)component.getAttributes().get("buttonBorder");
        }
        String sFirstDay = this.getNumericAttribute(firstDay, "first-day-of-week:", new Integer(DefaultFirstDay).toString(), new Integer(0), new Integer(6));
        String sBtnBorder = this.getNumericAttribute(buttonBorder, "button-border:", DEFAULT_BUTTON_BORDER, new Integer(-1), new Integer(3));
        if (dateComponent != null) {
            sCSSPrefix = dateComponent.getStyleClass();
            sBtnColor = dateComponent.getButtonColor();
        } else {
            sCSSPrefix = (String)component.getAttributes().get("styleClass");
            sBtnColor = (String)component.getAttributes().get("buttonColor");
        }
        StringBuffer script = new StringBuffer("hX_6").append(".addComponent(\"").append(parent.getClientId(context)).append("\", new ").append("hX_6").append(".JSFDatePicker(");
        if (null != converterId) {
            script.append("\"converter:");
            script.append(converterId);
            script.append('\"');
        }
        if (null != validatorId) {
            script.append(", \"");
            script.append("validator:");
            script.append(validatorId);
            script.append('\"');
        }
        if (sCSSPrefix != null && sCSSPrefix != "") {
            script.append(", \"css-prefix:");
            script.append(Utils.getFirstCSSClassName(sCSSPrefix));
            script.append('\"');
        }
        if (sBtnColor != null && sBtnColor != "") {
            script.append(", \"button-color:");
            script.append(sBtnColor);
            script.append('\"');
        }
        if (sRequired != null && sRequired != "") {
            script.append(", \"required:");
            script.append(sRequired);
            script.append('\"');
        }
        boolean multiLine = true;
        Object ml = component.getAttributes().get("multiLine");
        if (ml != null && ml instanceof String && "false".equalsIgnoreCase(ml.toString())) {
            multiLine = true;
        }
        if (ml != null && ml instanceof Boolean) {
            multiLine = (Boolean)ml;
        }
        if (multiLine) {
            script.append(", \"multi-line:");
            script.append("true");
            script.append('\"');
        } else {
            script.append(", \"multi-line:");
            script.append("false");
            script.append('\"');
        }
        script.append(", \"");
        script.append(sFirstDay);
        script.append('\"');
        script.append(", \"");
        script.append(sBtnBorder);
        script.append('\"');
        script.append("));");
        return script.toString();
    }

    private String getNumericAttribute(String sValue, String sAttOutName, String DefaultValue, Integer MinValue, Integer MaxValue) {
        if (sValue == null || sValue == "") {
            sValue = DefaultValue;
        } else {
            try {
                int iValue = Integer.parseInt(sValue);
                if (MinValue != null && iValue < MinValue) {
                    sValue = DefaultValue;
                } else if (MaxValue != null && iValue > MaxValue) {
                    sValue = DefaultValue;
                }
            }
            catch (NumberFormatException e) {
                sValue = DefaultValue;
            }
        }
        sValue = sAttOutName + sValue;
        return sValue;
    }

    private String getTimePickerScript(FacesContext context, UIComponent component, String converterId, String validatorId) {
        HtmlInputHelperDatePicker dateComponent = null;
        if (component instanceof HtmlInputHelperDatePicker) {
            dateComponent = (HtmlInputHelperDatePicker)component;
        }
        Boolean HMS_individual = dateComponent != null ? new Boolean(dateComponent.isPositional()) : (Boolean)component.getAttributes().get("positional");
        StringBuffer script = new StringBuffer("hX_6");
        script.append(".addComponent(\"");
        script.append(component.getParent().getClientId(context));
        script.append("\", new ");
        script.append("hX_6");
        script.append(".JSFSpinner(\"type:datetime\"");
        if (HMS_individual.booleanValue()) {
            int delta_num;
            String delta_secs_str;
            String delta_minutes_str;
            String delta_hours_str;
            if (dateComponent != null) {
                delta_hours_str = dateComponent.getDeltaHours();
                delta_minutes_str = dateComponent.getDeltaMinutes();
                delta_secs_str = dateComponent.getDeltaSeconds();
            } else {
                delta_hours_str = (String)component.getAttributes().get("deltaHours");
                delta_minutes_str = (String)component.getAttributes().get("deltaMinutes");
                delta_secs_str = (String)component.getAttributes().get("deltaSeconds");
            }
            if (delta_hours_str != null) {
                try {
                    delta_num = Integer.parseInt(delta_hours_str);
                }
                catch (NumberFormatException nfe) {
                    delta_num = 1;
                }
                int delta_hours = delta_num * 3600;
                script.append(", \"increment:");
                script.append(delta_hours + "\"");
            } else {
                script.append(", \"increment:3600\"");
            }
            if (delta_minutes_str != null) {
                try {
                    delta_num = Integer.parseInt(delta_minutes_str);
                }
                catch (NumberFormatException nfe) {
                    delta_num = 1;
                }
                int delta_minutes = delta_num * 60;
                script.append(", \"increment1:");
                script.append(delta_minutes + "\"");
            } else {
                script.append(", \"increment1:");
                script.append("60\"");
            }
            if (delta_secs_str != null) {
                int delta_secs;
                try {
                    delta_secs = Integer.parseInt(delta_secs_str);
                }
                catch (NumberFormatException nfe) {
                    delta_secs = 1;
                }
                script.append(", \"increment2:");
                script.append(delta_secs + "\"");
            } else {
                script.append(", \"increment2:");
                script.append("1\"");
            }
        } else {
            String delta = dateComponent != null ? dateComponent.getDelta() : (String)component.getAttributes().get("delta");
            if (delta == null) {
                delta = "1800";
            }
            script.append(", \"increment:" + delta);
            script.append('\"');
        }
        if (converterId != null) {
            script.append(",\"converter:");
            script.append(converterId);
            script.append('\"');
        }
        if (validatorId != null) {
            script.append(",\"validator:");
            script.append(validatorId);
            script.append('\"');
        }
        script.append("));");
        return script.toString();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

