/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputHelperAssist;
import com.ibm.faces.converter.MaskConverter;
import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.faces.converter.NumberConverterExICU;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.ScriptObject;
import com.ibm.faces.validator.ConstraintValidator;
import com.ibm.faces.validator.ExpressionValidator;
import com.ibm.faces.validator.ModulusSelfCheckValidator;
import java.io.IOException;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.render.Renderer;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;

public class AssistRenderer
extends Renderer
implements IScriptContributor {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        BehaviorArgs behavior = new BehaviorArgs(component);
        if (!behavior.isScriptRendered()) {
            return;
        }
        if (!(component.getParent() instanceof UIInput)) {
            return;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        HxClientRenderUtil.addScriptLibrary("hxclient_be.js", component);
        UIInput input = (UIInput)component.getParent();
        Converter converter = input.getConverter();
        if (converter instanceof DateTimeConverter) {
            DateTimeConverter dtConverter = (DateTimeConverter)converter;
            Locale locale = dtConverter.getLocale();
            HxClientRenderUtil.addLocalizedStringLibraryIfNeeded(locale.toString(), component);
        }
        if (HxClientRenderUtil.isContainedInPanel(component.getParent())) {
            this.encode(context, component, behavior, false);
        } else {
            scriptCollector.register(this, component);
        }
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
        BehaviorArgs behavior = new BehaviorArgs(component);
        if (!behavior.isScriptRendered()) {
            return;
        }
        this.encode(context, component, behavior, true);
    }

    private void encode(FacesContext context, UIComponent component, BehaviorArgs behavior, boolean writeNow) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        UIInput input = (UIInput)component.getParent();
        ScriptObject converterScript = null;
        ScriptObject validatorScript = null;
        String maxLength = null;
        if (behavior.getPromptCharacter() == null && (behavior.getAutoTab() != null && behavior.getAutoTab().equalsIgnoreCase("true") && !(input.getConverter() instanceof DateTimeConverter) && !(input.getConverter() instanceof NumberConverterEx) || behavior.getImeMode() != null && (behavior.getImeMode().equalsIgnoreCase("auto") || behavior.getImeMode().equalsIgnoreCase("active")))) {
            if (behavior.getAutoTab() != null && behavior.getAutoTab().equalsIgnoreCase("true")) {
                Validator[] validators = input.getValidators();
                LengthValidator length = null;
                for (int i = 0; i < validators.length; ++i) {
                    Validator validator = validators[i];
                    if (!(validator instanceof LengthValidator)) continue;
                    length = (LengthValidator)validator;
                }
                if (length != null && length.getMaximum() > 0) {
                    maxLength = Integer.toString(length.getMaximum());
                }
            }
        } else {
            Converter converter = input.getConverter();
            if (!(converter instanceof DateTimeConverter || converter instanceof NumberConverterEx || converter instanceof NumberConverterExICU || converter instanceof MaskConverter)) {
                Validator[] validators = input.getValidators();
                LengthValidator length = null;
                for (int i = 0; i < validators.length; ++i) {
                    Validator validator = validators[i];
                    if (!(validator instanceof LengthValidator)) continue;
                    length = (LengthValidator)validator;
                }
                maxLength = null != length && 0 < length.getMaximum() ? Integer.toString(length.getMaximum()) : null;
            }
            converterScript = AssistRenderer.getConverterScript(context, input);
            validatorScript = AssistRenderer.getValidatorScript(context, input, converterScript);
        }
        String assistScript = null;
        String validateScript = null;
        assistScript = this.genAssistBehavior(input.getClientId(context), converterScript, validatorScript, behavior, maxLength, component);
        if (behavior.isValidation) {
            behavior.setDefaultClass((String)input.getAttributes().get("styleClass"));
            validateScript = this.genValidateBehavior(input.getClientId(context), converterScript, validatorScript, behavior, component);
        }
        if (writeNow) {
            ResponseWriter writer = context.getResponseWriter();
            if (null != converterScript) {
                scriptCollector.writeScriptOnce(converterScript.getScript(), context, false);
            }
            if (null != validatorScript) {
                scriptCollector.writeScriptOnce(validatorScript.getScript(), context, false);
            }
            if (null != assistScript) {
                writer.write(10);
                writer.write(assistScript);
            }
            if (null != validateScript) {
                writer.write(10);
                writer.write(validateScript);
            }
        } else {
            if (null != converterScript) {
                scriptCollector.addScriptOnce(converterScript.getScript());
            }
            if (null != validatorScript) {
                scriptCollector.addScriptOnce(validatorScript.getScript());
            }
            if (null != assistScript) {
                scriptCollector.addScript(assistScript);
            }
            if (null != validateScript) {
                scriptCollector.addScript(validateScript);
            }
        }
    }

    protected static ScriptObject getConverterScript(FacesContext context, UIInput input) {
        ScriptObject converterScript = null;
        Converter converter = input.getConverter();
        if (converter instanceof DateTimeConverter) {
            converterScript = HxClientRenderUtil.buildJsDateConverter(context, (DateTimeConverter)converter);
        } else if (converter instanceof NumberConverterEx || converter instanceof NumberConverterExICU) {
            converterScript = HxClientRenderUtil.buildJsNumberConverter(context, (NumberConverterEx)converter);
        } else if (converter instanceof MaskConverter) {
            converterScript = HxClientRenderUtil.buildJsMaskConverter(context, (MaskConverter)converter);
        }
        return converterScript;
    }

    protected static ScriptObject getValidatorScript(FacesContext context, UIInput input, ScriptObject converterScript) {
        ScriptObject validatorScript = null;
        Converter converter = input.getConverter();
        ExpressionValidator expressionValidator = HxClientRenderUtil.getExpressionValidator(input);
        ModulusSelfCheckValidator modulusValidator = HxClientRenderUtil.getModulusValidator(input);
        if (converter instanceof DateTimeConverter) {
            if (null != converterScript) {
                validatorScript = HxClientRenderUtil.buildJsAddDateTimeValidator(context, HxClientRenderUtil.getDateRangeValidator(input), input.isRequired(), expressionValidator);
            }
        } else if (converter instanceof NumberConverterEx || converter instanceof NumberConverterExICU) {
            if (null != converterScript) {
                validatorScript = HxClientRenderUtil.buildJsAddNumberValidator(context, HxClientRenderUtil.getNumberRangeValidator(input), input.isRequired(), expressionValidator, modulusValidator);
            }
        } else if (converter instanceof MaskConverter) {
            if (input.isRequired() || expressionValidator != null) {
                validatorScript = HxClientRenderUtil.buildJsAddStringValidator(context, null, null, null, input.isRequired(), expressionValidator);
            }
        } else {
            Validator[] validators = input.getValidators();
            ConstraintValidator constraint = null;
            LengthValidator length = null;
            for (int i = 0; i < validators.length; ++i) {
                Validator validator = validators[i];
                if (validator instanceof ConstraintValidator) {
                    constraint = (ConstraintValidator)validator;
                }
                if (!(validator instanceof LengthValidator)) continue;
                length = (LengthValidator)validator;
            }
            String regexp = null != constraint ? constraint.getRegex() : null;
            String minLength = null != length && 0 < length.getMinimum() ? Integer.toString(length.getMinimum()) : null;
            String maxLength = null != length && 0 < length.getMaximum() ? Integer.toString(length.getMaximum()) : null;
            validatorScript = null;
            validatorScript = HxClientRenderUtil.buildJsAddStringValidator(context, regexp, minLength, maxLength, input.isRequired(), expressionValidator);
        }
        return validatorScript;
    }

    protected String genAssistBehavior(String scope, ScriptObject converter, ScriptObject validator, BehaviorArgs behavior, String maxLength, UIComponent component) {
        StringBuffer script = new StringBuffer();
        String[] basicArgs = new String[7];
        int iBaseArg = 0;
        String s = null;
        s = behavior.getPromptCharacter();
        if (null != s) {
            if (s.equals("")) {
                s = "default";
            }
            basicArgs[iBaseArg++] = "prompt-char:" + s;
        }
        if (null != (s = behavior.getImeMode())) {
            basicArgs[iBaseArg++] = "ime-mode:" + s;
        }
        if (null != behavior.getAutoSubmit()) {
            UIComponent comp;
            basicArgs[iBaseArg++] = behavior.getAutoSubmit().length() > 0 ? ((comp = component.findComponent(behavior.getAutoSubmit())) != null ? "auto-submit:" + comp.getClientId(FacesContext.getCurrentInstance()) : "auto-submit:" + behavior.getAutoSubmit()) : "auto-submit:";
        }
        if (null != behavior.getAutoTab() && behavior.getAutoTab().equalsIgnoreCase("true")) {
            basicArgs[iBaseArg++] = "auto-tab:" + (maxLength == null ? "0" : maxLength);
        }
        if (iBaseArg == 0) {
            return null;
        }
        if (null != validator) {
            basicArgs[iBaseArg++] = "validator:" + validator.getId();
        }
        if (null != converter) {
            basicArgs[iBaseArg++] = "converter:" + converter.getId();
        }
        if (basicArgs.length > 0) {
            script.append("hX_6").append(".addBehavior(\"").append(scope).append("\", \"oninput\", new ").append("hX_6").append(".JSFBehaviorAssist(\"").append(basicArgs[--iBaseArg]).append('\"');
            while (iBaseArg > 0) {
                script.append(", \"").append(basicArgs[--iBaseArg]).append('\"');
            }
            script.append("));");
        }
        return script.toString();
    }

    protected String genValidateBehavior(String scope, ScriptObject converter, ScriptObject validator, BehaviorArgs behavior, UIComponent component) {
        int argSize;
        StringBuffer script = new StringBuffer();
        String[] blurArgs = new String[11];
        String[] focusArgs = new String[11];
        int iBlurArgs = 0;
        int iFocusArgs = 0;
        String s = null;
        s = behavior.getSuccessAction();
        if (null != s) {
            blurArgs[iBlurArgs++] = "success-action:" + s;
        }
        if (null != (s = behavior.getErrorAction())) {
            blurArgs[iBlurArgs++] = "error-action:" + s;
        }
        if (null != (s = behavior.getSuccessClass())) {
            blurArgs[iBlurArgs++] = "success-class:" + s;
        }
        if (null != (s = behavior.getErrorClass())) {
            blurArgs[iBlurArgs++] = "error-class:" + s;
        }
        if (null != (s = behavior.getOnsuccess())) {
            blurArgs[iBlurArgs++] = "success-function:" + s;
        }
        if (null != (s = behavior.getOnerror())) {
            blurArgs[iBlurArgs++] = "error-function:" + s;
        }
        if (null != (s = behavior.getTargetErrorAction())) {
            s = HxClientRenderUtil.convertComponentIdsToClientIds(s, component);
            blurArgs[iBlurArgs++] = "error-target:" + s;
        }
        if (null != (s = behavior.getTargetSuccessAction())) {
            s = HxClientRenderUtil.convertComponentIdsToClientIds(s, component);
            blurArgs[iBlurArgs++] = "success-target:" + s;
        }
        if (iBlurArgs > 0) {
            if (null != validator) {
                blurArgs[iBlurArgs++] = "validator:" + validator.getId();
            }
            if (null != converter) {
                blurArgs[iBlurArgs++] = "converter:" + converter.getId();
            }
            if (null != (s = behavior.getDefaultClass())) {
                blurArgs[iBlurArgs++] = "default-class:" + s;
            }
            argSize = iBlurArgs--;
            script.append("if (").append("hX_6").append(".getBehaviorById(\"").append(scope).append("\", \"validate\", \"onblur\")==null) \n\t");
            script.append("hX_6").append(".addBehavior(\"").append(scope).append("\", \"onblur\", new ").append("hX_6").append(".JSFBehaviorValidate(\"").append(blurArgs[iBlurArgs]).append('\"');
            while (iBlurArgs > 0) {
                script.append(", \"").append(blurArgs[--iBlurArgs]).append('\"');
            }
            script.append("));");
            iBlurArgs = argSize;
            script.append("\nelse\t");
            script.append("hX_6").append(".getBehaviorById(\"").append(scope).append("\", \"validate\", \"onblur\").setAttribute(\"").append(blurArgs[--iBlurArgs]).append('\"');
            while (iBlurArgs > 0) {
                script.append(", \"").append(blurArgs[--iBlurArgs]).append('\"');
            }
            script.append(");");
        }
        if (null != (s = behavior.getOnfocusSuccessAction())) {
            focusArgs[iFocusArgs++] = "success-action:" + s;
        }
        if (null != (s = behavior.getOnfocusErrorAction())) {
            focusArgs[iFocusArgs++] = "error-action:" + s;
        }
        if (null != (s = behavior.getOnfocusSuccessClass())) {
            focusArgs[iFocusArgs++] = "success-class:" + s;
        }
        if (null != (s = behavior.getOnfocusErrorClass())) {
            focusArgs[iFocusArgs++] = "error-class:" + s;
        }
        if (null != (s = behavior.getOnfocussuccess())) {
            focusArgs[iFocusArgs++] = "success-function:" + s;
        }
        if (null != (s = behavior.getOnfocuserror())) {
            focusArgs[iFocusArgs++] = "error-function:" + s;
        }
        if (null != (s = behavior.getTargetOnfocusErrorAction())) {
            s = HxClientRenderUtil.convertComponentIdsToClientIds(s, component);
            focusArgs[iFocusArgs++] = "error-target:" + s;
        }
        if (null != (s = behavior.getTargetOnfocusSuccessAction())) {
            s = HxClientRenderUtil.convertComponentIdsToClientIds(s, component);
            focusArgs[iFocusArgs++] = "success-target:" + s;
        }
        if (iFocusArgs > 0) {
            if (null != validator) {
                focusArgs[iFocusArgs++] = "validator:" + validator.getId();
            }
            if (null != converter) {
                focusArgs[iFocusArgs++] = "converter:" + converter.getId();
            }
            if (null != (s = behavior.getDefaultClass())) {
                focusArgs[iFocusArgs++] = "default-class:" + s;
            }
            if (script.length() > 0) {
                script.append("\n");
            }
            argSize = iFocusArgs--;
            script.append("if (").append("hX_6").append(".getBehaviorById(\"").append(scope).append("\", \"validate\", \"onfocus\")==null) \n\t");
            script.append("hX_6").append(".addBehavior(\"").append(scope).append("\", \"onfocus\", new ").append("hX_6").append(".JSFBehaviorValidate(\"").append(focusArgs[iFocusArgs]).append('\"');
            while (iFocusArgs > 0) {
                script.append(", \"").append(focusArgs[--iFocusArgs]).append('\"');
            }
            script.append("));");
            iFocusArgs = argSize;
            script.append("\nelse\t");
            script.append("hX_6").append(".getBehaviorById(\"").append(scope).append("\", \"validate\", \"onfocus\").setAttribute(\"").append(focusArgs[--iFocusArgs]).append('\"');
            while (iFocusArgs > 0) {
                script.append(", \"").append(focusArgs[--iFocusArgs]).append('\"');
            }
            script.append(");");
        }
        return script.toString();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    protected class BehaviorArgs {
        boolean scriptRendered = true;
        boolean isValidation = false;
        String defaultClass = null;
        String inputAssist;
        String validation;
        String promptCharacter;
        String autoTab;
        String autoSubmit;
        String imeMode;
        String errorClass;
        String successClass;
        String errorAction;
        String successAction;
        String onerror;
        String onsuccess;
        String onfocuserror;
        String onfocussuccess;
        String onfocusErrorClass;
        String onfocusSuccessClass;
        String onfocusErrorAction;
        String onfocusSuccessAction;
        String targetErrorAction;
        String targetSuccessAction;
        String targetOnfocusErrorAction;
        String targetOnfocusSuccessAction;

        BehaviorArgs(UIComponent component) {
            HtmlInputHelperAssist assistComponent = null;
            if (component instanceof HtmlInputHelperAssist) {
                assistComponent = (HtmlInputHelperAssist)component;
            }
            if (assistComponent != null) {
                this.validation = assistComponent.getValidation();
                if (this.validation != null && this.validation.equalsIgnoreCase("true")) {
                    this.isValidation = true;
                    this.errorClass = assistComponent.getErrorClass();
                    this.successClass = assistComponent.getSuccessClass();
                    this.errorAction = assistComponent.getErrorAction();
                    this.successAction = assistComponent.getSuccessAction();
                    this.onerror = assistComponent.getOnerror();
                    this.onsuccess = assistComponent.getOnsuccess();
                    this.onfocuserror = assistComponent.getOnfocuserror();
                    this.onfocussuccess = assistComponent.getOnfocussuccess();
                    this.onfocusErrorClass = assistComponent.getOnfocusErrorClass();
                    this.onfocusSuccessClass = assistComponent.getOnfocusSuccessClass();
                    this.onfocusErrorAction = assistComponent.getOnfocusErrorAction();
                    this.onfocusSuccessAction = assistComponent.getOnfocusSuccessAction();
                    this.targetErrorAction = assistComponent.getTargetErrorAction();
                    this.targetSuccessAction = assistComponent.getTargetSuccessAction();
                    this.targetOnfocusErrorAction = assistComponent.getTargetOnfocusErrorAction();
                    this.targetOnfocusSuccessAction = assistComponent.getTargetOnfocusSuccessAction();
                }
                this.inputAssist = assistComponent.getInputAssist();
                this.promptCharacter = assistComponent.getPromptCharacter();
                this.autoTab = assistComponent.getAutoTab();
                this.imeMode = assistComponent.getImeMode();
                if (this.isValidation || this.inputAssist != null && this.inputAssist.equalsIgnoreCase("true") || this.promptCharacter != null || this.autoTab != null && this.autoTab.equalsIgnoreCase("true") || this.imeMode != null && (this.imeMode.equalsIgnoreCase("auto") || this.imeMode.equalsIgnoreCase("active"))) {
                    this.setScriptRendered(true);
                    if (null == this.promptCharacter && "true".equalsIgnoreCase(this.inputAssist)) {
                        this.promptCharacter = "";
                    }
                } else {
                    this.setScriptRendered(false);
                }
            } else {
                this.validation = (String)component.getAttributes().get("validation");
                if (null != this.validation) {
                    this.isValidation = true;
                    this.errorClass = (String)component.getAttributes().get("errorClass");
                    this.successClass = (String)component.getAttributes().get("successClass");
                    this.errorAction = (String)component.getAttributes().get("errorAction");
                    this.successAction = (String)component.getAttributes().get("successAction");
                    this.onerror = (String)component.getAttributes().get("onerror");
                    this.onsuccess = (String)component.getAttributes().get("onsuccess");
                    this.onfocuserror = (String)component.getAttributes().get("onfocussrror");
                    this.onfocussuccess = (String)component.getAttributes().get("onfocussuccess");
                    this.onfocusErrorClass = (String)component.getAttributes().get("onfocusErrorClass");
                    this.onfocusSuccessClass = (String)component.getAttributes().get("onfocusSuccessClass");
                    this.onfocusErrorAction = (String)component.getAttributes().get("onfocusErrorAction");
                    this.onfocusSuccessAction = (String)component.getAttributes().get("onfocusSuccessAction");
                    this.targetErrorAction = (String)component.getAttributes().get("targetErrorAction");
                    this.targetSuccessAction = (String)component.getAttributes().get("targetSuccessAction");
                    this.targetOnfocusErrorAction = (String)component.getAttributes().get("targetOnfocusErrorAction");
                    this.targetOnfocusSuccessAction = (String)component.getAttributes().get("targetOnfocusSuccessAction");
                }
                this.inputAssist = (String)component.getAttributes().get("inputAssist");
                this.promptCharacter = (String)component.getAttributes().get("promptCharacter");
                this.autoTab = (String)component.getAttributes().get("autoTab");
                this.imeMode = (String)component.getAttributes().get("imeMode");
                if (this.isValidation || this.inputAssist != null && this.inputAssist.equalsIgnoreCase("true") || this.promptCharacter != null || this.autoTab != null && this.autoTab.equalsIgnoreCase("true") || this.imeMode != null && (this.imeMode.equalsIgnoreCase("auto") || this.imeMode.equalsIgnoreCase("active"))) {
                    this.setScriptRendered(true);
                    if (null == this.promptCharacter && "true".equalsIgnoreCase(this.inputAssist)) {
                        this.promptCharacter = "";
                    }
                } else {
                    this.setScriptRendered(false);
                }
            }
        }

        public String getAutoSubmit() {
            return this.autoSubmit;
        }

        public String getAutoTab() {
            return this.autoTab;
        }

        public String getErrorAction() {
            return this.errorAction;
        }

        public String getErrorClass() {
            return this.errorClass;
        }

        public String getImeMode() {
            return this.imeMode;
        }

        public String getInputAssist() {
            return this.inputAssist;
        }

        public boolean isValidation() {
            return this.isValidation;
        }

        public String getOnerror() {
            return this.onerror;
        }

        public String getOnsuccess() {
            return this.onsuccess;
        }

        public String getPromptCharacter() {
            return this.promptCharacter;
        }

        public String getSuccessAction() {
            return this.successAction;
        }

        public String getSuccessClass() {
            return this.successClass;
        }

        public String getValidation() {
            return this.validation;
        }

        public void setAutoSubmit(String string) {
            this.autoSubmit = string;
        }

        public void setAutoTab(String string) {
            this.autoTab = string;
        }

        public void setErrorAction(String string) {
            this.errorAction = string;
        }

        public void setErrorClass(String string) {
            this.errorClass = string;
        }

        public void setImeMode(String string) {
            this.imeMode = string;
        }

        public void setInputAssist(String string) {
            this.inputAssist = string;
        }

        public void setValidation(boolean b) {
            this.isValidation = b;
        }

        public void setOnerror(String string) {
            this.onerror = string;
        }

        public void setOnsuccess(String string) {
            this.onsuccess = string;
        }

        public void setPromptCharacter(String string) {
            this.promptCharacter = string;
        }

        public void setSuccessAction(String string) {
            this.successAction = string;
        }

        public void setSuccessClass(String string) {
            this.successClass = string;
        }

        public void setValidation(String string) {
            this.validation = string;
        }

        public String getDefaultClass() {
            return this.defaultClass;
        }

        public void setDefaultClass(String string) {
            this.defaultClass = string;
        }

        public String getOnfocuserror() {
            return this.onfocuserror;
        }

        public void setOnfocuserror(String onfocuserror) {
            this.onfocuserror = onfocuserror;
        }

        public String getOnfocusErrorAction() {
            return this.onfocusErrorAction;
        }

        public void setOnfocusErrorAction(String onfocusErrorAction) {
            this.onfocusErrorAction = onfocusErrorAction;
        }

        public String getOnfocusErrorClass() {
            return this.onfocusErrorClass;
        }

        public void setOnfocusErrorClass(String onfocusErrorClass) {
            this.onfocusErrorClass = onfocusErrorClass;
        }

        public String getOnfocussuccess() {
            return this.onfocussuccess;
        }

        public void setOnfocussuccess(String onfocussuccess) {
            this.onfocussuccess = onfocussuccess;
        }

        public String getOnfocusSuccessAction() {
            return this.onfocusSuccessAction;
        }

        public void setOnfocusSuccessAction(String onfocusSuccessAction) {
            this.onfocusSuccessAction = onfocusSuccessAction;
        }

        public String getOnfocusSuccessClass() {
            return this.onfocusSuccessClass;
        }

        public void setOnfocusSuccessClass(String onfocusSuccessClass) {
            this.onfocusSuccessClass = onfocusSuccessClass;
        }

        public String getTargetErrorAction() {
            return this.targetErrorAction;
        }

        public void setTargetErrorAction(String targetErrorAction) {
            this.targetErrorAction = targetErrorAction;
        }

        public String getTargetOnfocusErrorAction() {
            return this.targetOnfocusErrorAction;
        }

        public void setTargetOnfocusErrorAction(String targetOnfocusErrorAction) {
            this.targetOnfocusErrorAction = targetOnfocusErrorAction;
        }

        public String getTargetOnfocusSuccessAction() {
            return this.targetOnfocusSuccessAction;
        }

        public void setTargetOnfocusSuccessAction(String targetOnfocusSuccessAction) {
            this.targetOnfocusSuccessAction = targetOnfocusSuccessAction;
        }

        public String getTargetSuccessAction() {
            return this.targetSuccessAction;
        }

        public void setTargetSuccessAction(String targetSuccessAction) {
            this.targetSuccessAction = targetSuccessAction;
        }

        public boolean isScriptRendered() {
            return this.scriptRendered;
        }

        public void setScriptRendered(boolean scriptRendered) {
            this.scriptRendered = scriptRendered;
        }
    }
}

