/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit;

import com.ibm.faces.application.AjaxResponseStateManagerImpl;
import com.ibm.faces.renderkit.AjaxRenderer;
import com.ibm.faces.renderkit.DefaultAjaxRenderer;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class AjaxRenderKit
extends RenderKit {
    private RenderKit _renderKit;
    private AjaxResponseStateManagerImpl RSM;
    private Map _rendererCache;

    AjaxRenderKit(RenderKit renderKit) {
        this._renderKit = renderKit;
        this.RSM = new AjaxResponseStateManagerImpl(renderKit.getResponseStateManager());
        this._rendererCache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderer(String family, String rendererType, Renderer renderer) {
        this._renderKit.addRenderer(family, rendererType, renderer);
        renderer = this._renderKit.getRenderer(family, rendererType);
        if (!(renderer instanceof AjaxRenderer)) {
            renderer = new DefaultAjaxRenderer(renderer);
        }
        String ajaxKey = family + rendererType;
        Map map = this._rendererCache;
        synchronized (map) {
            this._rendererCache.put(ajaxKey, renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = null;
        String ajaxKey = family + rendererType;
        renderer = (Renderer)this._rendererCache.get(ajaxKey);
        if (renderer == null && (renderer = this._renderKit.getRenderer(family, rendererType)) != null) {
            if (!(renderer instanceof AjaxRenderer)) {
                renderer = new DefaultAjaxRenderer(renderer);
            }
            Map map = this._rendererCache;
            synchronized (map) {
                this._rendererCache.put(ajaxKey, renderer);
            }
        }
        return renderer;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.RSM;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        return this._renderKit.createResponseWriter(writer, contentTypeList, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return this._renderKit.createResponseStream(out);
    }
}

