/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.jwlajaxencoder;

import com.ibm.faces.jwlajaxencoder.AjaxUrlEncoder;
import com.ibm.faces.portlet.httpbridge.PortletRequestWrapper;
import com.ibm.faces.portlet.httpbridge.PortletResponseWrapper;
import com.ibm.portal.ObjectID;
import com.ibm.portal.portlet.service.PortletServiceHome;
import com.ibm.portal.portlet.service.PortletServiceUnavailableException;
import com.ibm.portal.state.Constants;
import com.ibm.portal.state.EngineURL;
import com.ibm.portal.state.PortletStateManager;
import com.ibm.portal.state.URLFactory;
import com.ibm.portal.state.accessors.portlet.PortletAccessorController;
import com.ibm.portal.state.accessors.portlet.PortletAccessorFactory;
import com.ibm.portal.state.accessors.portlet.PortletTargetAccessorController;
import com.ibm.portal.state.accessors.selection.SelectionAccessorController;
import com.ibm.portal.state.accessors.selection.SelectionAccessorFactory;
import com.ibm.portal.state.accessors.solo.SoloAccessorController;
import com.ibm.portal.state.accessors.solo.SoloAccessorFactory;
import com.ibm.portal.state.exceptions.StateException;
import com.ibm.portal.state.service.PortletStateManagerService;
import com.ibm.wps.pe.om.window.PortletWindow;
import com.ibm.wps.pe.om.window.PortletWindowEx;
import com.ibm.wps.pe.pc.std.core.InternalPortletRequest;
import com.ibm.wps.pe.pc.std.core.PortletUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;

public class PortalAjaxUrlEncoder
implements AjaxUrlEncoder {
    private static final String JNDI_NAME = "portletservice/com.ibm.portal.state.service.PortletStateManagerService";
    private static final String THEME_NAME = "PortletFragment";
    private static final String MULTIPLE_ACTION_EXECUTION_ALLOWED = "wps.multiple.action.execution";
    private static final String ENFORCE_REDIRECT = "wps.multiple.action.execution";
    private PortletStateManagerService _stateManService;
    private boolean _useTheme = false;
    private boolean _useSoloMode = true;
    private boolean _useAction = true;

    public PortalAjaxUrlEncoder() throws Exception {
        try {
            InitialContext ctxt = new InitialContext();
            PortletServiceHome serviceHome = (PortletServiceHome)ctxt.lookup(JNDI_NAME);
            this._stateManService = (PortletStateManagerService)serviceHome.getPortletService(PortletStateManagerService.class);
        }
        catch (PortletServiceUnavailableException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }

    public String encodeAjaxUrl(FacesContext context, String url) {
        ExternalContext extcontext = context.getExternalContext();
        HashMap<String, String[]> map = new HashMap<String, String[]>(3);
        String params = null;
        int n = url.indexOf(63);
        if (n > 0) {
            params = url.substring(n + 1);
            url = url.substring(0, n);
        }
        if (url.startsWith(extcontext.getRequestContextPath())) {
            url = url.substring(extcontext.getRequestContextPath().length());
        }
        if (url.startsWith(extcontext.getRequestServletPath())) {
            url = url.substring(extcontext.getRequestServletPath().length());
        }
        if (null != url) {
            String[] urla = new String[]{url};
            map.put("javax.servlet.include.path_info", urla);
        }
        if (null != params) {
            this.addParams(params, map);
        }
        PortletRequest req = null;
        PortletResponse resp = null;
        ServletRequest arg0 = (ServletRequest)extcontext.getRequest();
        ServletResponse arg1 = (ServletResponse)extcontext.getResponse();
        while (arg0 instanceof HttpServletRequestWrapper) {
            arg0 = ((HttpServletRequestWrapper)arg0).getRequest();
        }
        while (arg1 instanceof HttpServletResponseWrapper) {
            arg1 = ((HttpServletResponseWrapper)arg1).getResponse();
        }
        if (arg0 instanceof PortletRequestWrapper) {
            req = ((PortletRequestWrapper)arg0).getPortletRequest();
        }
        if (arg1 instanceof PortletResponseWrapper) {
            resp = ((PortletResponseWrapper)arg1).getPortletResponse();
        }
        try {
            return this.createAjaxUrl(req, resp, map);
        }
        catch (IOException ioe) {
        }
        catch (PortletException pe) {
            // empty catch block
        }
        return null;
    }

    private void addParams(String params, Map map) {
        if (params != null && params.indexOf("=") > -1) {
            int pos1 = 0;
            int pos2 = 0;
            String name = null;
            String value = null;
            while (pos1 > -1) {
                pos2 = params.indexOf("=", pos1);
                name = params.substring(pos1, pos2);
                pos1 = params.indexOf("&", pos2);
                if (pos1 == -1) {
                    value = params.substring(pos2 + 1);
                } else {
                    value = params.substring(pos2 + 1, pos1);
                    ++pos1;
                }
                String[] valuea = new String[]{value};
                map.put(name, valuea);
            }
        }
    }

    public String createAjaxUrl(PortletRequest request, PortletResponse response, Map actionParameters) throws PortletException, IOException {
        PortletStateManager stateManager = null;
        try {
            ObjectID pageID = this.getPageId(request);
            ObjectID portletWindowID = this.getWindowId(request);
            stateManager = this._stateManService.getPortletStateManager(request, response);
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            this.writePortletActionURL(stateManager, writer, pageID, portletWindowID, actionParameters, request.getPortletMode(), request.getWindowState());
            writer.flush();
            String string = buffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        finally {
            if (stateManager != null) {
                stateManager.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePortletActionURL(PortletStateManager stateManager, PrintWriter writer, ObjectID pageID, ObjectID portletWindowID, Map actionParams, PortletMode portletMode, WindowState windowState) throws IOException, StateException {
        URLFactory urlFactory = stateManager.getURLFactory();
        EngineURL returnURL = urlFactory.newURL((Constants.Clone)null);
        PortletStateManager stateManagerService = stateManager;
        try {
            SelectionAccessorFactory selFct = (SelectionAccessorFactory)stateManagerService.getAccessorFactory(SelectionAccessorFactory.class);
            SelectionAccessorController selCtrl = selFct.getSelectionAccessorController(returnURL.getState());
            try {
                selCtrl.setSelection(pageID);
                selCtrl.setSelectionMapping(pageID, portletWindowID);
            }
            finally {
                selCtrl.dispose();
            }
            if (this._useSoloMode) {
                SoloAccessorFactory soloFct = (SoloAccessorFactory)stateManagerService.getAccessorFactory(SoloAccessorFactory.class);
                SoloAccessorController soloCtrl = soloFct.getSoloAccessorController(returnURL.getState());
                try {
                    soloCtrl.setSoloPortlet(portletWindowID);
                }
                finally {
                    soloCtrl.dispose();
                }
            }
            if (this._useAction) {
                PortletTargetAccessorController targetCtrl = stateManager.getPortletTargetAccessorController(returnURL.getState());
                try {
                    targetCtrl.setActionTarget(portletWindowID);
                }
                finally {
                    targetCtrl.dispose();
                }
            }
            PortletAccessorFactory portletFct = (PortletAccessorFactory)stateManagerService.getAccessorFactory(PortletAccessorFactory.class);
            PortletAccessorController portletCtrl = portletFct.getPortletAccessorController(portletWindowID, returnURL.getState());
            try {
                if (portletMode != null) {
                    portletCtrl.setPortletMode(portletMode);
                }
                if (windowState != null) {
                    portletCtrl.setWindowState(windowState);
                }
                try {
                    if (actionParams != null && !actionParams.isEmpty()) {
                        portletCtrl.getParameters().clear();
                        portletCtrl.getParameters().putAll(actionParams);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            finally {
                portletCtrl.dispose();
            }
            returnURL.writeDispose((Writer)writer);
        }
        finally {
            urlFactory.dispose();
        }
    }

    private PortletWindow getPortletWindow(PortletRequest request) {
        InternalPortletRequest internalPortletRequest = PortletUtils.getInternalRequest((PortletRequest)request);
        return internalPortletRequest.getPortletWindow();
    }

    private ObjectID getPageIdFromWindow(PortletWindow portletWindow) {
        if (portletWindow instanceof PortletWindowEx) {
            return ((PortletWindowEx)portletWindow).getContentPageId();
        }
        return portletWindow.getCompositionId();
    }

    private ObjectID getPageId(PortletRequest request) {
        PortletWindow portletWindow = this.getPortletWindow(request);
        if (portletWindow == null) {
            return null;
        }
        return this.getPageIdFromWindow(portletWindow);
    }

    private ObjectID getWindowId(PortletRequest request) {
        PortletWindow portletWindow = this.getPortletWindow(request);
        if (portletWindow == null) {
            return null;
        }
        return portletWindow.getId();
    }
}

