/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.jwlajaxencoder;

import com.ibm.faces.jwlajaxencoder.AjaxUrlEncoder;
import com.ibm.faces.jwlajaxencoder.DefaultAjaxUrlEncoder;
import com.ibm.faces.jwlajaxencoder.PortalAjaxUrlEncoder;
import javax.faces.context.FacesContext;

public class AjaxUrlFactory {
    private static final String ERROR_MESSAGE_NO_LOAD_ENCODER_START = "the specified encoder class - '";
    private static final String ERROR_MESSAGE_NO_LOAD_ENCODER_END = "' could not be instancied";
    private static final boolean IS_PORTAL_SUPPORTED = AjaxUrlFactory.determineSupported();
    private static final boolean IS_SPECIFIED_ENCODER = AjaxUrlFactory.determineSpecifiedSupported();
    private static final AjaxUrlEncoder DEFAULT_ENCODER = new DefaultAjaxUrlEncoder();
    private static final AjaxUrlEncoder SPECIFIED_ENCODER = AjaxUrlFactory.createSpecifiedEncoder();
    private static final AjaxUrlEncoder PORTAL_ENCODER = AjaxUrlFactory.createPortalEncoder();
    private static String USE_SPECIFIED_CLASS;
    private static Class PORTLET_REQUEST;

    public static AjaxUrlEncoder getAjaxUrlEncoder(FacesContext context) {
        if (IS_SPECIFIED_ENCODER) {
            return SPECIFIED_ENCODER;
        }
        if (PORTLET_REQUEST == null) {
            return DEFAULT_ENCODER;
        }
        Object request = context.getExternalContext().getRequest();
        if (PORTLET_REQUEST.isInstance(request)) {
            return PORTAL_ENCODER;
        }
        return DEFAULT_ENCODER;
    }

    private static AjaxUrlEncoder createPortalEncoder() {
        try {
            if (IS_SPECIFIED_ENCODER) {
                return SPECIFIED_ENCODER;
            }
            if (!IS_PORTAL_SUPPORTED) {
                return DEFAULT_ENCODER;
            }
            return new PortalAjaxUrlEncoder();
        }
        catch (Exception pe) {
            return DEFAULT_ENCODER;
        }
    }

    private static Class loadRequestClass(String str) {
        try {
            return AjaxUrlFactory.loadClass(str);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static AjaxUrlEncoder createSpecifiedEncoder() {
        if (IS_SPECIFIED_ENCODER) {
            try {
                return (AjaxUrlEncoder)AjaxUrlFactory.loadClass(USE_SPECIFIED_CLASS).newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println(ERROR_MESSAGE_NO_LOAD_ENCODER_START + USE_SPECIFIED_CLASS + ERROR_MESSAGE_NO_LOAD_ENCODER_START);
                return DEFAULT_ENCODER;
            }
            catch (Exception e) {
                System.err.println(ERROR_MESSAGE_NO_LOAD_ENCODER_START + USE_SPECIFIED_CLASS + ERROR_MESSAGE_NO_LOAD_ENCODER_START);
                return DEFAULT_ENCODER;
            }
        }
        return DEFAULT_ENCODER;
    }

    private static boolean determineSpecifiedSupported() {
        USE_SPECIFIED_CLASS = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.ibm.faces.JWL_AJAX_ENCODER_CLASS");
        return USE_SPECIFIED_CLASS != null && USE_SPECIFIED_CLASS.trim().length() > 0;
    }

    private static boolean determineSupported() {
        String TURN_OFF_PORTAL_60_PATH = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.ibm.faces.TURN_OFF_AJAX_PORTAL_60_PATH");
        if (TURN_OFF_PORTAL_60_PATH != null && "true".equalsIgnoreCase(TURN_OFF_PORTAL_60_PATH)) {
            return false;
        }
        String soloController = "com.ibm.portal.state.accessors.solo.SoloAccessorController";
        String soloMethod = "setSoloPortlet";
        String[] soloMethodParams = new String[]{"com.ibm.portal.ObjectID"};
        String stateManagerService = "com.ibm.portal.state.service.StateManagerService";
        String localeAcessor = "com.ibm.portal.state.accessors.locale.LocaleAccessor";
        String localeMethod = "getLocale";
        String[] localeMethodParams = new String[]{""};
        MethodDescription[] MethodDesc1 = new MethodDescription[]{new MethodDescription(soloMethod, soloMethodParams)};
        Check chk1 = new Check(soloController, MethodDesc1);
        MethodDescription[] MethodDesc2 = new MethodDescription[]{new MethodDescription(localeMethod, localeMethodParams)};
        Check chk2 = new Check(localeAcessor, MethodDesc2);
        Check[] checks = new Check[]{chk1, chk2};
        for (int i = 0; i < checks.length; ++i) {
            if (checks[i].isSupported()) continue;
            return false;
        }
        try {
            Class x = AjaxUrlFactory.loadClass(stateManagerService);
            if (x == null) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    protected static Class loadClass(String className) throws ClassNotFoundException {
        if ("".equalsIgnoreCase(className)) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = AjaxUrlFactory.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(className);
    }

    static {
        PORTLET_REQUEST = AjaxUrlFactory.loadRequestClass("javax.portlet.PortletRequest");
    }

    private static class MethodDescription {
        private String _methodName;
        private String[] _paramClasses;
        private Class[] _params;

        protected MethodDescription(String methodName, String[] paramClasses) {
            this._methodName = methodName;
            this._paramClasses = paramClasses;
        }

        public boolean isSupported() {
            this._params = new Class[this._paramClasses.length];
            for (int i = 0; i < this._paramClasses.length; ++i) {
                try {
                    this._params[i] = AjaxUrlFactory.loadClass(this._paramClasses[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return true;
        }

        public Class[] getParams() {
            return this._params;
        }

        public String getName() {
            return this._methodName;
        }
    }

    private static class Check {
        private String _className;
        private MethodDescription[] _methods;

        protected Check(String className, MethodDescription[] methods) {
            this._className = className;
            this._methods = methods;
        }

        public boolean isSupported() {
            try {
                Class c = AjaxUrlFactory.loadClass(this._className);
                for (int i = 0; i < this._methods.length; ++i) {
                    if (!this._methods[i].isSupported()) {
                        return false;
                    }
                    if (this._methods[i].getParams()[0] != null) {
                        c.getMethod(this._methods[i].getName(), this._methods[i].getParams());
                        continue;
                    }
                    c.getMethod(this._methods[i].getName(), null);
                }
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            return true;
        }
    }
}

