/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.fileupload.util;

import com.ibm.faces.fileupload.util.ContentLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ContentLineReader {
    protected InputStream reader;
    private boolean eof;
    private static final char lf = '\n';
    private boolean debug;
    private String encoding;
    private ByteArrayOutputStream dump;

    public ContentLineReader(InputStream r, String enc) {
        this.reader = r;
        this.eof = false;
        this.encoding = enc;
        this.debug = false;
    }

    public ContentLineReader(InputStream r, String enc, boolean isDebug) {
        this.reader = r;
        this.debug = isDebug;
        this.encoding = enc;
        this.eof = false;
        if (this.debug) {
            this.dump = new ByteArrayOutputStream();
        }
    }

    public ContentLine readLine() throws IOException {
        boolean eol = false;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (this.eof) {
            return null;
        }
        while (!eol && !this.eof) {
            int i = this.reader.read();
            if (i == -1) {
                this.eof = true;
                continue;
            }
            if (this.debug) {
                this.dump.write(i);
            }
            os.write(i);
            if (i != 10) continue;
            eol = true;
        }
        return new ContentLine(os.toByteArray(), this.encoding);
    }

    public byte[] getDump() {
        if (!this.debug) {
            return null;
        }
        return this.dump.toByteArray();
    }
}

