/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.fileupload.util;

import com.ibm.faces.fileupload.util.ContentLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class ContentElement {
    private static String TAG_CONTENT_TYPE = "Content-Type";
    private static String TAG_CONTENT_DISP = "Content-Disposition";
    private static String TAG_NAME = "name";
    private static String TAG_FILENAME = "filename";
    private String name;
    private String fileName;
    private String mimeType;
    boolean headerSection = true;
    private String encoding;
    private ByteArrayOutputStream contentValue = new ByteArrayOutputStream();
    private byte[] content = null;

    public ContentElement(String enc) {
        this.encoding = enc;
    }

    public void setName(String n) {
        this.name = new String(n);
    }

    public String getName() {
        return this.name;
    }

    public void setFileName(String n) {
        this.fileName = new String(n);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMimeType(String n) {
        this.mimeType = new String(n);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getContentValue() {
        if (this.content == null) {
            int realLength = this.getContentSize();
            this.content = new byte[realLength];
            System.arraycopy(this.contentValue.toByteArray(), 0, this.content, 0, realLength);
            this.contentValue = null;
        }
        return this.content;
    }

    public String getContentValueAsString() {
        String rc = null;
        try {
            rc = new String(this.getContentValue(), 0, this.getContentSize(), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public int getContentSize() {
        int rc = 0;
        if (this.content == null) {
            this.content = this.contentValue.toByteArray();
        }
        if (this.content != null) {
            rc = this.content.length >= 2 && this.content[this.content.length - 2] == 13 && this.content[this.content.length - 1] == 10 ? this.content.length - 2 : this.content.length;
        }
        return rc;
    }

    public void addToContent(ContentLine line) {
        block15: {
            block13: {
                String tag;
                int ix;
                block17: {
                    String value;
                    block16: {
                        block14: {
                            if (!this.headerSection) break block13;
                            String s = line.getString();
                            ix = s.indexOf(58);
                            if (ix < 0) {
                                tag = s;
                                value = "";
                            } else {
                                tag = s.substring(0, ix);
                                value = s.substring(ix + 1, s.length());
                            }
                            if (!tag.equals("") || !value.equals("")) break block14;
                            this.headerSection = false;
                            break block15;
                        }
                        if (!tag.equalsIgnoreCase(TAG_CONTENT_TYPE)) break block16;
                        this.mimeType = value.trim();
                        break block15;
                    }
                    if (!tag.equalsIgnoreCase(TAG_CONTENT_DISP)) break block17;
                    StringTokenizer st = new StringTokenizer(value, ";");
                    while (st.hasMoreTokens()) {
                        String val;
                        String tok = st.nextToken().trim();
                        ix = tok.indexOf(61);
                        if (ix < 0) {
                            tag = tok;
                            val = "";
                        } else {
                            tag = tok.substring(0, ix);
                            val = tok.substring(ix + 1, tok.length());
                        }
                        if (tag.equalsIgnoreCase(TAG_NAME)) {
                            this.name = new String(val.trim());
                        }
                        if (!tag.equalsIgnoreCase(TAG_FILENAME)) continue;
                        if ((val = val.trim()).startsWith("\"") && !val.endsWith("\"")) {
                            int x = value.indexOf(val);
                            int y = value.indexOf("\"", x + 1);
                            int z = value.indexOf("\"", y + 1);
                            while (z > -1 && value.charAt(z - 1) != '=') {
                                y = z;
                                z = value.indexOf("\"", z + 1);
                            }
                            this.fileName = value.substring(x, y + 1);
                            continue;
                        }
                        this.fileName = new String(val);
                    }
                    break block15;
                }
                if (!tag.startsWith(" ") && !tag.startsWith("\t")) break block15;
                StringTokenizer st = new StringTokenizer(tag.trim(), ";");
                while (st.hasMoreTokens()) {
                    String val;
                    String tok = st.nextToken().trim();
                    ix = tok.indexOf(61);
                    if (ix < 0) {
                        tag = tok;
                        val = "";
                    } else {
                        tag = tok.substring(0, ix);
                        val = tok.substring(ix + 1, tok.length());
                    }
                    if (!tag.equalsIgnoreCase(TAG_FILENAME)) continue;
                    this.fileName = new String(val.trim());
                }
                break block15;
            }
            try {
                this.contentValue.write(line.getBytes());
            }
            catch (IOException e) {
                System.err.println("Exception!");
            }
        }
    }

    public String toString() {
        return TAG_CONTENT_TYPE + "=" + this.mimeType + "; " + TAG_NAME + "=" + this.name;
    }
}

