/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.converter;

import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public class NumberConverterExICU
extends NumberConverterEx {
    private static final char NBSP = '\u00a0';
    private static final char SPACE = ' ';
    public static final String CONVERTER_ID = "com.ibm.faces.Number";

    private Locale setupLocale(FacesContext context) {
        Locale l;
        if (!this.isLocaleSet() && (l = context.getViewRoot().getLocale()) != null) {
            return l;
        }
        return this.getLocale();
    }

    public DecimalFormat getNumberFormat(FacesContext context) {
        return this.getNumberFormat(context, false);
    }

    private DecimalFormatSymbols fixNbspSymbols(DecimalFormatSymbols symbols) {
        if (symbols.getDecimalSeparator() == '\u00a0') {
            symbols.setDecimalSeparator(' ');
        }
        if (symbols.getGroupingSeparator() == '\u00a0') {
            symbols.setGroupingSeparator(' ');
        }
        if (symbols.getCurrencySymbol() != null) {
            symbols.setCurrencySymbol(symbols.getCurrencySymbol().replace('\u00a0', ' '));
        }
        return symbols;
    }

    public DecimalFormat getNumberFormat(FacesContext context, boolean isInput) {
        Locale locale = this.setupLocale(context);
        DecimalFormat df = null;
        DecimalFormatSymbols symbols = null;
        if (this.isPatternSet()) {
            symbols = new DecimalFormatSymbols(locale);
            if (this.isCurrencyCodeSet()) {
                symbols.setInternationalCurrencySymbol(this.getCurrencyCode());
            }
            if (this.isCurrencySymbolSet()) {
                symbols.setCurrencySymbol(this.getCurrencySymbol());
            }
            if (isInput) {
                this.fixNbspSymbols(symbols);
            }
            df = new DecimalFormat(this.getPattern(), symbols);
            return df;
        }
        symbols = new DecimalFormatSymbols(locale);
        if (this.isCurrencyCodeSet()) {
            symbols.setInternationalCurrencySymbol(this.getCurrencyCode());
        }
        if (this.isCurrencySymbolSet()) {
            symbols.setCurrencySymbol(this.getCurrencySymbol());
        }
        if (isInput) {
            this.fixNbspSymbols(symbols);
        }
        if ("number".equalsIgnoreCase(this.getType()) || !this.isTypeSet() && !this.isPatternSet()) {
            df = (DecimalFormat)NumberFormat.getInstance((Locale)locale);
        } else if ("currency".equalsIgnoreCase(this.getType())) {
            df = (DecimalFormat)NumberFormat.getCurrencyInstance((Locale)locale);
        } else if ("percent".equalsIgnoreCase(this.getType())) {
            df = (DecimalFormat)NumberFormat.getPercentInstance((Locale)locale);
        } else {
            throw new ConverterException("Cannot resolve a NumberFormat from attributes set");
        }
        df.setDecimalFormatSymbols(symbols);
        return df;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (this.isPatternExtensionSet()) {
            value = this.decodeExtensionPatternValue(context, value);
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() <= 0) {
            return null;
        }
        try {
            DecimalFormat nf = this.getNumberFormat(context, component instanceof EditableValueHolder);
            if (this.isIntegerOnlySet()) {
                nf.setParseIntegerOnly(this.isIntegerOnly());
            }
            Number num = nf.parse(value);
            ValueBinding vb = component.getValueBinding("value");
            if (vb != null) {
                Class vbClass = vb.getType(context);
                if (vbClass == Number.class || vbClass == num.getClass() || vbClass == Object.class) {
                    return num;
                }
                if (vbClass == Short.class || vbClass == Short.TYPE) {
                    return new Short(num.shortValue());
                }
                if (vbClass == Integer.class || vbClass == Integer.TYPE) {
                    return new Integer(num.intValue());
                }
                if (vbClass == Long.class || vbClass == Long.TYPE) {
                    return new Long(num.longValue());
                }
                if (vbClass == Double.class || vbClass == Double.TYPE) {
                    return new Double(num.doubleValue());
                }
                if (vbClass == Float.class || vbClass == Float.TYPE) {
                    return new Float(num.floatValue());
                }
                if (vbClass == BigDecimal.class) {
                    return new BigDecimal(num.toString());
                }
                if (vbClass == BigInteger.class) {
                    return new BigInteger(num.toString());
                }
                if (vbClass == com.ibm.icu.math.BigDecimal.class) {
                    return new com.ibm.icu.math.BigDecimal(num.toString());
                }
                Converter converter = null;
                try {
                    Application application = context.getApplication();
                    converter = application.createConverter(vbClass);
                }
                catch (Exception e) {
                    return null;
                }
                if (converter != null) {
                    Object numobj = converter.getAsObject(context, component, num.toString());
                    return numobj;
                }
                throw new ConverterException("Valuebinding type not supported.");
            }
            return num;
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        String valueStr = null;
        if (value == null) {
            valueStr = "";
        } else if (value instanceof String) {
            valueStr = (String)value;
        } else {
            try {
                DecimalFormat nf = this.getNumberFormat(context, component instanceof EditableValueHolder);
                if (this.isMaxFractionDigitsSet()) {
                    nf.setMaximumFractionDigits(this.getMaxFractionDigits());
                }
                if (this.isMinFractionDigitsSet()) {
                    nf.setMinimumFractionDigits(this.getMinFractionDigits());
                }
                if (this.isMaxIntegerDigitsSet()) {
                    nf.setMaximumIntegerDigits(this.getMaxIntegerDigits());
                }
                if (this.isMinIntegerDigitsSet()) {
                    nf.setMinimumIntegerDigits(this.getMinIntegerDigits());
                }
                if (this.isGroupingUsedSet()) {
                    nf.setGroupingUsed(this.isGroupingUsed());
                }
                valueStr = nf.format(value);
            }
            catch (Exception e) {
                throw new ConverterException((Throwable)e);
            }
        }
        if (this.isPatternExtensionSet()) {
            return this.encodeExtensionPatternValue(value, valueStr);
        }
        return valueStr;
    }

    public Object saveState(FacesContext context) {
        return super.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        super.restoreState(context, state);
    }
}

