/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.converter;

import com.ibm.faces.ResourceHandler;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public class MaskConverter
implements Converter,
StateHolder {
    private String mask;
    private boolean asis;
    private String protectMask;
    private String char1RegEx;
    private String char2RegEx;
    private String char3RegEx;
    private String char4RegEx;
    private String sourceObjType;
    public static final String CONVERTER_ID = "com.ibm.faces.Mask";
    private char[] regExChars = new char[]{'-', '\\'};
    private boolean transientFlag = false;

    public String getChar1RegEx() {
        return this.char1RegEx;
    }

    public void setChar1RegEx(String char1RegEx) {
        this.char1RegEx = char1RegEx;
    }

    public String getChar2RegEx() {
        return this.char2RegEx;
    }

    public void setChar2RegEx(String char2RegEx) {
        this.char2RegEx = char2RegEx;
    }

    public String getChar3RegEx() {
        return this.char3RegEx;
    }

    public void setChar3RegEx(String char3RegEx) {
        this.char3RegEx = char3RegEx;
    }

    public String getChar4RegEx() {
        return this.char4RegEx;
    }

    public void setChar4RegEx(String char4RegEx) {
        this.char4RegEx = char4RegEx;
    }

    public String getProtectMask() {
        return this.protectMask;
    }

    public void setProtectMask(String protectMask) {
        this.protectMask = protectMask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        ResourceBundle rb = ResourceHandler.getBundle(context);
        if (context == null) throw new NullPointerException(ResourceHandler.getString(rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        if (component == null) {
            throw new NullPointerException(ResourceHandler.getString(rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        if (value == null) return null;
        if (value.length() < 1) {
            return null;
        }
        try {
            if (this.asis) {
                this.getStrippedValue(value, this.mask, rb);
                return value;
            }
            String modValue = this.getStrippedValue(value, this.mask, rb);
            if (this.sourceObjType != null) return this.convertToOrignType(this.sourceObjType, modValue, rb);
            ValueBinding valuebinding = component.getValueBinding("value");
            if (valuebinding == null) return this.getStrippedValue(value, this.mask, rb);
            String type = null;
            Class tClass = valuebinding.getType(context);
            if (tClass != null) {
                type = tClass.getName();
            }
            if (type == null) {
                MessageFormat format = new MessageFormat(ResourceHandler.getString(rb, "MaskConverter.Failed_to_convert___{0}___to_the_object_due_to_unknown_data_type._1"));
                Object[] obj = new Object[]{value};
                throw new ConverterException(format.format(obj));
            }
            this.sourceObjType = type;
            return this.convertToOrignType(this.sourceObjType, modValue, rb);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        ResourceBundle rb = ResourceHandler.getBundle(context);
        if (context == null || component == null) {
            throw new NullPointerException(ResourceHandler.getString(rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        if (value == null) {
            return "";
        }
        try {
            String sourceString;
            if (value instanceof String) {
                sourceString = (String)value;
            } else if (value instanceof Number) {
                sourceString = value.toString();
                int nDigits = this.getNumberOfDigitsInMask();
                if (sourceString.length() < nDigits) {
                    StringBuffer str = new StringBuffer();
                    for (int i = 0; i < nDigits - sourceString.length(); ++i) {
                        str.append("0");
                    }
                    str.append(sourceString);
                    sourceString = str.toString();
                }
            } else {
                sourceString = value.toString();
            }
            this.sourceObjType = value.getClass().getName();
            return this.getMaskedString(this.mask, sourceString, rb, context, component);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private String getStrippedValue(String data, String mask, ResourceBundle rb) {
        char[] dataArray = data.toCharArray();
        char[] maskArray = mask.toCharArray();
        StringBuffer maskChars = new StringBuffer();
        StringBuffer dataChars = new StringBuffer();
        int count = 0;
        for (int i = 0; i < maskArray.length; ++i) {
            String c = String.valueOf(maskArray[i]);
            if (!c.equals("?") && !c.equals("#") && (!c.equals("!") || this.getChar3RegEx() == null || this.getChar3RegEx().length() <= 0) && (!c.equals("~") || this.getChar4RegEx() == null || this.getChar4RegEx().length() <= 0)) continue;
            maskChars.append(c);
            if (count < dataArray.length) {
                if (!this.isValidType(c, dataArray[i])) break;
                dataChars.append(dataArray[i]);
            } else if (this.isValidType(c, ' ')) {
                dataChars.append(' ');
            } else {
                throw new ConverterException(ResourceHandler.getString(rb, "MaskConverter.Data_String_and_mask_pattern_are_mismatched._1"));
            }
            ++count;
        }
        if (maskChars.length() == dataChars.length()) {
            return dataChars.toString();
        }
        return this.removeNonDataCharacter(data, mask, rb);
    }

    private String removeNonDataCharacter(String data, String mask, ResourceBundle rb) {
        boolean b = true;
        char[] dataArray = data.toCharArray();
        char[] maskArray = mask.toCharArray();
        StringBuffer result = new StringBuffer();
        Boolean fill = Boolean.FALSE;
        for (int i = 0; i < maskArray.length; ++i) {
            String temp;
            if (!fill.booleanValue() && i >= dataArray.length) {
                fill = Boolean.TRUE;
            }
            if ((temp = String.valueOf(maskArray[i])).equals("?") || temp.equals("#") || temp.equals("!") && this.getChar3RegEx() != null && this.getChar3RegEx().length() > 0 || temp.equals("~") && this.getChar4RegEx() != null && this.getChar4RegEx().length() > 0) {
                boolean valid = fill != false ? this.isValidType(temp, ' ') : this.isValidType(temp, dataArray[i]);
                if (!valid) {
                    b = false;
                    break;
                }
                if (fill.booleanValue()) {
                    result.append(' ');
                    continue;
                }
                result.append(dataArray[i]);
                continue;
            }
            if (fill.booleanValue() || maskArray[i] == dataArray[i]) continue;
            b = false;
            break;
        }
        if (b) {
            return result.toString();
        }
        throw new ConverterException(ResourceHandler.getString(rb, "MaskConverter.Data_String_and_mask_pattern_are_mismatched._1"));
    }

    protected Object convertToOrignType(String type, String value, ResourceBundle rb) {
        Class[] classes = new Class[]{String.class};
        Object[] values = new String[]{value};
        try {
            Constructor<?> construtor = Class.forName(type).getConstructor(classes);
            Object obj = construtor.newInstance(values);
            return obj;
        }
        catch (Exception e) {
            throw new ConverterException(ResourceHandler.getString(rb, "MaskConverter.Error__Fail_to_covert_original_Object_type._2"));
        }
    }

    private String getMaskedString(String mask, String source, ResourceBundle rb, FacesContext context, UIComponent component) {
        StringBuffer tmp = new StringBuffer();
        char[] maskChars = mask.toCharArray();
        char[] sourceChars = source.toCharArray();
        int sourceCharIndex = 0;
        int sourceLength = sourceChars.length;
        int maskLength = maskChars.length;
        for (int i = 0; i < maskLength; ++i) {
            String temp = String.valueOf(maskChars[i]);
            if (temp.equals("?") || temp.equals("#") || temp.equals("!") && this.getChar3RegEx() != null && this.getChar3RegEx().length() > 0 || temp.equals("~") && this.getChar4RegEx() != null && this.getChar4RegEx().length() > 0) {
                if (sourceLength > sourceCharIndex) {
                    boolean b;
                    boolean bl = b = sourceLength >= maskLength ? this.isValidType(temp, sourceChars[i]) : this.isValidType(temp, sourceChars[sourceCharIndex]);
                    if (b) {
                        if (sourceLength >= maskLength) {
                            tmp.append(sourceChars[i]);
                        } else {
                            tmp.append(sourceChars[sourceCharIndex]);
                        }
                        ++sourceCharIndex;
                        continue;
                    }
                    FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(rb, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._3"), ResourceHandler.getString(rb, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._3"));
                    context.addMessage(component.getClientId(context), errMsg);
                    return source;
                }
                return source;
            }
            tmp.append(maskChars[i]);
        }
        return tmp.toString();
    }

    private boolean isValidForRegEx(String regex, char targetChar) {
        if (regex.equals(".")) {
            return true;
        }
        if (regex.trim().startsWith("[") && regex.trim().endsWith("]")) {
            Boolean negated = Boolean.FALSE;
            if (regex.trim().startsWith("[^")) {
                negated = Boolean.TRUE;
            }
            for (int x = 0; x < this.regExChars.length; ++x) {
                if (targetChar != this.regExChars[x]) continue;
                int index = 0;
                while (index > -1) {
                    if ((index = regex.indexOf(targetChar, index + 1)) <= -1 || regex.charAt(index - 1) != '\\') continue;
                    return negated == false;
                }
                return negated != false;
            }
            if (regex.indexOf(targetChar) > -1) {
                return negated == false;
            }
            int sep = -1;
            sep = regex.indexOf("-");
            while (sep > -1) {
                if (targetChar >= regex.charAt(sep - 1) && targetChar <= regex.charAt(sep + 1)) {
                    return negated == false;
                }
                if ((sep = regex.indexOf("-", sep + 1)) <= -1 || regex.charAt(sep - 1) != '\\') continue;
                sep = regex.indexOf("-", sep + 1);
            }
            return negated != false;
        }
        return false;
    }

    private boolean isValidType(String placeHolder, char targetChar) {
        if (placeHolder.equals("?")) {
            if (this.getChar2RegEx() != null && this.getChar2RegEx().length() > 0) {
                return this.isValidForRegEx(this.getChar2RegEx(), targetChar);
            }
            return Character.isLetter(targetChar);
        }
        if (placeHolder.equals("#")) {
            if (this.getChar1RegEx() != null && this.getChar1RegEx().length() > 0) {
                return this.isValidForRegEx(this.getChar1RegEx(), targetChar);
            }
            return Character.isDigit(targetChar);
        }
        if (placeHolder.equals("!")) {
            return this.isValidForRegEx(this.getChar3RegEx(), targetChar);
        }
        if (placeHolder.equals("~")) {
            return this.isValidForRegEx(this.getChar4RegEx(), targetChar);
        }
        return false;
    }

    private int getNumberOfDigitsInMask() {
        int result = 0;
        char[] maskChars = this.mask.toCharArray();
        int maskLength = maskChars.length;
        for (int i = 0; i < maskLength; ++i) {
            String temp = String.valueOf(maskChars[i]);
            if (!temp.equals("#")) continue;
            ++result;
        }
        return result;
    }

    public boolean isAsis() {
        return this.asis;
    }

    public String getMask() {
        return this.mask;
    }

    public void setAsis(boolean b) {
        this.asis = b;
    }

    public void setMask(String string) {
        this.mask = string;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.mask = (String)values[0];
        this.asis = (Boolean)values[1];
        this.sourceObjType = (String)values[2];
        this.char1RegEx = (String)values[3];
        this.char2RegEx = (String)values[4];
        this.char3RegEx = (String)values[5];
        this.char4RegEx = (String)values[6];
        this.protectMask = (String)values[7];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.mask, new Boolean(this.asis), this.sourceObjType, this.char1RegEx, this.char2RegEx, this.char3RegEx, this.char4RegEx, this.protectMask};
        return values;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }
}

