/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.converter;

import com.ibm.faces.util.ICU4JUtil;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;

public class DateTimeConverterExICU
extends DateTimeConverter {
    private boolean dateStyleSet = false;
    private boolean timeStyleSet = false;
    private boolean timeZoneSet = false;
    private boolean localeSet = false;
    private boolean patternSet = false;
    private boolean typeSet = false;
    private boolean calendarSet = false;
    private Calendar calendar = null;
    private TimeZone timeZoneEx = null;
    private Calendar defaultCalendar = new GregorianCalendar();
    public static final String CONVERTER_ID = "com.ibm.faces.DateTime";

    public TimeZone getTimeZoneEx() {
        return this.timeZoneEx;
    }

    public Calendar getCalendar() {
        return this.calendar != null ? this.calendar : this.defaultCalendar;
    }

    public void setDateStyle(String dateStyle) {
        super.setDateStyle(dateStyle);
        this.setDateStyleSet(dateStyle != null && dateStyle.length() > 0);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.setLocaleSet(locale != null);
    }

    public void setPattern(String pattern) {
        super.setPattern(pattern);
        this.setPatternSet(pattern != null && pattern.length() > 0);
    }

    public void setTimeStyle(String timeStyle) {
        super.setTimeStyle(timeStyle);
        this.setTimeStyleSet(timeStyle != null && timeStyle.length() > 0);
    }

    public void setTimeZoneEx(TimeZone timeZone) {
        this.timeZoneEx = timeZone;
        this.setTimeZoneSet(timeZone != null);
    }

    public void setType(String type) {
        super.setType(type);
        this.setTypeSet(type != null && type.length() > 0);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.setCalendarSet(calendar != null);
    }

    public boolean isDateStyleSet() {
        return this.dateStyleSet;
    }

    public boolean isLocaleSet() {
        return this.localeSet;
    }

    public boolean isPatternSet() {
        return this.patternSet;
    }

    public boolean isTimeStyleSet() {
        return this.timeStyleSet;
    }

    public boolean isTimeZoneSet() {
        return this.timeZoneSet;
    }

    public void setDateStyleSet(boolean b) {
        this.dateStyleSet = b;
    }

    public void setLocaleSet(boolean b) {
        this.localeSet = b;
    }

    public void setPatternSet(boolean b) {
        this.patternSet = b;
    }

    public void setTimeStyleSet(boolean b) {
        this.timeStyleSet = b;
    }

    public void setTimeZoneSet(boolean b) {
        this.timeZoneSet = b;
    }

    public boolean isTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(boolean b) {
        this.typeSet = b;
    }

    public boolean isCalendarSet() {
        return this.calendarSet;
    }

    public void setCalendarSet(boolean b) {
        this.calendarSet = b;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return this.getDateFormat(context).parse(value);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return this.getDateFormat(context).format(value);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private DateFormat getDateFormat(FacesContext context) {
        SimpleDateFormat df = null;
        Locale locale = this.setupLocale(context);
        if (this.isPatternSet() && !this.isCalendarSet()) {
            df = new SimpleDateFormat(this.getPattern(), locale);
        } else {
            Calendar cal;
            Calendar calendar = cal = this.isCalendarSet() ? this.calendar : this.defaultCalendar;
            if (this.isTimeZoneSet()) {
                cal.setTimeZone(this.timeZoneEx);
            }
            if ((df = this.getType().equalsIgnoreCase("both") ? DateFormat.getDateTimeInstance((Calendar)cal, (int)ICU4JUtil.getDateStyle(this.getDateStyle()), (int)ICU4JUtil.getDateStyle(this.getTimeStyle()), (Locale)locale) : (this.getType().equalsIgnoreCase("date") ? DateFormat.getDateInstance((Calendar)cal, (int)ICU4JUtil.getDateStyle(this.getDateStyle()), (Locale)locale) : (this.getType().equalsIgnoreCase("time") ? DateFormat.getTimeInstance((Calendar)cal, (int)ICU4JUtil.getDateStyle(this.getTimeStyle()), (Locale)locale) : DateFormat.getDateInstance((Calendar)cal, (int)ICU4JUtil.getDateStyle(this.getDateStyle()), (Locale)locale)))) != null && this.isPatternSet()) {
                df.applyPattern(this.getPattern());
            }
        }
        return df;
    }

    private Locale setupLocale(FacesContext context) {
        Locale l;
        if (!this.isLocaleSet() && (l = context.getViewRoot().getLocale()) != null) {
            return l;
        }
        return this.getLocale();
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.calendar, this.timeZoneEx, this.getLocale(), this.getDateStyle(), this.getTimeStyle(), this.getPattern(), this.getType()};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.setCalendar((Calendar)values[0]);
        this.setTimeZoneEx((TimeZone)values[1]);
        this.setLocale((Locale)values[2]);
        this.setDateStyle((String)values[3]);
        this.setTimeStyle((String)values[4]);
        this.setPattern((String)values[5]);
        this.setType((String)values[6]);
    }
}

