/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.context;

import com.ibm.faces.context.BaseContextMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

class RequestHeaderValuesMap
extends BaseContextMap {
    private HttpServletRequest request = null;

    RequestHeaderValuesMap(HttpServletRequest request) {
        this.request = request;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.request.getHeaders(key.toString());
    }

    public Set entrySet() {
        HashSet<BaseContextMap.Entry> entries = new HashSet<BaseContextMap.Entry>();
        Enumeration e = this.request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            entries.add(new BaseContextMap.Entry(headerName, this.request.getHeaders(headerName)));
        }
        return entries;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RequestHeaderValuesMap)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean containsValue(Object value) {
        if (value == null || !(value instanceof Enumeration)) {
            return false;
        }
        int valHash = 0;
        int valCount = 0;
        Enumeration val = (Enumeration)value;
        while (val.hasMoreElements()) {
            valHash += val.nextElement().hashCode();
            ++valCount;
        }
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            int thisHash = 0;
            int thisCount = 0;
            Map.Entry entry = (Map.Entry)i.next();
            Enumeration thisMap = (Enumeration)entry.getValue();
            while (thisMap.hasMoreElements()) {
                thisHash += thisMap.nextElement().hashCode();
                ++thisCount;
            }
            if (thisCount != valCount || thisHash != valHash) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashSum = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            hashSum += entry.getKey().hashCode();
            Enumeration e = (Enumeration)entry.getValue();
            while (e.hasMoreElements()) {
                hashSum += e.nextElement().hashCode();
            }
        }
        return hashSum;
    }
}

