/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.context;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.context.FacesContextImpl;
import com.ibm.faces.context.MultipartExternalContextImpl;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class MultipartFacesContextFactoryImpl
extends FacesContextFactory {
    protected static ArrayList FACES_CONTEXT_POOL = new ArrayList();
    protected static int FACES_CONTEXT_POOL_SIZE = -1;
    private FacesContextFactory superFactory = null;
    private Boolean multipartDisabled = null;

    public MultipartFacesContextFactoryImpl() {
    }

    public MultipartFacesContextFactoryImpl(FacesContextFactory factory) {
        this.superFactory = factory;
    }

    public FacesContext getFacesContext(Object sc, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        if (sc == null || request == null || response == null || lifecycle == null) {
            throw new NullPointerException();
        }
        if (!(sc instanceof ServletContext)) {
            this.multipartDisabled = Boolean.TRUE;
        }
        if (this.multipartDisabled == null) {
            this.multipartDisabled = "true".equalsIgnoreCase(((ServletContext)sc).getInitParameter("com.ibm.faces.DISABLE_JWL_MULTIPART_CONTEXT")) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.superFactory != null && this.multipartDisabled.booleanValue() || this.superFactory != null && (((ServletRequest)request).getContentType() == null || !((ServletRequest)request).getContentType().startsWith("multipart/form-data"))) {
            return this.superFactory.getFacesContext(sc, request, response, lifecycle);
        }
        MultipartExternalContextImpl ec = new MultipartExternalContextImpl((ServletContext)sc, (ServletRequest)request, (ServletResponse)response);
        if (FACES_CONTEXT_POOL_SIZE == -1) {
            String poolSize = ec.getInitParameter("com.ibm.faces.FACES_CONTEXT_POOL_SIZE");
            if (poolSize != null) {
                FACES_CONTEXT_POOL_SIZE = Integer.parseInt(poolSize.trim());
                if (FACES_CONTEXT_POOL_SIZE < 1) {
                    FACES_CONTEXT_POOL_SIZE = 1;
                }
            } else {
                FACES_CONTEXT_POOL_SIZE = 20;
            }
        }
        if (this.superFactory != null) {
            FacesContext superContext = this.superFactory.getFacesContext(sc, request, response, lifecycle);
            ec.getRequestMap().put("com.sun.faces.FacesContextImpl", superContext);
            ec.getRequestMap().put("com.sun.faces.ExternalContextImpl", superContext.getExternalContext());
        }
        FacesContextImpl context = null;
        if (FACES_CONTEXT_POOL.isEmpty()) {
            context = new FacesContextImpl(ec);
        } else {
            context = (FacesContextImpl)((Object)FACES_CONTEXT_POOL.remove(FACES_CONTEXT_POOL.size() - 1));
            context.initialize(ec);
        }
        if (ec.getRequestMap().get("com.ibm.faces.MAX_REQUEST_CONTENT_SIZE") != null) {
            ResourceBundle bundle = ResourceHandler.getBundle(ec.getRequestLocale());
            String err = ResourceHandler.getString(bundle, "FileUpload.ServerOutOfMemoryErr");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err, err));
            ec.getRequestMap().put("com.ibm.faces.MAX_REQUEST_CONTENT_SIZE", null);
        }
        return context;
    }
}

