/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.context;

import com.ibm.faces.context.ApplicationMap;
import com.ibm.faces.context.InitParameterMap;
import com.ibm.faces.context.MyServletRequestWrapper;
import com.ibm.faces.context.RequestCookieMap;
import com.ibm.faces.context.RequestHeaderMap;
import com.ibm.faces.context.RequestHeaderValuesMap;
import com.ibm.faces.context.RequestMap;
import com.ibm.faces.context.RequestParameterMap;
import com.ibm.faces.context.RequestParameterValuesMap;
import com.ibm.faces.context.SessionMap;
import com.ibm.faces.fileupload.util.ContentElement;
import com.ibm.faces.fileupload.util.MultipartContent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MultipartExternalContextImpl
extends ExternalContext {
    public static final String FILE_ITEM_MAP_PARAM = "com.ibm.faces.FileItemMap";
    private ServletContext servletContext = null;
    private ServletRequest request = null;
    private ServletResponse response = null;
    private ApplicationMap applicationMap = null;
    private SessionMap sessionMap = null;
    private RequestMap requestMap = null;
    private RequestParameterMap requestParameterMap = null;
    private RequestParameterValuesMap requestParameterValuesMap = null;
    private RequestHeaderMap requestHeaderMap = null;
    private RequestHeaderValuesMap requestHeaderValuesMap = null;
    private RequestCookieMap cookieMap = null;
    private InitParameterMap initParameterMap = null;
    private static int maxRequestSize = -1;
    private String[][] encNVPs = null;
    private String ENV_UNSUPPORTED = "This operation is not supported in this Java EE environment, JavaEE5 required.";

    public MultipartExternalContextImpl(ServletContext sc, ServletRequest request, ServletResponse response) {
        if (sc == null || request == null || response == null) {
            throw new NullPointerException();
        }
        this.servletContext = sc;
        this.request = request;
        if (maxRequestSize == -1) {
            maxRequestSize = 0;
            String maxRequestSizeStr = this.getInitParameter("com.ibm.faces.MAX_REQUEST_CONTENT_SIZE");
            if (maxRequestSizeStr != null && maxRequestSizeStr.trim().length() > 0) {
                maxRequestSize = Integer.parseInt(maxRequestSizeStr.trim());
            }
        }
        this.request = request instanceof HttpServletRequest ? new MultiPartServletRequestWrapper((HttpServletRequest)request) : new MyServletRequestWrapper(request);
        this.response = response;
    }

    private String getRequestEncoding(ServletRequest req) {
        String enc = req.getCharacterEncoding();
        if (null == enc) {
            int iX;
            String cType = (String)this.getRequestHeaderMap().get("Content-Type");
            if (null != cType && (iX = cType.indexOf("charset=")) >= 0 && cType.length() > iX + 8) {
                enc = cType.substring(iX + 8).trim();
            }
            if (null == enc) {
                enc = (String)this.getSessionMap().get("javax.faces.request.charset");
            }
            if (null == enc) {
                try {
                    enc = System.getProperty("file.encoding", "ISO8859_1");
                }
                catch (SecurityException se) {
                    enc = "ISO8859_1";
                }
            }
        }
        if (null != enc) {
            enc = this.mapEncodingFromProperties(enc);
        }
        return enc;
    }

    private String mapEncodingFromProperties(String enc) {
        int iX;
        String encoding = enc;
        if (null == this.encNVPs) {
            try {
                URL mapUrl = null;
                String NVPUrl = this.getInitParameter("com.ibm.faces.ENCODING_MAPPING");
                mapUrl = null != NVPUrl ? new URL(NVPUrl) : Thread.currentThread().getContextClassLoader().getResource("converter.properties");
                if (null != mapUrl) {
                    String line;
                    InputStream inStrm = mapUrl.openStream();
                    InputStreamReader inRdr = new InputStreamReader(inStrm);
                    BufferedReader bufRdr = new BufferedReader(inRdr);
                    this.encNVPs = new String[100][2];
                    int NVix = 0;
                    while ((line = bufRdr.readLine()) != null) {
                        iX = line.indexOf("=");
                        if (iX <= 0) continue;
                        this.encNVPs[NVix][0] = new String(line.substring(0, iX).trim());
                        this.encNVPs[NVix++][1] = new String(line.substring(iX + 1).trim());
                    }
                }
            }
            catch (Exception e) {
                this.encNVPs = null;
            }
            if (null == this.encNVPs) {
                this.encNVPs = new String[1][2];
            }
        }
        for (iX = 0; iX < this.encNVPs.length && null != this.encNVPs[iX][0]; ++iX) {
            if (!this.encNVPs[iX][0].equalsIgnoreCase(enc)) continue;
            encoding = this.encNVPs[iX][1];
            break;
        }
        return encoding;
    }

    public Object getSession(boolean create) {
        return ((HttpServletRequest)this.request).getSession(create);
    }

    public Object getContext() {
        return this.servletContext;
    }

    public Object getRequest() {
        return this.request;
    }

    public Object getResponse() {
        return this.response;
    }

    public Map getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.servletContext);
        }
        return this.applicationMap;
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap((HttpSession)this.getSession(true));
        }
        return this.sessionMap;
    }

    public Map getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map getRequestHeaderMap() {
        if (null == this.requestHeaderMap) {
            this.requestHeaderMap = new RequestHeaderMap((HttpServletRequest)this.request);
        }
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (null == this.requestHeaderValuesMap) {
            this.requestHeaderValuesMap = new RequestHeaderValuesMap((HttpServletRequest)this.request);
        }
        return this.requestHeaderValuesMap;
    }

    public Map getRequestCookieMap() {
        if (null == this.cookieMap) {
            this.cookieMap = new RequestCookieMap((HttpServletRequest)this.request);
        }
        return this.cookieMap;
    }

    public Map getInitParameterMap() {
        if (null == this.initParameterMap) {
            this.initParameterMap = new InitParameterMap(this.servletContext);
        }
        return this.initParameterMap;
    }

    public Map getRequestParameterMap() {
        if (null == this.requestParameterMap) {
            this.requestParameterMap = new RequestParameterMap(this.request);
        }
        return this.requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        if (null == this.requestParameterValuesMap) {
            this.requestParameterValuesMap = new RequestParameterValuesMap(this.request);
        }
        return this.requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        final Enumeration namEnum = this.request.getParameterNames();
        Iterator result = new Iterator(){

            public boolean hasNext() {
                return namEnum.hasMoreElements();
            }

            public Object next() {
                return namEnum.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return result;
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator getRequestLocales() {
        return new LocalesIterator(this.request.getLocales());
    }

    public String getRequestPathInfo() {
        return ((HttpServletRequest)this.request).getPathInfo();
    }

    public String getRealPath(String basePath) {
        return this.servletContext.getRealPath(basePath);
    }

    public Cookie[] getRequestCookies() {
        return ((HttpServletRequest)this.request).getCookies();
    }

    public String getRequestContextPath() {
        return ((HttpServletRequest)this.request).getContextPath();
    }

    public String getRequestServletPath() {
        return ((HttpServletRequest)this.request).getServletPath();
    }

    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    public Set getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public URL getResource(String path) {
        URL url = null;
        try {
            url = this.servletContext.getResource(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url;
    }

    public String encodeActionURL(String sb) {
        return ((HttpServletResponse)this.response).encodeURL(sb);
    }

    public String encodeResourceURL(String sb) {
        return ((HttpServletResponse)this.response).encodeURL(sb);
    }

    public String encodeNamespace(String aValue) {
        return aValue;
    }

    public String encodeURL(String url) {
        return ((HttpServletResponse)this.response).encodeURL(url);
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(requestURI);
        try {
            requestDispatcher.forward(this.request, this.response);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw new FacesException((Throwable)se);
        }
    }

    public void redirect(String requestURI) throws IOException {
        ((HttpServletResponse)this.response).sendRedirect(requestURI);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public void log(String message) {
        this.servletContext.log(message);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public String getAuthType() {
        return ((HttpServletRequest)this.request).getAuthType();
    }

    public String getRemoteUser() {
        return ((HttpServletRequest)this.request).getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return ((HttpServletRequest)this.request).getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return ((HttpServletRequest)this.request).isUserInRole(role);
    }

    public String getRequestContentType() {
        return this.request.getContentType();
    }

    public String getRequestCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getResponseCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getResponseContentType() {
        try {
            Method m = this.response.getClass().getMethod("getContentType", null);
            return (String)m.invoke((Object)this.response, null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(this.ENV_UNSUPPORTED);
        }
    }

    public void setRequest(Object req) {
        if (req instanceof ServletRequest) {
            this.request = (ServletRequest)req;
        }
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(encoding);
    }

    public void setResponse(Object res) {
        if (res instanceof ServletResponse) {
            this.response = (ServletResponse)res;
        }
    }

    public void setResponseCharacterEncoding(String encoding) {
        try {
            Method m = this.response.getClass().getMethod("setCharacterEncoding", String.class);
            m.invoke((Object)this.response, encoding);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(this.ENV_UNSUPPORTED);
        }
    }

    private class LocalesIterator
    implements Iterator {
        private Enumeration locales;

        public LocalesIterator(Enumeration locales) {
            this.locales = locales;
        }

        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        public Object next() {
            return this.locales.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class MultiPartServletRequestWrapper
    extends HttpServletRequestWrapper {
        private Map parameters;

        public MultiPartServletRequestWrapper(HttpServletRequest request) {
            String contentType;
            super(request);
            if (request.getParameterMap().size() > 0) {
                Enumeration names = request.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String[] values = request.getParameterValues(name);
                    this.addParameter(name, values);
                }
            }
            if ((contentType = request.getContentType()) != null && contentType.startsWith("multipart/form-data")) {
                try {
                    if (maxRequestSize > 0 && request.getContentLength() > maxRequestSize) {
                        request.setAttribute("com.ibm.faces.MAX_REQUEST_CONTENT_SIZE", (Object)new Integer(maxRequestSize));
                        return;
                    }
                    MultipartContent mpc = new MultipartContent((InputStream)request.getInputStream());
                    Vector form_content = mpc.getContents(MultipartExternalContextImpl.this.getRequestEncoding((ServletRequest)request));
                    Enumeration elems = form_content.elements();
                    HashMap<String, ContentElement> fileItemMap = (HashMap<String, ContentElement>)MultipartExternalContextImpl.this.getRequestMap().get(MultipartExternalContextImpl.FILE_ITEM_MAP_PARAM);
                    while (elems.hasMoreElements()) {
                        ContentElement item = (ContentElement)elems.nextElement();
                        String name = item.getName();
                        String fname = item.getFileName();
                        if (name == null) {
                            throw new FacesException("Error parsing multipart/form-data. Uploaded item has no name.");
                        }
                        name = name.substring(1, name.length() - 1);
                        if (fname == null || fname.trim().equals("")) {
                            this.addParameter(name, item.getContentValueAsString());
                        } else {
                            fname = fname.substring(1, fname.length() - 1);
                            if (null == fileItemMap) {
                                fileItemMap = new HashMap<String, ContentElement>();
                            }
                            fileItemMap.put(name, item);
                        }
                        if (fileItemMap == null) continue;
                        MultipartExternalContextImpl.this.getRequestMap().put(MultipartExternalContextImpl.FILE_ITEM_MAP_PARAM, fileItemMap);
                    }
                }
                catch (IOException ioe) {
                    throw new FacesException("Error parsing multipart/form-data", (Throwable)ioe);
                }
            }
        }

        private void addParameter(String name, String[] values) {
            Object val;
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            if ((val = this.parameters.get(name)) == null) {
                this.parameters.put(name, values);
            } else {
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    this.addParameter(name, values[i]);
                }
            }
        }

        private void addParameter(String name, String value) {
            Object objExisting;
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            if ((objExisting = this.parameters.get(name)) == null) {
                this.parameters.put(name, new String[]{value});
            } else if (objExisting instanceof String[]) {
                String[] arr = this.combine((String[])objExisting, value);
                this.parameters.put(name, arr);
            } else if (objExisting instanceof String) {
                String[] arr = this.combine((String)objExisting, value);
                this.parameters.put(name, arr);
            }
        }

        private String[] combine(String str1, String str2) {
            String[] ret = new String[]{str1, str2};
            return ret;
        }

        private String[] combine(String[] arr, String str) {
            String[] ret = new String[arr.length + 1];
            ret[arr.length] = str;
            System.arraycopy(arr, 0, ret, 0, arr.length);
            return ret;
        }

        public String getParameter(String arg0) {
            if (this.parameters == null) {
                return null;
            }
            Object obj = this.parameters.get(arg0);
            if (obj instanceof String[] && ((String[])obj).length > 0) {
                return ((String[])obj)[0];
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            return null;
        }

        public Enumeration getParameterNames() {
            if (this.parameters == null) {
                return new Enumeration(){

                    public Object nextElement() {
                        return null;
                    }

                    public boolean hasMoreElements() {
                        return false;
                    }
                };
            }
            return Collections.enumeration(this.parameters.keySet());
        }

        public String[] getParameterValues(String arg0) {
            if (null == this.parameters) {
                return null;
            }
            Object obj = this.parameters.get(arg0);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String[]) {
                String[] arr = (String[])obj;
                String[] ret = new String[arr.length];
                System.arraycopy(arr, 0, ret, 0, arr.length);
                return ret;
            }
            if (obj instanceof String) {
                String[] ret = new String[]{(String)obj};
                return ret;
            }
            return null;
        }

        public Map getParameterMap() {
            if (this.parameters == null) {
                return Collections.EMPTY_MAP;
            }
            return Collections.unmodifiableMap(this.parameters);
        }

        public Object getAttribute(String key) {
            Object result = super.getAttribute(key);
            if (result == null) {
                ServletRequest wrapped = this.getRequest();
                if (wrapped != null && wrapped instanceof ServletRequestWrapper) {
                    wrapped = ((ServletRequestWrapper)wrapped).getRequest();
                }
                if (wrapped != null && wrapped instanceof HttpServletRequestWrapper) {
                    wrapped = ((HttpServletRequestWrapper)wrapped).getRequest();
                }
                if (wrapped != null) {
                    result = wrapped.getAttribute(key);
                }
            }
            return result;
        }
    }
}

