/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.context;

import com.ibm.faces.context.AjaxFacesContext;
import com.ibm.faces.context.MultipartFacesContextFactoryImpl;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.AjaxUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AjaxFacesContextFactory
extends FacesContextFactory {
    private FacesContextFactory _contextFactory;
    private static String[][] encNVPs = null;

    public AjaxFacesContextFactory() {
        this._contextFactory = new MultipartFacesContextFactoryImpl();
    }

    public AjaxFacesContextFactory(FacesContextFactory delegate) {
        if (delegate == null) {
            throw new NullPointerException("Invalid FacesContextFactory delegate");
        }
        this._contextFactory = delegate;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        try {
            if (!HxClientRenderUtil.isPortal(request)) {
                ((ServletRequest)request).setCharacterEncoding(AjaxFacesContextFactory.getRequestEncoding(request, context));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        FacesContext facesContext = this._contextFactory.getFacesContext(context, request, response, lifecycle);
        if (facesContext == null) {
            return null;
        }
        int mode = AjaxUtil.getAjaxMode(facesContext);
        if (mode != 0) {
            AjaxUtil.getAjaxComponentId(facesContext);
            facesContext = new AjaxFacesContext(facesContext);
        }
        return facesContext;
    }

    public static String getRequestEncoding(Object req, Object sc) {
        String enc = ((ServletRequest)req).getCharacterEncoding();
        if (null == enc) {
            if (req instanceof HttpServletRequest) {
                HttpSession sess;
                int iX;
                String cType = ((HttpServletRequest)req).getHeader("Content-Type");
                if (null != cType && (iX = cType.indexOf("charset=")) >= 0 && cType.length() > iX + 8) {
                    enc = cType.substring(iX + 8).trim();
                }
                if (null == enc && null != (sess = ((HttpServletRequest)req).getSession(false))) {
                    enc = (String)sess.getAttribute("javax.faces.request.charset");
                }
            }
            if (null == enc) {
                try {
                    enc = System.getProperty("file.encoding", "ISO8859_1");
                }
                catch (SecurityException se) {
                    enc = "ISO8859_1";
                }
            }
        }
        if (null != enc) {
            enc = AjaxFacesContextFactory.mapEncodingFromProperties(enc, sc);
        }
        return enc;
    }

    private static String mapEncodingFromProperties(String enc, Object sc) {
        int iX;
        String encoding = enc;
        if (null == encNVPs) {
            try {
                URL mapUrl = null;
                String NVPUrl = ((ServletContext)sc).getInitParameter("com.ibm.faces.ENCODING_MAPPING");
                mapUrl = null != NVPUrl ? new URL(NVPUrl) : Thread.currentThread().getContextClassLoader().getResource("converter.properties");
                if (null != mapUrl) {
                    String line;
                    InputStream inStrm = mapUrl.openStream();
                    InputStreamReader inRdr = new InputStreamReader(inStrm);
                    BufferedReader bufRdr = new BufferedReader(inRdr);
                    encNVPs = new String[100][2];
                    int NVix = 0;
                    while ((line = bufRdr.readLine()) != null) {
                        iX = line.indexOf("=");
                        if (iX <= 0) continue;
                        AjaxFacesContextFactory.encNVPs[NVix][0] = new String(line.substring(0, iX).trim());
                        AjaxFacesContextFactory.encNVPs[NVix++][1] = new String(line.substring(iX + 1).trim());
                    }
                }
            }
            catch (Exception e) {
                encNVPs = null;
            }
            if (null == encNVPs) {
                encNVPs = new String[1][2];
            }
        }
        for (iX = 0; iX < encNVPs.length && null != encNVPs[iX][0]; ++iX) {
            if (!encNVPs[iX][0].equalsIgnoreCase(enc)) continue;
            encoding = encNVPs[iX][1];
            break;
        }
        return encoding;
    }
}

