/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.component;

import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.util.AjaxUtil;
import com.ibm.faces.util.JavaScriptUtil;
import com.ibm.faces.util.LifecycleUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;

public class UIScriptCollector
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "com.ibm.faces.ScriptCollector";
    public static final String COMPONENT_FAMILY = "com.ibm.faces.ScriptCollector";
    public static final int FIND_NEAREST = 1;
    public static final int FIND_TOPMOST = 2;
    public static final int ADD_AT_TOP = 1;
    public static final int ADD_AT_BOTTOM = 2;
    public static final int ADD_AT_VERY_BOTTOM = 3;
    private static Boolean NO_LINE_FEED = null;
    private Vector scriptsTop = null;
    private Vector scriptsBottom = null;
    private Vector scriptsVeryBottom = null;
    private Vector libraryReferencesTop = null;
    private HashMap contributors = null;
    private HashMap libraries = null;
    private Vector writtenLibraries = null;
    private Vector writtenScripts = null;
    private MethodBinding preRender = null;
    private MethodBinding postRender = null;
    private MethodBinding decode = null;

    public UIScriptCollector() {
        this.setRendererType("ScriptCollector");
        this.scriptsTop = new Vector();
        this.libraryReferencesTop = new Vector();
        this.scriptsBottom = new Vector();
        this.scriptsVeryBottom = new Vector();
        this.contributors = new HashMap();
        this.libraries = new HashMap();
        this.writtenLibraries = new Vector();
        this.writtenScripts = new Vector();
        if (NO_LINE_FEED == null) {
            NO_LINE_FEED = Boolean.valueOf(this.getFacesContext().getExternalContext().getInitParameter("com.ibm.faces.NO_LINE_FEED"));
        }
    }

    public String getFamily() {
        return "com.ibm.faces.ScriptCollector";
    }

    public void addScript(String newScript, int addWhere) {
        if (this.isRendering()) {
            if (addWhere == 1) {
                this.scriptsTop.add(newScript);
            } else if (addWhere == 3) {
                this.scriptsVeryBottom.add(newScript);
            } else {
                this.scriptsBottom.add(newScript);
            }
        }
    }

    public void addScript(String newScript) {
        this.addScript(newScript, 2);
    }

    public void addScriptOnce(String newScript) {
        this.addScriptOnce(newScript, 2);
    }

    public void addScriptOnce(String newScript, int addWhere) {
        if (this.isRendering()) {
            Vector scripts = addWhere == 1 ? this.scriptsTop : (addWhere == 3 ? this.scriptsVeryBottom : this.scriptsBottom);
            for (int i = 0; i < scripts.size(); ++i) {
                String str = (String)scripts.get(i);
                if (!str.equals(newScript)) continue;
                return;
            }
            scripts.add(newScript);
        }
    }

    public Vector getScriptsTop() {
        return this.scriptsTop;
    }

    public Vector getLibraryReferencesTop() {
        return this.libraryReferencesTop;
    }

    public Vector getScriptsBottom() {
        return this.scriptsBottom;
    }

    public Vector getScriptsVeryBottom() {
        return this.scriptsVeryBottom;
    }

    public void reset() {
        this.scriptsTop.clear();
        this.scriptsBottom.clear();
        this.scriptsVeryBottom.clear();
        this.contributors.clear();
        this.libraries.clear();
        this.writtenLibraries.clear();
        this.writtenScripts.clear();
        this.libraryReferencesTop.clear();
    }

    public void register(IScriptContributor contributor, UIComponent component) {
        if (!this.isRendering()) {
            return;
        }
        this.contributors.put(component, contributor);
    }

    public HashMap getContributors() {
        return this.contributors;
    }

    public static UIScriptCollector find(UIComponent component, int scope) {
        UIScriptCollector scriptCollector = null;
        while (null != (component = component.getParent())) {
            if (!(component instanceof UIScriptCollector)) continue;
            scriptCollector = (UIScriptCollector)component;
            if (scope != 1) continue;
            return scriptCollector;
        }
        return scriptCollector;
    }

    public static UIScriptCollector find(UIComponent component) {
        return UIScriptCollector.find(component, 2);
    }

    public void addLibrary(String newLib, String libBlock) {
        this.libraries.put(newLib, libBlock);
    }

    public void addLibrary(String newLib) {
        if (!this.libraries.containsKey(newLib)) {
            StringBuffer libBlock = new StringBuffer();
            libBlock.append(JavaScriptUtil.getStartTag(newLib));
            libBlock.append(JavaScriptUtil.getEndTag());
            this.addLibrary(newLib, libBlock.toString());
        }
    }

    public void addLibraryReference(String newLib, FacesContext context) {
        if (newLib != null) {
            if (context != null) {
                newLib = context.getExternalContext().encodeResourceURL(LifecycleUtil.getResourceServletContextPath(context) + "/" + newLib);
            }
            Iterator i = this.libraryReferencesTop.iterator();
            while (i.hasNext()) {
                String str = (String)i.next();
                if (!str.equals(newLib)) continue;
                return;
            }
            for (int x = 0; x < this.writtenLibraries.size(); ++x) {
                String str = (String)this.writtenLibraries.get(x);
                if (!str.equals(newLib)) continue;
                return;
            }
            this.libraryReferencesTop.add(newLib);
        }
    }

    public void writeLibraryReference(String newLib, FacesContext context) {
        String str;
        int i;
        for (i = 0; i < this.writtenLibraries.size(); ++i) {
            str = (String)this.writtenLibraries.get(i);
            if (!str.equals(newLib)) continue;
            return;
        }
        for (i = 0; i < this.libraryReferencesTop.size(); ++i) {
            str = (String)this.libraryReferencesTop.get(i);
            if (!str.equals(newLib)) continue;
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String lib = LifecycleUtil.getContextPath(context) + "/" + newLib;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(JavaScriptUtil.getStartTag(lib));
            buf.append(JavaScriptUtil.getEndTag());
            buf.append("\n");
            if (NO_LINE_FEED.booleanValue()) {
                writer.write(buf.toString().replaceAll("[\r\n]", ""));
            } else {
                writer.write(buf.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writtenLibraries.add(newLib);
    }

    public void writeLibraryReference(FacesContext context, String newLib, String libBlock) {
        String str;
        int i;
        for (i = 0; i < this.writtenLibraries.size(); ++i) {
            str = (String)this.writtenLibraries.get(i);
            if (!str.equals(newLib)) continue;
            return;
        }
        for (i = 0; i < this.libraryReferencesTop.size(); ++i) {
            str = (String)this.libraryReferencesTop.get(i);
            if (!str.equals(newLib)) continue;
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        try {
            libBlock = "\n" + libBlock;
            if (NO_LINE_FEED.booleanValue()) {
                libBlock = libBlock.replaceAll("[\r\n]", "");
            }
            writer.write(libBlock);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writtenLibraries.add(newLib);
    }

    public void addSimpleLibraryReference(FacesContext context, String newLib) {
        String jsLib = JavaScriptUtil.getJavaScriptPath(context) + newLib + "v3_1_3" + ".js";
        this.addLibrary(jsLib);
    }

    public void addSimpleLibraryReference(String newLib) {
        this.addSimpleLibraryReference(FacesContext.getCurrentInstance(), newLib);
    }

    public void writeScriptOnce(String newScript, FacesContext context, boolean bWrapInScriptBlock) {
        if (!this.isRendering()) {
            return;
        }
        for (int i = 0; i < this.writtenScripts.size(); ++i) {
            String str = (String)this.writtenScripts.get(i);
            if (!str.equals(newScript)) continue;
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer buf = new StringBuffer();
        try {
            if (bWrapInScriptBlock) {
                buf.append("\n");
                buf.append(JavaScriptUtil.getStartTag());
            }
            buf.append("\n");
            buf.append(newScript);
            if (bWrapInScriptBlock) {
                buf.append("\n");
                buf.append(JavaScriptUtil.getEndTag());
            }
            if (NO_LINE_FEED.booleanValue()) {
                writer.write(buf.toString().replaceAll("[\r\n]", ""));
            } else {
                writer.write(buf.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writtenScripts.add(newScript);
    }

    public Vector getLibraries() {
        return new Vector(this.libraries.keySet());
    }

    public HashMap getLibraryBlocks() {
        return this.libraries;
    }

    public MethodBinding getDecode() {
        return this.decode;
    }

    public MethodBinding getPostRender() {
        return this.postRender;
    }

    public MethodBinding getPreRender() {
        return this.preRender;
    }

    public void setDecode(MethodBinding binding) {
        this.decode = binding;
    }

    public void setPostRender(MethodBinding binding) {
        this.postRender = binding;
    }

    public void setPreRender(MethodBinding binding) {
        this.preRender = binding;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), UIScriptCollector.saveAttachedState((FacesContext)context, (Object)this.decode), UIScriptCollector.saveAttachedState((FacesContext)context, (Object)this.preRender), UIScriptCollector.saveAttachedState((FacesContext)context, (Object)this.postRender)};
        return values;
    }

    public void restoreState(FacesContext context, Object valueArray) {
        Object[] values = (Object[])valueArray;
        super.restoreState(context, values[0]);
        this.decode = (MethodBinding)UIScriptCollector.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this.preRender = (MethodBinding)UIScriptCollector.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.postRender = (MethodBinding)UIScriptCollector.restoreAttachedState((FacesContext)context, (Object)values[3]);
    }

    public boolean isRendering() {
        boolean isRendering = true;
        FacesContext context = FacesContext.getCurrentInstance();
        if (AjaxUtil.isAjaxRequest(context) && !AjaxUtil.isRendering(context)) {
            isRendering = false;
        }
        return isRendering;
    }

    public static boolean isNoLineFeed() {
        return NO_LINE_FEED;
    }
}

