/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.component;

import com.ibm.faces.component.UIDataIterator;
import com.ibm.faces.event.PagerEvent;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;

public class UIPager
extends UICommand
implements ActionListener {
    private PagerDataWrapper pagerData = null;
    protected String UNSUPPORTED_PAGED_COMPONENT = "com.ibm.faces.UNSUPPORTED_PAGED_COMPONENT";
    public static final String PAGED_INNER_TABLE_IDS = "com.ibm.faces.PAGED_INNER_TABLE_IDS";
    private boolean innerTable = false;
    private Boolean innerTableSet = Boolean.FALSE;
    public static final String COMPONENT_FAMILY = "com.ibm.faces.Pager";

    public boolean isInnerTable() {
        if (!this.innerTableSet.booleanValue()) {
            UIData d = Utils.findParentUIData((UIComponent)this);
            if (d != null && (d = Utils.findParentUIData(d.getParent())) != null) {
                this.innerTable = true;
            }
            this.innerTableSet = Boolean.TRUE;
        }
        return this.innerTable;
    }

    public PagerDataWrapper getPagerDataWrapper() {
        String dataId = (String)this.getAttributes().get("for");
        UIComponent data = null;
        if (dataId != null) {
            data = this.findComponent(dataId);
        }
        if (data == null) {
            data = this.findDataParent((UIComponent)this);
        }
        if (data == null) {
            return null;
        }
        this.pagerData = new PagerDataWrapper(data, this.isInnerTable());
        return this.pagerData;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIData data;
        this.resetId();
        if (this.isInnerTable() && (data = Utils.findParentUIData((UIComponent)this)) != null) {
            HashMap<String, int[]> tableIdMap = (HashMap<String, int[]>)context.getExternalContext().getSessionMap().get(PAGED_INNER_TABLE_IDS);
            if (tableIdMap == null) {
                tableIdMap = new HashMap<String, int[]>();
                context.getExternalContext().getSessionMap().put(PAGED_INNER_TABLE_IDS, tableIdMap);
            }
            String tableId = data.getClientId(context);
            int rows = data.getRows();
            int rowCount = data.getRowCount();
            if (!tableIdMap.containsKey(tableId)) {
                tableIdMap.put(tableId, new int[]{0, rows, rowCount});
                data.setFirst(0);
            } else {
                int[] vals = (int[])tableIdMap.get(tableId);
                vals[1] = rows;
                vals[2] = rowCount;
            }
        }
        super.encodeBegin(context);
    }

    public void decode(FacesContext context) {
        this.resetId();
        super.decode(context);
    }

    private void resetId() {
        if (HxClientRenderUtil.isContainedInPanel((UIComponent)this)) {
            String id = this.getId();
            this.setId(id);
        }
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        if (event instanceof PagerEvent) {
            this.processAction((PagerEvent)event);
        }
    }

    private void processAction(PagerEvent pagerEvent) {
        PagerDataWrapper pdw = this.getPagerDataWrapper();
        if (pdw == null) {
            return;
        }
        int rows = pdw.getRows();
        int first = pdw.getFirst();
        if (rows <= 0) {
            return;
        }
        int page = pagerEvent.getPage();
        page = this.getCheckRange(page, rows);
        int currentPage = (first + 1) / rows;
        if (rows == 1) {
            currentPage = first;
        }
        if ((first + 1) % rows > 1) {
            ++currentPage;
        }
        if (page > currentPage) {
            first += (page - currentPage) * rows;
        }
        if (page < currentPage) {
            first -= (currentPage - page) * rows;
        }
        if (first < 0) {
            first = 0;
        }
        if (this.isInnerTable()) {
            int[] vals = this.getInnerTableIdMapVals();
            vals[0] = first;
        } else {
            pdw.setFirst(first);
        }
    }

    private int getCheckRange(int page, int rows) {
        PagerDataWrapper pdw = this.getPagerDataWrapper();
        if (page <= 0 || pdw == null) {
            return 0;
        }
        int max = pdw.getRowCount();
        int first = pdw.getFirst();
        if (max > 0) {
            int lastPage = first / rows;
            if (first % rows > 0) {
                ++lastPage;
            }
            lastPage += (max - (first + rows)) / rows;
            if (first + rows <= max && (max - (first + rows)) % rows > 0) {
                ++lastPage;
            }
            if (page > lastPage) {
                page = lastPage;
            }
        }
        return page;
    }

    private int[] getInnerTableIdMapVals() {
        Map tableMap = (Map)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(PAGED_INNER_TABLE_IDS);
        if (tableMap == null) {
            return null;
        }
        UIData data = Utils.findParentUIData((UIComponent)this);
        if (data != null) {
            return (int[])tableMap.get(data.getClientId(FacesContext.getCurrentInstance()));
        }
        return null;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ActionEvent) {
            this.processAction((ActionEvent)event);
        }
        super.broadcast(event);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getCurrentPage(PagerDataWrapper pdw) {
        int lastPage;
        if (pdw == null) {
            return 0;
        }
        int rows = pdw.getRows();
        int first = pdw.getFirst();
        if (rows <= 0) {
            return 0;
        }
        int current = first / rows;
        if (first % rows > 0) {
            ++current;
        }
        if (current > (lastPage = this.getLastPage(pdw)) && lastPage >= 0) {
            current = 0;
            pdw.setFirst(0);
        }
        return current;
    }

    public int getLastPage(PagerDataWrapper pdw) {
        if (pdw == null) {
            return -1;
        }
        int rows = pdw.getRows();
        int first = pdw.getFirst();
        int rowCount = pdw.getRowCount();
        if (rows <= 0) {
            return 0;
        }
        int max = rowCount;
        if (max < 0) {
            return -1;
        }
        if (max > 0) {
            int lastPage = first / rows;
            if (first % rows > 0) {
                ++lastPage;
            }
            lastPage += (max - (first + rows)) / rows;
            if (first + rows <= max && (max - (first + rows)) % rows > 0) {
                ++lastPage;
            }
            return lastPage;
        }
        return 0;
    }

    public boolean isPaged(PagerDataWrapper pdw) {
        int[] vals;
        if (pdw == null) {
            return false;
        }
        if (this.isInnerTable() && (vals = this.getInnerTableIdMapVals()) != null) {
            return vals[1] > 0;
        }
        return pdw.getRows() > 0;
    }

    private UIComponent findDataParent(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIData || component instanceof UIDataIterator) {
            return component;
        }
        return this.findDataParent(component.getParent());
    }

    public class PagerDataWrapper {
        UIComponent dataComponent = null;
        boolean innerTable = false;

        public PagerDataWrapper(UIComponent component, boolean innerTable) {
            this.dataComponent = component;
            this.innerTable = innerTable;
        }

        public int getRows() {
            int[] vals;
            if (this.innerTable && (vals = this.getInnerTableIdMapVals()) != null) {
                return vals[1];
            }
            if (this.dataComponent instanceof UIData) {
                return ((UIData)this.dataComponent).getRows();
            }
            if (this.dataComponent instanceof UIDataIterator) {
                return ((UIDataIterator)this.dataComponent).getRows();
            }
            throw new FacesException(UIPager.this.UNSUPPORTED_PAGED_COMPONENT);
        }

        public void setRows(int rows) {
            int[] vals;
            if (this.innerTable && (vals = this.getInnerTableIdMapVals()) != null) {
                vals[1] = rows;
                return;
            }
            if (this.dataComponent instanceof UIData) {
                ((UIData)this.dataComponent).setRows(rows);
            } else if (this.dataComponent instanceof UIDataIterator) {
                ((UIDataIterator)this.dataComponent).setRows(rows);
            } else {
                throw new FacesException(UIPager.this.UNSUPPORTED_PAGED_COMPONENT);
            }
        }

        public int getFirst() {
            int[] vals;
            if (this.innerTable && (vals = this.getInnerTableIdMapVals()) != null) {
                return vals[0];
            }
            if (this.dataComponent instanceof UIData) {
                return ((UIData)this.dataComponent).getFirst();
            }
            if (this.dataComponent instanceof UIDataIterator) {
                return ((UIDataIterator)this.dataComponent).getFirst();
            }
            throw new FacesException(UIPager.this.UNSUPPORTED_PAGED_COMPONENT);
        }

        public void setFirst(int first) {
            int[] vals;
            if (this.innerTable && (vals = this.getInnerTableIdMapVals()) != null) {
                vals[0] = first;
                return;
            }
            if (this.dataComponent instanceof UIData) {
                ((UIData)this.dataComponent).setFirst(first);
            } else if (this.dataComponent instanceof UIDataIterator) {
                ((UIDataIterator)this.dataComponent).setFirst(first);
            } else {
                throw new FacesException(UIPager.this.UNSUPPORTED_PAGED_COMPONENT);
            }
        }

        public int getRowCount() {
            int[] vals;
            if (this.innerTable && (vals = this.getInnerTableIdMapVals()) != null) {
                return vals[2];
            }
            if (this.dataComponent instanceof UIData) {
                return ((UIData)this.dataComponent).getRowCount();
            }
            if (this.dataComponent instanceof UIDataIterator) {
                return ((UIDataIterator)this.dataComponent).getRowCount();
            }
            throw new FacesException(UIPager.this.UNSUPPORTED_PAGED_COMPONENT);
        }

        private int[] getInnerTableIdMapVals() {
            Map tableMap = (Map)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(UIPager.PAGED_INNER_TABLE_IDS);
            UIData data = Utils.findParentUIData(this.dataComponent);
            if (data != null) {
                return (int[])tableMap.get(data.getClientId(FacesContext.getCurrentInstance()));
            }
            return null;
        }
    }
}

