/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.component;

import com.ibm.faces.event.DataIndexEvent;
import com.ibm.faces.util.DataModelUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;

public class UIDataIterator
extends UIComponentBase
implements NamingContainer {
    private Object value;
    private String var;
    private int index;
    private DataModel model;
    private HashMap savedValues;
    private int first = 0;
    private Boolean firstSet = Boolean.FALSE;
    private int rows = 0;
    private Boolean rowsSet = Boolean.FALSE;
    public static final String COMPONENT_TYPE = "com.ibm.faces.DataIterator";
    public static final String COMPONENT_FAMILY = "com.ibm.faces.DataIterator";

    public String getFamily() {
        return "com.ibm.faces.DataIterator";
    }

    public int getFirst() {
        Integer v;
        if (this.firstSet.booleanValue()) {
            return this.first;
        }
        ValueBinding vb = this.getValueBinding("first");
        if (vb != null && (v = (Integer)vb.getValue(FacesContext.getCurrentInstance())) != null) {
            return v;
        }
        return this.first;
    }

    public void setFirst(int first) {
        if (first < 0) {
            first = 0;
        }
        this.first = first;
        this.firstSet = Boolean.TRUE;
    }

    public int getRows() {
        Integer v;
        if (this.rowsSet.booleanValue()) {
            return this.rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        if (vb != null && (v = (Integer)vb.getValue(FacesContext.getCurrentInstance())) != null) {
            return v;
        }
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.rowsSet = Boolean.TRUE;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            return vb.getValue(FacesContext.getCurrentInstance());
        }
        return null;
    }

    public void setValue(Object o) {
        this.value = o;
        this.model = null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        Iterator children = this.getFacetsAndChildren();
        while (children.hasNext()) {
            this.saveValueHolderState(FacesContext.getCurrentInstance(), (UIComponent)children.next());
        }
        this.index = index;
        this.getDataModel().setRowIndex(index);
        if (this.var != null) {
            if (this.isRowAvailable()) {
                this.getFacesContext().getExternalContext().getRequestMap().put(this.var, this.getDataModel().getRowData());
            } else {
                this.getFacesContext().getExternalContext().getRequestMap().remove(this.var);
            }
        }
        children = this.getFacetsAndChildren();
        while (children.hasNext()) {
            this.restoreValueHolderState(FacesContext.getCurrentInstance(), (UIComponent)children.next());
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected DataModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        Object v = this.getValue();
        this.model = DataModelUtil.getDataModel(v);
        return this.model;
    }

    protected void saveValueHolderState(FacesContext context, UIComponent component) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder valueHolder = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            Object[] valueState = null;
            if (this.savedValues != null) {
                valueState = (Object[])this.savedValues.get(clientId);
            }
            if (valueState == null) {
                valueState = new Object[4];
                this.savedValues.put(clientId, valueState);
            }
            valueState[0] = valueHolder.getLocalValue();
            valueState[1] = valueHolder.getSubmittedValue();
            valueState[2] = valueHolder.isValid() ? Boolean.TRUE : Boolean.FALSE;
            valueState[3] = valueHolder.isLocalValueSet() ? Boolean.TRUE : Boolean.FALSE;
        }
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            this.saveValueHolderState(context, (UIComponent)children.next());
        }
    }

    protected void restoreValueHolderState(FacesContext context, UIComponent component) {
        String id = component.getId();
        component.setId(id);
        if (component instanceof EditableValueHolder) {
            EditableValueHolder valueHolder = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            Object[] valueState = null;
            if (this.savedValues != null) {
                valueState = (Object[])this.savedValues.get(clientId);
            }
            if (valueState != null) {
                valueHolder.setValue((Object)valueState[0]);
                valueHolder.setSubmittedValue(valueState[1]);
                valueHolder.setValid(((Boolean)valueState[2]).booleanValue());
                valueHolder.setLocalValueSet(((Boolean)valueState[3]).booleanValue());
            }
        }
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            this.restoreValueHolderState(context, (UIComponent)children.next());
        }
    }

    public String getClientId(FacesContext context) {
        String clientid = super.getClientId(context);
        if (this.index > -1) {
            clientid = clientid + ':' + this.index;
        }
        return clientid;
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.model = null;
        if (this.savedValues == null) {
            this.savedValues = new HashMap();
        }
        this.setIndex(this.getFirst());
        while (this.getDataModel().isRowAvailable() && this.isNotEndRow()) {
            Iterator children = this.getFacetsAndChildren();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (!child.isRendered()) continue;
                child.processDecodes(context);
            }
            this.setIndex(++this.index);
        }
        this.setIndex(-1);
        this.decode(context);
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.isNestedInUIIterator()) {
            this.model = null;
        }
        this.setIndex(this.getFirst());
        while (this.getDataModel().isRowAvailable() && this.isNotEndRow()) {
            Iterator children = this.getFacetsAndChildren();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (!child.isRendered()) continue;
                child.processUpdates(context);
            }
            this.setIndex(++this.index);
        }
        this.setIndex(-1);
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.isNestedInUIIterator()) {
            this.model = null;
        }
        this.setIndex(this.getFirst());
        while (this.getDataModel().isRowAvailable() && this.isNotEndRow()) {
            Iterator children = this.getFacetsAndChildren();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (!child.isRendered()) continue;
                child.processValidators(context);
            }
            this.setIndex(++this.index);
        }
        this.setIndex(-1);
    }

    protected boolean isNestedInUIIterator() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIDataIterator)) continue;
            return true;
        }
        return false;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.model = null;
        if (this.savedValues == null) {
            this.savedValues = new HashMap();
        }
        super.encodeBegin(context);
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.index = (Integer)values[1];
        this.savedValues = (HashMap)values[2];
        this.value = values[3];
        this.var = (String)values[4];
        this.first = (Integer)values[5];
        this.firstSet = (Boolean)values[6];
        this.rows = (Integer)values[7];
        this.rowsSet = (Boolean)values[8];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), new Integer(this.index), this.savedValues, this.value, this.var, new Integer(this.first), this.firstSet, new Integer(this.rows), this.rowsSet};
        return values;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new DataIndexEvent((UIComponent)this, event, this.getIndex()));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof DataIndexEvent) {
            DataIndexEvent die = (DataIndexEvent)event;
            int currIndex = this.getIndex();
            this.setIndex(die.getIndex());
            die.getEvent().getComponent().broadcast(die.getEvent());
            this.setIndex(currIndex);
        } else {
            super.broadcast(event);
        }
    }

    private boolean isNotEndRow() {
        boolean isnotendrow = true;
        if (this.getRows() > 0) {
            isnotendrow = this.getIndex() <= this.getFirst() + this.getRows() - 1;
        }
        return isnotendrow;
    }
}

