/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.application;

import com.ibm.faces.application.StateManagerImpl;
import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ViewHandlerImpl
extends ViewHandler {
    private ViewHandler parentHandler = null;
    private UniqueIdCounter uniqueIdCounter = new UniqueIdCounter(0);

    public ViewHandlerImpl(ViewHandler handler) {
        this.parentHandler = handler;
    }

    public Locale calculateLocale(FacesContext context) {
        return this.parentHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.parentHandler.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this.parentHandler.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String url) {
        return this.parentHandler.getActionURL(context, url);
    }

    public String getResourceURL(FacesContext context, String url) {
        return this.parentHandler.getResourceURL(context, url);
    }

    public void renderView(FacesContext context, UIViewRoot viewRoot) throws IOException, FacesException {
        this.createUniqueViewId(context, context.getViewRoot().getViewId());
        this.parentHandler.renderView(context, viewRoot);
    }

    public UIViewRoot restoreView(FacesContext context, String view) {
        return this.parentHandler.restoreView(context, view);
    }

    public void writeState(FacesContext context) throws IOException {
        if (context != null && StateManagerImpl.isSavingEnhancedServerState(context)) {
            this.addHiddenViewId(context);
        }
        this.parentHandler.writeState(context);
    }

    private boolean addHiddenViewId(FacesContext context) {
        ResponseWriter writer = context.getResponseWriter();
        try {
            if (writer != null) {
                writer.startElement("input", null);
                writer.writeAttribute("type", (Object)"hidden", "type");
                writer.writeAttribute("name", (Object)StateManagerImpl.ENHANCED_SERVER_STATE_SAVING, null);
                writer.writeAttribute("value", context.getViewRoot().getAttributes().get(StateManagerImpl.ENHANCED_SERVER_STATE_SAVING), "value");
                writer.endElement("input");
            }
        }
        catch (IOException io) {
            context.getViewRoot().getAttributes().remove(StateManagerImpl.ENHANCED_SERVER_STATE_SAVING);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createUniqueViewId(FacesContext context, String viewId) {
        if (!StateManagerImpl.isSavingEnhancedServerState(context)) {
            return viewId;
        }
        String uniqueId = null;
        UniqueIdCounter uniqueIdCounter = this.uniqueIdCounter;
        synchronized (uniqueIdCounter) {
            uniqueId = viewId + this.uniqueIdCounter.increment();
        }
        context.getViewRoot().getAttributes().put(StateManagerImpl.ENHANCED_SERVER_STATE_SAVING, uniqueId);
        return uniqueId;
    }

    public class UniqueIdCounter {
        private int counter;

        public UniqueIdCounter(int i) {
            this.counter = i;
        }

        public int increment() {
            if (++this.counter == Integer.MAX_VALUE) {
                this.counter = 0;
            }
            return this.counter;
        }
    }
}

