/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.application;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class DevelopmentStateManager
extends StateManager {
    private StateManager stateManager = null;
    private HashMap jspFileInfoMap = null;

    public DevelopmentStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
        System.out.println("Develoment State Manager Decorator loaded.");
    }

    public StateManager.SerializedView saveSerializedView(FacesContext fc) {
        return this.stateManager.saveSerializedView(fc);
    }

    public void writeState(FacesContext fc, StateManager.SerializedView sv) throws IOException {
        this.stateManager.writeState(fc, sv);
    }

    protected Object getComponentStateToSave(FacesContext fc) {
        return null;
    }

    protected Object getTreeStructureToSave(FacesContext fc) {
        return null;
    }

    protected void restoreComponentState(FacesContext fc, UIViewRoot arg1, String arg2) {
    }

    protected UIViewRoot restoreTreeStructure(FacesContext fc, String arg1, String arg2) {
        return null;
    }

    public UIViewRoot restoreView(FacesContext fc, String viewId, String renderKitId) {
        if (this.isFileModified(viewId)) {
            System.out.println("Development State Manager: View modified - discarding restored view.");
            return null;
        }
        UIViewRoot viewRoot = this.stateManager.restoreView(fc, viewId, renderKitId);
        if (null == viewRoot) {
            this.storeFileInfo(fc, viewId);
        }
        return viewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFileInfo(FacesContext context, String viewId) {
        DevelopmentStateManager developmentStateManager = this;
        synchronized (developmentStateManager) {
            File jspFile;
            if (this.jspFileInfoMap == null) {
                this.jspFileInfoMap = new HashMap();
            }
            if (this.jspFileInfoMap.containsKey(viewId)) {
                return;
            }
            String jspPath = this.getRealJSPPath(context, viewId);
            if (jspPath != null && (jspFile = new File(jspPath)).exists() && viewId != null) {
                this.jspFileInfoMap.put(viewId, new JspFileInfo(jspPath, jspFile.lastModified()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileModified(String viewId) {
        DevelopmentStateManager developmentStateManager = this;
        synchronized (developmentStateManager) {
            JspFileInfo jspData;
            if (this.jspFileInfoMap == null) {
                this.jspFileInfoMap = new HashMap();
            }
            if ((jspData = (JspFileInfo)this.jspFileInfoMap.get(viewId)) != null) {
                File jspFile = new File(jspData.getFilePath());
                if (jspData.getTimestamp() < jspFile.lastModified()) {
                    jspData.setTimestamp(jspFile.lastModified());
                    this.jspFileInfoMap.put(viewId, jspData);
                    return true;
                }
            }
        }
        return false;
    }

    private String getRealJSPPath(FacesContext facesContext, String viewId) {
        if (null != viewId) {
            String rjspPath = null;
            Object realContext = facesContext.getExternalContext().getContext();
            Class[] params = new Class[]{String.class};
            try {
                Method m = realContext.getClass().getDeclaredMethod("getRealPath", params);
                Object[] param = new Object[]{viewId};
                rjspPath = (String)m.invoke(realContext, param);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rjspPath;
        }
        return null;
    }

    public class JspFileInfo {
        private String filePath;
        private long timestamp;

        public JspFileInfo(String path, long time) {
            this.filePath = path;
            this.timestamp = time;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setFilePath(String string) {
            this.filePath = string;
        }

        public void setTimestamp(long long1) {
            this.timestamp = long1;
        }
    }
}

