/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces;

import com.ibm.icu.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;

public class ResourceHandler {
    public static final String PROPERTIES_FILE = "runtimeibm";
    public static Boolean USING_CUSTOM = null;
    public static String CUSTOM_FILE = null;

    public static boolean isUsingCustomBundle() {
        if (USING_CUSTOM != null) {
            return USING_CUSTOM;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = null;
        if (context != null) {
            app = context.getApplication();
        } else {
            ApplicationFactory af = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            app = af.getApplication();
        }
        if (app != null) {
            String f = app.getMessageBundle();
            if (f != null) {
                CUSTOM_FILE = f;
                USING_CUSTOM = Boolean.TRUE;
                return USING_CUSTOM;
            }
            USING_CUSTOM = Boolean.FALSE;
        }
        return false;
    }

    public static ResourceBundle getBundle(FacesContext context) {
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        if (context != null) {
            return ResourceHandler.getBundle(context.getViewRoot().getLocale());
        }
        return ResourceHandler.getBundle();
    }

    public static ResourceBundle getBundle(Locale locale) {
        if (locale != null) {
            return ResourceBundle.getBundle(PROPERTIES_FILE, locale);
        }
        return ResourceHandler.getBundle();
    }

    public static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(PROPERTIES_FILE);
    }

    public static String getServerString(String key) {
        try {
            return ResourceBundle.getBundle(PROPERTIES_FILE).getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getFacesMessageString(ResourceBundle bundle, String key) {
        if (ResourceHandler.isUsingCustomBundle()) {
            ResourceBundle customBundle = null;
            FacesContext context = FacesContext.getCurrentInstance();
            customBundle = context != null ? ResourceBundle.getBundle(CUSTOM_FILE, context.getViewRoot().getLocale()) : ResourceBundle.getBundle(CUSTOM_FILE);
            if (customBundle != null) {
                try {
                    return customBundle.getString(key);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
        }
        if (bundle == null) {
            bundle = ResourceHandler.getBundle();
        }
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return "!" + key + "!";
            }
        }
        return "!" + key + "!";
    }

    public static String getString(ResourceBundle bundle, String key) {
        if (bundle == null) {
            bundle = ResourceHandler.getBundle();
        }
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return "!" + key + "!";
            }
        }
        return "!" + key + "!";
    }

    public static String getString(ResourceBundle bundle, String key, Object[] args) {
        try {
            Locale viewLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            MessageFormat mf = new MessageFormat(ResourceHandler.getString(bundle, key), viewLocale);
            return mf.format((Object)args);
        }
        catch (IllegalArgumentException e) {
            return ResourceHandler.getString(bundle, key);
        }
    }

    public static String buildLocalizedLibName(ResourceBundle bundle, String lib) {
        if (bundle == null) {
            bundle = ResourceHandler.getBundle();
        }
        if (bundle == null) {
            return lib;
        }
        String suffix = bundle.getString("Locale.suffix");
        if (suffix == null || suffix.trim().length() == 0 || suffix.equals("!Locale.suffix!") || suffix.equals("en")) {
            return lib;
        }
        int n = lib.lastIndexOf(".js");
        return lib.substring(0, n) + "_" + suffix + ".js";
    }

    public static String buildLocalizedLibName(String lib, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(PROPERTIES_FILE, locale);
        return ResourceHandler.buildLocalizedLibName(bundle, lib);
    }
}

