/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.util;

import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.List;
import java.util.Locale;

public abstract class LocalisedDisplayName
implements LocalisedString {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006.\n\n";
    private Locale currentLocale = null;
    private String displayName = null;

    public LocalisedDisplayName() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Creating new empty display name.");
        }
    }

    public LocalisedDisplayName(String string, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating new display name for: " + locale + " - " + string));
        }
        this.displayName = string;
        this.currentLocale = locale;
    }

    public String getString(Locale locale) {
        if (this.displayName == null || this.currentLocale == null || !this.currentLocale.equals(locale)) {
            Locale locale2;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"displayName is not set! retrieving...");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Current locale: " + this.currentLocale + " new locale " + locale));
            }
            if ((locale2 = LocaleUtils.getSupportedLocale((Locale)locale, (List)this.getLocalesOfDisplayNames())) != null) {
                this.displayName = this.getDisplayName(locale2);
                this.currentLocale = locale;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting display name (" + locale + "): " + this.displayName));
                }
            }
        }
        if (this.displayName != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returning display name (" + locale + "): " + this.displayName));
            }
            return this.displayName;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No display name (" + locale + "), returning name: " + this.getName()));
        }
        return this.getName();
    }

    public boolean isSupported(Locale locale) {
        return LocaleUtils.getSupportedLocale((Locale)locale, (List)this.getLocalesOfDisplayNames()) != null;
    }

    protected abstract String getDisplayName(Locale var1);

    protected abstract String getName();

    protected abstract List getLocalesOfDisplayNames();
}

