/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.util;

import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.List;
import java.util.Locale;

public abstract class LocalisedDescription
implements LocalisedString {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2009.\n\n";
    private Locale currentLocale = null;
    private String description = null;

    public LocalisedDescription() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Creating new empty description.");
        }
    }

    public LocalisedDescription(String string, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating new description for: " + locale + " - " + string));
        }
        this.description = string;
        this.currentLocale = locale;
    }

    public String getString(Locale locale) {
        if (this.description == null || this.currentLocale == null || !this.currentLocale.equals(locale)) {
            Locale locale2;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"description is not set! retrieving...");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Current locale: " + this.currentLocale + " new locale " + locale));
            }
            if ((locale2 = LocaleUtils.getSupportedLocale((Locale)locale, (List)this.getLocalesOfDescriptions())) != null) {
                this.description = this.getDescription(locale2);
                this.currentLocale = locale;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting description (" + locale + "): " + this.description));
                }
            }
        }
        return this.description;
    }

    public boolean isSupported(Locale locale) {
        return LocaleUtils.getSupportedLocale((Locale)locale, (List)this.getLocalesOfDescriptions()) != null;
    }

    protected abstract String getDescription(Locale var1);

    protected abstract List getLocalesOfDescriptions();
}

