/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ESIID;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TKTID;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.NamingException;

public class HTMUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";

    public static HumanTaskManagerService getHumanTaskManagerService(HTMConnection hTMConnection) throws ClientException {
        HumanTaskManagerService humanTaskManagerService = null;
        try {
            humanTaskManagerService = hTMConnection.getHumanTaskManagerService();
        }
        catch (NamingException namingException) {
            throw new CommunicationException(new Object[]{"HTMConnection.getHumanTaskManagerService"}, (Throwable)namingException);
        }
        catch (CreateException createException) {
            throw new CommunicationException(new Object[]{"HTMConnection.getHumanTaskManagerService"}, (Throwable)createException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"HTMConnection.getHumanTaskManagerService"}, (Throwable)remoteException);
        }
        return humanTaskManagerService;
    }

    public static boolean isHTMSystemAdministrator(HTMConnection hTMConnection) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = HTMUtils.getHumanTaskManagerService(hTMConnection).isSystemAdministrator();
            }
            catch (Exception exception) {
                if (!BPCClientTrace.isTracing) break block2;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
            }
        }
        return bl;
    }

    public static boolean isHTMSystemMonitor(HTMConnection hTMConnection) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = HTMUtils.getHumanTaskManagerService(hTMConnection).isSystemMonitor();
            }
            catch (Exception exception) {
                if (!BPCClientTrace.isTracing) break block2;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
            }
        }
        return bl;
    }

    static String getEntityType(OID oID) {
        if (oID instanceof TKTID) {
            return HTMQueryConstants.TASKTEMPLATE_ENITITYTYPE;
        }
        if (oID instanceof TKIID) {
            return HTMQueryConstants.TASKINSTANCE_ENITITYTYPE;
        }
        if (oID instanceof ESIID) {
            return HTMQueryConstants.ESCALATION_ENITITYTYPE;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("No entity type for " + oID.getClass().getName()));
        }
        return null;
    }

    public static boolean isUserInRole(HTMConnection hTMConnection, TKIID tKIID, String string, int n) throws ClientException {
        boolean bl = false;
        try {
            bl = HTMUtils.getHumanTaskManagerService(hTMConnection).isUserInRole(tKIID, string, n);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            throw new NotAuthorizedException(new Object[0], (Throwable)notAuthorizedException);
        }
        catch (TaskException taskException) {
            throw new HTMCommandException(new Object[]{"HumanTaskManagerService.isUserInRole"}, taskException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"HumanTaskManagerService.isUserInRole"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{"HumanTaskManagerService.isUserInRole"}, (Throwable)eJBException);
        }
        return bl;
    }
}

