/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.QueryPropertyBean;
import com.ibm.bpc.clientcore.util.QueryProperties;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKIID;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.query.QueryPropertyHTMQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMQueryProperties
extends QueryProperties {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";
    private HTMConnection connection = null;

    public HTMQueryProperties(OID oID, HTMConnection hTMConnection) {
        super(oID);
        this.connection = hTMConnection;
    }

    protected Map retrieveBeanQueryProperties() throws ClientException {
        return HTMQueryProperties.getQueryPropertiesMap(this.getOid(), this.connection);
    }

    public static List getQueryPropertyBeans(OID oID, HTMConnection hTMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        Assert.assertion((oID instanceof PIID || oID instanceof AIID || oID instanceof TKIID ? 1 : 0) != 0, (String)"OID must be PTID, PIID, AIID or TKIID!");
        QueryPropertyHTMQuery queryPropertyHTMQuery = new QueryPropertyHTMQuery();
        queryPropertyHTMQuery.setConnection(hTMConnection);
        queryPropertyHTMQuery.getQueryPropertyFilterAttributes().setOid(oID);
        List list = queryPropertyHTMQuery.execute();
        if (BPCClientTrace.isTracing) {
            int n = 0;
            if (list != null) {
                n = list.size();
            }
            BPCClientTrace.exit((Object)("returning " + n + " properties"));
        }
        return list;
    }

    public static Map getQueryPropertiesMap(OID oID, HTMConnection hTMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        List list = HTMQueryProperties.getQueryPropertyBeans(oID, hTMConnection);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (list != null && list.size() > 0) {
            for (QueryPropertyBean queryPropertyBean : list) {
                hashMap.put(queryPropertyBean.getKey(), queryPropertyBean.getValue());
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added query property " + queryPropertyBean.toString()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + hashMap.size() + " properties"));
        }
        return hashMap;
    }
}

