/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.CustomPropertyBean;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.CustomProperties;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.CustomProperty;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.util.HTMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMCustomProperties
extends CustomProperties {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";
    private HTMConnection connection = null;

    public HTMCustomProperties(OID oID, HTMConnection hTMConnection) {
        super(oID);
        this.connection = hTMConnection;
    }

    protected Map retrieveAllCustomProperties() throws ClientException {
        return HTMCustomProperties.getCustomPropertiesMap(this.getOid(), this.connection);
    }

    public static List getCustomPropertyBeans(OID oID, HTMConnection hTMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        ArrayList<CustomPropertyBean> arrayList = new ArrayList<CustomPropertyBean>();
        List list = HTMCustomProperties.getCustomProperties(oID, hTMConnection);
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList(list.size());
            for (CustomProperty customProperty : list) {
                arrayList.add(new CustomPropertyBean(HTMUtils.getEntityType(oID), customProperty.getName(), customProperty.getValue()));
            }
        }
        if (BPCClientTrace.isTracing) {
            int n = 0;
            if (arrayList != null) {
                n = arrayList.size();
            }
            BPCClientTrace.exit((Object)("returning " + n + " properties"));
        }
        return arrayList;
    }

    private static List getCustomProperties(OID oID, HTMConnection hTMConnection) throws ClientException {
        List list = null;
        HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(hTMConnection);
        try {
            list = humanTaskManagerService.getCustomProperties(oID.toString());
        }
        catch (TaskException taskException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)taskException);
            }
            throw new HTMCommandException(new Object[]{"HumanTaskManagerService.getCustomProperties"}, taskException);
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"HumanTaskManagerService.getCustomProperties"}, (Throwable)remoteException);
        }
        return list;
    }

    public static Map getCustomPropertiesMap(OID oID, HTMConnection hTMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = HTMCustomProperties.getCustomProperties(oID, hTMConnection);
        if (list != null && list.size() > 0) {
            String string = HTMUtils.getEntityType(oID);
            for (CustomProperty customProperty : list) {
                String string2 = customProperty.getValue();
                CustomPropertyBean customPropertyBean = new CustomPropertyBean(string, customProperty.getName(), string2);
                hashMap.put(customPropertyBean.getKey(), string2);
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added custom property " + customPropertyBean.toString()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + hashMap.size() + " properties"));
        }
        return hashMap;
    }
}

