/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.util.TimeZone;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.util.TaskTimer;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Locale;

public class ExpirationTimer
extends TaskTimer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";

    public ExpirationTimer(TaskInstanceBean taskInstanceBean, String string, String string2, Locale locale, TimeZone timeZone) {
        super(taskInstanceBean, string, string2, locale, timeZone);
        Assert.assertion((taskInstanceBean != null ? 1 : 0) != 0, (String)"Task Instance Bean not set");
        this.initializeAvailableActions();
    }

    protected boolean isTimerTimestampUpdateable() {
        boolean bl = this.taskInstanceBean.isExpirationTimeUpdateable();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Expiration timer time updateable: " + bl));
        }
        return bl;
    }

    protected boolean isTimerDurationUpdateable() {
        boolean bl = this.taskInstanceBean.isDurationUntilExpiresUpdateable();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Expiration timer duration updateable: " + bl));
        }
        return bl;
    }

    public String getTimestamp() {
        Calendar calendar = this.taskInstanceBean.getExpirationTime();
        if (calendar != null) {
            this.timestamp = LocaleUtils.getISODate((Calendar)calendar, (Locale)this.getLocale(), (TimeZone)this.getTimeZone());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)this.timestamp);
            }
        } else {
            this.timestamp = this.taskInstanceBean.getDurationUntilExpires();
            if (this.timestamp != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.entry((Object)("Timer duration set to " + this.timestamp));
                }
            } else {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.entry((Object)"Timer not set, set timestamp to DURATION_INFINITE to indicate this to the GUI");
                }
                this.timestamp = "DURATION_INFINITE";
            }
        }
        return this.timestamp;
    }

    public void updateTimer() throws ClientException, TaskException, RemoteException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.timestamp.equals("DURATION_ZERO")) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Fire timer now");
            }
            this.taskInstanceBean.setDurationUntilExpires("DURATION_ZERO");
        } else if (this.timestamp.equals("DURATION_INFINITE")) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Set time to infinite");
            }
            this.taskInstanceBean.setDurationUntilExpires("DURATION_INFINITE");
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Set timer to new timestamp:" + this.timestamp));
            }
            Calendar calendar = LocaleUtils.parseDateTime((String)this.timestamp, (int)1, (int)1, (Locale)this.getLocale(), (TimeZone)this.getTimeZone());
            this.taskInstanceBean.setExpirationTime(calendar);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"New expiration was set");
            }
        }
    }
}

