/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.PropertyNotSetException;
import com.ibm.bpc.clientcore.util.QueryResultSetWrapper;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBeanExt;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TKTID;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import com.ibm.task.clientmodel.query.HTMQuery;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import com.ibm.task.clientmodel.query.WorkItemQueryAttributes;
import com.ibm.task.clientmodel.util.LocalisedDescEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemQuery
extends HTMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    public static final String TYPE = HTMQueryConstants.WORKITEMQUERYTYPE;
    private boolean retrieveTaskDisplayNames = false;
    private Map<TKIID, TaskInstanceBeanExt> taskInstanceBeans = null;
    private List<TKIID> taskInstanceIds = null;
    private Map<PIID, ProcessInstanceBeanExt> processInstanceBeans = null;
    private List<PIID> processInstanceIds = null;

    public WorkItemQuery() {
        super(new WorkItemQueryAttributes());
        this.setType(TYPE);
    }

    public void setRetrieveTaskDisplayNames(boolean bl) {
        this.retrieveTaskDisplayNames = bl;
    }

    public void setTaskInstanceBeans(List<TaskInstanceBeanExt> list) {
        if (list.size() > 0) {
            this.processInstanceBeans = null;
            this.taskInstanceBeans = new HashMap<TKIID, TaskInstanceBeanExt>(list.size());
            this.taskInstanceIds = new ArrayList<TKIID>(list.size());
            for (TaskInstanceBeanExt taskInstanceBeanExt : list) {
                TKIID tKIID = taskInstanceBeanExt.getID();
                this.taskInstanceBeans.put(tKIID, taskInstanceBeanExt);
                this.taskInstanceIds.add(tKIID);
            }
        } else {
            this.taskInstanceBeans = null;
        }
        this.getWorkItemAdministrationFilterAttributes().addTaskInstanceIds(this.taskInstanceIds);
    }

    protected Map<TKIID, TaskInstanceBeanExt> getTaskInstanceBeans() throws PropertyNotSetException {
        if (this.taskInstanceBeans == null || this.taskInstanceBeans.size() == 0) {
            throw new PropertyNotSetException(new Object[]{"taskInstanceBeans", ((Object)((Object)this)).getClass()});
        }
        return this.taskInstanceBeans;
    }

    protected List<TKIID> getTaskInstanceIds() throws PropertyNotSetException {
        if (this.taskInstanceIds == null || this.taskInstanceIds.size() == 0) {
            throw new PropertyNotSetException(new Object[]{"taskInstanceIds", ((Object)((Object)this)).getClass()});
        }
        return this.taskInstanceIds;
    }

    public void setProcessInstanceBeans(List<ProcessInstanceBeanExt> list) {
        if (list.size() > 0) {
            this.taskInstanceBeans = null;
            this.retrieveTaskDisplayNames = false;
            this.processInstanceBeans = new HashMap<PIID, ProcessInstanceBeanExt>(list.size());
            this.processInstanceIds = new ArrayList<PIID>(list.size());
            for (ProcessInstanceBeanExt processInstanceBeanExt : list) {
                PIID pIID = processInstanceBeanExt.getID();
                this.processInstanceBeans.put(pIID, processInstanceBeanExt);
                this.processInstanceIds.add(pIID);
            }
        } else {
            this.processInstanceBeans = null;
        }
        this.getWorkItemAdministrationFilterAttributes().addProcessInstanceIds(this.processInstanceIds);
    }

    protected Map<PIID, ProcessInstanceBeanExt> getProcessInstanceBeans() throws PropertyNotSetException {
        if (this.processInstanceBeans == null || this.processInstanceBeans.size() == 0) {
            throw new PropertyNotSetException(new Object[]{"processInstanceBeans", ((Object)((Object)this)).getClass()});
        }
        return this.processInstanceBeans;
    }

    protected List<PIID> getProcessInstanceIds() throws PropertyNotSetException {
        if (this.processInstanceIds == null || this.processInstanceIds.size() == 0) {
            throw new PropertyNotSetException(new Object[]{"processInstanceIds", ((Object)((Object)this)).getClass()});
        }
        return this.processInstanceIds;
    }

    public String getSelectClause() {
        String string = super.getSelectClause();
        this.getQueryAttributes();
        if (this.processInstanceBeans == null) {
            string = string + ", TASK.NAME, TASK.TKIID";
        }
        return string;
    }

    @Override
    protected List executeHTMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.resetQueryForTaskTemplateDesc();
        QueryResultSet queryResultSet = null;
        String string = this.getSelectClause();
        if (this.taskInstanceBeans == null && this.processInstanceBeans == null && this.getLocale() != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"add task display name and description to query!");
            }
            string = string + ", " + this.getSelectTaskInstanceDesc();
        }
        String string2 = this.getWhereClause();
        queryResultSet = this.executeGenericHTMQuery(string, string2, this.getOrderClause(), this.getThreshold());
        List<WorkItemBeanExt> list = this.transformToBeans(new QueryResultSetWrapper((Object)queryResultSet));
        if (this.processInstanceBeans != null) {
            queryResultSet = null;
            list = this.addProcessInfo(list);
        } else {
            list = this.addTaskInfo(list, queryResultSet, string2);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " instances"));
        }
        return list;
    }

    private List<WorkItemBeanExt> addProcessInfo(List<WorkItemBeanExt> list) throws PropertyNotSetException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (list != null) {
            Map<PIID, ProcessInstanceBeanExt> map = this.getProcessInstanceBeans();
            for (WorkItemBeanExt workItemBeanExt : list) {
                if (workItemBeanExt.getObjectType() != 3) continue;
                workItemBeanExt.setProcessInstance(map.get((PIID)workItemBeanExt.getObjectID()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return list;
    }

    private List<WorkItemBeanExt> addTaskInfo(List<WorkItemBeanExt> list, QueryResultSet queryResultSet, String string) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (list != null) {
            Map<String, LocalisedDescEntry> map = this.getTaskInstanceDescValues(queryResultSet);
            queryResultSet = null;
            if (this.taskInstanceBeans != null && this.taskInstanceBeans.size() > 0) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"retrieving display names from task instance beans!");
                }
                list = this.addDisplayNames(list);
            } else if (this.retrieveTaskDisplayNames && this.getLocale() != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"add task display name and description to query!");
                }
                QueryResultSet queryResultSet2 = null;
                Map<String, LocalisedDescEntry> map2 = null;
                if (this.getQueryForTaskTemplateDesc()) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Additional task template description query!");
                    }
                    if ((queryResultSet2 = this.executeTaskTemplateDescQuery(string)) != null) {
                        map2 = this.getTaskTemplateDescValues(queryResultSet2);
                    } else if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Task template description query returned null!");
                    }
                } else if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No additional task template description query needed!");
                }
                list = this.addDescValues(list, map, map2);
            } else {
                queryResultSet = null;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No retrieval of task display names!");
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return list;
    }

    private List<WorkItemBeanExt> addDescValues(List<WorkItemBeanExt> list, Map<String, LocalisedDescEntry> map, Map<String, LocalisedDescEntry> map2) {
        if (list != null) {
            for (WorkItemBeanExt workItemBeanExt : list) {
                String string = workItemBeanExt.getID().toString();
                LocalisedDescEntry localisedDescEntry = map.get(string);
                LocalisedDescEntry localisedDescEntry2 = null;
                if (map2 != null) {
                    localisedDescEntry2 = map2.get(string);
                }
                workItemBeanExt = this.addDescValuesToBean(workItemBeanExt, localisedDescEntry, localisedDescEntry2);
            }
        }
        return list;
    }

    private WorkItemBeanExt addDescValuesToBean(WorkItemBeanExt workItemBeanExt, LocalisedDescEntry localisedDescEntry, LocalisedDescEntry localisedDescEntry2) {
        String string;
        Locale locale = this.getLocale();
        String string2 = workItemBeanExt.getID().toString();
        TKTID tKTID = workItemBeanExt.getTaskTemplateID();
        if (tKTID != null) {
            string = tKTID.toString();
            if (localisedDescEntry2 != null) {
                this.addTaskTemplateDescriptionToCache(string, localisedDescEntry2);
            } else {
                localisedDescEntry2 = this.getTaskTemplateDescriptionFromCache(string);
            }
        }
        string = LocalisedDescEntry.getResolvedInstanceDisplayName(localisedDescEntry, localisedDescEntry2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting localized values for " + string2 + " for locale " + locale.toString() + " -> displayName: " + string));
        }
        workItemBeanExt.setLocalisedTaskDisplayName(string, locale);
        return workItemBeanExt;
    }

    protected String getQueryString(String string, String string2, String string3, Integer n) {
        StringBuffer stringBuffer = new StringBuffer(super.getQueryString(string, string2, string3, n));
        stringBuffer.append("\nretrieveTaskDisplayNames: ").append(this.retrieveTaskDisplayNames);
        if (this.retrieveTaskDisplayNames) {
            if (this.taskInstanceBeans != null) {
                stringBuffer.append("\ntaskInstanceBeans: ").append(this.getWorkItemAdministrationFilterAttributes().getAttribute("tkiids"));
            } else if (this.processInstanceBeans != null) {
                stringBuffer.append("\nSelectTaskDesc clause: ").append(this.getSelectTaskInstanceDesc());
                stringBuffer.append("\nSelectTaskTemplateDesc clause: ").append(this.getSelectClauseTaskTemplateDesc());
            }
        }
        if (this.processInstanceBeans != null) {
            stringBuffer.append("\nprocessInstanceBeans: ").append(this.getWorkItemAdministrationFilterAttributes().getAttribute("piids"));
        }
        return stringBuffer.toString();
    }

    private List<WorkItemBeanExt> addDisplayNames(List<WorkItemBeanExt> list) {
        if (list != null) {
            for (WorkItemBeanExt workItemBeanExt : list) {
                TaskInstanceBeanExt taskInstanceBeanExt;
                OID oID = workItemBeanExt.getObjectID();
                if (oID == null || !(oID instanceof TKIID) || (taskInstanceBeanExt = this.taskInstanceBeans.get(oID)) == null) continue;
                workItemBeanExt.setLocalisedTaskDisplayName(taskInstanceBeanExt.getDisplayName().getString(this.getLocale()), this.getLocale());
            }
        }
        return list;
    }

    protected Object createBean(QueryResultSetWrapper queryResultSetWrapper) {
        WorkItemBeanExt workItemBeanExt = new WorkItemBeanExt(queryResultSetWrapper.getHTMQueryResultSet(), this.getConnection(), this.getLocale());
        if (5 == workItemBeanExt.getObjectType()) {
            TKTID tKTID = null;
            tKTID = workItemBeanExt.getTaskTemplateID();
            if (tKTID != null) {
                this.checkDescCacheForTaskTemplate(tKTID.toString());
            }
        }
        return workItemBeanExt;
    }
}

