/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKIID;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    public static final String TYPE = HTMQueryConstants.WORKITEM_ENITITYTYPE;
    private static Map<String, Object> validAttributes = new HashMap<String, Object>();

    public WorkItemFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new WorkItemFilterAttributes();
    }

    public StringBuffer getWhereFilterCondition() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("tkiids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("WORK_ITEM.OBJECT_ID IN(" + QueryUtils.convertToIDStringList((String[])((String[])this.getAttribute("tkiids"))) + ")"));
        }
        if (this.getAttribute("piids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("WORK_ITEM.OBJECT_ID IN(" + QueryUtils.convertToIDStringList((String[])((String[])this.getAttribute("piids"))) + ")"));
        }
        if ("true".equalsIgnoreCase((String)this.getAttribute("ownerExists"))) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)"WORK_ITEM.EVERYBODY = 0");
        }
        if (this.getAttribute("taskInstanceStates") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.STATE IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("taskInstanceStates"))) + ")"));
        }
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getWorkItemFilterCondition((BPCQueryFilterAttributes)this));
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("where " + stringBuffer));
        }
        return stringBuffer;
    }

    public void setAttribute(String string, Object object) {
        if ("tkiids".equals(string)) {
            if (object instanceof List) {
                this.addTaskInstanceIds((List)object);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Attribute value for 'tkiids' must be a list of TKIIDs, attribute is ignored!");
            }
        } else if ("piids".equals(string)) {
            if (object instanceof List) {
                this.addProcessInstanceIds((List)object);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Attribute value for 'piids' must be a list of PIIDs, attribute is ignored!");
            }
        } else {
            super.setAttribute(string, object);
        }
    }

    public void addTaskInstanceIds(List<TKIID> list) {
        String[] stringArray = null;
        if (list != null) {
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).toString();
            }
        }
        super.setAttribute("tkiids", (Object)stringArray);
    }

    public void addProcessInstanceIds(List<PIID> list) {
        String[] stringArray = null;
        if (list != null) {
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).toString();
            }
        }
        super.setAttribute("piids", (Object)stringArray);
    }

    public void addWorkItemOwnerExists() {
        this.setAttribute("ownerExists", "true");
    }

    public void addWorkItemOwner(String string) {
        this.setAttribute("wiOwners", new String[]{string});
    }

    public void addWorkItemOwners(String[] stringArray) {
        this.setAttribute("wiOwners", stringArray);
    }

    public void addWorkItemReasons(int[] nArray) {
        this.setAttribute("wiReasons", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addTaskStates(int[] nArray) {
        this.setAttribute("taskInstanceStates", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void setGroups(String[] stringArray) {
        this.setAttribute("wiGroups", stringArray);
    }

    static {
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"tkiids", (Object)new String[0]);
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"piids", (Object)new String[0]);
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"ownerExists", (Object)"false");
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiOwners", (Object)new String[0]);
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiReasons", (Object)new String[0]);
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"taskInstanceStates", (Object)new String[0]);
        WorkItemFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiGroups", (Object)new String[0]);
    }
}

