/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.PropertyNotSetException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.WorkItem;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.query.WorkItemQuery;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskWorkItemQuery
extends WorkItemQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    @Override
    public List executeHTMQuery() throws ClientException {
        List<WorkItemBeanExt> list;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)"getAllWorkitems");
        }
        if (this.isSystemAdmin()) {
            list = super.executeHTMQuery();
        } else {
            Map<TKIID, TaskInstanceBeanExt> map = this.getTaskInstanceBeans();
            Assert.precondition((map != null && map.size() > 0 ? 1 : 0) != 0, (String)"Task instance beans required as parameter! Use method 'setTaskInstanceBeans()'.");
            try {
                HumanTaskManagerService humanTaskManagerService = this.getService();
                list = new ArrayList<WorkItemBeanExt>();
                WorkItem[] workItemArray = null;
                for (TKIID tKIID : map.keySet()) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("getAllWorkitems for TKIID " + tKIID.toString()));
                    }
                    workItemArray = humanTaskManagerService.getAllWorkItems(tKIID);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("getAllWorkitems returned: " + workItemArray.length + " items for tkiid " + tKIID));
                    }
                    list = this.transformAndAddWorkitems(list, tKIID, workItemArray);
                }
            }
            catch (TaskException taskException) {
                throw new HTMCommandException(new Object[]{"HumanTaskManagerService.getAllWorkitems"}, taskException);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()});
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()});
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " instances"));
        }
        return list;
    }

    private List<WorkItemBeanExt> transformAndAddWorkitems(List<WorkItemBeanExt> list, TKIID tKIID, WorkItem[] workItemArray) throws PropertyNotSetException {
        if (list == null) {
            list = new ArrayList<WorkItemBeanExt>();
        }
        Map<TKIID, TaskInstanceBeanExt> map = this.getTaskInstanceBeans();
        for (int i = 0; i < workItemArray.length; ++i) {
            WorkItemBeanExt workItemBeanExt = new WorkItemBeanExt(workItemArray[i], this.getConnection(), this.getLocale());
            TaskInstanceBean taskInstanceBean = map.get(tKIID);
            workItemBeanExt.setLocalisedTaskDisplayName(taskInstanceBean.getDisplayName().getString(this.getLocale()), this.getLocale());
            list.add(workItemBeanExt);
        }
        return list;
    }
}

