/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TaskTemplate;
import com.ibm.task.clientmodel.bean.TaskTemplateBeanPropertyExt;
import com.ibm.task.clientmodel.exception.HTMQueryException;
import com.ibm.task.clientmodel.query.HTMQuery;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import com.ibm.task.clientmodel.query.TaskTemplateQueryAttributes;
import java.util.ArrayList;
import java.util.List;

public class TaskTemplateQuery
extends HTMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";
    public static final String TYPE = HTMQueryConstants.TASKTEMPLATEQUERYTYPE;

    public TaskTemplateQuery() {
        super(new TaskTemplateQueryAttributes());
        this.setType(TYPE);
    }

    protected List executeHTMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getQueryString());
        }
        TaskTemplate[] taskTemplateArray = this.executeTaskTemplateQuery();
        List list = this.transform(taskTemplateArray);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " templates"));
        }
        return list;
    }

    private TaskTemplate[] executeTaskTemplateQuery() throws ClientException {
        TaskTemplate[] taskTemplateArray = null;
        try {
            taskTemplateArray = this.getService().queryTaskTemplates(this.updateWhereClauseForTemplates(this.getWhereClause()), this.getOrderClause(), this.getThreshold(), null);
        }
        catch (Exception exception) {
            throw new HTMQueryException(new Object[]{this.getQueryString()}, exception);
        }
        return taskTemplateArray;
    }

    private List transform(TaskTemplate[] taskTemplateArray) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Number of templates " + (taskTemplateArray != null ? taskTemplateArray.length : 0)));
        }
        ArrayList<TaskTemplateBeanPropertyExt> arrayList = null;
        if (taskTemplateArray != null && taskTemplateArray.length > 0) {
            arrayList = new ArrayList(taskTemplateArray.length);
            for (int i = 0; i < taskTemplateArray.length; ++i) {
                arrayList.add(new TaskTemplateBeanPropertyExt(taskTemplateArray[i], this.getConnection()));
            }
        } else {
            arrayList = new ArrayList<TaskTemplateBeanPropertyExt>(0);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Returned templates " + arrayList.size()));
        }
        return arrayList;
    }
}

